/*global jQuery */
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */

(function ($) {

    function evaluateShowIfExpression(expr, values) {
        var realExpr, code;

        realExpr = expr;
        code = "function _reqEval() {\n";

        if (values) {
            $.each(values, function (key, value) {
		// switch (jQuery.type(value)) {
                switch (typeof(value)) {
                case "boolean":
                case "number":
                    code += "var " + key + " = " + value + ";\n";
                    break;
                case "string":
                    code += "var " + key + " = '" + value.replace(/'/g, "\\'") + "';\n";
                    break;
                default:
                    realExpr = "false";
                }
            });
        }

        code += "return (" + realExpr + ");\n";
        code += "}\n";
        code += "_reqEval();\n";

        try {
            return eval(code);
        } catch (e) {
            return false;
        }
    }

    $.widget('ui.hytoolbar', {
        _activeView: null,
        _viewProperties: {},

        options: {
            conf: {},
            views: [],
            searchBox: true,
            searchBoxHint: 'Search',
            searchBoxTooltip: ''
        },

        _create: function () {
            var self, searchLabel, searchDiv, searchDeleteDiv, searchForm, searchWrap, searchTip, initialActiveView, largest;

            this.element.addClass('hy-toolbar ui-widget-header ui-helper-clearfix');

            self = this;

            this.contentDiv = $('<div></div>').appendTo(this.element);
            this.buttonsDiv = $('<div class="hy-buttonset ui-helper-clearfix"></div>').appendTo(this.contentDiv);

            this.viewsDiv = $('<div></div>').hide().appendTo(this.contentDiv);
            this.viewsDiv.addClass('hy-buttonset hy-toolbar-views hy-buttonset-single ui-helper-clearfix');

            if (self.options.searchBox) {
                searchDiv = $('<div></div>').appendTo(this.contentDiv);
                searchForm = $('<form></form>').appendTo(searchDiv);
                searchLabel = $('<span></span>').appendTo(searchForm);
                this.searchInput = $('<input value=""></input>').appendTo(searchForm);

                searchDiv.addClass('hy-searchbox');
                searchLabel.addClass('ui-icon ui-icon-search');

                searchDeleteDiv = $('<div class="hy-searchbox-delete ui-icon ui-icon-trash"></div>');
                searchWrap = this.searchInput.add(searchDeleteDiv).
                    wrapAll('<div class="hy-searchbox-wrapper ui-state-default"></div>');

                // this.searchInput.focus(function () {
		this.searchInput.on("focus", function() {
                    $(this).parent().addClass('ui-state-focus');
		// }).blur(function () {
	        }).on("blur", function () {
                    $(this).parent().removeClass('ui-state-focus');
                });

                searchDeleteDiv.click(function () {
                    if (self.searchInput.val() !== '') {
                        self.searchInput.val('').trigger("focus");
                        self._trigger('search', null, {search: ''});
                        self.searchInput.trigger("blur");
                    }
                });

                if (self.options.searchBoxHint) {
                    self.searchInput.inputHint({
                        value: self.options.searchBoxHint,
                        className: 'hy-searchbox-hint'
                    });
                }

                searchTip = self.options.searchBoxTooltip || self.options.searchBoxHint;
                if (searchTip) {
                    self.searchInput.attr('title', searchTip);
                }

                searchForm.on("submit", function () {
                    self._trigger('search', null, {search: self.searchInput.val()});
                    self.searchInput.trigger("blur");
                    return false;
                });
            }

            this._addActionButtons();

            initialActiveView = null;

            if (this.options.views) {
                largest = 0;

                $.each(this.options.views, function (i, view) {
                    var element;

                    element = $('<button id="' + view.id + '" class="hy-button ui-state-default"></button>');
                    if (view.icon) {
                        $('<span class="hy-button-icon hy-button-icon-' + view.icon + '"></span>').appendTo(element);
                    }
                    if (view.name) {
                        $('<span>' + efEncodeHtml(view.name) + '</span>').appendTo(element);
                    }

                    if (i === 0) {
                        element.addClass('ui-corner-left');
                    } else if (i === self.options.views.length - 1) {
                        element.addClass('ui-corner-right');
                    }

                    if (self.options.conf.params && self.options.conf.params['active-view'] === view.id) {
                        initialActiveView = view;
                    }

                    element.click(function () {
                        self.activeView(view);
                    });

                    self.viewsDiv.append(element);

                    largest = Math.max(largest, element.width());
                });

                // make sure they have the same width
                this.viewsDiv.children().css({'min-width': largest});

                this.viewsDiv.show();
            }

            this._bindButtons();

            if (initialActiveView) {
                this.activeView(initialActiveView);
            }
        },

        _addActionButtons: function () {
            var self, hideSeparator;

            self = this;
            hideSeparator = true;

            this.buttonsDiv.empty();

            if (this.options.conf['global-action-items']) {
                $.each(this.options.conf['global-action-items'], function (i, item) {
                    var element;

                    if (item.separator) {
                        if (!hideSeparator) {
                            element = $("<span id='" + item.id + "'></span>");
                            element.addClass("hy-separator").appendTo(self.buttonsDiv);
                            hideSeparator = true;
                        }
                    } else if (!item.showIf || evaluateShowIfExpression(item.showIf, self._viewProperties)) {
                        element = $("<button id='" + item.id + "'></button>")
                            .addClass('hy-button ui-state-default ui-corner-all')
                            .appendTo(self.buttonsDiv)
                            .click(function () {
                                self._trigger('action', null, item.action);
                            });
                        if (item.icon) {
                            $('<img src="' + item.icon + '">').appendTo(element);
                        } else {
                            if (item.awesome) {
                                $('<i class="fa fa-'+item.awesome+'"></i>').appendTo(element);
                            }
                            if (item.name) {
                                $('<span>&nbsp;' + efEncodeHtml(item.name) + '</span>').appendTo(element);
                            }
                        }
                        if (item.classes) {
                            element.addClass(item.classes);
                        }
                        hideSeparator = false;
                    }
                });
            }
        },

        _bindButtons: function () {
            // all hover and click logic for buttons
            $(".hy-button:not(.ui-state-disabled)", this.contentDiv)
                .hover(
                    function () {
                        $(this).addClass("ui-state-hover");
                    },
                    function () {
                        $(this).removeClass("ui-state-hover");
                    }
                )
                .mousedown(function () {
                    $(this).parents('.hy-buttonset-single:first').
                        find(".hy-button.ui-state-active").removeClass("ui-state-active");
                    if ($(this).is('.ui-state-active.hy-button-toggleable, .hy-buttonset-multi .ui-state-active')) {
                        $(this).removeClass("ui-state-active");
                    } else {
                        $(this).addClass("ui-state-active");
                    }
                })
                .mouseup(function () {
                    if (!$(this).is('.hy-button-toggleable, .hy-buttonset-single .hy-button, ' +
                            '.hy-buttonset-multi .hy-button')) {
                        $(this).removeClass("ui-state-active");
                    }
                });
        },

        destroy: function () {
            this.element.removeClass('hy-toolbar ui-widget');
            this.contentDiv.remove();

            $.Widget.prototype.destroy.apply(this, arguments);

            return this;
        },

        search: function (newValue) {
            if (newValue === undefined) {
                return this.searchInput.val();
            }

            this._setOption('search', newValue);
            return this;
        },

        activeView: function (newValue) {
            if (newValue === undefined) {
                return this._activeView;
            }

            this._setOption('activeView', newValue);
            return this;
        },

        _setActiveView: function (newValue) {
            if (this._activeView !== newValue) {
                this._activeView = newValue;

                this.viewsDiv.children().each(function (i, element) {
                    if ($(element).attr('id') === newValue.id) {
                        $(element).addClass('ui-state-active');
                    } else {
                        $(element).removeClass('ui-state-active');
                    }
                });

                this._trigger('viewchanged', null, this._activeView);
            }
        },

        viewProperties: function (newValue) {
            if (newValue === undefined) {
                return this._viewProperties;
            }
            this._setOption('viewProperties', newValue);
            return this;
        },

        _setViewProperties: function (newValue) {
            // note that we do not check if the value changed, comparing arrays is too hard
            this._viewProperties = $.extend(this._viewProperties, newValue);
            this._addActionButtons();
            this._bindButtons();
        },

        _setOption: function (key, value) {
            switch (key) {
            case 'search':
                this.searchInput.val(value);
                break;
            case 'activeView':
                this._setActiveView(value);
                break;
            case 'viewProperties':
                this._setViewProperties(value);
                break;
            }

            $.Widget.prototype._setOption.apply(this, arguments);
        }
    });

}(jQuery));

// ex:ts=4:et:
