/*global jQuery, hydrogenConf */
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */


var efListSpoolers = {
    refresh: function (id) {
        jQuery('#' + id + '-table').hytable('reload');
    },

    renameDialog: function (id, environment) {
        var msg = jQuery('#' + id + '-message').hymessage();
        jQuery.hydrogen.renameSpoolerDialog(environment["%CURRENT_ID%"], msg, function () {
            efListSpoolers.refresh(id);
        });
    },

    init: function (id) {
        jQuery(document).ready(function () {
            var msg, toolbar, table, filters, projects, initialFilter, showProjects;

            msg = jQuery('#' + id + '-message').hymessage();

            toolbar = jQuery('#' + id + '-toolbar').hytoolbar({
                conf: hydrogenConf[id],
                searchBoxHint: 'Search in all columns',
                searchBoxTooltip: 'Dates can be searched using YYYY/MM/DD notation or part of it, e.g. YYYY/MM, MM/DD, MM/'
            });

            filters = jQuery('#' + id + '-filters').hyfilters({
                conf: hydrogenConf[id]
            });

            initialFilter = filters.hyfilters('selected');

            table = jQuery('#' + id + '-table').hytable({
                xmlreader: {
                    root: 'list-spoolers',
                    row: 'spooler',
                    page: 'list-spoolers>page',
                    total: 'list-spoolers>total',
                    records: 'list-spoolers>records',
                    repeatitems: false,
                    id: '[uri]'
                },
                conf: hydrogenConf[id],
                messageArea: msg,
                defaultFilter: initialFilter,
                defaultLoadErrorMessage: 'Cannot obtain the list of spoolers from the server.'
            });

            if (hydrogenConf[id].params.showProjectBox === undefined) {
                showProjects = true;
            } else {
                showProjects = hydrogenConf[id].params.showProjectBox;
            }

            if (showProjects) {
                projects = jQuery('#' + id + '-projects').hyprojects({
                    conf: hydrogenConf[id]
                });

                projects.bind('hyprojectsselect', function (e, filter) {
                    filters.hyfilters('unselectAll');
                    toolbar.hytoolbar('search', '');
                    table.hytable('filter', filter.formula);
                });

                table.bind('hytableloadcomplete', function (e, d) {
                    projects.hyprojects('update');
                });
            }

            filters.bind('hyfiltersselect', function (e, filter) {
                if (showProjects) {
                    projects.hyprojects('unselectAll');
                }
                toolbar.hytoolbar('search', '');
                table.hytable('filter', filter.formula);
            });

            table.bind('hytablegridcomplete', function () {
                jQuery('td>div.hy-star').toggleStar();
            });

            table.bind('hytableaction', function (e, data) {
                jQuery.hydrogen.executeAction(data.action,
                    {'%CURRENT_ID%': data.currentId},
                    function () {
                        table.hytable('reload');
                    },
                    msg);
            });

            table.bind('hytableselectionchanged', function (e, data) {
                toolbar.hytoolbar('viewProperties', {
                    'selected': table.hytable('selected').length
                });
            });

            toolbar.bind('hytoolbaraction', function (e, action) {
                jQuery.hydrogen.executeAction(action,
                    {'%SELECTED_IDS%': function () {
                        return table.hytable('selected').join('\n');
                    }
                        },
                    function () {
                        table.hytable('reload');
                    },
                    msg);
            });

            toolbar.bind('hytoolbarsearch', function (e, s) {
                var formula, params, date, filter;

                formula = table.hytable('filter');

                if (s.search !== '') {
                    params = [
                        { key: "name", value: s.search, comparator: "?:=" },
                        { key: "status", value: s.search, comparator: "?:=" },
                        { key: "project", value: s.search, comparator: "?:=" }
                    ];
                    if (s.search.match(/^\d*\/\d*\/?\d*$/)) {
                        date = ".*" + s.search.replaceAll("/", "-") + ".*";
                        params.push({ key: "creation-time", value: date, comparator: "~=" });
                        params.push({ key: "expiration-time", value: date, comparator: "~=" });
                    }

                    filter = jQuery.hydrogen.composeFilter(params, "or");
                }
                if (formula !== null && formula !== '') {
                    if (filter !== undefined) {
                        formula += " and " + filter;
                    }
                } else {
                    if (filter !== undefined) {
                        formula = filter;
                    } else {
                        formula = "";
                    }
                }

                table.hytable('filter', formula, false);
            });

            jQuery.hydrogen.setupAutoRefresh(id, hydrogenConf, efListSpoolers.refresh);
        });
    }
};

// ex:ts=4:et:
