/*global jQuery, document, hydrogenConf */
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */

var fmBrowse = {
    refresh: function (id) {
        jQuery('#' + id + '-file-browser').hyfilebrowser('reload');
    },

    upload: function (id) {
        return jQuery('#' + id + '-file-browser').hyfilebrowser('uploadSingle');
    },

    downloadSelected: function (id) {
        return jQuery('#' + id + '-file-browser').hyfilebrowser('downloadSelected');
    },

    copyToLocal: function (id) {
        return jQuery('#' + id + '-file-browser').hyfilebrowser('copyToLocal');
    },

    streamingDownload: function (id, environment) {
        return jQuery('#' + id + '-file-browser').hyfilebrowser('streamingDownload', environment["%CURRENT_ID%"]);
    },

    createNewFolder: function (id) {
        return jQuery('#' + id + '-file-browser').hyfilebrowser('createNewFolder');
    },

    rename: function (id, environment) {
        return jQuery('#' + id + '-file-browser').hyfilebrowser('rename', environment["%CURRENT_ID%"]);
    },

    compressSelected: function (id) {
        return jQuery('#' + id + '-file-browser').hyfilebrowser('compressSelected');
    },

    compress: function (id, environment) {
        return jQuery('#' + id + '-file-browser').hyfilebrowser('compress', environment["%CURRENT_ID%"]);
    },

    deleteSelected: function (id) {
        return jQuery('#' + id + '-file-browser').hyfilebrowser('deleteSelected');
    },

    deleteItem: function (id, environment) {
        return jQuery('#' + id + '-file-browser').hyfilebrowser('deleteItem', environment["%CURRENT_ID%"]);
    },

    copySelected: function (id) {
        return jQuery('#' + id + '-file-browser').hyfilebrowser('copySelected');
    },

    pasteCopied: function (id, mode) {
        return jQuery('#' + id + '-file-browser').hyfilebrowser('pasteCopied', mode);
    },

    copyItem: function (id) {
        return jQuery('#' + id + '-file-browser').hyfilebrowser('copyItem', environment["%CURRENT_ID%"]);
    },

    executeFileAction: function (id, sdf, uri, params) {
        return jQuery('#' + id + '-file-browser').hyfilebrowser('executeFileAction', sdf, uri, params);
    },

    init: function (id) {

        jQuery(document).ready(function () {
            var msg, fileBrowser, toolbar;

            msg = jQuery('#' + id + '-message').hymessage();

            toolbar = jQuery('#' + id + '-toolbar').hytoolbar({
                conf: hydrogenConf[id],
                searchBox: true,
                searchBoxHint: 'Search by name or date',
                searchBoxTooltip: 'Glob expressions are allowed, e.g *.log\nDates can be searched using YYYY/MM/DD notation or part of it, e.g. YYYY/MM, MM/DD, MM/'
            });

            fileBrowser = jQuery('#' + id + '-file-browser').hyfilebrowser({
                conf: hydrogenConf[id],
                messageArea: msg
            });

            fileBrowser.bind('hyfilebrowseraction', function (e, data) {
                jQuery.hydrogen.executeAction(data.action,
                    {
                        '%CURRENT_ID%': data.currentId,
                        '%CURRENT_DIR%': function () {
                            return fileBrowser.hyfilebrowser('currentPath');
                        },
                        '%CURRENT_VROOT%': function () {
                            return fileBrowser.hyfilebrowser('currentVRoot');
                        }
                    },
                    function () {
                        fileBrowser.hyfilebrowser('reload');
                    },
                    msg);
            });

            fileBrowser.bind('hyfilebrowserselectionchanged', function (e, data) {
                toolbar.hytoolbar('viewProperties', {
                    'selected': fileBrowser.hyfilebrowser('selected').length
                });
            });

            toolbar.bind('hytoolbaraction', function (e, action) {
                jQuery.hydrogen.executeAction(action,
                    {
                        '%SELECTED_IDS%': function () {
                            return fileBrowser.hyfilebrowser('selected').join('\n');
                        },
                        '%CURRENT_DIR%': function () {
                            return fileBrowser.hyfilebrowser('currentPath');
                        },
                        '%CURRENT_VROOT%': function () {
                            return fileBrowser.hyfilebrowser('currentVRoot');
                        }
                    },
                    function () {
                        fileBrowser.hyfilebrowser('reload');
                    },
                    msg);
            });

            toolbar.bind('hytoolbarsearch', function (e, s) {
                var formula, params, date;

                if (s.search !== '') {
                    params = [
                        { key: "name", value: s.search, comparator: "*=" },
                        { key: "name", value: s.search, comparator: "?:=" }
                    ];
                    if (s.search.match(/^\d*\/\d*\/?\d*$/)) {
                        date = ".*" + s.search.replaceAll("/", "-") + ".*";
                        params.push({ key: "modified", value: date, comparator: "~=" });
                    }

                    formula = jQuery.hydrogen.composeFilter(params, "or");
                } else {
                    formula = "";
                }

                fileBrowser.hyfilebrowser('filter', formula);
            });

            jQuery.hydrogen.setupAutoRefresh(id, hydrogenConf, fmBrowse.refresh);
        });
    }
};

// ex:ts=4:et:
