/*global jQuery, hydrogenConf */
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */

var gridArrayJobs = {
    init: function (id) {

        jQuery(document).ready(function () {
            var box, msg, toolbar, table;

            box = jQuery('#' + id).collapsibleBox({
                cookieNamePrefix: id + '-box'
            });

            msg = jQuery('#' + id + '-message').hymessage();

            toolbar = jQuery('#' + id + '-toolbar').hytoolbar({
                conf: hydrogenConf[id],
                searchBoxHint: 'Search by job id',
                searchBoxTooltip: 'Regular expressions are allowed'
            });

            table = jQuery('#' + id + '-table').hytable({
                conf: hydrogenConf[id],
                xmlreader: {
                    root: 'job-list',
                    row: 'job',
                    page: 'job-list>page',
                    total: 'job-list>total',
                    records: 'job-list>records',
                    repeatitems: false,
                    id: 'id'
                },
                loadDataOnInit: false,
                messageArea: msg,
                defaultLoadErrorMessage: 'Cannot obtain the list of jobs from the server.'
            });

            table.bind('hytableaction', function (e, data) {
                jQuery.hydrogen.executeAction(data.action,
                    {'%CURRENT_ID%': data.currentId},
                    function () {
                        table.hytable('reload', data.currentId);
                    },
                    msg);
            });

            table.bind('hytableselectionchanged', function (e, data) {
                toolbar.hytoolbar('viewProperties', {
                    'selected': table.hytable('selected').length
                });
            });

            toolbar.bind('hytoolbaraction', function (e, action) {
                var selectedIds;

                selectedIds = table.hytable('selected').join('\n');

                jQuery.hydrogen.executeAction(action,
                    {'%SELECTED_IDS%': selectedIds},
                    function () {
                        table.hytable('reload', selectedIds);
                    },
                    msg);
            });

            toolbar.bind('hytoolbarsearch', function (e, s) {
                var formula;

                if (s.search !== '') {
                    formula = "index ~= '" + s.search + "'";
                } else {
                    formula = "";
                }

                table.hytable('filter', formula);
            });

            table.bind('hytablegridcomplete', function () {
                jQuery('td>span.hy-vtip').vtip();
            });
        });
    }
};

// ex:ts=4:et:
