/*global jQuery, hydrogenConf */
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */

var gridHostInfo = {
    refresh: function (id) {
        var hostJobs, detailsDiv, loadDiv, msg;

        detailsDiv = jQuery('#' + id + '-host-details');
        loadDiv = jQuery('#' + id + '-loaddiv').show();
        msg = jQuery('#' + id + '-message');

        jQuery.hydrogen.invokeService({
            sdf: hydrogenConf[id].params.SDF,
            uri: hydrogenConf[id].params.serviceUri,
            data: hydrogenConf[id].params.serviceParams,
            complete: function () {
                loadDiv.hide();
            },
            success: function (html) {
                detailsDiv.html(html);
            },
            dataType: 'html',
            messagebox: msg,
            defaultErrorMessage: 'Cannot obtain the host information from the server.'
        });

        hostJobs = jQuery('.hy-host-jobs .hy-table');
        if (hostJobs.length !== 0) {
            hostJobs.hytable('reload');
        }
    },

    init: function (id) {
        jQuery(document).ready(function () {
            var msg, toolbar, hostView;

            msg = jQuery('#' + id + '-message').hymessage();

            toolbar = jQuery('#' + id + '-toolbar').hytoolbar({
                conf: hydrogenConf[id],
                searchBox: false
            });

            hostView = jQuery('#' + id + '-host-view');

            jQuery('<div id="' + id + '-loaddiv" class="loading ui-state-default ui-state-active">' +
                   '  Loading ...' +
                   '</div>').appendTo(hostView);

            toolbar.bind('hytoolbaraction', function (e, action) {
                jQuery.hydrogen.executeAction(action,
                    null,
                    function () {
                        gridHostInfo.refresh(id);
                    },
                    msg);
            });

            gridHostInfo.refresh(id);

            jQuery.hydrogen.setupAutoRefresh(id, hydrogenConf, gridHostInfo.refresh);
        });
    },
    showCommandOutput: function(id, host, description, cmd, question) {
        var userInput;

        if (question) {
            // Ask user for input
            userInput = prompt(question);
            if (userInput !== null && userInput.trim() !== '') {
                // Replace placeholder %INPUT% with user input
                cmd = cmd.replace(/%INPUT%/g, userInput.trim());
            } else {
                return;
            }
        }

        jQuery.enginframe.invokeService({
            sdf: '/' + jQuery.enginframe.rootContext + '/grid/lib/xml/com.enginframe.grid.xml',
            uri: '//com.enginframe.grid/host.info.cmd',
            data: {
                host: host,
                remote_cmd: hydrogenConf[id].params.remoteCmd,
                cmd: cmd
            },
            success: function (output) {
                var dialog, textarea;

                dialog = jQuery('<div class="hy-action-dialog"></div>').appendTo(jQuery('body'));
                textarea = jQuery('<textarea rows="21" readonly="readonly" style="width: 99%; height: 99%;"/>').appendTo(dialog);
                dialog.dialog({
                    title: "Output of Command '" + efEncodeHtml(description) + "'",
                    buttons: {
                        'Close': function () {
                            jQuery(this).dialog('close');
                        }
                    },
                    width: jQuery(80).toPx(),
                    bgiframe: true,
                    modal: true
                });
                textarea.val(output);
                console.log(output);
            },
            dataType: 'text'
        });
    }
};

// ex:ts=4:et:
