/*global jQuery, hydrogenConf */
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */

var gridHostJobs = {
    refresh: function (id) {
        jQuery('#' + id + '-table').hytable('reload');
    },

    init: function (id) {

        jQuery(document).ready(function () {
            var box, msg, toolbar, table, searchBoxHint;

            box = jQuery('#' + id).collapsibleBox({
                title: hydrogenConf[id].params.title,
                cookieNamePrefix: 'host-jobs-box'
            });

            msg = jQuery('#' + id + '-message').hymessage();

            searchBoxHint = 'Search in all columns';
            toolbar = jQuery('#' + id + '-toolbar').hytoolbar({
                conf: hydrogenConf[id],
                searchBoxHint: searchBoxHint,
                searchBoxTooltip: 'Dates can be searched using YYYY/MM/DD notation or part of it, e.g. YYYY/MM, MM/DD, MM/'
            });

            table = jQuery('#' + id + '-table').hytable({
                xmlreader: {
                    root: 'job-list',
                    row: 'job',
                    page: 'job-list>page',
                    total: 'job-list>total',
                    records: 'job-list>records',
                    repeatitems: false,
                    id: 'id'
                },
                conf: hydrogenConf[id],
                messageArea: msg,
                defaultLoadErrorMessage: 'Cannot obtain the list of jobs from the server.'
            });

            table.bind('hytablegridcomplete', function (e, data) {
                box.toggleClass('ui-helper-hidden-accessible',
                    (table.hytable('nRecords') === 0 && toolbar.hytoolbar('search') === searchBoxHint));
            });

            table.bind('hytableloaderror', function (e, data) {
                box.toggleClass('ui-helper-hidden-accessible', false);
            });

            table.bind('hytableaction', function (e, data) {
                jQuery.hydrogen.executeAction(data.action,
                    {'%CURRENT_ID%': data.currentId},
                    function () {
                        table.hytable('reload', data.currentId);
                    },
                    msg);
            });

            table.bind('hytableselectionchanged', function (e, data) {
                toolbar.hytoolbar('viewProperties', {
                    'selected': table.hytable('selected').length
                });
            });

            toolbar.bind('hytoolbaraction', function (e, action) {
                var selectedIds;

                selectedIds = table.hytable('selected').join('\n');

                jQuery.hydrogen.executeAction(action,
                    {'%SELECTED_IDS%': selectedIds},
                    function () {
                        table.hytable('reload', selectedIds);
                    },
                    msg);
            });

            toolbar.bind('hytoolbarsearch', function (e, s) {
                var formula, params, date;

                if (s.search !== '') {
                    params = [
                        { key: "id", value: s.search, comparator: "?:=" },
                        { key: "ef-status", value: s.search, comparator: "?:=" },
                        { key: "queue", value: s.search, comparator: "?:=" },
                        { key: "execution-host", value: s.search, comparator: "?:=" },
                        { key: "name", value: s.search, comparator: "?:=" }
                    ];
                    if (s.search.match(/^\d*\/\d*\/?\d*$/)) {
                        date = ".*" + s.search.replaceAll("/", "-") + ".*";
                        params.push({ key: "submission-time", value: date, comparator: "~=" });
                    }

                    formula = jQuery.hydrogen.composeFilter(params, "or");
                } else {
                    formula = "";
                }

                table.hytable('filter', formula);
            });

            table.bind('hytablegridcomplete', function () {
                jQuery('td>span.hy-vtip').vtip();
            });

            jQuery.hydrogen.setupAutoRefresh(id, hydrogenConf, gridHostJobs.refresh);
        });
    }
};

// ex:ts=4:et:
