/*global jQuery, hydrogenConf */
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.
 */

var gridJobInfo = {
    
    changeNiceValue: function (id, grid, cluster, jobId) {
        var msg = jQuery('#' + id + '-message');

        jQuery.hydrogen.changeNiceDialog(grid, cluster, jobId, msg, function () {
            gridJobInfo.refresh(id);
        });
    },

    refresh: function (id) {
        var detailsDiv, loadDiv, msg;

        detailsDiv = jQuery('#' + id + '-job-details');
        loadDiv = jQuery('#' + id + '-loaddiv').show();
        msg = jQuery('#' + id + '-message');

        jQuery.hydrogen.invokeService({
            sdf: hydrogenConf[id].params.SDF,
            uri: hydrogenConf[id].params.serviceUri,
            data: hydrogenConf[id].params.serviceParams,
            complete: function () {
                loadDiv.hide();
            },
            success: function (html) {
                var content, label;

                // it may have been hidden if we are retrying
                jQuery('#' + id + '-toolbar').show();

                detailsDiv.html(html);

                content = jQuery('.hy-gridjobs-command');
                label = content.parent().prev();

                if (content.height() > label.height()) {
                    content.addClass('hy-gridjobs-command-ellipsize hy-gridjobs-command-clickable');
                    content.click(function () {
                        content.toggleClass('hy-gridjobs-command-ellipsize');
                    });
                }

                jQuery(".hy-iso8601-time", detailsDiv).each(function () {
                    var value, formatted;
                    value = jQuery(this).text();
                    formatted = jQuery.hydrogen.formatDate(value, {useRelativeDate: false});
                    jQuery(this).html(formatted);
                });

                if (jQuery('.hy-gridjobs-array-title').length > 0) {
                    jQuery('#' + hydrogenConf[id].params.arrayJobsWidgetId).removeClass('ui-helper-hidden-accessible');
                    jQuery('#' + hydrogenConf[id].params.arrayJobsWidgetId + '-table').hytable('reload');
                }

                if (hydrogenConf[id].params.allJobsLink && jQuery(".hy-gridjobs-job-list-link").length) {
                    jQuery(".hy-gridjobs-job-list-link a").attr('href', jQuery(".hy-gridjobs-job-list-link a").attr('href').replace('list.jobs', 'list.all.jobs'));
                }
            },
            error: function () {
                var err;

                // hide the toolbar, no point showing it on an empty page and
                // add a retry link to the error message
                jQuery('#' + id + '-toolbar').hide();
                // hide the job array list box too
                jQuery('#' + hydrogenConf[id].params.arrayJobsWidgetId).addClass('ui-helper-hidden-accessible');
                err = msg.hymessage('alert') + '<div class="hy-message-action"><a href="#">Retry</a></div>';
                msg.hymessage('alert', err);
                jQuery('.hy-message-action a', msg).click(function () {
                    gridJobInfo.refresh(id);
                });
            },
            dataType: 'html',
            messagebox: msg,
            defaultErrorMessage: 'Cannot obtain the job information from the server.'
        });
    },

    init: function (id) {

        jQuery(document).ready(function () {
            var msg, toolbar, jobView;

            msg = jQuery('#' + id + '-message').hymessage();

            toolbar = jQuery('#' + id + '-toolbar').hytoolbar({
                conf: hydrogenConf[id],
                searchBox: false
            });

            jobView = jQuery('#' + id + '-job-view');

            jQuery('<div id="' + id + '-loaddiv" class="loading ui-state-default ui-state-active">' +
                   '  Loading ...' +
                   '</div>').appendTo(jobView);

            toolbar.bind('hytoolbaraction', function (e, action) {
                jQuery.hydrogen.executeAction(action,
                    null,
                    function () {
                        gridJobInfo.refresh(id);
                    },
                    msg);
            });

            gridJobInfo.refresh(id);

            jQuery.hydrogen.setupAutoRefresh(id, hydrogenConf, gridJobInfo.refresh);
        });
    }
};

// ex:ts=4:et:

