/*global jQuery, hydrogenConf */
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */

var gridListClusters = {
    refresh: function (id) {
        jQuery('#' + id + '-table').hytable('reload');
    },

    clusterNameMaxlength: 50,
    clusterIdMaxlength: 60,

    init: function (id) {
        jQuery(document).ready(function () {
            var msg, toolbar, table;

            msg = hydrogenCommonUtils.message(id);

            toolbar = jQuery('#' + id + '-toolbar').hytoolbar({
                conf: hydrogenConf[id],
                searchBoxHint: 'Search by cluster name'
            });

            table = jQuery('#' + id + '-table').hytable({
                xmlreader: {
                    root: 'cluster-list',
                    row: 'cluster',
                    page: 'cluster-list>page',
                    total: 'cluster-list>total',
                    records: 'cluster-list>records',
                    repeatitems: false,
                    id: 'id'
                },
                conf: hydrogenConf[id],
                messageArea: msg,
                defaultLoadErrorMessage: 'Cannot obtain the list of clusters from the server.'
            });

            table.bind('hytableaction', function (e, data) {
                jQuery.hydrogen.executeAction(data.action,
                    {'%CURRENT_ID%': data.currentId},
                    function () {
                        table.hytable('reload', data.currentId);
                    },
                    msg);
            });

            table.bind('hytableselectionchanged', function (e, data) {
                toolbar.hytoolbar('viewProperties', {
                    'selected': table.hytable('selected').length
                });
            });

            toolbar.bind('hytoolbaraction', function (e, action) {
                var selectedIds;

                selectedIds = table.hytable('selected').join('\n');

                jQuery.hydrogen.executeAction(action,
                    {'%SELECTED_IDS%': selectedIds},
                    function () {
                        table.hytable('reload', selectedIds);
                    },
                    msg);
            });

            toolbar.bind('hytoolbarsearch', function (e, s) {
                var formula;

                formula = table.hytable('filter');

                if (formula !== null && formula !== '') {
                    if (s.search !== '') {
                        formula += " and name ?:= '" + s.search + "'";
                    }
                } else {
                    if (s.search !== '') {
                        formula = "name ?:= '" + s.search + "'";
                    } else {
                        formula = "";
                    }
                }

                table.hytable('filter', formula, false);
            });

            table.bind('hytablegridcomplete', function () {
                jQuery('td>span.hy-vtip').vtip();
            });

            jQuery.hydrogen.setupAutoRefresh(id, hydrogenConf, gridListClusters.refresh);
        });
    },

    onResponse(id, xmlResponse) {
        let msg = hydrogenCommonUtils.message(id);
        msg.css('white-space', 'pre-wrap')
        let error = jQuery(xmlResponse).find('ef\\:error');
        if (error.size() === 1) {
            msg.hymessage('error', error)
            return false;
        } else {
            msg.hymessage('info', efEncodeHtml(jQuery(xmlResponse).find('ef\\:message, message').text()), 20000)
            return true;
        }
    },

    goShareClusterPre: function (environment) {
        var clusterId = environment["%SELECTED_IDS%"];
        gridListClusters.goShareCluster(clusterId);
    },

    appendUserGroups: function (inputId) {
        jQuery.hydrogen.invokeService({
            sdf: '/' + jQuery.enginframe.rootContext + '/applications/applications.admin.xml',
            uri: '//com.enginframe.user-group-manager/list.groups',
            dataType: 'xml',
            data: {
                namespace: 'applications'
            },
            success: function (xml) {
                var userGroup, encUserGroup, userGroupList = '';
                var isAdminGroupPresent = false;
                jQuery(xml).find('ugm\\:group, group').each(function () {
                    userGroup = jQuery(this).attr('name');
                    encUserGroup = efEncodeHtml(userGroup);
                    if (userGroup !== "all-users" && userGroup !== "admin") {
                        userGroupList += '<label><input type="checkbox" name="user-group-multiselect" value="' + encUserGroup + '" disabled="disabled"/>' + encUserGroup + '</label>';
                    }
                });
                jQuery(userGroupList).appendTo(jQuery('div#' + inputId));
            }
        });
    },

    goShareCluster: function (id, clusterId) {
        var dialog, label, entry, button, dialogButtons, dialogId, inputId, availableAcl, folderInputId;

        let _this = this
        let message = jQuery('#' + id + '-message').hymessage();
        dialogId = Math.floor(Math.random() * 1000) + 1;
        inputId = 'input_' + dialogId;
        label = "Shared with:";

        //FIXME: use a proper dialog
        dialog = jQuery('<div class="ef-manage-services-publish-dialog" id="' + dialogId + '"/>').appendTo(jQuery('body'));
        jQuery('<div class="ef-manage-services-publish-message" style="display:none;" />').appendTo(dialog);

        jQuery('<label for="new-value" style="display:block;padding-bottom:5px;">' + label + '</label>').appendTo(dialog);

        selectedInputId = 'groups_' + Math.floor(Math.random() * 1000) + 1;

        jQuery('.ef-ugm-multiselect input:checkbox[name=user-group-multiselect]').addClass('greyed').attr('disabled', 'disabled');
        jQuery('div#' + inputId).addClass('greyed');

        jQuery('<div class="input-radio"><input type="radio" name="users" value="admins" checked="checked"/>Only Administrators</div>').appendTo(dialog);
        jQuery('<div class="input-radio"><input type="radio" name="users" value="all"/>All Users</div>').appendTo(dialog);
        jQuery('<div class="input-radio"><input type="radio" name="users" value="selected"/>Selected Groups</div>').appendTo(dialog);
        jQuery('<div class="ef-ugm-multiselect greyed" id="' + inputId + '"></div>').appendTo(dialog);
        gridListClusters.appendUserGroups(inputId);

        jQuery('div#' + dialogId + ' input:radio[name=users]').click(function () {
            if (jQuery('div#' + dialogId + ' input:radio[name=users]:checked').val() === "selected") {
                jQuery('.ef-ugm-multiselect input:checkbox[name=user-group-multiselect]').removeClass('greyed').removeAttr('disabled');
                jQuery('div#' + inputId).removeClass('greyed');
            }
            else {
                jQuery('.ef-ugm-multiselect input:checkbox[name=user-group-multiselect]').addClass('greyed').attr('disabled', 'disabled');
                jQuery('div#' + inputId).addClass('greyed');
            }
        });

        dialogButtons = {
            Cancel: function () {
                jQuery(this).dialog("close");
            }
        };
        dialogButtons.Save = function () {
            var userGroupList, msg, selectedValue, access, targetFolderName;

            selectedValue = jQuery('div#' + dialogId + ' input:radio[name=users]:checked').val();

            if (selectedValue === "all") {
                userGroupList = "all-users";
            } else {
                userGroupList = '';
                jQuery('div#' + dialogId + ' input:checkbox[name=user-group-multiselect]:checked').each(function (index) {
                    if (index !== 0) {
                        userGroupList += ',';
                    }
                    userGroupList += jQuery(this).val();
                });
            }
            jQuery(this).dialog("close");

            jQuery.hydrogen.invokeService({
                sdf: '/' + jQuery.enginframe.rootContext + '/applications/applications.admin.xml',
                uri: '//hpc.actions/share.cluster',
                data: {
                    cluster_id: clusterId,
                    acl: userGroupList
                },
                success: function (xml, statusText, xhr) {
                    if (_this.onResponse(id, xml)) _this.refresh(id);
                },
                messagebox: message
            });

        };

        dialog.dialog({
            title: "Share Cluster",
            resizable: false,
            buttons: dialogButtons,
            modal: true
        });

        button = jQuery('button:contains(Save)', dialog.parent('div.ui-dialog'));
        button.addClass('ui-priority-primary');
        dialog.keypress(function (e) {
            if (e.which === 13) {
                button.click();
                return false;
            }
            return true;
        });
    },

    goRenameCluster: function (id, clusterId) {
        let _this = this
        let msg = hydrogenCommonUtils.message(id);
        gridListClusters.renameClusterDialog("Rename Cluster", "Rename", function (newName) {
            jQuery.hydrogen.invokeService({
                sdf: '/' + jQuery.enginframe.rootContext + '/applications/applications.admin.xml',
                uri: '//hpc.actions/rename.cluster',
                data: {
                    cluster_id: clusterId,
                    cluster_name: newName
                },
                success: function (xml, statusText, xhr) {
                    if (_this.onResponse(id, xml)) _this.refresh(id);
                },
                messagebox: msg
            });
        });
    },

    goDeleteCluster: function (id, clusterId) {
        let _this = this
        let msg = hydrogenCommonUtils.message(id);
        gridListClusters.alertClusterDialog("delete-cluster",
    "Delete Cluster",
    "Do you really want to delete the selected cluster?",
    "Delete",
    function () {
                    jQuery.hydrogen.invokeService({
                        sdf: '/' + jQuery.enginframe.rootContext + '/applications/applications.admin.xml',
                        uri: '//hpc.actions/delete.cluster',
                        data: {
                            cluster_id: clusterId
                        },
                        success: function (xml, statusText, xhr) {
                            if (_this.onResponse(id, xml)) _this.refresh(id);
                        },
                        messagebox: msg
                    });
              });
    },

    goStopCluster: function (id, clusterId) {
        let _this = this
        let msg = hydrogenCommonUtils.message(id);
        gridListClusters.alertClusterDialog("stop-cluster",
            "Stop Cluster",
            "Do you really want to stop the selected cluster?",
            "Stop",
            function () {
                jQuery.hydrogen.invokeService({
                    sdf: '/' + jQuery.enginframe.rootContext + '/applications/applications.admin.xml',
                    uri: '//hpc.actions/stop.cluster',
                    data: {
                        cluster_id: clusterId
                    },
                    success: function (xml, statusText, xhr) {
                        if (_this.onResponse(id, xml)) _this.refresh(id);
                    },
                    messagebox: msg
                });
            });
    },

    goRestoreCluster: function (id, clusterId) {
        let _this = this
        let msg = hydrogenCommonUtils.message(id);
        gridListClusters.alertClusterDialog("restore-cluster",
            "Restore Cluster",
            "Do you really want to restore the selected cluster?",
            "Restore",
            function () {
                jQuery.hydrogen.invokeService({
                    sdf: '/' + jQuery.enginframe.rootContext + '/applications/applications.admin.xml',
                    uri: '//hpc.actions/restore.cluster',
                    data: {
                        cluster_id: clusterId
                    },
                    success: function (xml, statusText, xhr) {
                        if (_this.onResponse(id, xml)) _this.refresh(id);
                    },
                    messagebox: msg
                });
            });
    },

    goStartCluster: function (id, clusterId) {
        let _this = this
        let msg = hydrogenCommonUtils.message(id);
        jQuery.hydrogen.invokeService({
            sdf: '/' + jQuery.enginframe.rootContext + '/applications/applications.admin.xml',
            uri: '//hpc.actions/start.cluster',
            data: {
                cluster_id: clusterId
            },
            success: function (xml, statusText, xhr) {
                if (_this.onResponse(id, xml)) _this.refresh(id);
            },
            messagebox: msg
        });
    },

    goUpdateCluster: function (id, clusterId) {
        let _this = this
        let msg = hydrogenCommonUtils.message(id);
        let loadDiv = jQuery('#load_' + id + '-table-hy-table');
        loadDiv.show()

        jQuery.hydrogen.invokeService({
            sdf: '/' + jQuery.enginframe.rootContext + '/applications/applications.admin.xml',
            uri: '//hpc.actions/get.up-to-date.cluster',
            data: {
                cluster_id: clusterId
            },
            complete: function () {
                loadDiv.hide();
            },
            success: function (xml, statusText, xhr) {
                if (_this.onResponse(id, xml)) {
                    _this.refresh(id);
                    /*FIXME
                    To avoid this refresh that calls a Kotlin scriptlet you can use the code below,
                    the problem is that the output gives the status in upper case (READY instead of Ready)
                    probably to fix we want to use the clusterStatusFormatter
                    and I did not found a way to use it here

                    jQuery(xml).find('grid\\:cluster').each(function(index) {
                        let id = jQuery(this).attr("id")
                        let status = jQuery(this).attr("status")
                        let queues = jQuery(this).attr("queues")
                        jQuery("#" + id).find(".hy-cluster-status").replaceWith('<span class="hy-cluster-status hy-cluster-status-' + status + '">' + status + '</span>')
                        jQuery("#" + id).find("[aria-describedby='ef-list-clusters-table-hy-table_queues']").replaceWith('<td role="gridcell" style class="ui-ellipsis" title="' + queues + '" aria-describedby="ef-list-clusters-table-hy-table_queues">' + queues + '</td>')
                    })
                    */
                }
            }
        });
    },

    renameClusterDialog: function (dialogTitle, buttonLabel, actionfunc) {
        let dialog = jQuery("#hy-rename-cluster-dialog");
        if (dialog.length === 0) {
            dialog = jQuery('<div class="hy-manage-cluster-dialog hy-simple-input-dialog" id="hy-rename-cluster-dialog"/>').appendTo(jQuery('body'));
            jQuery('<div class="dialog-message" style="display:none;" />').appendTo(dialog);
            jQuery('<label for="cluster_name" style="display:block">Cluster Name:</label>').appendTo(dialog);
            jQuery('<input type="text" name="cluster_name" id="cluster_name" maxlength="'+ this.clusterNameMaxlength +'" style="width: 99%"/>').appendTo(dialog);
        }

        let msg = hydrogenCommonUtils.dialogMessage('hy-rename-cluster-dialog').val('')
        let clusterNameEntry = hydrogenCommonUtils.dialogInput('hy-rename-cluster-dialog', 'cluster_name').val('');
        hydrogenCommonUtils.dialogClearWhenClosing('hy-rename-cluster-dialog')

        let dialogButtons = {
            Cancel: function () {
                jQuery(this).dialog("close");
            }
        };
        dialogButtons[buttonLabel] = function () {
            let clusterName = clusterNameEntry.val();

            // Validation
            if (clusterName.match("^\\s*$")) {
                msg.hymessage().hymessage('alert', "Cluster name cannot be empty");
                return false;
            }

            jQuery(this).dialog("close");

            actionfunc(clusterName);
        };

        dialog.dialog({
            title: dialogTitle,
            resizable: false,
            buttons: dialogButtons,
            modal: true,
        });

        let button = jQuery('button:contains(' + buttonLabel + ')', dialog.parent('div.ui-dialog'));
        button.addClass('ui-priority-primary');
    },

    alertClusterDialog: function (dialogId, dialogTitle, dialogLabel, buttonLabel, actionfunc) {
        let _id = "hy-" + dialogId + "-dialog"
        let dialog = jQuery(_id);
        if (dialog.length === 0) {
            dialog = jQuery('<div class="hy-manage-cluster-dialog hy-simple-input-dialog" id=' + _id + '/>').appendTo(jQuery('body'));
            jQuery('<div class="dialog-message" style="display:none;" />').appendTo(dialog);
            jQuery('<label for="dialog-label" style="display:block">' + dialogLabel + '</label>').appendTo(dialog);
        }

        let msg = hydrogenCommonUtils.dialogMessage(_id).val('')
        hydrogenCommonUtils.dialogClearWhenClosing(_id)

        let dialogButtons = {
            Cancel: function () {
                jQuery(this).dialog("close");
            }
        };
        dialogButtons[buttonLabel] = function () {
            jQuery(this).dialog("close");
            actionfunc();
        };

        dialog.dialog({
            title: dialogTitle,
            resizable: false,
            buttons: dialogButtons,
            modal: true,
        });

        let button = jQuery('button:contains(' + buttonLabel + ')', dialog.parent('div.ui-dialog'));
        button.addClass('ui-priority-primary');
    },

    goImportCluster: function (id) {
        let _this = this
        let msg = hydrogenCommonUtils.message(id);
        this.importClusterDialog("Import Cluster", "Import",function (data) {
            jQuery.hydrogen.invokeService({
                sdf: '/' + jQuery.enginframe.rootContext + '/applications/applications.admin.xml',
                uri: '//hpc.actions/import.cluster',
                data: data,
                success: function (xml, statusText, xhr) {
                    if (_this.onResponse(id, xml)) _this.refresh(id);
                },
                messagebox: msg
            });
        })
    },

    loadClustersToImport: function() {
        let _this = this
        let dialogId = "hy-import-cluster-dialog"
        let msg = hydrogenCommonUtils.dialogMessage(dialogId).hymessage()
        let loading = jQuery("#hy-import-cluster-dialog .loading")

        loading.text('Loading...')
        jQuery.hydrogen.invokeService({
            sdf: '/' + jQuery.enginframe.rootContext + '/applications/applications.admin.xml',
            uri: '//hpc.actions/list.clusters.to.import',
            data: {
                // account_id: jQuery("#account_id").val(),
                cluster_type: jQuery("#cluster_type").val(),
                // region: jQuery("#region").val(),
                scheduler: jQuery("#scheduler").val(),
            },
            success: function (xml, statusText, xhr) {
                if (_this.onResponse(dialogId, xml)) {
                    let clusters = jQuery("#cluster_id");
                    jQuery(clusters).empty();
                    jQuery(xml).find('grid\\:cluster-to-import').each(function(index) {
                        let id = jQuery(this).attr("id")
                        jQuery(clusters).append($("<option></option>")
                            .attr("value", id).text(id));
                    });
                }
                loading.text('')
            },
            messagebox: msg
        });
    },

    importClusterDialog: function (dialogTitle, buttonLabel, actionfunc) {
        let dialog = jQuery("#hy-import-cluster-dialog");
        if (dialog.length === 0) {
            dialog = jQuery('<div class="ef-manage-cluster-dialog hy-simple-input-dialog" id="hy-import-cluster-dialog"/>').appendTo(jQuery('body'));
            jQuery('<div class="dialog-message" style="display:none;" />').appendTo(dialog);
            jQuery('<div class="loading" style="position: absolute;background-color: #e4e4e4;text-align: center;width: calc(100% - 2em);"/>').appendTo(dialog);

            jQuery('<input type="hidden" name="cluster_type" id="cluster_type" value="pc"/>').appendTo(dialog);

            // jQuery('<label for="account_id" style="display:block">Account Id:</label>').appendTo(dialog);
            // jQuery('<input type="text" name="account_id" id="account_id" maxlength="12" style="width: 110px"/>').appendTo(dialog);
            //
            // jQuery('<label for="region" style="display:block">Region:</label>').appendTo(dialog);
            // jQuery('<input type="text" name="region" id="region" maxlength="12" style="width: 110px"/>').appendTo(dialog);

            jQuery('<label for="scheduler" style="display:block">Scheduler:</label>').appendTo(dialog);
            jQuery('<input type="text" name="scheduler" id="scheduler" maxlength="63" value="slurm" style="width: 99%" readonly/>').appendTo(dialog);

            jQuery('<label for="cluster_id" style="display:block">Cluster:</label>').appendTo(dialog);

            let div = jQuery('<div style="display: table"/>').appendTo(dialog)
            jQuery('<div style="display: table-cell"><i class="fa fa-refresh" onclick="gridListClusters.loadClustersToImport()"/></div>').appendTo(div)
            jQuery('<div style="display: table-cell;width:100%;"><select style="width:99%" name="cluster_id" id="cluster_id"/></div>').appendTo(div);

            jQuery('<label for="cluster_name" style="display:block">Cluster Label:</label>').appendTo(dialog);
            jQuery('<input type="text" name="cluster_name" id="cluster_name" maxlength="'+ this.clusterNameMaxlength +'" style="width: 99%"/>').appendTo(dialog);

            gridUserModes.addToDialog(dialog)

            // jQuery('<label for="bucket_name" style="display:block">Bucket Name:</label>').appendTo(dialog);
            // jQuery('<input type="text" name="bucket_name" id="bucket_name" maxlength="63" style="width: 99%"/>').appendTo(dialog);
        }

        let _this = this
        let msg = hydrogenCommonUtils.dialogMessage('hy-import-cluster-dialog').val('')
        // let accountIdEntry = jQuery('#account_id').attr('type') === 'hidden' ?
        //     hydrogenCommonUtils.dialogInput('hy-import-cluster-dialog', 'account_id') :
        //     hydrogenCommonUtils.dialogInput('hy-import-cluster-dialog', 'account_id').val('')
        // let bucketNameEntry = hydrogenCommonUtils.dialogInput('hy-import-cluster-dialog', 'bucket_name').val('');
        let clusterIdEntry = hydrogenCommonUtils.dialogTagByName('hy-import-cluster-dialog', 'select', 'cluster_id').val('');
        let clusterNameEntry = hydrogenCommonUtils.dialogInput('hy-import-cluster-dialog', 'cluster_name').val('');

        gridUserModes.prepareDialog('hy-import-cluster-dialog');

        hydrogenCommonUtils.dialogClearWhenClosing('hy-import-cluster-dialog')

        let dialogButtons = {
            Cancel: function () {
                jQuery(this).dialog("close");
            }
        };

        dialogButtons[buttonLabel] = function () {
            let clusterId = clusterIdEntry.val();
            let clusterName = clusterNameEntry.val();
            // let accountId = accountIdEntry.val();

            // Validation
            if (!clusterId || clusterId.length <= 0) {
                msg.hymessage().hymessage('alert', "Please select a cluster to import");
                return false;
            }

            if (clusterName.length <= 0) {
                msg.hymessage().hymessage('alert', "Cluster Label cannot be empty");
                return false;
            }

            if (!gridUserModes.validate('hy-import-cluster-dialog')) return false;

            //
            // if (accountId.length <= 0) {
            //     msg.hymessage().hymessage('alert', "AWS account id cannot be empty");
            //     return false;
            // }
            // if (!/^\d{12}$/.test(accountId)) {
            //     msg.hymessage().hymessage('alert', "AWS account id should contain exactly 12 digits");
            //     return false;
            // }

            // let bucketName = bucketNameEntry.val();
            // if (bucketName.length <= 0) {
            //     msg.hymessage().hymessage('alert', "AWS S3 bucket name cannot be empty");
            //     return false;
            // }
            //
            // if (!/(?!^(\d{1,3}\.){3}\d{1,3}$)(^[a-z0-9]([a-z0-9-]*(\.[a-z0-9])?)*$(?<!\-))/.test(bucketName)) {
            //     msg.hymessage().hymessage('alert', "Invalid AWS S3 Bucket name (requirements <a href='https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-s3-bucket-naming-requirements.html' target='_blank'>here</a>)");
            //     return false;
            // }

            let data = {
                cluster_type: hydrogenCommonUtils.dialogInput('hy-import-cluster-dialog', 'cluster_type').val(),
                cluster_id: hydrogenCommonUtils.dialogTagByName('hy-import-cluster-dialog', 'select', 'cluster_id').val(),
                cluster_name: clusterName,
                // account_id: hydrogenCommonUtils.dialogInput('hy-import-cluster-dialog', 'account_id').val(),
                // bucket_name: hydrogenCommonUtils.dialogInput('hy-import-cluster-dialog', 'bucket_name').val(),
                scheduler: hydrogenCommonUtils.dialogInput('hy-import-cluster-dialog', 'scheduler').val(),
                user_mode: gridUserModes.selectedUserModeJson('hy-import-cluster-dialog')
                // region: hydrogenCommonUtils.dialogInput('hy-import-cluster-dialog', 'region').val(),
            }

            actionfunc(data);

            jQuery(this).dialog("close");
        };

        dialog.dialog({
            title: dialogTitle,
            resizable: false,
            buttons: dialogButtons,
            modal: true,
            width: "550px",
        });

        let button = jQuery('button:contains(' + buttonLabel + ')', dialog.parent('div.ui-dialog'));
        button.addClass('ui-priority-primary');
    },
};

// ex:ts=4:et:
