/*global jQuery, hydrogenConf */
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */

var gridListHosts = {
    refresh: function (id) {
        jQuery('#' + id + '-list-view').hytable('reload');
        jQuery('#' + id + '-compact-view').hycompactview('reload');
        jQuery('#' + id + '-charts').hycharts('reload');
    },

    init: function (id) {

        function createListView(msg, initialFilter) {
            var listView;

            listView = jQuery('#' + id + '-list-view').hytable({
                xmlreader: {
                    root: 'host-list',
                    row: 'host',
                    page: 'host-list>page',
                    total: 'host-list>total',
                    records: 'host-list>records',
                    repeatitems: false,
                    id: 'name'
                },
                conf: hydrogenConf[id],
                loadDataOnInit: false,
                messageArea: msg,
                defaultFilter: initialFilter,
                defaultLoadErrorMessage: 'Cannot obtain the cluster load information from the server.'
            }).hide();

            return listView;
        }

        function createCompactView(msg, initialFilter) {
            var compactView;

            compactView = jQuery('#' + id + '-compact-view').hycompactview({
                conf: hydrogenConf[id],
                messageArea: msg,
                defaultFilter: initialFilter,
                defaultLoadErrorMessage: 'Cannot obtain the cluster load information from the server.'
            }).hide();

            return compactView;
        }

        // TODO: reload charts on grid-complete?

        jQuery(document).ready(function () {
            var msg, toolbar, listView, compactView, clusters, filters, initialFilter;

            msg = jQuery('#' + id + '-message').hymessage();

            toolbar = jQuery('#' + id + '-toolbar').hytoolbar({
                conf: hydrogenConf[id],
                views: [
                    {id: 'compact', icon: 'grid'},
                    {id: 'list', icon: 'list'}
                ],
                searchBoxHint: 'Search by host name'
            });

            clusters = jQuery('#' + id + '-clusters').hyclusters({
                conf: hydrogenConf[id]
            });

            filters = jQuery('#' + id + '-filters').hyfilters({
                conf: hydrogenConf[id]
            });

            initialFilter = filters.hyfilters('selected');

            listView = createListView(msg, initialFilter);
            compactView = createCompactView(msg, initialFilter);

            if (toolbar.hytoolbar('activeView').id === 'list') {
                listView.show();
                listView.hytable('reload');
            } else {
                compactView.show();
                compactView.hycompactview('reload');
            }

            jQuery('#' + id + '-charts').hycharts({
                conf: hydrogenConf[id]
            });

            clusters.bind('hyclustersselect', function (e, c) {
                location.search = jQuery.query.set('grid', c.cluster.type).set('cluster', c.cluster.id).toString();
            });

            filters.bind('hyfiltersselect', function (e, filter) {
                toolbar.hytoolbar('search', '');
                listView.hytable('filter', filter.formula);
                compactView.hycompactview('filter', filter.formula);
            });

            toolbar.bind('hytoolbarviewchanged', function (e, view) {
                if (view.id === 'list') {
                    compactView.hide();
                    listView.show();
                    listView.hytable('reload');
                } else {
                    listView.hide();
                    compactView.show();
                    compactView.hycompactview('reload');
                }
            });

            listView.bind('hytableaction', function (e, data) {
                jQuery.hydrogen.executeAction(data.action,
                    {'%CURRENT_ID%': data.currentId},
                    function () {
                        gridListHosts.refresh(id);
                    },
                    msg);
            });

            listView.bind('hytableselectionchanged', function (e, data) {
                toolbar.hytoolbar('viewProperties', {
                    'selected': listView.hytable('selected').length
                });
            });

            compactView.bind('hycompactviewselectionchanged', function (e, data) {
                toolbar.hytoolbar('viewProperties', {
                    'selected': compactView.hycompactview('selected').length
                });
            });

            toolbar.bind('hytoolbaraction', function (e, action) {
                jQuery.hydrogen.executeAction(action,
                    {'%SELECTED_IDS%': function () {
                        return listView.hytable('selected').join('\n');
                    }
                        },
                    function () {
                        gridListHosts.refresh(id);
                    },
                    msg);
            });

            toolbar.bind('hytoolbarsearch', function (e, s) {
                var formula;

                formula = listView.hytable('filter');

                if (formula !== null && formula !== '') {
                    if (s.search !== '') {
                        formula += " and name ?:= '" + s.search + "'";
                    }
                } else {
                    if (s.search !== '') {
                        formula = "name ?:= '" + s.search + "'";
                    } else {
                        formula = "";
                    }
                }

                listView.hytable('filter', formula, false);
                compactView.hycompactview('filter', formula);
            });

            jQuery.hydrogen.setupAutoRefresh(id, hydrogenConf, gridListHosts.refresh);
        });
    }
};

// ex:ts=4:et:
