/*global jQuery, hydrogenConf */
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.
 */

var gridListJobs = {
    refresh: function (id, selectedIds) {
        jQuery('#' + id + '-table').hytable('reload', selectedIds);
    },

    changeNiceValue: function (id, grid, cluster, environment) {
        var msg, selectedIds;

        msg = jQuery('#' + id + '-message');
        selectedIds = environment["%SELECTED_IDS%"];
        jQuery.hydrogen.changeNiceDialog(grid, cluster, selectedIds, msg, function () {
            gridListJobs.refresh(id, selectedIds);
        });
    },

    init: function (id) {

        jQuery(document).ready(function () {
            var msg, toolbar, table, clusters, filters, queues, initialFilter;

            msg = jQuery('#' + id + '-message').hymessage();

            toolbar = jQuery('#' + id + '-toolbar').hytoolbar({
                conf: hydrogenConf[id],
                searchBoxHint: 'Search in all columns',
                searchBoxTooltip: 'Dates can be searched using YYYY/MM/DD notation or part of it, e.g. YYYY/MM, MM/DD, MM/'
            });

            clusters = jQuery('#' + id + '-clusters').hyclusters({
                conf: hydrogenConf[id]
            });

            filters = jQuery('#' + id + '-filters').hyfilters({
                conf: hydrogenConf[id]
            });

            initialFilter = filters.hyfilters('selected');

            hydrogenConf[id].colmodel.push({
                hidden: true,
                name: 'selectable',
                xmlmap: function (row) {
                    if (jQuery(row).attr('id').startsWith("app://")) {
                        return 'false';
                    }
                    return 'true';
                }
            });

            table = jQuery('#' + id + '-table').hytable({
                xmlreader: {
                    root: 'job-list',
                    row: 'job',
                    page: 'job-list>page',
                    total: 'job-list>total',
                    records: 'job-list>records',
                    repeatitems: false,
                    id: 'id'
                },
                conf: hydrogenConf[id],
                messageArea: msg,
                defaultFilter: initialFilter,
                defaultLoadErrorMessage: 'Cannot obtain the list of jobs from the server.'
            });

            queues = jQuery('#' + id + '-queues').hyqueues({
                conf: hydrogenConf[id]
            });

            clusters.bind('hyclustersselect', function (e, c) {
                location.search = jQuery.query.set('grid', c.cluster.type).set('cluster', c.cluster.id).toString();
            });

            filters.bind('hyfiltersselect', function (e, filter) {
                queues.hyqueues('unselectAll');
                toolbar.hytoolbar('search', '');
                table.hytable('filter', filter.formula);
            });

            queues.bind('hyqueuesselect', function (e, filter) {
                filters.hyfilters('unselectAll');
                toolbar.hytoolbar('search', '');
                table.hytable('filter', filter.formula);
            });

            table.bind('hytableloadcomplete', function (e, xhr) {
                queues.hyqueues('update');
            });

            table.bind('hytableaction', function (e, data) {
                jQuery.hydrogen.executeAction(data.action,
                    {'%CURRENT_ID%': data.currentId},
                    function () {
                        table.hytable('reload', data.currentId);
                    },
                    msg);
            });

            table.bind('hytableselectionchanged', function (e, data) {
                toolbar.hytoolbar('viewProperties', {
                    'selected': table.hytable('selected').length
                });
            });

            toolbar.bind('hytoolbaraction', function (e, action) {
                var selectedIds;

                selectedIds = table.hytable('selected').join('\n');

                jQuery.hydrogen.executeAction(action,
                    {'%SELECTED_IDS%': selectedIds},
                    function () {
                        table.hytable('reload', selectedIds);
                    },
                    msg);
            });

            toolbar.bind('hytoolbarsearch', function (e, s) {
                var formula, params, date, filter;

                formula = table.hytable('filter');

                if (s.search !== '') {
                    params = [
                        { key: "id", value: s.search, comparator: "?:=" },
                        { key: "ef-status", value: s.search, comparator: "?:=" },
                        { key: "queue", value: s.search, comparator: "?:=" },
                        { key: "execution-host", value: s.search, comparator: "?:=" },
                        { key: "name", value: s.search, comparator: "?:=" }
                    ];
                    if (s.search.match(/^\d*\/\d*\/?\d*$/)) {
                        date = ".*" + s.search.replaceAll("/", "-") + ".*";
                        params.push({ key: "submission-time", value: date, comparator: "~=" });
                    }

                    filter = jQuery.hydrogen.composeFilter(params, "or");
                }

                if (formula !== null && formula !== '') {
                    if (filter !== undefined) {
                        formula += " and " + filter;
                    }
                } else {
                    if (filter !== undefined) {
                        formula = filter;
                    } else {
                        formula = "";
                    }
                }

                table.hytable('filter', formula, false);
            });

            table.bind('hytablegridcomplete', function () {
                jQuery('td>span.hy-vtip').vtip();
            });

            jQuery.hydrogen.setupAutoRefresh(id, hydrogenConf, gridListJobs.refresh);
        });
    }
};

// ex:ts=4:et:
