/*global jQuery, hydrogenConf */
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */

var interactiveConnectSession = {

    init: function (id) {
        var self, msg, connectionBar;

        self = this;

        msg = jQuery('#' + id + '-message').hymessage();
        connectionBar = jQuery('#' + id + '-connectionbar').hyconnectionbar({
            conf: hydrogenConf[id],
            messageArea: msg
        });

        function redirectToDetails() {
            setTimeout(function () {
                var loc = window.location;
                window.location = loc.pathname +
                                  '?_uri=//com.enginframe.interactive/session.info' +
                                  '&sessionUri=' + encodeURIComponent(hydrogenConf[id].params.sessionUri);
            }, 2000);
            return;
        }

        connectionBar.bind('hyconnectionbarupdated', function (e, data) {
            if (data.status === 'Failed' || data.status === 'Error' || data.status === 'Closing' || data.status === 'Closed') {
                redirectToDetails();
            }
        });

        connectionBar.bind('hyconnectionbarexpired', function () {
            redirectToDetails();
        });

        connectionBar.hyconnectionbar('start', {
            sessionUri: hydrogenConf[id].params.sessionUri,
            sessionRemote: hydrogenConf[id].params.sessionRemote,
            initialStatus: hydrogenConf[id].params.initialStatus,
            allowStarting: hydrogenConf[id].params.allowStarting
        });
    }

};

// ex:ts=4:et:
