/*global jQuery, hydrogenConf */
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */

var interactiveSessionInfo = {
    refresh: function (id) {
        var self, detailsDiv, loadDiv, msg;

        self = this;

        detailsDiv = jQuery('#' + id + '-session-details');
        loadDiv = jQuery('#' + id + '-loaddiv').show();
        msg = jQuery('#' + id + '-message');

        jQuery.hydrogen.invokeService({
            sdf: hydrogenConf[id].params.SDF,
            uri: hydrogenConf[id].params.serviceUri,
            data: hydrogenConf[id].params.serviceParams,
            complete: function () {
                loadDiv.hide();
            },
            success: function (html) {
                // it may have been hidden if we are retrying
                jQuery('#' + id + '-toolbar').show();

                detailsDiv.html(html);

                jQuery(".hy-session-warning", detailsDiv).each(function () {
                    jQuery('#' + id + '-message').hymessage('info', jQuery(this).html());
                });

                jQuery(".hy-iso8601-time", detailsDiv).each(function () {
                    var value, formatted;
                    value = jQuery(this).text();
                    formatted = jQuery.hydrogen.formatDate(value, {useRelativeDate: false});
                    jQuery(this).html(formatted);
                });

                jQuery(".hy-session-info-screen-starting .hy-session-info-spinner," +
                       ".hy-session-info-screen-pending .hy-session-info-spinner").spin({
                    lines: 11,
                    length: 7,
                    width: 5,
                    radius: 10,
                    corners: 1.0,
                    rotate: 0,
                    trail: 50,
                    speed: 0.6,
                    fps: 10,
                    zIndex: 500, // high but less than dialogs
                    shadow: "on",
                    hwaccel: "off"
                });

                jQuery('.hy-session-info-screen-wrapper a', detailsDiv).click(function () {
                    self.connect(id, {
                        sessionUri: hydrogenConf[id].params.serviceParams.sessionUri,
                        sessionRemote: hydrogenConf[id].params.serviceParams.sessionRemote,
                        initialStatus: 'Running',
                        allowStarting: false
                    });
                });

                jQuery('div.hy-star').toggleStar(hydrogenConf[id].params.serviceParams.sessionUri);
            },
            error: function () {
                var err;

                // hide the toolbar, no point showing it on an empty page and
                // add a retry link to the error message
                jQuery('#' + id + '-toolbar').hide();
                err = msg.hymessage('alert') + '<div class="hy-message-action"><a href="#">Retry</a></div>';
                msg.hymessage('alert', err);
                jQuery('.hy-message-action a', msg).click(function () {
                    interactiveSessionInfo.refresh(id);
                });
            },
            dataType: 'html',
            messagebox: msg,
            defaultErrorMessage: 'Cannot obtain the session information from the server.'
        });
    },

    connect: function (id, data) {
        jQuery('#' + id + '-connectionbar').hyconnectionbar('start', data);
    },

    cleanup: function (id, sessionUri) {
        var msg;

        msg = jQuery('#' + id + '-message');

        // We do this manually since we need to redirect to the session list
        jQuery.hydrogen.invokeService({
            sdf: jQuery.hydrogen.SDF,
            uri: '//com.enginframe.interactive/cleanup.sessions',
            data: {
                sessionUris: sessionUri
            },
            success: function (data, textStatus) {
                window.location = window.location.pathname + '?_uri=//com.enginframe.interactive/list.sessions';
            },
            messagebox: msg,
            dataType: 'text'
        });
    },

    renameDialog: function (id, sessionUri) {
        var msg = jQuery('#' + id + '-message').hymessage();
        jQuery.hydrogen.renameSessionDialog(sessionUri, msg, function () {
            interactiveSessionInfo.refresh(id);
        });
    },

    shareDialog: function (id, sessionUri, sessionProps) {
        var dialog;

        jQuery('<div class="hy-action-dialog"/>').hysessionsharedialog({
            conf: hydrogenConf[id],
            sessionUri: sessionUri,
            supportViewOnly: sessionProps.supportViewOnly,
            onSave: function () {
                interactiveSessionInfo.refresh(id);
            }
        });
    },

    logDialog: function (id, sessionUri) {
        var dialog, textarea;

        function updateLogData() {
            jQuery.enginframe.invokeService({
                sdf: '/' + jQuery.enginframe.rootContext + '/interactive/lib/xml/com.enginframe.interactive.xml',
                uri: hydrogenConf[id].params.logDataServiceUri,
                data: {
                    sessionUri: sessionUri
                },
                success: function (output) {
                    textarea.val(output);
                },
                dataType: 'text'
            });
        }

        dialog = jQuery('<div class="hy-action-dialog"/>').appendTo(jQuery('body'));
        textarea = jQuery('<textarea rows="25" readonly="readonly" style="width: 99%; height: 99%; resize: none;"/>').appendTo(dialog);
        dialog.dialog({
            title: "Session Log",
            width: jQuery(80).toPx(),
            bgiframe: true,
            modal: true,
            buttons: {
                Refresh: function () {
                    updateLogData();
                },
                Close: function () {
                    jQuery(this).dialog("close");
                }
            }
        });

        updateLogData();
    },

    debugInfoDialog: function (id, sessionUri) {
        var dialog;
        var height = jQuery(window).height() * 0.8;

        dialog = jQuery('<div class="hy-action-dialog"/>').appendTo(jQuery('body'));
        dialog.dialog({
            title: "Session Debug Info",
            width: jQuery(window).width() * 0.7,
            height: height,
            bgiframe: true,
            modal: true,
            buttons: {
                Close: function () {
                    jQuery(this).dialog("close");
                }
            }
        });

        jQuery.enginframe.invokeService({
            sdf: '/' + jQuery.enginframe.rootContext + '/interactive/lib/xml/com.enginframe.interactive.xml',
            uri: '//com.enginframe.interactive/list.session.files',
            data: {
                sessionUri: sessionUri
            },
            success: function (html) {
                jQuery('<div/>').appendTo(dialog).html(html).tabs({
                    beforeLoad: function (event, ui) {
                        event.preventDefault();
                        // load raw content in a iframe instead of parsing them
                        if (!ui.panel.find('iframe')[0]) {
                            jQuery('<iframe width="100%" height="' + (height - 180) + '" frameBorder="0" src="' + ui.ajaxSettings.url + '"/>').appendTo(ui.panel);
                        }
                    }
                });
            },
            dataType: 'html'
        });
    },

    init: function (id) {

        jQuery(document).ready(function () {
            var msg, connectionBar, toolbar, sessionView;

            msg = jQuery('#' + id + '-message').hymessage();

            connectionBar = jQuery('#' + id + '-connectionbar').hyconnectionbar({
                conf: hydrogenConf[id],
                messageArea: msg
            });

            toolbar = jQuery('#' + id + '-toolbar').hytoolbar({
                conf: hydrogenConf[id],
                searchBox: false
            });

            sessionView = jQuery('#' + id + '-session-view');

            jQuery('<div id="' + id + '-loaddiv" class="loading ui-state-default ui-state-active">' +
                   '  Loading ...' +
                   '</div>').appendTo(sessionView);

            toolbar.bind('hytoolbaraction', function (e, action) {
                jQuery.hydrogen.executeAction(action,
                    null,
                    function () {
                        interactiveSessionInfo.refresh(id);
                    },
                    msg);
            });

            interactiveSessionInfo.refresh(id);

            jQuery.hydrogen.setupAutoRefresh(id, hydrogenConf, interactiveSessionInfo.refresh);
        });
    }
};

// ex:ts=4:et:

