<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:func="http://exslt.org/functions"
  xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
  xmlns:grid="http://www.enginframe.com/2000/GRID"
  xmlns:f="http://www.enginframe.com/2011/EnginFrame/functions"
  xmlns:encode="org.owasp.encoder.Encode"
  exclude-result-prefixes="ef grid func f encode">

<!--
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.
-->

  <!-- Input parameters -->
  <xsl:param name="_root_context">enginframe</xsl:param>

  <xsl:template match="grid:cluster" priority="1">
    <div class="hy-gridclusters-panel-container">
      <div class="hy-gridclusters-panel-head">

        <div id="hy-gridclusters-cluster-name" style="display:none"><xsl:value-of select="text()"/></div>

        <div class="hy-gridclusters-panel-clusterdata">
          <div class="hy-gridclusters-data-name">Id:</div>
          <div class="hy-gridclusters-data-value">
            <xsl:choose>
              <xsl:when test="@link and @link!=''">
                <a href="{@link}"  target="_blank">
                  <xsl:value-of select="@id"/>
                </a>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="@id"/>
              </xsl:otherwise>
            </xsl:choose>
            <xsl:choose>
              <xsl:when test="@infoMessage and @infoMessage!=''">&#160;<i class="fa fa-question-circle" title="{@infoMessage}"/>
              </xsl:when>
            </xsl:choose>
          </div>
        </div>

        <div class="hy-gridclusters-panel-clusterdata">
          <div class="hy-gridclusters-data-name">Scheduler:</div>
          <div class="hy-gridclusters-data-value">
            <xsl:choose>
              <xsl:when test="@scheduler and @scheduler!=''">
                <xsl:value-of select="@scheduler"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:choose>
                  <xsl:when test="@type and @type!=''">
                    <xsl:value-of select="@type"/>
                  </xsl:when>
                  <xsl:otherwise>-</xsl:otherwise>
                </xsl:choose>
              </xsl:otherwise>
            </xsl:choose>
          </div>

          <div class="hy-gridclusters-data-name">Location:</div>
          <div class="hy-gridclusters-data-value">
            <xsl:if test="not(@location) or @location=''">Local</xsl:if><xsl:value-of select="@location"/>
          </div>

          <div class="hy-gridclusters-data-name">Status:</div>
          <div class="hy-gridclusters-data-value">
            <xsl:if test="not(@status) or @status=''">READY</xsl:if><xsl:value-of select="@status"/>
          </div>

          <div class="hy-gridclusters-data-name">Queues:</div>
          <div class="hy-gridclusters-data-value">
            <xsl:if test="not(@queues) or @queues=''">-</xsl:if><xsl:value-of select="@queues"/>
          </div>

          <div class="hy-gridclusters-data-name">User Mode:</div>
          <div class="hy-gridclusters-data-value">
            <xsl:if test="not(@userMode) or @userMode=''">Multi User 1:1</xsl:if><xsl:value-of select="@userMode"/>
          </div>

          <div class="hy-gridclusters-data-name">Hosts:</div>
          <div class="hy-gridclusters-data-value">
            <xsl:variable name="host-info-url">
              <xsl:text>?_uri=//com.enginframe.grid</xsl:text>
              <xsl:text>/list.hosts&amp;host=</xsl:text>
              <xsl:value-of select="encode:forUriComponent(text())"/>
              <xsl:text>&amp;grid=</xsl:text>
              <xsl:value-of select="encode:forUriComponent(@type)"/>
              <xsl:text>&amp;cluster=</xsl:text>
              <xsl:value-of select="encode:forUriComponent(@id)"/>
            </xsl:variable>
            <a href="{$host-info-url}">All hosts of <xsl:value-of select="text()"/> cluster</a>
          </div>

          <div class="hy-gridclusters-data-name">Availability:</div>
          <div class="hy-gridclusters-data-value" id="cluster-availability">
            <script type="text/javascript">
              document.getElementById("cluster-availability").innerHTML = jQuery.hydrogen.clusterGroupsFormatter("<xsl:value-of select="encode:forJavaScriptBlock(@userGroups)"/>")
            </script>
          </div>
        </div>

      </div>
    </div>
  </xsl:template>

  <!-- propagate ef:errors -->
  <xsl:template match="/ef:error" priority="-1">
    <xsl:apply-templates select="." mode="error"/>
  </xsl:template>

  <xsl:template match="node()|@*" mode="error" >
    <xsl:copy>
      <xsl:apply-templates select="node()|@*" mode="error"/>
    </xsl:copy>
  </xsl:template>

</xsl:stylesheet>
