<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
  xmlns:grid="http://www.enginframe.com/2000/GRID"
  xmlns:func="http://exslt.org/functions"
  xmlns:f="http://www.enginframe.com/2011/EnginFrame/functions"
  xmlns:encode="org.owasp.encoder.Encode"
  exclude-result-prefixes="ef grid func f encode">

<!--
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.
-->

  <!-- Host list options -->
  <xsl:variable name="hostcellspace">200</xsl:variable>
  <xsl:variable name="show_base_batch_status">0</xsl:variable>
  <xsl:variable name="bar_width">148</xsl:variable>

  <!-- Input parameters -->
  <xsl:param name="_root_context">enginframe</xsl:param>

  <!-- Auxiliary templates -->

  <!-- hy_gridhosts_percentage
       generates percentage bar plus overlay message -->
  <xsl:template name="hy_gridhosts_percentage">
    <xsl:param name="value">0</xsl:param>
    <xsl:param name="max">0</xsl:param>
    <xsl:param name="class_name"></xsl:param>
    <xsl:param name="overlay"></xsl:param>

    <xsl:param name="normalized_value">
      <xsl:value-of select="$value*$bar_width div ($hostcellspace div 2)"/>
    </xsl:param>

    <xsl:param name="normalized_max">
      <xsl:value-of select="$max*$bar_width div ($hostcellspace div 2)"/>
    </xsl:param>

    <xsl:choose>
      <xsl:when test="$value = '-' or $value = '--'" >
        <div class="hy-gridhosts-data">
          <xsl:if test="$overlay">
            <div class="hy-gridhosts-centered-data" style="width: {encode:forCssString($normalized_max)}px">
              <xsl:value-of select="$overlay"/>
            </div>
          </xsl:if>
          <div class="{$class_name}" style="width: {encode:forCssString($normalized_max)}px">
            <div style="width: 0px"></div>
          </div>
        </div>
      </xsl:when>
      <xsl:otherwise>
        <div class="hy-gridhosts-data">
          <xsl:if test="$overlay">
            <div class="hy-gridhosts-centered-data" style="width: {encode:forCssString($normalized_max)}px">
              <xsl:value-of select="$overlay"/>
            </div>
          </xsl:if>
          <div class="{$class_name}" style="width: {encode:forCssString($normalized_max)}px">
            <div style="width: {encode:forCssString($normalized_value)}px"></div>
          </div>
        </div>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


  <!-- hy_gridhosts_normalize_mem
       returns bytes value in MB or GB amount -->
  <xsl:template name="hy_gridhosts_normalize_mem">
    <xsl:param name="bytes_value">0</xsl:param>
    <xsl:choose>
      <xsl:when test="not($bytes_value)">-</xsl:when>
      <xsl:when test="string($bytes_value)='NaN'">-</xsl:when>
      <xsl:when test="$bytes_value = 0">0</xsl:when>
      <xsl:when test="$bytes_value > 1073741824">
        <xsl:value-of select="format-number($bytes_value div 1073741824, '#.00GB')"/>
      </xsl:when>
      <xsl:when test="$bytes_value > 1048576">
        <xsl:value-of select="format-number($bytes_value div 1048576, '#MB')"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="format-number($bytes_value, '#B')"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


  <xsl:template match="grid:host">

    <xsl:variable name="cluster_type">
      <xsl:choose>
        <xsl:when test="@type"><xsl:value-of select="@type"/></xsl:when>
        <xsl:when test="../@type"><xsl:value-of select="../@type"/></xsl:when>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="cluster_id">
      <xsl:choose>
        <xsl:when test="@cluster"><xsl:value-of select="@cluster"/></xsl:when>
        <xsl:when test="../@cluster"><xsl:value-of select="../@cluster"/></xsl:when>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="cluster_name">
      <xsl:if test="count(/grid:list-clusters/grid:cluster) > 1">
        <xsl:choose>
          <xsl:when test="$cluster_id!=''">
            <xsl:copy-of select="/grid:list-clusters/grid:cluster[@type=$cluster_type and @id=$cluster_id]"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:copy-of select="/grid:list-clusters/grid:cluster[@type=$cluster_type][1]"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:if>
    </xsl:variable>

    <xsl:variable name="host_status_ef"><xsl:value-of select="grid:status/@ef"/></xsl:variable>
    <xsl:variable name="host_status_grid"><xsl:value-of select="grid:status/@grid"/></xsl:variable>
    <xsl:variable name="host_status_base"><xsl:value-of select="grid:status/@base"/></xsl:variable>
    <xsl:variable name="host_status_batch"><xsl:value-of select="grid:status/@batch"/></xsl:variable>

    <xsl:variable name="cpu_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='ut']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='ut']))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(round((grid:resource[@name='ut'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

     <xsl:variable name="gpu_avg_ut_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='gpu_avg_ut']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='gpu_avg_ut']))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(round((grid:resource[@name='gpu_avg_ut'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="gpu_avg_mut_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='gpu_avg_mut']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='gpu_avg_mut']))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(round((grid:resource[@name='gpu_avg_mut'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

  <xsl:variable name="mem_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='mem']/@max) = 0">0</xsl:when>
        <xsl:when test="number(grid:resource[@name='mem']) = 0">
          <xsl:value-of select="$hostcellspace div 2"/>
        </xsl:when>
        <xsl:when test="not(number(grid:resource[@name='mem'])) or not(number(grid:resource[@name='mem']/@max))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="round((number((grid:resource[@name='mem']/@max) - (grid:resource[@name='mem'])) div number(grid:resource[@name='mem']/@max)) * ($hostcellspace div 2))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="swp_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='swp']/@max) = 0">0</xsl:when>
        <xsl:when test="number(grid:resource[@name='swp']) = 0">
          <xsl:value-of select="$hostcellspace div 2"/>
        </xsl:when>
        <xsl:when test="not(number(grid:resource[@name='swp'])) or not(number(grid:resource[@name='swp']/@max))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="round((number((grid:resource[@name='swp']/@max) - (grid:resource[@name='swp'])) div number(grid:resource[@name='swp']/@max)) * ($hostcellspace div 2))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="slots_gauge">
      <xsl:choose>
        <xsl:when test="not(number(grid:job-slots))">-</xsl:when>
        <xsl:when test="not(number(grid:usage/@running-jobs))">0</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="round((number(grid:usage/@running-jobs) div number(grid:job-slots)) * ($hostcellspace div 2))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="virtual_session_gauge">
      <xsl:choose>
        <xsl:when test="not(number(grid:interactive-virtual-sessions))">0</xsl:when>
        <xsl:when test="not(number(grid:interactive-max-virtual-sessions)) or number(grid:interactive-max-virtual-sessions) &lt; 0">0</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="ceiling((number(grid:interactive-virtual-sessions) div number(grid:interactive-max-virtual-sessions)) * ($hostcellspace div 2))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="console_session_gauge">
      <xsl:choose>
        <xsl:when test="not(number(grid:interactive-console-sessions))">0</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="ceiling((number(grid:interactive-console-sessions) div 1) * ($hostcellspace div 2))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <div class="hy-gridhosts-panel-container">

      <div class="hy-gridhosts-panel-head">
        <div class="hy-gridhosts-panel-title">
          <xsl:apply-templates select="." mode="archicon"/>
          <div class="hy-gridhosts-panel-title-hostname">Host <xsl:value-of select="@name"/></div>
        </div>
      </div>

      <div class="hy-gridhosts-panel-body">
        <div class="hy-gridhosts-panel-data">
          <xsl:if test="$cluster_name != ''">
            <div class="hy-gridhosts-panel-body-name">
              Cluster
            </div>
            <div class="hy-gridhosts-panel-body-value">
              <a href="{f:cluster-load-link($cluster_type, $cluster_id)}"><xsl:value-of select="$cluster_name"/></a>
            </div>
            <!-- Seperator -->
            <div class=".hy-gridhosts-panel-body-paragraph">&#160;</div>
          </xsl:if>
          <div class="hy-gridhosts-panel-body-name">
            Status
          </div>
          <div class="hy-gridhosts-panel-body-value">
            <div class="hy-gridhosts-grid-status-{$host_status_ef}">
              <xsl:choose>
                <xsl:when test="$host_status_ef">
                  <xsl:value-of select="$host_status_ef"/>
                </xsl:when>
                <xsl:otherwise>
                  -
                </xsl:otherwise>
              </xsl:choose>
              <xsl:choose>
                <xsl:when test="$show_base_batch_status = 1">
                  (base: <xsl:value-of select="$host_status_base"/>, batch: <xsl:value-of select="$host_status_batch"/>)
                </xsl:when>
                <xsl:otherwise>
                  <xsl:if test="$host_status_grid">
                    (<xsl:value-of select="$host_status_grid"/>)
                  </xsl:if>
                </xsl:otherwise>
              </xsl:choose>
            </div>
          </div>
        </div>

        <div class="ui-helper-clearfix">

        <div class="hy-gridhosts-panel-box">
          <div class="hy-gridhosts-panel-box-head">
            <h2 class="hy-gridhosts-load-icon">Load</h2>
          </div>
          <div class="hy-gridhosts-panel-box-body">
            <xsl:if test="grid:resource[@name='ls'] != '' ">
              <div class="hy-gridhosts-panel-body-name">Number of users</div>
              <div class="hy-gridhosts-panel-body-value"><xsl:value-of select="grid:resource[@name='ls']" /></div>
            </xsl:if>
            <xsl:choose>
              <xsl:when test="grid:is-session-manager">
                <xsl:if test="grid:interactive-virtual-sessions">
                <div class="hy-gridhosts-panel-body-name">Virtual Sessions</div>
                <div class="hy-gridhosts-panel-body-value">
                  <xsl:call-template name="hy_gridhosts_percentage">
                    <xsl:with-param name="value">
                      <xsl:value-of select="$virtual_session_gauge" />
                    </xsl:with-param>
                    <xsl:with-param name="max">
                      <xsl:value-of select="$hostcellspace div 2" />
                    </xsl:with-param>
                    <xsl:with-param name="class_name">hy-gridhosts-slots-bar</xsl:with-param>
                    <xsl:with-param name="overlay">
                      <xsl:choose>
                        <xsl:when test="grid:interactive-virtual-sessions">
                          <xsl:choose>
                            <xsl:when test="string(number(grid:interactive-max-virtual-sessions)) != 'NaN' and number(grid:interactive-max-virtual-sessions) >= 0">
                              <xsl:value-of select="grid:interactive-virtual-sessions"/>/<xsl:value-of select="grid:interactive-max-virtual-sessions"/>
                            </xsl:when>
                            <xsl:otherwise>
                              <xsl:value-of select="grid:interactive-virtual-sessions"/>
                            </xsl:otherwise>
                          </xsl:choose>
                        </xsl:when>
                        <xsl:otherwise>
                          N/A
                        </xsl:otherwise>
                      </xsl:choose>
                    </xsl:with-param>
                  </xsl:call-template>
                </div>
                </xsl:if>
                <xsl:if test="grid:interactive-console-sessions">
                  <div class="hy-gridhosts-panel-body-name">Console Sessions</div>
                  <div class="hy-gridhosts-panel-body-value">
                    <xsl:call-template name="hy_gridhosts_percentage">
                      <xsl:with-param name="value">
                        <xsl:value-of select="$console_session_gauge" />
                      </xsl:with-param>
                      <xsl:with-param name="max">
                        <xsl:value-of select="$hostcellspace div 2" />
                      </xsl:with-param>
                      <xsl:with-param name="class_name">hy-gridhosts-slots-bar</xsl:with-param>
                      <xsl:with-param name="overlay">
                        <xsl:value-of select="grid:interactive-console-sessions"/>/1
                      </xsl:with-param>
                    </xsl:call-template>
                  </div>
                </xsl:if>
              </xsl:when>
              <xsl:when test="grid:job-slots">
                <div class="hy-gridhosts-panel-body-name">Job Slots</div>
                <div class="hy-gridhosts-panel-body-value">
                  <xsl:call-template name="hy_gridhosts_percentage">
                    <xsl:with-param name="value">
                      <xsl:value-of select="$slots_gauge" />
                    </xsl:with-param>
                    <xsl:with-param name="max">
                      <xsl:value-of select="$hostcellspace div 2" />
                    </xsl:with-param>
                    <xsl:with-param name="class_name">hy-gridhosts-slots-bar</xsl:with-param>
                    <xsl:with-param name="overlay">
                      <xsl:value-of select="grid:usage/@running-jobs"/>/<xsl:value-of select="grid:job-slots"/>
                    </xsl:with-param>
                  </xsl:call-template>
                </div>
              </xsl:when>
            </xsl:choose>

            <xsl:if test="grid:resource[@name='ut'] != '' ">
              <div class="hy-gridhosts-panel-body-name">CPU utilization</div>
              <div class="hy-gridhosts-panel-body-value">
                <xsl:choose>
                  <xsl:when test="substring-after(grid:resource[@name='ut'], '/') != '' "><xsl:value-of select="grid:resource[@name='ut']"/></xsl:when>
                  <xsl:otherwise>
                    <xsl:call-template name="hy_gridhosts_percentage">
                      <xsl:with-param name="value">
                        <xsl:value-of select="$cpu_gauge" />
                      </xsl:with-param>
                      <xsl:with-param name="max">
                        <xsl:value-of select="$hostcellspace div 2" />
                      </xsl:with-param>
                      <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
                      <xsl:with-param name="overlay">
                        <xsl:value-of select="$cpu_gauge"/><xsl:if test="not($cpu_gauge='--')">%</xsl:if>
                      </xsl:with-param>
                    </xsl:call-template>
                  </xsl:otherwise>
                </xsl:choose>
               </div>
             </xsl:if>

            <xsl:if test="grid:resource[@name='gpu_avg_ut'] != '' ">
              <div class="hy-gridhosts-panel-body-name">GPU AVG utilization</div>
              <div class="hy-gridhosts-panel-body-value">
                <xsl:choose>
                  <xsl:when test="substring-after(grid:resource[@name='gpu_avg_ut'], '/') != '' "><xsl:value-of select="grid:resource[@name='gpu_avg_ut']"/></xsl:when>
                  <xsl:otherwise>
                    <xsl:call-template name="hy_gridhosts_percentage">
                      <xsl:with-param name="value">
                        <xsl:value-of select="$gpu_avg_ut_gauge" />
                      </xsl:with-param>
                      <xsl:with-param name="max">
                        <xsl:value-of select="$hostcellspace div 2" />
                      </xsl:with-param>
                      <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
                      <xsl:with-param name="overlay">
                        <xsl:value-of select="$gpu_avg_ut_gauge"/><xsl:if test="not($gpu_avg_ut_gauge='--')">%</xsl:if>
                      </xsl:with-param>
                    </xsl:call-template>
                  </xsl:otherwise>
                </xsl:choose>
               </div>
             </xsl:if>

            <xsl:if test="grid:resource[@name='gpu_avg_mut'] != '' ">
              <div class="hy-gridhosts-panel-body-name">GPU AVG MEM utilization</div>
              <div class="hy-gridhosts-panel-body-value">
                <xsl:choose>
                  <xsl:when test="substring-after(grid:resource[@name='gpu_avg_mut'], '/') != '' "><xsl:value-of select="grid:resource[@name='gpu_avg_mut']"/></xsl:when>
                  <xsl:otherwise>
                    <xsl:call-template name="hy_gridhosts_percentage">
                      <xsl:with-param name="value">
                        <xsl:value-of select="$gpu_avg_mut_gauge" />
                      </xsl:with-param>
                      <xsl:with-param name="max">
                        <xsl:value-of select="$hostcellspace div 2" />
                      </xsl:with-param>
                      <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
                      <xsl:with-param name="overlay">
                        <xsl:value-of select="$gpu_avg_mut_gauge"/><xsl:if test="not($gpu_avg_mut_gauge='--')">%</xsl:if>
                      </xsl:with-param>
                    </xsl:call-template>
                  </xsl:otherwise>
                </xsl:choose>
               </div>
             </xsl:if>

             <xsl:if test="grid:resource[starts-with(@name, 'r1')] or grid:resource[starts-with(@name, 'r5')]">
               <div class="hy-gridhosts-panel-body-paragraph">
                 <div class="hy-gridhosts-panel-body-paragraph-title">CPU run queue length:</div>
                 <xsl:if test="grid:resource[@name='r15s']">
                   <div class="hy-gridhosts-panel-body-subname">Averaged 15 sec (r15s)</div>
                   <div class="hy-gridhosts-panel-body-value">
                     <xsl:value-of select="grid:resource[@name='r15s']"/>
                   </div>
                 </xsl:if>
                 <xsl:if test="grid:resource[@name='r1m']">
                   <div class="hy-gridhosts-panel-body-subname">Averaged one minute (r1m)</div>
                   <div class="hy-gridhosts-panel-body-value">
                     <xsl:value-of select="grid:resource[@name='r1m']"/>
                   </div>
                 </xsl:if>
                 <xsl:if test="grid:resource[@name='r5m']">
                   <div class="hy-gridhosts-panel-body-subname">Averaged 5 minutes (r5m)</div>
                   <div class="hy-gridhosts-panel-body-value">
                     <xsl:value-of select="grid:resource[@name='r5m']"/>
                   </div>
                 </xsl:if>
                 <xsl:if test="grid:resource[@name='r15m']">
                   <div class="hy-gridhosts-panel-body-subname">Averaged 15 minutes (r15m)</div>
                   <div class="hy-gridhosts-panel-body-value">
                     <xsl:value-of select="grid:resource[@name='r15m']"/>
                   </div>
                 </xsl:if>
               </div>
             </xsl:if>

             <xsl:if test="grid:resource[@name='mem']">
               <div class="hy-gridhosts-panel-body-name">Physical memory</div>
               <div class="hy-gridhosts-panel-body-value">
                 <xsl:call-template name="hy_gridhosts_percentage">
                   <xsl:with-param name="value">
                     <xsl:value-of select="$mem_gauge" />
                   </xsl:with-param>
                   <xsl:with-param name="max">
                     <xsl:value-of select="$hostcellspace div 2" />
                   </xsl:with-param>
                   <xsl:with-param name="class_name">hy-gridhosts-mem-bar</xsl:with-param>
                   <xsl:with-param name="overlay">
                     <xsl:call-template name="hy_gridhosts_normalize_mem">
                       <xsl:with-param name="bytes_value">
                         <xsl:value-of select="(grid:resource[@name='mem']/@max - grid:resource[@name='mem'])"/>
                       </xsl:with-param>
                       </xsl:call-template>/<xsl:call-template name="hy_gridhosts_normalize_mem">
                       <xsl:with-param name="bytes_value">
                         <xsl:value-of select="grid:resource[@name='mem']/@max"/>
                       </xsl:with-param>
                     </xsl:call-template>
                   </xsl:with-param>
                 </xsl:call-template>
                </div>
              </xsl:if>

              <xsl:if test="grid:resource[@name='swp']">
                <div class="hy-gridhosts-panel-body-name">Swap space</div>
                <div class="hy-gridhosts-panel-body-value">
                  <xsl:call-template name="hy_gridhosts_percentage">
                    <xsl:with-param name="value">
                      <xsl:value-of select="$swp_gauge" />
                    </xsl:with-param>
                    <xsl:with-param name="max">
                      <xsl:value-of select="$hostcellspace div 2" />
                    </xsl:with-param>
                    <xsl:with-param name="class_name">hy-gridhosts-mem-bar</xsl:with-param>
                    <xsl:with-param name="overlay">
                      <xsl:call-template name="hy_gridhosts_normalize_mem">
                        <xsl:with-param name="bytes_value">
                          <xsl:value-of select="(grid:resource[@name='swp']/@max - grid:resource[@name='swp'])"/>
                        </xsl:with-param>
                      </xsl:call-template>/<xsl:call-template name="hy_gridhosts_normalize_mem">
                        <xsl:with-param name="bytes_value">
                          <xsl:value-of select="grid:resource[@name='swp']/@max"/>
                        </xsl:with-param>
                      </xsl:call-template>
                    </xsl:with-param>
                  </xsl:call-template>
                 </div>
               </xsl:if>

               <xsl:if test="grid:resource[@name='tmp']">
                 <div class="hy-gridhosts-panel-body-name">Free tmp space</div>
                 <div class="hy-gridhosts-panel-body-value">
                   <xsl:call-template name="hy_gridhosts_normalize_mem">
                     <xsl:with-param name="bytes_value">
                       <xsl:value-of select="grid:resource[@name='tmp']"/>
                     </xsl:with-param>
                   </xsl:call-template>
                 </div>
               </xsl:if>

               <xsl:if test="grid:resource[@name='pg']">
                 <div class="hy-gridhosts-panel-body-name">Paging rate</div>
                 <div class="hy-gridhosts-panel-body-value">
                   <xsl:value-of select="grid:resource[@name='pg']" /> pages/sec
                 </div>
               </xsl:if>

               <xsl:if test="grid:resource[@name='io']">
                 <div class="hy-gridhosts-panel-body-name">I/O throughput</div>
                 <div class="hy-gridhosts-panel-body-value">
                   <xsl:value-of select="grid:resource[@name='io']" /> Kb/sec
                 </div>
               </xsl:if>

               <xsl:if test="grid:resource[@name='it']">
                 <div class="hy-gridhosts-panel-body-name">Idle time</div>
                 <div class="hy-gridhosts-panel-body-value">
                    <xsl:value-of select="grid:resource[@name='it']" /> minutes
                 </div>
               </xsl:if>

            </div> <!-- closes ef_box_body -->
          </div> <!-- closes ef_box -->

        <div class="hy-gridhosts-panel-box-alt">
          <div class="hy-gridhosts-panel-box-alt-head">
            <h2 class="hy-gridhosts-hardware-icon">Hardware</h2>
          </div>
          <div class="hy-gridhosts-panel-box-alt-body">

            <xsl:if test="@arch">
              <div class="hy-gridhosts-panel-body-name">Host type</div>
              <div class="hy-gridhosts-panel-body-value">
                <xsl:value-of select="@arch"/>
              </div>
            </xsl:if>

            <xsl:if test="@model">
              <div class="hy-gridhosts-panel-body-name">Host model</div>
              <div class="hy-gridhosts-panel-body-value">
                <xsl:value-of select="@model"/>
              </div>
            </xsl:if>

            <xsl:if test="@ncpus">
              <div class="hy-gridhosts-panel-body-name">Number of processors</div>
              <div class="hy-gridhosts-panel-body-value">
                <xsl:value-of select="@ncpus"/>
              </div>
            </xsl:if>

            <xsl:if test="grid:resource[@name='vmem']/@max">
              <xsl:variable name="vmem_gauge">
                <xsl:choose>
                  <xsl:when test="number(grid:resource[@name='vmem']) = 0">$hostcellspace div 2</xsl:when>
                  <xsl:when test="not(number(grid:resource[@name='vmem']))">-</xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="round((number((grid:resource[@name='vmem']/@max) - (grid:resource[@name='vmem'])) div number(grid:resource[@name='vmem']/@max)) * ($hostcellspace div 2))"/>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:variable>
              <div class="hy-gridhosts-panel-body-name">Virtual memory</div>
              <div class="hy-gridhosts-panel-body-value">
                <xsl:call-template name="hy_gridhosts_percentage">
                  <xsl:with-param name="value">
                    <xsl:value-of select="$vmem_gauge" />
                  </xsl:with-param>
                  <xsl:with-param name="max">
                    <xsl:value-of select="$hostcellspace div 2" />
                  </xsl:with-param>
                  <xsl:with-param name="class_name">hy-gridhosts-mem-bar</xsl:with-param>
                  <xsl:with-param name="overlay">
                    <xsl:call-template name="hy_gridhosts_normalize_mem">
                      <xsl:with-param name="bytes_value">
                        <xsl:value-of select="(grid:resource[@name='vmem']/@max - grid:resource[@name='vmem'])"/>
                      </xsl:with-param>
                      </xsl:call-template>/<xsl:call-template name="hy_gridhosts_normalize_mem">
                      <xsl:with-param name="bytes_value">
                        <xsl:value-of select="grid:resource[@name='vmem']/@max"/>
                      </xsl:with-param>
                    </xsl:call-template>
                  </xsl:with-param>
                </xsl:call-template>
              </div>
            </xsl:if>

            <xsl:if test="grid:resource[@name='swp']/@max">
              <div class="hy-gridhosts-panel-body-name">Swap space</div>
              <div class="hy-gridhosts-panel-body-value">
                <xsl:call-template name="hy_gridhosts_normalize_mem">
                  <xsl:with-param name="bytes_value">
                    <xsl:value-of select="grid:resource[@name='swp']/@max"/>
                  </xsl:with-param>
                </xsl:call-template>
              </div>
            </xsl:if>
          </div>
        </div>

        <xsl:if test="grid:resource[@name != 'io' and @name != 'pg' and @name != 'tmp' and @name != 'swp' and @name != 'mem' and @name != 'vmem' and @name != 'r15s' and @name != 'r5m' and @name != 'r1m' and @name != 'r15m' and @name != 'ut' and @name != 'ls' and @name != 'it']">
          <div class="hy-gridhosts-panel-box-alt">
            <div class="hy-gridhosts-panel-box-alt-head">
              <h2 class="hy-gridhosts-resources-icon">Resources</h2>
            </div>
            <div class="hy-gridhosts-panel-box-alt-body">
              <xsl:for-each select="grid:resource[@name != 'io' and @name != 'pg' and @name != 'tmp' and @name != 'swp' and @name != 'mem' and @name != 'vmem' and @name != 'r15s' and @name != 'r5m' and @name != 'r1m' and @name != 'r15m' and @name != 'ut' and @name != 'ls' and @name != 'it']">
                <div class="hy-gridhosts-panel-body-name">
                  <xsl:attribute name="title"><xsl:value-of select="@name"/></xsl:attribute>
                  <xsl:value-of select="@name"/>
                </div>
                <div class="hy-gridhosts-panel-body-value">
                  <xsl:attribute name="title"><xsl:value-of select="."/></xsl:attribute>
                  <xsl:value-of select="."/>
                </div>
              </xsl:for-each>
            </div>
          </div>
        </xsl:if>

        <div class="hy-gridhosts-padder" ></div>

        </div>

      </div>
    </div>
  </xsl:template>

  <xsl:template match="grid:host[@arch-family]" mode="archicon" priority="+1">
    <img class="hy-gridhosts-panel-title-icon" src="/{$_root_context}/images/arch-family/32x32/{f:uppercase(@arch-family)}.gif" alt=" "/>
  </xsl:template>

  <xsl:template match="grid:host[@arch]" mode="archicon">
    <img class="hy-gridhosts-panel-title-icon" src="/{$_root_context}/images/arch-family/32x32/{f:uppercase(@arch)}.gif" alt=" "/>
  </xsl:template>

  <!-- propagate ef:errors -->
  <xsl:template match="/ef:error" priority="-1">
    <xsl:apply-templates select="." mode="error"/>
  </xsl:template>

  <xsl:template match="node()|@*" mode="error" >
    <xsl:copy>
      <xsl:apply-templates select="node()|@*" mode="error"/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="grid:list-clusters"/>

  <func:function name="f:uppercase">
    <xsl:param name="text" />
    <func:result>
      <xsl:variable name="lowercase" select="'abcdefghijklmnopqrstuvwxyz'" />
      <xsl:variable name="uppercase" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'" />
      <xsl:value-of select="translate($text, $lowercase, $uppercase)"/>
    </func:result>
  </func:function>

  <func:function name="f:cluster-load-link">
    <xsl:param name="grid-manager"/>
    <xsl:param name="cluster" />
    <func:result>
      <xsl:text>?_uri=//com.enginframe.grid/list.hosts</xsl:text>
      <xsl:text>&amp;grid=</xsl:text>
      <xsl:value-of select="encode:forUriComponent($grid-manager)"/>
      <xsl:text>&amp;cluster=</xsl:text>
      <xsl:value-of select="encode:forUriComponent($cluster)"/>
    </func:result>
  </func:function>

</xsl:stylesheet>
