<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:exsl="http://exslt.org/common"
  xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
  xmlns:efactions="http://www.enginframe.com/2009/efactions"
  xmlns:StringEscapeUtils="org.apache.commons.lang3.StringEscapeUtils"
  extension-element-prefixes="exsl"
  exclude-result-prefixes="ef exsl StringEscapeUtils">
  <!--
    * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.  -->

  <xsl:output omit-xml-declaration="yes" method="text" media-type="application/json" />

  <xsl:template match="/">
    <xsl:apply-templates select="ef:item-action-list" />
  </xsl:template>

  <!-- TODO: We should use @expanded=true|false to indicate that the text content is already the JSON for the actions -->
  <xsl:template match="ef:item-action-list[not(./*)]">
    <xsl:copy-of select="text()" />
  </xsl:template>

  <xsl:template match="ef:item-action-list[./*]">
     <xsl:text>[</xsl:text>
     <xsl:apply-templates select="ef:item-action|ef:item-action-list/ef:item-action" />
     <xsl:text>]</xsl:text>
  </xsl:template>

  <xsl:template match="ef:item-action">
    <xsl:text>{"id": "</xsl:text>
    <xsl:value-of select="StringEscapeUtils:escapeJson(@id)"/>
    <xsl:text>", "icon": "</xsl:text>
    <xsl:value-of select="StringEscapeUtils:escapeJson(@icon)"/>
    <xsl:text>", "classes": "</xsl:text>
    <xsl:value-of select="StringEscapeUtils:escapeJson(@class)"/>
    <xsl:text>", "name": "</xsl:text>
    <xsl:value-of select="StringEscapeUtils:escapeJson(ef:name/text())"/>
    <xsl:text>", "action": {</xsl:text>
    <xsl:choose>
      <xsl:when test="child::efactions:invoke-service">
        <xsl:text>"type": "invoke-service", "sdf": "</xsl:text>
        <xsl:value-of select="StringEscapeUtils:escapeJson(child::efactions:invoke-service/@sdf)"/>
        <xsl:text>", "uri": "</xsl:text>
        <xsl:value-of select="StringEscapeUtils:escapeJson(child::efactions:invoke-service/@uri)"/>
        <xsl:text>", "refresh": "</xsl:text>
        <xsl:value-of select="StringEscapeUtils:escapeJson(child::efactions:invoke-service/@refresh)"/>
        <xsl:text>", "confirmation": "</xsl:text>
        <xsl:value-of select="StringEscapeUtils:escapeJson(child::efactions:invoke-service/@confirmation)"/>
        <xsl:text>", "params": {</xsl:text>
        <xsl:apply-templates select="child::efactions:invoke-service/efactions:param"/>
        <xsl:text>}</xsl:text>
      </xsl:when>
      <xsl:when test="child::efactions:open">
        <xsl:text>"type": "open", "uri": "</xsl:text>
        <xsl:value-of select="StringEscapeUtils:escapeJson(child::efactions:open/@uri)"/>
        <xsl:text>", "href": "</xsl:text>
        <xsl:value-of select="StringEscapeUtils:escapeJson(child::efactions:open/@href)"/>
        <xsl:text>", "target": "</xsl:text>
        <xsl:value-of select="StringEscapeUtils:escapeJson(child::efactions:open/@target)"/>
        <xsl:text>", "confirmation": "</xsl:text>
        <xsl:value-of select="StringEscapeUtils:escapeJson(child::efactions:open/@confirmation)"/>
        <xsl:text>", "params": {</xsl:text>
        <xsl:apply-templates select="child::efactions:open/efactions:param"/>
        <xsl:text>}</xsl:text>
      </xsl:when>
      <xsl:when test="child::efactions:invoke-javascript">
        <xsl:text>"type": "invoke-javascript", "confirmation": "</xsl:text>
        <xsl:value-of select="StringEscapeUtils:escapeJson(child::efactions:invoke-javascript/@confirmation)"/>
        <xsl:text>", "js": "</xsl:text>
        <xsl:value-of select="StringEscapeUtils:escapeJson(child::efactions:invoke-javascript/text())"/>
        <xsl:text>"</xsl:text>
      </xsl:when>
    </xsl:choose>
    <xsl:text>}}</xsl:text>
    <xsl:if test="position() != last()">
      <xsl:text>, </xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template match="efactions:param">
    <xsl:text>"</xsl:text>
    <xsl:value-of select="StringEscapeUtils:escapeJson(@id)"/>
    <xsl:text>": "</xsl:text>
    <xsl:value-of select="StringEscapeUtils:escapeJson(text())"/>
    <xsl:text>"</xsl:text>
    <xsl:if test="position() != last()">
      <xsl:text>, </xsl:text>
    </xsl:if>
  </xsl:template>

</xsl:stylesheet>
