<?xml version="1.0" encoding="UTF-8"?>
<!--
  * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.-->
<xsl:transform version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:dyn="http://exslt.org/dynamic"
  xmlns:xalan="http://xml.apache.org/xalan"
  xmlns:filter="http://www.enginframe.com/2010/EnginFrame/Filter"
  xmlns:encode="org.owasp.encoder.Encode"
  exclude-result-prefixes="dyn xalan filter encode">

  <!-- output format -->
  <xsl:output
    method="xml"
    media-type="text/xml"
    encoding="UTF-8"
    indent="yes"
    xalan:indent-amount="2"
    omit-xml-declaration="no" />

  <!-- read root and row tagname from inline configuration -->
  <xsl:variable name="root-element" select="//filter:mapper-list/@root" />
  <xsl:variable name="row-element" select="//filter:mapper-list/@row" />

  <!-- match document root -->
  <xsl:template match="/">
    <!-- perform syntax check -->
    <!--
    <xsl:call-template name="filter:syntax-check" />
    -->
    <!-- if syntax is ok, then transform the xml, otherwise simply copy it -->
    <!-- apply to "real" child node and comment() only, not processing-instruction(), text() -->
    <xsl:apply-templates select="*|comment()" />
  </xsl:template>

  <!-- match root element -->
  <xsl:template match="*[name()=$root-element]">
    <!-- pretty print -->
    <xsl:text>&#x0A;</xsl:text>
    <!-- copy root element removing namespace -->
    <xsl:element name="{local-name()}">
      <xsl:attribute name="path">
	<xsl:value-of select="encode:forUriComponent(@path)" />
      </xsl:attribute>
      <!-- copy all remaining attributes -->
      <!-- <xsl:apply-templates select="@*" /> -->
      <xsl:apply-templates select="@*[name() != 'path']" />
      <page><xsl:value-of select="ceiling(@start-index div @max-results)" /></page>
      <total><xsl:value-of select="ceiling(@total-results div @max-results)" /></total>
      <records><xsl:value-of select="@total-results" /></records>
      <xsl:apply-templates select="node()"/>
    </xsl:element>
  </xsl:template>

  <!-- match row element in root element -->
  <xsl:template match="*[name()=$root-element]/*[name()=$row-element]">
    <!-- copy row element removing namespace -->
    <xsl:element name="{local-name()}">
      <!-- copy all attributes -->
      <xsl:apply-templates select="@*" />
      <!-- call template with mode="adapter" that may be overwritten -->
      <xsl:apply-templates select="//filter:mapper-list/filter:mapper" mode="adapter">
        <xsl:with-param name="row" select="." />
      </xsl:apply-templates>
    </xsl:element>
  </xsl:template>

  <!-- this template may be overwritten -->
  <xsl:template match="filter:mapper-list/filter:mapper" mode="adapter">
    <!-- contains the current row element with all its context -->
    <xsl:param name="row" />
    <!-- create an element named as the hydrogen column -->
    <xsl:variable name="value">
      <!-- get the proper value -->
      <xsl:apply-templates select="$row" mode="filter:value" >
        <xsl:with-param name="xpath" select="@xpath" />
      </xsl:apply-templates>
    </xsl:variable>
    <xsl:if test="$value!=''">
      <xsl:element name="{@id}">
        <xsl:value-of select="$value"/>
      </xsl:element>
    </xsl:if>
  </xsl:template>

  <!-- get the proper value -->
  <xsl:template match="*[name()=$root-element]/*[name()=$row-element]" mode="filter:value">
    <xsl:param name="xpath" />
    <xsl:value-of select="dyn:evaluate($xpath)" />
  </xsl:template>

  <!-- match and remove filter configuration -->
  <xsl:template match="filter:header|filter:mapper-list" />

  <!-- identity template for attributes and nodes -->
  <xsl:template match="node()|@*">
    <xsl:copy>
      <xsl:apply-templates select="node()|@*" />
    </xsl:copy>
  </xsl:template>

  <!-- syntax check -->
  <xsl:template name="filter:syntax-check">
    <xsl:choose>
      <!-- there is no <filter:mapper-list> -->
      <xsl:when test="not(//filter:mapper-list)">
        <xsl:text>&#x0A;</xsl:text>
        <xsl:comment> missing &lt;filter:mapper-list&gt; </xsl:comment>
        <xsl:text>&#x0A;</xsl:text>
      </xsl:when>
      <!-- <filter:mapper-list> has no @root attribute -->
      <xsl:when test="not($root-element)">
        <xsl:text>&#x0A;</xsl:text>
        <xsl:comment> missing @root </xsl:comment>
        <xsl:text>&#x0A;</xsl:text>
      </xsl:when>
      <!-- <filter:mapper-list> has no @row attribute -->
      <xsl:when test="not($row-element)">
        <xsl:text>&#x0A;</xsl:text>
        <xsl:comment> missing @row </xsl:comment>
        <xsl:text>&#x0A;</xsl:text>
      </xsl:when>
      <!-- there is no <filter:mapper> -->
      <xsl:when test="not(//filter:mapper-list/filter:mapper)">
        <xsl:text>&#x0A;</xsl:text>
        <xsl:comment> missing &lt;filter:mapper&gt; </xsl:comment>
        <xsl:text>&#x0A;</xsl:text>
      </xsl:when>
    </xsl:choose>
  </xsl:template>

</xsl:transform>
