<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
  xmlns:ia="http://www.enginframe.com/2012/Interactive"
  xmlns:encode="org.owasp.encoder.Encode"
  exclude-result-prefixes="ef ia encode">

  <!--
    * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.  -->

  <!-- Special handling of the INTERACTIVE_CLASS metadata to trigger prompt reconnect on service form -->
  <xsl:template match="ef:service[@id=$_service]/ef:metadata[@attribute='INTERACTIVE_CLASS']">
    <!-- Get the class label, if specified -->
    <xsl:variable name="label" select="../ef:metadata[@attribute='INTERACTIVE_CLASS_LABEL']"/>
    <script type="text/javascript">
        jQuery(document).ready(function () {
            jQuery.hydrogen.promptReconnect({
                label: "<xsl:value-of select="encode:forJavaScriptBlock($label)"/>",
                formid: "serviceform",
                serviceUri: "<xsl:value-of select="encode:forJavaScriptBlock(concat('//', $agent, '/', $_service))"/>"
            });
        });
    </script>
  </xsl:template>

  <!-- Special handling of the ia:duplicated-sessions to trigger prompt reconnect on service uri -->
  <xsl:template match="ia:duplicated-sessions">
    <div id="hy-duplicated-sessions"></div>
    <script type="text/javascript">
        var tot, dupSessions;

        dupSessions = [];

        <xsl:apply-templates select="ef:spooler" mode="duplicated-sessions"/>

        jQuery(document).ready(function () {
            jQuery.hydrogen.promptReconnect({
                divid: 'hy-duplicated-sessions',
                label: "<xsl:value-of select="encode:forJavaScriptBlock(@label)"/>",
                tot: "<xsl:value-of select="encode:forJavaScriptBlock(@tot)"/>",
                max: "<xsl:value-of select="encode:forJavaScriptBlock(@max)"/>",
                allowMore: "<xsl:value-of select="encode:forJavaScriptBlock(@allow-more)"/>",
                sessions: dupSessions
            });
        });
    </script>

    <!-- FIXME: should we point this form directly to the submit session scriptlet? We could emit all the info to populate the post in exact same way... -->
    <xsl:if test="@allow-more='true'">
      <form action="{/ef:agent/ef:result/@req-url}&amp;interactive_skipprompt=true" method="post" class="interactive-create-new-session">
        <xsl:if test="@spooler and not(@spooler='')">
          <input type="hidden" name="EF_REUSE_SPOOLER" value="{@spooler}"/>
        </xsl:if>
        <input type="submit" value="Create New Session" class="ui-button ui-widget ui-state-default ui-corner-all"/>
      </form>
    </xsl:if>
  </xsl:template>

  <xsl:template match="ef:spooler" mode="duplicated-sessions">
      dupSessions.push({
          uri: "<xsl:value-of select="encode:forJavaScriptBlock(@uri)"/>",
          name: "<xsl:value-of select="encode:forJavaScriptBlock(ef:name/text())"/>",
          project: "<xsl:value-of select="encode:forJavaScriptBlock(ef:metadata[@attribute='EF_SPOOLER_PROJECT']/text())"/>",
          creation: "<xsl:value-of select="encode:forJavaScriptBlock(ef:creation-time/text())"/>",
          host: "<xsl:value-of select="encode:forJavaScriptBlock(ef:metadata[@attribute='INTERACTIVE_SESSION_EXECUTION_HOST']/text())"/>"
      });
  </xsl:template>

  <!-- Show tabs for interactive-<remote>-settings widgets  -->
  <xsl:template match="ef:ui-widget-tabs[@type='interactive-settings-tabs']">
    <script type="text/javascript">
      jQuery(document).ready(function () {
        jQuery('#service-tabs').tabs();
      });
    </script>
    <div id="service-tabs">
      <ul>
        <xsl:for-each select="ef:ui-widget">
          <li>
            <a>
              <xsl:attribute name="href">#<xsl:value-of select="@type" /></xsl:attribute>
              <xsl:value-of select="@label" />
            </a>
          </li>
        </xsl:for-each>
      </ul>
      <xsl:for-each select="ef:ui-widget">
        <div>
          <xsl:variable name="widgetId" select="@id"/>
          <xsl:attribute name="id"><xsl:value-of select="@type" /></xsl:attribute>
          <xsl:apply-templates select="../ef:ui-widget[@id = $widgetId]" />
        </div>
      </xsl:for-each>
    </div>
  </xsl:template>

</xsl:stylesheet>
