<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:exsl="http://exslt.org/common"
  xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
  xmlns:grid="http://www.enginframe.com/2000/GRID"
  xmlns:efactions="http://www.enginframe.com/2009/efactions"
  xmlns:hy="http://www.enginframe.com/2009/UI/Hydrogen"
  xmlns:java="http://xml.apache.org/xalan/java"
  xmlns:encode="org.owasp.encoder.Encode"
  extension-element-prefixes="exsl"
  exclude-result-prefixes="ef exsl java hy encode">
  <!--
    * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.  -->
  <xsl:template match="ef:ui-configure-widget[@ui='hydrogen']"/>
  <xsl:template match="ef:ui-configure-widget[@ui='hydrogen']" mode="configure">
    <xsl:apply-templates mode="configure">
      <xsl:with-param name="wid" select="@id"/>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match="*" mode="column">
    <xsl:value-of select="local-name()"/>
    <xsl:text>: </xsl:text>
    <!-- text() must be javascript-encoded in ui scripts -->
    <xsl:value-of select="text()"/>
    <xsl:if test="position() != last()">
      <xsl:text>, </xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template match="hy:label" mode="column">
    <xsl:text>label: </xsl:text>
    <xsl:variable name="label-html" select="java:com.enginframe.common.utils.xml.XMLUtils.nodeListToString(*)"/>
    <xsl:variable name="label">
      <xsl:choose>
        <xsl:when test="$label-html = ''">
          <xsl:value-of select="text()"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$label-html"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:text>"</xsl:text>
    <xsl:value-of select="encode:forJavaScriptBlock($label)"/>
    <xsl:text>"</xsl:text>
    <xsl:if test="position() != last()">
      <xsl:text>, </xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template match="hy:custom-formatter" mode="column">
    <xsl:text>formatter: </xsl:text>
    <xsl:value-of select="encode:forJavaScriptBlock(text())"/>
    <xsl:if test="position() != last()">
      <xsl:text>, </xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template match="hy:custom-unformatter" mode="column">
    <xsl:text>unformat: </xsl:text>
    <xsl:value-of select="encode:forJavaScriptBlock(text())"/>
    <xsl:if test="position() != last()">
      <xsl:text>, </xsl:text>
    </xsl:if>
  </xsl:template>

  <!-- This are attributes of type String -->
  <xsl:template match="hy:xmlmap | hy:align | hy:formatter" mode="column">
    <xsl:value-of select="local-name()"/>
    <xsl:text>: "</xsl:text>
    <xsl:value-of select="encode:forJavaScriptBlock(text())"/>
    <xsl:text>"</xsl:text>
    <xsl:if test="position() != last()">
      <xsl:text>, </xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template match="hy:ellipsize" mode="column">
    <xsl:text>ellipsize: </xsl:text>
    <xsl:value-of select="encode:forJavaScriptBlock(text())"/>
    <xsl:if test="position() != last()">
      <xsl:text>, </xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template match="hy:add-column" mode="configure">
    <xsl:param name="wid"/>
    <xsl:variable name="position" select="@position"/>
    <xsl:variable name="before" select="@before"/>
    <xsl:variable name="after" select="@after"/>
    <xsl:text>hydrogenConfActions.push(function (conf) {jQuery.hydrogen.addColumn(conf, "</xsl:text>
    <xsl:value-of select="$wid"/>
    <xsl:text>", {index: "</xsl:text>
    <xsl:value-of select="encode:forJavaScriptBlock(@id)"/>
    <xsl:text>", name:"</xsl:text>
    <xsl:value-of select="encode:forJavaScriptBlock(@id)"/>
    <xsl:text>", resizable: false,</xsl:text>
    <xsl:apply-templates select="*" mode="column"/>
    <xsl:text>}</xsl:text>
    <xsl:if test="$position != ''">
      <xsl:text>, {position: </xsl:text>
        <xsl:value-of select="$position"/>
      <xsl:text>}</xsl:text>
    </xsl:if>
    <xsl:text>);});</xsl:text>
  </xsl:template>

  <xsl:template match="hy:delete-column" mode="configure">
    <xsl:param name="wid"/>
    <xsl:text>hydrogenConfActions.push(function (conf) {jQuery.hydrogen.deleteColumn(conf, "</xsl:text>
    <xsl:value-of select="$wid"/>
    <xsl:text>", "</xsl:text>
    <xsl:value-of select="encode:forJavaScriptBlock(@id)"/>
    <xsl:text>");});</xsl:text>
  </xsl:template>

  <xsl:template match="hy:set-param" mode="configure">
    <xsl:param name="wid"/>
    <xsl:text>hydrogenConfActions.push(function (conf) {jQuery.hydrogen.setParam(conf, "</xsl:text>
    <xsl:value-of select="$wid"/>
    <xsl:text>", "</xsl:text>
    <xsl:value-of select="encode:forJavaScriptBlock(@name)"/>
    <xsl:text>", </xsl:text>
    <xsl:choose>
      <xsl:when test="@type = 'text'">
        <xsl:text>"</xsl:text>
        <xsl:value-of select="encode:forJavaScriptBlock(text())"/>
        <xsl:text>"</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <!-- If the parameter is a javascript object, it is js-escaped in bash script where is generated -->
        <xsl:value-of select="text()"/>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:text>);});</xsl:text>
  </xsl:template>

  <xsl:template match="hy:add-filter" mode="configure">
    <xsl:param name="wid"/>
    <xsl:variable name="position" select="@position"/>
    <xsl:variable name="def" select="@default"/>
    <xsl:text>hydrogenConfActions.push(function (conf) {jQuery.hydrogen.addFilter(conf, "</xsl:text>
    <xsl:value-of select="$wid"/>
    <xsl:text>", {id: "</xsl:text>
    <xsl:value-of select="encode:forJavaScriptBlock(@id)"/>
    <xsl:text>", label: "</xsl:text>
    <xsl:value-of select="encode:forJavaScriptBlock(hy:label/text())"/>
    <xsl:text>", formula: "</xsl:text>
    <xsl:value-of select="encode:forJavaScriptBlock(hy:formula/text())"/>
    <xsl:text>", dataSourceQuery: "</xsl:text>
    <xsl:value-of select="encode:forJavaScriptBlock(hy:data-source-query/text())"/>
    <xsl:text>"</xsl:text>
    <xsl:if test="$def = 'true'">
      <xsl:text>, isDefault: true</xsl:text>
    </xsl:if>
    <xsl:text>}</xsl:text>
    <xsl:if test="$position != ''">
      <xsl:text>, {position: "</xsl:text>
        <xsl:value-of select="$position"/>
      <xsl:text>"}</xsl:text>
    </xsl:if>
    <xsl:text>);});</xsl:text>
  </xsl:template>

  <xsl:template match="hy:delete-filter" mode="configure">
    <xsl:param name="wid"/>
    <xsl:text>hydrogenConfActions.push(function (conf) {jQuery.hydrogen.deleteFilter(conf, "</xsl:text>
    <xsl:value-of select="$wid"/>
    <xsl:text>", "</xsl:text>
    <xsl:value-of select="encode:forJavaScriptBlock(@id)"/>
    <xsl:text>");});</xsl:text>
  </xsl:template>

  <xsl:template match="hy:add-chart" mode="configure">
    <xsl:param name="wid"/>
    <xsl:variable name="position" select="@position"/>
    <xsl:text>hydrogenConfActions.push(function (conf) {jQuery.hydrogen.addChart(conf, "</xsl:text>
    <xsl:value-of select="$wid"/>
    <xsl:text>", {chartid: "</xsl:text>
    <xsl:value-of select="encode:forJavaScriptBlock(@id)"/>
    <xsl:text>", label: "</xsl:text>
    <xsl:value-of select="encode:forJavaScriptBlock(hy:label/text())"/>
    <xsl:text>"}</xsl:text>
    <xsl:if test="$position != ''">
      <xsl:text>, {position: "</xsl:text>
        <xsl:value-of select="$position"/>
      <xsl:text>"}</xsl:text>
    </xsl:if>
    <xsl:text>);});</xsl:text>
  </xsl:template>

  <xsl:template match="hy:delete-chart" mode="configure">
    <xsl:param name="wid"/>
    <xsl:text>hydrogenConfActions.push(function (conf) {jQuery.hydrogen.deleteChart(conf, "</xsl:text>
    <xsl:value-of select="$wid"/>
    <xsl:text>", "</xsl:text>
    <xsl:value-of select="encode:forJavaScriptBlock(@id)"/>
    <xsl:text>");});</xsl:text>
  </xsl:template>

  <xsl:template match="efactions:param" mode="configure">
    <xsl:text>"</xsl:text>
    <xsl:value-of select="encode:forJavaScriptBlock(@id)"/>
    <xsl:text>": "</xsl:text>
    <xsl:value-of select="encode:forJavaScriptBlock(text())"/>
    <xsl:text>"</xsl:text>
    <xsl:if test="position() != last()">
      <xsl:text>, </xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template name="add-item-action" mode="configure">
    <xsl:param name="scope"/>
    <xsl:param name="position"/>
    <xsl:param name="before"/>
    <xsl:param name="after"/>
    <xsl:param name="wid"/>
    <xsl:param name="show-if"/>
    <xsl:text>hydrogenConfActions.push(function (conf) {</xsl:text>
      <xsl:choose>
      <xsl:when test="$scope = 'global'">
          <xsl:text>jQuery.hydrogen.addGlobalItemAction(conf, "</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>jQuery.hydrogen.addSingleItemAction(conf, "</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:value-of select="$wid"/>
    <xsl:text>", {id: "</xsl:text>
    <xsl:value-of select="encode:forJavaScriptBlock(@id)"/>
    <xsl:text>", icon: "</xsl:text>
    <xsl:value-of select="encode:forJavaScriptBlock(@icon)"/>
    <xsl:text>", classes: "</xsl:text>
    <xsl:value-of select="encode:forJavaScriptBlock(@class)"/>
    <xsl:text>", awesome: "</xsl:text>
    <xsl:value-of select="encode:forJavaScriptBlock(@awesome)"/>
    <xsl:text>", name: "</xsl:text>
    <xsl:value-of select="encode:forJavaScriptBlock(ef:name/text())"/>
    <xsl:if test="$show-if != ''">
      <xsl:text>", showIf: "</xsl:text>
      <xsl:value-of select="encode:forJavaScriptBlock($show-if)"/>
    </xsl:if>
    <xsl:text>", action: {</xsl:text>
    <xsl:choose>
      <xsl:when test="child::efactions:invoke-service">
        <xsl:text>type: 'invoke-service', sdf: "</xsl:text>
        <xsl:value-of select="encode:forJavaScriptBlock(child::efactions:invoke-service/@sdf)"/>
        <xsl:text>", uri: "</xsl:text>
        <xsl:value-of select="encode:forJavaScriptBlock(child::efactions:invoke-service/@uri)"/>
        <xsl:text>", refresh: "</xsl:text>
        <xsl:value-of select="encode:forJavaScriptBlock(child::efactions:invoke-service/@refresh)"/>
        <xsl:text>", confirmation: "</xsl:text>
        <xsl:value-of select="encode:forJavaScriptBlock(child::efactions:invoke-service/@confirmation)"/>
        <xsl:text>", params: {</xsl:text>
        <xsl:apply-templates select="child::efactions:invoke-service/efactions:param" mode="configure"/>
        <xsl:text>}</xsl:text>
      </xsl:when>
      <xsl:when test="child::efactions:open">
        <xsl:text>type: 'open', uri: "</xsl:text>
        <xsl:value-of select="encode:forJavaScriptBlock(child::efactions:open/@uri)"/>
        <xsl:text>", confirmation: "</xsl:text>
        <xsl:value-of select="encode:forJavaScriptBlock(child::efactions:open/@confirmation)"/>
        <xsl:text>", href: "</xsl:text>
        <xsl:value-of select="encode:forJavaScriptBlock(child::efactions:open/@href)"/>
        <xsl:text>", target: "</xsl:text>
        <xsl:value-of select="encode:forJavaScriptBlock(child::efactions:open/@target)"/>
        <xsl:text>", params: {</xsl:text>
        <xsl:apply-templates select="child::efactions:open/efactions:param" mode="configure"/>
        <xsl:text>}</xsl:text>
      </xsl:when>
      <xsl:when test="child::efactions:invoke-javascript">
        <xsl:text>type: 'invoke-javascript', confirmation: "</xsl:text>
        <xsl:value-of select="encode:forJavaScriptBlock(child::efactions:invoke-javascript/@confirmation)"/>
        <xsl:text>", js: "</xsl:text>
        <xsl:value-of select="encode:forJavaScriptBlock(child::efactions:invoke-javascript/text())"/>
        <xsl:text>"</xsl:text>
      </xsl:when>
    </xsl:choose>
    <xsl:text>}}</xsl:text>
    <xsl:if test="$position != ''">
      <xsl:text>, {position: </xsl:text>
        <xsl:value-of select="$position"/>
      <xsl:text>}</xsl:text>
    </xsl:if>
    <xsl:text>);});</xsl:text>
  </xsl:template>
  
  <xsl:template match="hy:add-global-item-action" mode="configure">
    <xsl:param name="wid"/>
    <xsl:call-template name="add-item-action">
      <xsl:with-param name="scope">global</xsl:with-param>
      <xsl:with-param name="wid" select="$wid"/>
      <xsl:with-param name="position" select="@position"/>
      <xsl:with-param name="before" select="@before"/>
      <xsl:with-param name="after" select="@after"/>
      <xsl:with-param name="show-if" select="hy:show-if"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="hy:delete-global-item-action|hy:delete-global-item-separator" mode="configure">
    <xsl:param name="wid"/>
    <xsl:text>hydrogenConfActions.push(function (conf) {jQuery.hydrogen.deleteGlobalItemAction(conf, "</xsl:text>
    <xsl:value-of select="$wid"/>
    <xsl:text>", "</xsl:text>
    <xsl:value-of select="encode:forJavaScriptBlock(@id)"/>
    <xsl:text>");});</xsl:text>
  </xsl:template>

  <xsl:template match="hy:add-global-item-separator" mode="configure">
    <xsl:param name="wid"/>
    <xsl:variable name="position" select="@position"/>
    <xsl:variable name="before" select="@before"/>
    <xsl:variable name="after" select="@after"/>
    <xsl:text>hydrogenConfActions.push(function (conf) {jQuery.hydrogen.addGlobalItemAction(conf, "</xsl:text>
    <xsl:value-of select="$wid"/>
    <xsl:text>", {id: "</xsl:text>
    <xsl:value-of select="encode:forJavaScriptBlock(@id)"/>
    <xsl:text>", separator: true }</xsl:text>
    <xsl:if test="$position != ''">
      <xsl:text>, {position: </xsl:text>
        <xsl:value-of select="$position"/>
      <xsl:text>}</xsl:text>
    </xsl:if>
    <xsl:text>);});</xsl:text>
  </xsl:template>

   <xsl:template match="hy:add-single-item-action" mode="configure">
    <xsl:param name="wid"/>
    <xsl:call-template name="add-item-action">
      <xsl:with-param name="scope">single</xsl:with-param>
      <xsl:with-param name="wid" select="$wid"/>
      <xsl:with-param name="position" select="@position"/>
      <xsl:with-param name="before" select="@before"/>
      <xsl:with-param name="after" select="@after"/>
      <xsl:with-param name="show-if" select="hy:show-if"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="hy:delete-single-item-action|hy:delete-single-item-separator" mode="configure">
    <xsl:param name="wid"/>
    <xsl:text>hydrogenConfActions.push(function (conf) {jQuery.hydrogen.deleteSingleItemAction(conf, "</xsl:text>
    <xsl:value-of select="$wid"/>
    <xsl:text>", "</xsl:text>
    <xsl:value-of select="encode:forJavaScriptBlock(@id)"/>
    <xsl:text>");});</xsl:text>
  </xsl:template>

  <xsl:template match="hy:add-single-item-separator" mode="configure">
    <xsl:param name="wid"/>
    <xsl:text>hydrogenConfActions.push(function (conf) {jQuery.hydrogen.addSingleItemAction(conf, "</xsl:text>
    <xsl:value-of select="$wid"/>
    <xsl:text>", {id: "</xsl:text>
    <xsl:value-of select="encode:forJavaScriptBlock(@id)"/>
    <xsl:text>", separator: true });});</xsl:text>
  </xsl:template>

  <xsl:template match="hy:add-clusters" mode="configure">
    <xsl:param name="wid"/>
    <!-- this one is slightly different, it expects the cluster list in gridml -->
    <xsl:apply-templates select="grid:cluster-list//grid:cluster[not(@status='WAITING_FOR_CREATION' or @status='CREATING')]" mode="clusters">
      <xsl:with-param name="wid" select="$wid"/>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match="grid:cluster" mode="clusters">
    <xsl:param name="wid"/>
    <xsl:variable name="status"><xsl:if test="not(@status)">READY</xsl:if><xsl:value-of select="@status"/></xsl:variable>
    <xsl:text>hydrogenConfActions.push(function (conf) {jQuery.hydrogen.addCluster(conf, "</xsl:text>
    <xsl:value-of select="$wid"/>
    <xsl:text>", {id: "</xsl:text>
    <xsl:value-of select="encode:forJavaScriptBlock(@id)"/>
    <xsl:text>", type: "</xsl:text>
    <xsl:value-of select="encode:forJavaScriptBlock(@type)"/>
    <xsl:text>", status: "</xsl:text>
    <xsl:value-of select="encode:forJavaScriptBlock($status)"/>
    <xsl:text>", name: "</xsl:text>
    <xsl:value-of select="encode:forJavaScriptBlock(@name)"/>
    <xsl:text>"});});</xsl:text>
  </xsl:template>

  <xsl:template match="hy:add-vroot" mode="configure">
    <xsl:param name="wid"/>
    <xsl:variable name="position" select="@position"/>
    <xsl:text>hydrogenConfActions.push(function (conf) {jQuery.hydrogen.addVRoot(conf, "</xsl:text>
    <xsl:value-of select="$wid"/>
    <xsl:text>", {id: "</xsl:text>
    <xsl:value-of select="encode:forJavaScriptBlock(@id)"/>
    <xsl:text>", label: "</xsl:text>
    <xsl:value-of select="encode:forJavaScriptBlock(hy:label/text())"/>
    <xsl:text>"</xsl:text>
    <xsl:if test="hy:type/text() != ''">
      <xsl:text>, type: "</xsl:text>
      <xsl:value-of select="encode:forJavaScriptBlock(hy:type/text())"/>
      <xsl:text>"</xsl:text>
    </xsl:if>
    <xsl:text>, path: "</xsl:text>
    <xsl:value-of select="encode:forJavaScriptBlock(hy:path/text())"/>
    <xsl:text>"}</xsl:text>
    <xsl:if test="$position != ''">
      <xsl:text>, {position: "</xsl:text>
        <xsl:value-of select="$position"/>
      <xsl:text>"}</xsl:text>
    </xsl:if>
    <xsl:text>);});</xsl:text>
  </xsl:template>

  <xsl:template match="hy:delete-vroot" mode="configure">
    <xsl:param name="wid"/>
    <xsl:text>hydrogenConfActions.push(function (conf) {jQuery.hydrogen.deleteVRoot(conf, "</xsl:text>
    <xsl:value-of select="$wid"/>
    <xsl:text>", "</xsl:text>
    <xsl:value-of select="encode:forJavaScriptBlock(@id)"/>
    <xsl:text>");});</xsl:text>
  </xsl:template>

  <xsl:template match="ef:ui-widget[@ui='hydrogen']" mode="configure">
    <script type="text/javascript">
      <xsl:text>var hydrogenConf, hydrogenConfActions; hydrogenConfActions = [];</xsl:text>
      <xsl:apply-templates select="//ef:ui-configure-widget[@ui='hydrogen']" mode="configure"/>
      <xsl:text>hydrogenConf = jQuery.hydrogen.populateConfiguration(hydrogenConfActions);</xsl:text>
    </script>
  </xsl:template>

  <xsl:template match="ef:ui-widget[@ui='hydrogen']">
    <xsl:if test="not(preceding-sibling::ef:ui-widget[@ui='hydrogen'])">
      <xsl:apply-templates select="." mode="configure"/>
    </xsl:if>
    <xsl:apply-templates select="." mode="widget"/>
  </xsl:template>

  <!-- rely on com.enginframe.system.xsl for the default copy template -->

</xsl:stylesheet>
