<?xml version="1.0" encoding="UTF-8"?>
<!--
  * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.-->
<xsl:transform version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:grid="http://www.enginframe.com/2000/GRID"
  xmlns:filter="http://www.enginframe.com/2010/EnginFrame/Filter"
  exclude-result-prefixes="grid filter"
  >

  <!-- import generic adapter library -->
  <xsl:import href="hydrogen.adapter.library.xsl" />

  <!-- special handling of unlicensed hosts -->
  <xsl:template match="grid:host[@licensed='false']">
    <host>
      <name><xsl:value-of select="@name"/></name>
      <type><xsl:value-of select="@type" /></type>
      <status>ef-unlicensed</status>
    </host>
  </xsl:template>

  <!-- re-define the value of NCPUs in some special cases -->
  <xsl:template match="filter:mapper[@id='ncpus']" mode="adapter">
    <xsl:param name="row" />
    <xsl:variable name="value" select="$row/@ncpus" />
    <xsl:variable name="ncpus">
      <xsl:choose>
        <xsl:when test="$value and not($value='') and not($value='-')">
          <xsl:value-of select="$value" />
        </xsl:when>
        <xsl:otherwise>N/A</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <ncpus><xsl:value-of select="$ncpus" /></ncpus>
  </xsl:template>

</xsl:transform>
