<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
  xmlns:grid="http://www.enginframe.com/2000/GRID"
  xmlns:func="http://exslt.org/functions"
  xmlns:f="http://www.enginframe.com/2011/EnginFrame/functions"
  xmlns:encode="org.owasp.encoder.Encode"
  exclude-result-prefixes="ef grid func f encode">

<!--
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.
-->

  <!-- Hostname separator -->
  <xsl:variable name="hostnameSeparator">_</xsl:variable>

  <!-- Host list options -->
  <xsl:variable name="hostcellspace">200</xsl:variable>
  <xsl:variable name="cellspace_minimal">60</xsl:variable>
  <xsl:variable name="nhost_for_minimal_view">32</xsl:variable>
  <xsl:variable name="nhost_for_singlebar_view">512</xsl:variable>
  <xsl:variable name="show_base_batch_status">0</xsl:variable>
  <xsl:variable name="bar_width">114</xsl:variable>
  <xsl:variable name="min_host_name_max_length">8</xsl:variable>

  <!-- Input parameters -->
  <xsl:param name="_root_context">enginframe</xsl:param>
  <xsl:param name="_jobid"/>
  <xsl:param name="_uri"/>
  <xsl:param name="url"/>

  <!-- Auxiliary templates -->

  <!-- hy_gridhosts_percentage
       generates percentage bar plus overlay message -->
  <xsl:template name="hy_gridhosts_percentage">
    <xsl:param name="value">0</xsl:param>
    <xsl:param name="max">0</xsl:param>
    <xsl:param name="class_name"></xsl:param>
    <xsl:param name="overlay"></xsl:param>

    <xsl:param name="normalized_value">
      <xsl:value-of select="$value*$bar_width div ($hostcellspace div 2)"/>
    </xsl:param>

    <xsl:param name="normalized_max">
      <xsl:value-of select="$max*$bar_width div ($hostcellspace div 2)"/>
    </xsl:param>

    <xsl:choose>
      <xsl:when test="$value = '-' or $value = '--'" >
        <div class="hy-gridhosts-data">
          <xsl:if test="$overlay">
            <div class="hy-gridhosts-centered-data" style="width: {encode:forCssString($normalized_max)}px">
              <xsl:value-of select="$overlay"/>
            </div>
          </xsl:if>
          <div class="{$class_name}" style="width: {encode:forCssString($normalized_max)}px">
            <div style="width: 0px"></div>
          </div>
        </div>
      </xsl:when>
      <xsl:otherwise>
        <div class="hy-gridhosts-data">
          <xsl:if test="$overlay">
            <div class="hy-gridhosts-centered-data" style="width: {encode:forCssString($normalized_max)}px">
              <xsl:value-of select="$overlay"/>
            </div>
          </xsl:if>
          <div class="{$class_name}" style="width: {encode:forCssString($normalized_max)}px">
            <div style="width: {encode:forCssString($normalized_value)}px"></div>
          </div>
        </div>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


  <!-- hy_gridhosts_normalize_mem
       returns bytes value in MB or GB amount -->
  <xsl:template name="hy_gridhosts_normalize_mem">
    <xsl:param name="bytes_value">0</xsl:param>
    <xsl:choose>
      <xsl:when test="not($bytes_value)">-</xsl:when>
      <xsl:when test="$bytes_value = 0">0</xsl:when>
      <xsl:when test="$bytes_value > 1073741824">
        <xsl:value-of select="format-number($bytes_value div 1073741824, '#.00GB')"/>
      </xsl:when>
      <xsl:when test="$bytes_value > 1048576">
        <xsl:value-of select="format-number($bytes_value div 1048576, '#MB')"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="format-number($bytes_value, '#B')"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- no host detected message -->
  <xsl:template match="grid:host-list[count(grid:host) = 0]" priority="+2">
    <div>No hosts found.</div>
  </xsl:template>

  <!-- grid:host mode compact view
       medium size global grid view -->
  <xsl:template match="grid:host-list[(count(grid:host) > 0) and (count(grid:host) &lt;= $nhost_for_minimal_view)]" priority="+2">
    <div class="hy-gridhosts-compact-cluster-wrapper">
      <xsl:apply-templates select="grid:host" mode="compact"/>
    </div>
  </xsl:template>

  <xsl:template match="grid:host" mode="compact" priority="+2">

    <xsl:variable name="cpu_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='ut']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='ut']))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(ceiling((grid:resource[@name='ut'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="gpu_avg_ut_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='gpu_avg_ut']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='gpu_avg_ut']))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(ceiling((grid:resource[@name='gpu_avg_ut'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="gpu_avg_mut_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='gpu_avg_mut']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='gpu_avg_mut']))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(ceiling((grid:resource[@name='gpu_avg_mut'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="gpu_idx_ut_0_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='gpu_idx_ut_0']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='gpu_idx_ut_0']))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(ceiling((grid:resource[@name='gpu_idx_ut_0'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="gpu_idx_mut_0_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='gpu_idx_mut_0']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='gpu_idx_mut_0']))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(ceiling((grid:resource[@name='gpu_idx_mut_0'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="gpu_idx_ut_1_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='gpu_idx_ut_1']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='gpu_idx_ut_1']))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(ceiling((grid:resource[@name='gpu_idx_ut_1'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="gpu_idx_mut_1_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='gpu_idx_mut_1']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='gpu_idx_mut_1']))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(ceiling((grid:resource[@name='gpu_idx_mut_1'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="gpu_idx_ut_2_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='gpu_idx_ut_2']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='gpu_idx_ut_2']))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(ceiling((grid:resource[@name='gpu_idx_ut_2'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="gpu_idx_mut_2_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='gpu_idx_mut_2']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='gpu_idx_mut_2']))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(ceiling((grid:resource[@name='gpu_idx_mut_2'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="gpu_idx_ut_3_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='gpu_idx_ut_3']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='gpu_idx_ut_3']))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(ceiling((grid:resource[@name='gpu_idx_ut_3'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="gpu_idx_mut_3_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='gpu_idx_mut_3']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='gpu_idx_mut_3']))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(ceiling((grid:resource[@name='gpu_idx_mut_3'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="gpu_idx_ut_4_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='gpu_idx_ut_4']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='gpu_idx_ut_4']))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(ceiling((grid:resource[@name='gpu_idx_ut_4'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="gpu_idx_mut_4_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='gpu_idx_mut_4']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='gpu_idx_mut_4']))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(ceiling((grid:resource[@name='gpu_idx_mut_4'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="gpu_idx_ut_5_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='gpu_idx_ut_5']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='gpu_idx_ut_5']))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(ceiling((grid:resource[@name='gpu_idx_ut_5'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="gpu_idx_mut_5_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='gpu_idx_mut_5']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='gpu_idx_mut_5']))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(ceiling((grid:resource[@name='gpu_idx_mut_5'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="gpu_idx_ut_6_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='gpu_idx_ut_6']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='gpu_idx_ut_6']))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(ceiling((grid:resource[@name='gpu_idx_ut_6'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="gpu_idx_mut_6_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='gpu_idx_mut_6']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='gpu_idx_mut_6']))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(ceiling((grid:resource[@name='gpu_idx_mut_6'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

      <xsl:variable name="gpu_idx_ut_7_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='gpu_idx_ut_7']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='gpu_idx_ut_7']))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(ceiling((grid:resource[@name='gpu_idx_ut_7'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="gpu_idx_mut_7_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='gpu_idx_mut_7']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='gpu_idx_mut_7']))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(ceiling((grid:resource[@name='gpu_idx_mut_7'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

      <xsl:variable name="gpu_idx_ut_8_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='gpu_idx_ut_8']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='gpu_idx_ut_8']))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(ceiling((grid:resource[@name='gpu_idx_ut_8'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="gpu_idx_mut_8_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='gpu_idx_mut_8']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='gpu_idx_mut_8']))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(ceiling((grid:resource[@name='gpu_idx_mut_8'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

      <xsl:variable name="gpu_idx_ut_9_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='gpu_idx_ut_9']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='gpu_idx_ut_9']))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(ceiling((grid:resource[@name='gpu_idx_ut_9'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="gpu_idx_mut_9_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='gpu_idx_mut_9']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='gpu_idx_mut_9']))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(ceiling((grid:resource[@name='gpu_idx_mut_9'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

      <xsl:variable name="gpu_idx_ut_10_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='gpu_idx_ut_10']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='gpu_idx_ut_10']))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(ceiling((grid:resource[@name='gpu_idx_ut_10'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="gpu_idx_mut_10_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='gpu_idx_mut_10']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='gpu_idx_mut_10']))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(ceiling((grid:resource[@name='gpu_idx_mut_10'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

      <xsl:variable name="gpu_idx_ut_11_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='gpu_idx_ut_11']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='gpu_idx_ut_11']))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(ceiling((grid:resource[@name='gpu_idx_ut_11'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="gpu_idx_mut_11_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='gpu_idx_mut_11']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='gpu_idx_mut_11']))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(ceiling((grid:resource[@name='gpu_idx_mut_11'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

      <xsl:variable name="gpu_idx_ut_12_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='gpu_idx_ut_12']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='gpu_idx_ut_12']))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(ceiling((grid:resource[@name='gpu_idx_ut_12'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="gpu_idx_mut_12_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='gpu_idx_mut_12']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='gpu_idx_mut_12']))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(ceiling((grid:resource[@name='gpu_idx_mut_12'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

      <xsl:variable name="gpu_idx_ut_13_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='gpu_idx_ut_13']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='gpu_idx_ut_13']))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(ceiling((grid:resource[@name='gpu_idx_ut_13'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="gpu_idx_mut_13_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='gpu_idx_mut_13']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='gpu_idx_mut_13']))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(ceiling((grid:resource[@name='gpu_idx_mut_13'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

      <xsl:variable name="gpu_idx_ut_14_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='gpu_idx_ut_14']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='gpu_idx_ut_14']))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(ceiling((grid:resource[@name='gpu_idx_ut_14'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="gpu_idx_mut_14_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='gpu_idx_mut_14']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='gpu_idx_mut_14']))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(ceiling((grid:resource[@name='gpu_idx_mut_14'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

      <xsl:variable name="gpu_idx_ut_15_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='gpu_idx_ut_15']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='gpu_idx_ut_15']))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(ceiling((grid:resource[@name='gpu_idx_ut_15'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="gpu_idx_mut_15_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='gpu_idx_mut_15']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='gpu_idx_mut_15']))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(ceiling((grid:resource[@name='gpu_idx_mut_15'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="mem_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='mem']/@max) = 0">0</xsl:when>
        <xsl:when test="number(grid:resource[@name='mem']) = 0"><xsl:value-of select="$hostcellspace div 2"/></xsl:when>
        <xsl:when test="not(number(grid:resource[@name='mem'])) or not(number(grid:resource[@name='mem']/@max))">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="ceiling((number((grid:resource[@name='mem']/@max) - (grid:resource[@name='mem'])) div number(grid:resource[@name='mem']/@max)) * ($hostcellspace div 2))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="slots_gauge">
      <xsl:choose>
        <xsl:when test="not(number(grid:job-slots))">-</xsl:when>
        <xsl:when test="not(number(grid:usage/@running-jobs))">0</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="ceiling((number(grid:usage/@running-jobs) div number(grid:job-slots)) * ($hostcellspace div 2))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="virtual_session_gauge">
      <xsl:choose>
        <xsl:when test="not(number(grid:interactive-virtual-sessions))">0</xsl:when>
        <xsl:when test="not(number(grid:interactive-max-virtual-sessions)) or number(grid:interactive-max-virtual-sessions) &lt; 0">0</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="ceiling((number(grid:interactive-virtual-sessions) div number(grid:interactive-max-virtual-sessions)) * ($hostcellspace div 2))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="console_session_gauge">
      <xsl:choose>
        <xsl:when test="not(number(grid:interactive-console-sessions))">0</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="ceiling((number(grid:interactive-console-sessions) div 1) * ($hostcellspace div 2))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="action-url">
      <xsl:value-of select="$url"/>
      <xsl:text>?_uri=//com.enginframe.grid</xsl:text>
      <xsl:text>/host.info&amp;host=</xsl:text>
      <xsl:value-of select="encode:forUriComponent(@name)"/>
      <xsl:text>&amp;grid=</xsl:text>
      <xsl:value-of select="encode:forUriComponent(@type)"/>
      <xsl:if test="../@cluster">
        <xsl:text>&amp;cluster=</xsl:text>
        <xsl:value-of select="encode:forUriComponent(../@cluster)"/>
      </xsl:if>
    </xsl:variable>

    <xsl:variable name="host_status">
      <xsl:choose>
        <xsl:when test="@licensed='false'">
          <status>unlicensed</status>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="grid:status/@ef" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <div class="hy-gridhosts-box hy-gridhosts-status-{$host_status}">
      <a href="{$action-url}">
      <div class="hy-gridhosts-box-head" >
        <h2>
	  <xsl:attribute name="title">
            <xsl:value-of select="@name"/>
          </xsl:attribute>
          <xsl:apply-templates select="." mode="archicon"/>
          <xsl:choose>
            <xsl:when test="contains(@name, $hostnameSeparator)">
              <xsl:value-of select="substring-before(@name, $hostnameSeparator)"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="@name"/>
            </xsl:otherwise>
          </xsl:choose>
        </h2>
      </div>

      <div class="hy-gridhosts-cluster-host-image" >
        <img src="/{$_root_context}/hydrogen/images/host_alpha.png" />
      </div>

      <div class="hy-gridhosts-box-body">
        <div class="hy-gridhosts-data-name">Status</div>  <div class="hy-gridhosts-status-value"><xsl:value-of select="$host_status" /></div>
        <xsl:choose>
          <xsl:when test="grid:is-session-manager">
            <xsl:if test="grid:interactive-virtual-sessions">
            <div class="hy-gridhosts-data-name">Virtual</div>
              <xsl:call-template name="hy_gridhosts_percentage">
                <xsl:with-param name="value">
                  <xsl:value-of select="$virtual_session_gauge" />
                </xsl:with-param>
                <xsl:with-param name="max">
                  <xsl:value-of select="$hostcellspace div 2" />
                </xsl:with-param>
                <xsl:with-param name="class_name">hy-gridhosts-slots-bar</xsl:with-param>
                <xsl:with-param name="overlay">
                  <xsl:choose>
                    <xsl:when test="grid:interactive-virtual-sessions">
                      <xsl:choose>
                        <xsl:when test="string(number(grid:interactive-max-virtual-sessions)) != 'NaN' and number(grid:interactive-max-virtual-sessions) >= 0">
                          <xsl:value-of select="grid:interactive-virtual-sessions"/>/<xsl:value-of select="grid:interactive-max-virtual-sessions"/>
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:value-of select="grid:interactive-virtual-sessions"/>
                        </xsl:otherwise>
                      </xsl:choose>
                    </xsl:when>
                    <xsl:otherwise>
                      N/A
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:with-param>
              </xsl:call-template>
            </xsl:if>
            <xsl:if test="grid:interactive-console-sessions">
              <div class="hy-gridhosts-data-name">Console</div>
              <xsl:call-template name="hy_gridhosts_percentage">
                <xsl:with-param name="value">
                  <xsl:value-of select="$console_session_gauge" />
                </xsl:with-param>
                <xsl:with-param name="max">
                  <xsl:value-of select="$hostcellspace div 2" />
                </xsl:with-param>
                <xsl:with-param name="class_name">hy-gridhosts-slots-bar</xsl:with-param>
                <xsl:with-param name="overlay">
                  <xsl:value-of select="grid:interactive-console-sessions"/>/1
                </xsl:with-param>
              </xsl:call-template>
            </xsl:if>
          </xsl:when>
          <xsl:otherwise>
            <div class="hy-gridhosts-data-name">Jobs</div>
            <xsl:call-template name="hy_gridhosts_percentage">
              <xsl:with-param name="value">
                <xsl:value-of select="$slots_gauge" />
              </xsl:with-param>
              <xsl:with-param name="max">
                <xsl:value-of select="$hostcellspace div 2" />
              </xsl:with-param>
              <xsl:with-param name="class_name">hy-gridhosts-slots-bar</xsl:with-param>
              <xsl:with-param name="overlay">
                <xsl:choose>
                  <xsl:when test="not(number(grid:job-slots))">
                    <xsl:value-of select="grid:usage/@running-jobs"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="grid:usage/@running-jobs"/>/<xsl:value-of select="grid:job-slots"/>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:choose>
          <xsl:when test="grid:resource[@name='ut']">
            <div class="hy-gridhosts-data-name">CPU</div>
            <xsl:call-template name="hy_gridhosts_percentage">
              <xsl:with-param name="value">
                <xsl:value-of select="$cpu_gauge" />
              </xsl:with-param>
              <xsl:with-param name="max">
                <xsl:value-of select="$hostcellspace div 2" />
              </xsl:with-param>
              <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
              <xsl:with-param name="overlay">
                <xsl:value-of select="$cpu_gauge"/><xsl:if test="not($cpu_gauge='--')">%</xsl:if>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <div class="hy-gridhosts-data-name">Load</div>
            <div class="hy-gridhosts-cpu-value">
              <xsl:choose>
                <xsl:when test="grid:resource[@name='r1m']">
                  <xsl:value-of select="grid:resource[@name='r1m']" /><xsl:text> (r1m)</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:text>--</xsl:text>
                </xsl:otherwise>
              </xsl:choose>
            </div>
          </xsl:otherwise>
        </xsl:choose>

        <div class="hy-gridhosts-data-name">Memory</div>
        <xsl:call-template name="hy_gridhosts_percentage">
          <xsl:with-param name="value">
            <xsl:value-of select="$mem_gauge" />
          </xsl:with-param>
          <xsl:with-param name="max">
            <xsl:value-of select="$hostcellspace div 2" />
          </xsl:with-param>
          <xsl:with-param name="class_name">hy-gridhosts-mem-bar</xsl:with-param>
          <xsl:with-param name="overlay">
            <xsl:choose>
              <xsl:when test="grid:resource[@name='mem']">
                <xsl:call-template name="hy_gridhosts_normalize_mem">
                  <xsl:with-param name="bytes_value">
                    <xsl:value-of select="grid:resource[@name='mem']/@max - grid:resource[@name='mem']"/>
                  </xsl:with-param>
                </xsl:call-template>/<xsl:call-template name="hy_gridhosts_normalize_mem">
                  <xsl:with-param name="bytes_value">
                    <xsl:value-of select="grid:resource[@name='mem']/@max"/>
                  </xsl:with-param>
                </xsl:call-template>
              </xsl:when>
              <xsl:otherwise>--</xsl:otherwise>
            </xsl:choose>
          </xsl:with-param>
        </xsl:call-template>

        <xsl:if test="grid:resource[@name='gpu_avg_ut']">
          <div class="hy-gridhosts-data-name gpu-ut">GPU AVG UT</div>
          <xsl:call-template name="hy_gridhosts_percentage">
            <xsl:with-param name="value">
              <xsl:value-of select="$gpu_avg_ut_gauge" />
            </xsl:with-param>
            <xsl:with-param name="max">
              <xsl:value-of select="$hostcellspace div 2" />
            </xsl:with-param>
            <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
            <xsl:with-param name="overlay">
              <xsl:value-of select="$gpu_avg_ut_gauge"/>
              <xsl:if test="not($gpu_avg_ut_gauge='--')">%</xsl:if>
            </xsl:with-param>
          </xsl:call-template>
        </xsl:if>

        <xsl:if test="grid:resource[@name='gpu_avg_mut']">
          <div class="hy-gridhosts-data-name gpu-ut">GPU AVG MUT</div>
          <xsl:call-template name="hy_gridhosts_percentage">
            <xsl:with-param name="value">
              <xsl:value-of select="$gpu_avg_mut_gauge" />
            </xsl:with-param>
            <xsl:with-param name="max">
              <xsl:value-of select="$hostcellspace div 2" />
            </xsl:with-param>
            <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
            <xsl:with-param name="overlay">
              <xsl:value-of select="$gpu_avg_mut_gauge"/>
              <xsl:if test="not($gpu_avg_mut_gauge='--')">%</xsl:if>
            </xsl:with-param>
          </xsl:call-template>
        </xsl:if>

        <xsl:if test="grid:resource[@name='gpu_idx_ut_0']">
              <div class="hy-gridhosts-data-name gpu-ut">GPU 0 UT</div>
              <xsl:call-template name="hy_gridhosts_percentage">
              <xsl:with-param name="value">
                <xsl:value-of select="$gpu_idx_ut_0_gauge" />
              </xsl:with-param>
              <xsl:with-param name="max">
                <xsl:value-of select="$hostcellspace div 2" />
              </xsl:with-param>
              <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
              <xsl:with-param name="overlay">
                <xsl:value-of select="$gpu_idx_ut_0_gauge"/>
                <xsl:if test="not($gpu_idx_ut_0_gauge='--')">%</xsl:if>
              </xsl:with-param>
              </xsl:call-template>
        </xsl:if>

        <xsl:if test="grid:resource[@name='gpu_idx_mut_0']">
              <div class="hy-gridhosts-data-name gpu-ut">GPU 0 MUT</div>
              <xsl:call-template name="hy_gridhosts_percentage">
              <xsl:with-param name="value">
                <xsl:value-of select="$gpu_idx_mut_0_gauge" />
              </xsl:with-param>
              <xsl:with-param name="max">
                <xsl:value-of select="$hostcellspace div 2" />
              </xsl:with-param>
              <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
              <xsl:with-param name="overlay">
                <xsl:value-of select="$gpu_idx_mut_0_gauge"/>
                <xsl:if test="not($gpu_idx_mut_0_gauge='--')">%</xsl:if>
              </xsl:with-param>
              </xsl:call-template>
        </xsl:if>

        <xsl:if test="grid:resource[@name='gpu_idx_ut_1']">
              <div class="hy-gridhosts-data-name gpu-ut">GPU 1 UT</div>
              <xsl:call-template name="hy_gridhosts_percentage">
              <xsl:with-param name="value">
                <xsl:value-of select="$gpu_idx_ut_1_gauge" />
              </xsl:with-param>
              <xsl:with-param name="max">
                <xsl:value-of select="$hostcellspace div 2" />
              </xsl:with-param>
              <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
              <xsl:with-param name="overlay">
                <xsl:value-of select="$gpu_idx_ut_1_gauge"/>
                <xsl:if test="not($gpu_idx_ut_1_gauge='--')">%</xsl:if>
              </xsl:with-param>
              </xsl:call-template>
        </xsl:if>

        <xsl:if test="grid:resource[@name='gpu_idx_mut_1']">
              <div class="hy-gridhosts-data-name gpu-ut">GPU 1 MUT</div>
              <xsl:call-template name="hy_gridhosts_percentage">
              <xsl:with-param name="value">
                <xsl:value-of select="$gpu_idx_mut_1_gauge" />
              </xsl:with-param>
              <xsl:with-param name="max">
                <xsl:value-of select="$hostcellspace div 2" />
              </xsl:with-param>
              <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
              <xsl:with-param name="overlay">
                <xsl:value-of select="$gpu_idx_mut_1_gauge"/>
                <xsl:if test="not($gpu_idx_mut_1_gauge='--')">%</xsl:if>
              </xsl:with-param>
              </xsl:call-template>
        </xsl:if>

        <xsl:if test="grid:resource[@name='gpu_idx_ut_2']">
              <div class="hy-gridhosts-data-name gpu-ut">GPU 2 UT</div>
              <xsl:call-template name="hy_gridhosts_percentage">
              <xsl:with-param name="value">
                <xsl:value-of select="$gpu_idx_ut_2_gauge" />
              </xsl:with-param>
              <xsl:with-param name="max">
                <xsl:value-of select="$hostcellspace div 2" />
              </xsl:with-param>
              <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
              <xsl:with-param name="overlay">
                <xsl:value-of select="$gpu_idx_ut_2_gauge"/>
                <xsl:if test="not($gpu_idx_ut_2_gauge='--')">%</xsl:if>
              </xsl:with-param>
              </xsl:call-template>
        </xsl:if>

        <xsl:if test="grid:resource[@name='gpu_idx_mut_2']">
              <div class="hy-gridhosts-data-name gpu-ut">GPU 2 MUT</div>
              <xsl:call-template name="hy_gridhosts_percentage">
              <xsl:with-param name="value">
                <xsl:value-of select="$gpu_idx_mut_2_gauge" />
              </xsl:with-param>
              <xsl:with-param name="max">
                <xsl:value-of select="$hostcellspace div 2" />
              </xsl:with-param>
              <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
              <xsl:with-param name="overlay">
                <xsl:value-of select="$gpu_idx_mut_2_gauge"/>
                <xsl:if test="not($gpu_idx_mut_2_gauge='--')">%</xsl:if>
              </xsl:with-param>
              </xsl:call-template>
        </xsl:if>

        <xsl:if test="grid:resource[@name='gpu_idx_ut_3']">
              <div class="hy-gridhosts-data-name gpu-ut">GPU 3 UT</div>
              <xsl:call-template name="hy_gridhosts_percentage">
              <xsl:with-param name="value">
                <xsl:value-of select="$gpu_idx_ut_3_gauge" />
              </xsl:with-param>
              <xsl:with-param name="max">
                <xsl:value-of select="$hostcellspace div 2" />
              </xsl:with-param>
              <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
              <xsl:with-param name="overlay">
                <xsl:value-of select="$gpu_idx_ut_3_gauge"/>
                <xsl:if test="not($gpu_idx_ut_3_gauge='--')">%</xsl:if>
              </xsl:with-param>
              </xsl:call-template>
        </xsl:if>

        <xsl:if test="grid:resource[@name='gpu_idx_mut_3']">
              <div class="hy-gridhosts-data-name gpu-ut">GPU 3 MUT</div>
              <xsl:call-template name="hy_gridhosts_percentage">
              <xsl:with-param name="value">
                <xsl:value-of select="$gpu_idx_mut_3_gauge" />
              </xsl:with-param>
              <xsl:with-param name="max">
                <xsl:value-of select="$hostcellspace div 2" />
              </xsl:with-param>
              <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
              <xsl:with-param name="overlay">
                <xsl:value-of select="$gpu_idx_mut_3_gauge"/>
                <xsl:if test="not($gpu_idx_mut_3_gauge='--')">%</xsl:if>
              </xsl:with-param>
              </xsl:call-template>
        </xsl:if>

        <xsl:if test="grid:resource[@name='gpu_idx_ut_4']">
              <div class="hy-gridhosts-data-name gpu-ut">GPU 4 UT</div>
              <xsl:call-template name="hy_gridhosts_percentage">
              <xsl:with-param name="value">
                <xsl:value-of select="$gpu_idx_ut_4_gauge" />
              </xsl:with-param>
              <xsl:with-param name="max">
                <xsl:value-of select="$hostcellspace div 2" />
              </xsl:with-param>
              <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
              <xsl:with-param name="overlay">
                <xsl:value-of select="$gpu_idx_ut_4_gauge"/>
                <xsl:if test="not($gpu_idx_ut_4_gauge='--')">%</xsl:if>
              </xsl:with-param>
              </xsl:call-template>
        </xsl:if>

        <xsl:if test="grid:resource[@name='gpu_idx_mut_4']">
              <div class="hy-gridhosts-data-name gpu-ut">GPU 4 MUT</div>
              <xsl:call-template name="hy_gridhosts_percentage">
              <xsl:with-param name="value">
                <xsl:value-of select="$gpu_idx_mut_4_gauge" />
              </xsl:with-param>
              <xsl:with-param name="max">
                <xsl:value-of select="$hostcellspace div 2" />
              </xsl:with-param>
              <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
              <xsl:with-param name="overlay">
                <xsl:value-of select="$gpu_idx_mut_4_gauge"/>
                <xsl:if test="not($gpu_idx_mut_4_gauge='--')">%</xsl:if>
              </xsl:with-param>
              </xsl:call-template>
        </xsl:if>

        <xsl:if test="grid:resource[@name='gpu_idx_ut_5']">
              <div class="hy-gridhosts-data-name gpu-ut">GPU 5 UT</div>
              <xsl:call-template name="hy_gridhosts_percentage">
              <xsl:with-param name="value">
                <xsl:value-of select="$gpu_idx_ut_5_gauge" />
              </xsl:with-param>
              <xsl:with-param name="max">
                <xsl:value-of select="$hostcellspace div 2" />
              </xsl:with-param>
              <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
              <xsl:with-param name="overlay">
                <xsl:value-of select="$gpu_idx_ut_5_gauge"/>
                <xsl:if test="not($gpu_idx_ut_5_gauge='--')">%</xsl:if>
              </xsl:with-param>
              </xsl:call-template>
        </xsl:if>

        <xsl:if test="grid:resource[@name='gpu_idx_mut_5']">
              <div class="hy-gridhosts-data-name gpu-ut">GPU 5 MUT</div>
              <xsl:call-template name="hy_gridhosts_percentage">
              <xsl:with-param name="value">
                <xsl:value-of select="$gpu_idx_mut_5_gauge" />
              </xsl:with-param>
              <xsl:with-param name="max">
                <xsl:value-of select="$hostcellspace div 2" />
              </xsl:with-param>
              <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
              <xsl:with-param name="overlay">
                <xsl:value-of select="$gpu_idx_mut_5_gauge"/>
                <xsl:if test="not($gpu_idx_mut_5_gauge='--')">%</xsl:if>
              </xsl:with-param>
              </xsl:call-template>
        </xsl:if>

        <xsl:if test="grid:resource[@name='gpu_idx_ut_6']">
              <div class="hy-gridhosts-data-name gpu-ut">GPU 6 UT</div>
              <xsl:call-template name="hy_gridhosts_percentage">
              <xsl:with-param name="value">
                <xsl:value-of select="$gpu_idx_ut_6_gauge" />
              </xsl:with-param>
              <xsl:with-param name="max">
                <xsl:value-of select="$hostcellspace div 2" />
              </xsl:with-param>
              <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
              <xsl:with-param name="overlay">
                <xsl:value-of select="$gpu_idx_ut_6_gauge"/>
                <xsl:if test="not($gpu_idx_ut_6_gauge='--')">%</xsl:if>
              </xsl:with-param>
              </xsl:call-template>
        </xsl:if>

        <xsl:if test="grid:resource[@name='gpu_idx_mut_6']">
              <div class="hy-gridhosts-data-name gpu-ut">GPU 6 MUT</div>
              <xsl:call-template name="hy_gridhosts_percentage">
              <xsl:with-param name="value">
                <xsl:value-of select="$gpu_idx_mut_6_gauge" />
              </xsl:with-param>
              <xsl:with-param name="max">
                <xsl:value-of select="$hostcellspace div 2" />
              </xsl:with-param>
              <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
              <xsl:with-param name="overlay">
                <xsl:value-of select="$gpu_idx_mut_6_gauge"/>
                <xsl:if test="not($gpu_idx_mut_6_gauge='--')">%</xsl:if>
              </xsl:with-param>
              </xsl:call-template>
        </xsl:if>

        <xsl:if test="grid:resource[@name='gpu_idx_ut_7']">
              <div class="hy-gridhosts-data-name gpu-ut">GPU 7 UT</div>
              <xsl:call-template name="hy_gridhosts_percentage">
              <xsl:with-param name="value">
                <xsl:value-of select="$gpu_idx_ut_7_gauge" />
              </xsl:with-param>
              <xsl:with-param name="max">
                <xsl:value-of select="$hostcellspace div 2" />
              </xsl:with-param>
              <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
              <xsl:with-param name="overlay">
                <xsl:value-of select="$gpu_idx_ut_7_gauge"/>
                <xsl:if test="not($gpu_idx_ut_7_gauge='--')">%</xsl:if>
              </xsl:with-param>
              </xsl:call-template>
        </xsl:if>

        <xsl:if test="grid:resource[@name='gpu_idx_mut_7']">
              <div class="hy-gridhosts-data-name gpu-ut">GPU 7 MUT</div>
              <xsl:call-template name="hy_gridhosts_percentage">
              <xsl:with-param name="value">
                <xsl:value-of select="$gpu_idx_mut_7_gauge" />
              </xsl:with-param>
              <xsl:with-param name="max">
                <xsl:value-of select="$hostcellspace div 2" />
              </xsl:with-param>
              <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
              <xsl:with-param name="overlay">
                <xsl:value-of select="$gpu_idx_mut_7_gauge"/>
                <xsl:if test="not($gpu_idx_mut_7_gauge='--')">%</xsl:if>
              </xsl:with-param>
              </xsl:call-template>
        </xsl:if>

        <xsl:if test="grid:resource[@name='gpu_idx_ut_8']">
              <div class="hy-gridhosts-data-name gpu-ut">GPU 8 UT</div>
              <xsl:call-template name="hy_gridhosts_percentage">
              <xsl:with-param name="value">
                <xsl:value-of select="$gpu_idx_ut_8_gauge" />
              </xsl:with-param>
              <xsl:with-param name="max">
                <xsl:value-of select="$hostcellspace div 2" />
              </xsl:with-param>
              <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
              <xsl:with-param name="overlay">
                <xsl:value-of select="$gpu_idx_ut_8_gauge"/>
                <xsl:if test="not($gpu_idx_ut_8_gauge='--')">%</xsl:if>
              </xsl:with-param>
              </xsl:call-template>
        </xsl:if>

        <xsl:if test="grid:resource[@name='gpu_idx_mut_8']">
              <div class="hy-gridhosts-data-name gpu-ut">GPU 8 MUT</div>
              <xsl:call-template name="hy_gridhosts_percentage">
              <xsl:with-param name="value">
                <xsl:value-of select="$gpu_idx_mut_8_gauge" />
              </xsl:with-param>
              <xsl:with-param name="max">
                <xsl:value-of select="$hostcellspace div 2" />
              </xsl:with-param>
              <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
              <xsl:with-param name="overlay">
                <xsl:value-of select="$gpu_idx_mut_8_gauge"/>
                <xsl:if test="not($gpu_idx_mut_8_gauge='--')">%</xsl:if>
              </xsl:with-param>
              </xsl:call-template>
        </xsl:if>

        <xsl:if test="grid:resource[@name='gpu_idx_ut_9']">
              <div class="hy-gridhosts-data-name gpu-ut">GPU 9 UT</div>
              <xsl:call-template name="hy_gridhosts_percentage">
              <xsl:with-param name="value">
                <xsl:value-of select="$gpu_idx_ut_9_gauge" />
              </xsl:with-param>
              <xsl:with-param name="max">
                <xsl:value-of select="$hostcellspace div 2" />
              </xsl:with-param>
              <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
              <xsl:with-param name="overlay">
                <xsl:value-of select="$gpu_idx_ut_9_gauge"/>
                <xsl:if test="not($gpu_idx_ut_9_gauge='--')">%</xsl:if>
              </xsl:with-param>
              </xsl:call-template>
        </xsl:if>

        <xsl:if test="grid:resource[@name='gpu_idx_mut_9']">
              <div class="hy-gridhosts-data-name gpu-ut">GPU 9 MUT</div>
              <xsl:call-template name="hy_gridhosts_percentage">
              <xsl:with-param name="value">
                <xsl:value-of select="$gpu_idx_mut_9_gauge" />
              </xsl:with-param>
              <xsl:with-param name="max">
                <xsl:value-of select="$hostcellspace div 2" />
              </xsl:with-param>
              <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
              <xsl:with-param name="overlay">
                <xsl:value-of select="$gpu_idx_mut_9_gauge"/>
                <xsl:if test="not($gpu_idx_mut_9_gauge='--')">%</xsl:if>
              </xsl:with-param>
              </xsl:call-template>
        </xsl:if>

        <xsl:if test="grid:resource[@name='gpu_idx_ut_10']">
              <div class="hy-gridhosts-data-name gpu-ut">GPU 10 UT</div>
              <xsl:call-template name="hy_gridhosts_percentage">
              <xsl:with-param name="value">
                <xsl:value-of select="$gpu_idx_ut_10_gauge" />
              </xsl:with-param>
              <xsl:with-param name="max">
                <xsl:value-of select="$hostcellspace div 2" />
              </xsl:with-param>
              <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
              <xsl:with-param name="overlay">
                <xsl:value-of select="$gpu_idx_ut_10_gauge"/>
                <xsl:if test="not($gpu_idx_ut_10_gauge='--')">%</xsl:if>
              </xsl:with-param>
              </xsl:call-template>
        </xsl:if>

        <xsl:if test="grid:resource[@name='gpu_idx_mut_10']">
              <div class="hy-gridhosts-data-name gpu-ut">GPU 10 MUT</div>
              <xsl:call-template name="hy_gridhosts_percentage">
              <xsl:with-param name="value">
                <xsl:value-of select="$gpu_idx_mut_10_gauge" />
              </xsl:with-param>
              <xsl:with-param name="max">
                <xsl:value-of select="$hostcellspace div 2" />
              </xsl:with-param>
              <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
              <xsl:with-param name="overlay">
                <xsl:value-of select="$gpu_idx_mut_10_gauge"/>
                <xsl:if test="not($gpu_idx_mut_10_gauge='--')">%</xsl:if>
              </xsl:with-param>
              </xsl:call-template>
        </xsl:if>

        <xsl:if test="grid:resource[@name='gpu_idx_ut_11']">
              <div class="hy-gridhosts-data-name gpu-ut">GPU 11 UT</div>
              <xsl:call-template name="hy_gridhosts_percentage">
              <xsl:with-param name="value">
                <xsl:value-of select="$gpu_idx_ut_11_gauge" />
              </xsl:with-param>
              <xsl:with-param name="max">
                <xsl:value-of select="$hostcellspace div 2" />
              </xsl:with-param>
              <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
              <xsl:with-param name="overlay">
                <xsl:value-of select="$gpu_idx_ut_11_gauge"/>
                <xsl:if test="not($gpu_idx_ut_11_gauge='--')">%</xsl:if>
              </xsl:with-param>
              </xsl:call-template>
        </xsl:if>

        <xsl:if test="grid:resource[@name='gpu_idx_mut_11']">
              <div class="hy-gridhosts-data-name gpu-ut">GPU 11 MUT</div>
              <xsl:call-template name="hy_gridhosts_percentage">
              <xsl:with-param name="value">
                <xsl:value-of select="$gpu_idx_mut_11_gauge" />
              </xsl:with-param>
              <xsl:with-param name="max">
                <xsl:value-of select="$hostcellspace div 2" />
              </xsl:with-param>
              <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
              <xsl:with-param name="overlay">
                <xsl:value-of select="$gpu_idx_mut_11_gauge"/>
                <xsl:if test="not($gpu_idx_mut_11_gauge='--')">%</xsl:if>
              </xsl:with-param>
              </xsl:call-template>
        </xsl:if>

        <xsl:if test="grid:resource[@name='gpu_idx_ut_12']">
              <div class="hy-gridhosts-data-name gpu-ut">GPU 12 UT</div>
              <xsl:call-template name="hy_gridhosts_percentage">
              <xsl:with-param name="value">
                <xsl:value-of select="$gpu_idx_ut_12_gauge" />
              </xsl:with-param>
              <xsl:with-param name="max">
                <xsl:value-of select="$hostcellspace div 2" />
              </xsl:with-param>
              <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
              <xsl:with-param name="overlay">
                <xsl:value-of select="$gpu_idx_ut_12_gauge"/>
                <xsl:if test="not($gpu_idx_ut_12_gauge='--')">%</xsl:if>
              </xsl:with-param>
              </xsl:call-template>
        </xsl:if>

        <xsl:if test="grid:resource[@name='gpu_idx_mut_12']">
              <div class="hy-gridhosts-data-name gpu-ut">GPU 12 MUT</div>
              <xsl:call-template name="hy_gridhosts_percentage">
              <xsl:with-param name="value">
                <xsl:value-of select="$gpu_idx_mut_12_gauge" />
              </xsl:with-param>
              <xsl:with-param name="max">
                <xsl:value-of select="$hostcellspace div 2" />
              </xsl:with-param>
              <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
              <xsl:with-param name="overlay">
                <xsl:value-of select="$gpu_idx_mut_12_gauge"/>
                <xsl:if test="not($gpu_idx_mut_12_gauge='--')">%</xsl:if>
              </xsl:with-param>
              </xsl:call-template>
        </xsl:if>

        <xsl:if test="grid:resource[@name='gpu_idx_ut_13']">
              <div class="hy-gridhosts-data-name gpu-ut">GPU 13 UT</div>
              <xsl:call-template name="hy_gridhosts_percentage">
              <xsl:with-param name="value">
                <xsl:value-of select="$gpu_idx_ut_13_gauge" />
              </xsl:with-param>
              <xsl:with-param name="max">
                <xsl:value-of select="$hostcellspace div 2" />
              </xsl:with-param>
              <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
              <xsl:with-param name="overlay">
                <xsl:value-of select="$gpu_idx_ut_13_gauge"/>
                <xsl:if test="not($gpu_idx_ut_13_gauge='--')">%</xsl:if>
              </xsl:with-param>
              </xsl:call-template>
        </xsl:if>

        <xsl:if test="grid:resource[@name='gpu_idx_mut_13']">
              <div class="hy-gridhosts-data-name gpu-ut">GPU 13 MUT</div>
              <xsl:call-template name="hy_gridhosts_percentage">
              <xsl:with-param name="value">
                <xsl:value-of select="$gpu_idx_mut_13_gauge" />
              </xsl:with-param>
              <xsl:with-param name="max">
                <xsl:value-of select="$hostcellspace div 2" />
              </xsl:with-param>
              <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
              <xsl:with-param name="overlay">
                <xsl:value-of select="$gpu_idx_mut_13_gauge"/>
                <xsl:if test="not($gpu_idx_mut_13_gauge='--')">%</xsl:if>
              </xsl:with-param>
              </xsl:call-template>
        </xsl:if>

        <xsl:if test="grid:resource[@name='gpu_idx_ut_14']">
              <div class="hy-gridhosts-data-name gpu-ut">GPU 14 UT</div>
              <xsl:call-template name="hy_gridhosts_percentage">
              <xsl:with-param name="value">
                <xsl:value-of select="$gpu_idx_ut_14_gauge" />
              </xsl:with-param>
              <xsl:with-param name="max">
                <xsl:value-of select="$hostcellspace div 2" />
              </xsl:with-param>
              <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
              <xsl:with-param name="overlay">
                <xsl:value-of select="$gpu_idx_ut_14_gauge"/>
                <xsl:if test="not($gpu_idx_ut_14_gauge='--')">%</xsl:if>
              </xsl:with-param>
              </xsl:call-template>
        </xsl:if>

        <xsl:if test="grid:resource[@name='gpu_idx_mut_14']">
              <div class="hy-gridhosts-data-name gpu-ut">GPU 14 MUT</div>
              <xsl:call-template name="hy_gridhosts_percentage">
              <xsl:with-param name="value">
                <xsl:value-of select="$gpu_idx_mut_14_gauge" />
              </xsl:with-param>
              <xsl:with-param name="max">
                <xsl:value-of select="$hostcellspace div 2" />
              </xsl:with-param>
              <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
              <xsl:with-param name="overlay">
                <xsl:value-of select="$gpu_idx_mut_14_gauge"/>
                <xsl:if test="not($gpu_idx_mut_14_gauge='--')">%</xsl:if>
              </xsl:with-param>
              </xsl:call-template>
        </xsl:if>

        <xsl:if test="grid:resource[@name='gpu_idx_ut_15']">
              <div class="hy-gridhosts-data-name gpu-ut">GPU 15 UT</div>
              <xsl:call-template name="hy_gridhosts_percentage">
              <xsl:with-param name="value">
                <xsl:value-of select="$gpu_idx_ut_15_gauge" />
              </xsl:with-param>
              <xsl:with-param name="max">
                <xsl:value-of select="$hostcellspace div 2" />
              </xsl:with-param>
              <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
              <xsl:with-param name="overlay">
                <xsl:value-of select="$gpu_idx_ut_15_gauge"/>
                <xsl:if test="not($gpu_idx_ut_15_gauge='--')">%</xsl:if>
              </xsl:with-param>
              </xsl:call-template>
        </xsl:if>

        <xsl:if test="grid:resource[@name='gpu_idx_mut_15']">
              <div class="hy-gridhosts-data-name gpu-ut">GPU 15 MUT</div>
              <xsl:call-template name="hy_gridhosts_percentage">
              <xsl:with-param name="value">
                <xsl:value-of select="$gpu_idx_mut_15_gauge" />
              </xsl:with-param>
              <xsl:with-param name="max">
                <xsl:value-of select="$hostcellspace div 2" />
              </xsl:with-param>
              <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
              <xsl:with-param name="overlay">
                <xsl:value-of select="$gpu_idx_mut_15_gauge"/>
                <xsl:if test="not($gpu_idx_mut_15_gauge='--')">%</xsl:if>
              </xsl:with-param>
              </xsl:call-template>
        </xsl:if>
     </div>
    </a>
    </div>

  </xsl:template>


  <!-- grid:host mode minimal
       smallest size global grid view -->

  <xsl:template match="grid:host-list[(count(grid:host) > $nhost_for_minimal_view) and (count(grid:host) &lt;= $nhost_for_singlebar_view)]" priority="+1">
    <div class="hy-gridhosts-minimal-cluster-wrapper">
      <xsl:apply-templates select="grid:host" mode="minimal"/>
    </div>
  </xsl:template>

  <xsl:template match="grid:host" mode="minimal" priority="+1" >

    <xsl:variable name="mem_gauge_min">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='mem']) = 0"><xsl:value-of select="$cellspace_minimal - 8"/></xsl:when>
        <xsl:when test="not(number(grid:resource[@name='mem']))">--</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="ceiling((number((grid:resource[@name='mem']/@max) - (grid:resource[@name='mem'])) div number(grid:resource[@name='mem']/@max)) * ($cellspace_minimal - 8))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="cpu_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='ut']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='ut']))">--</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(ceiling((grid:resource[@name='ut'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="mem_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='mem']) = 0"><xsl:value-of select="$hostcellspace div 2"/></xsl:when>
        <xsl:when test="not(number(grid:resource[@name='mem']))">--</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="ceiling((number((grid:resource[@name='mem']/@max) - (grid:resource[@name='mem'])) div number(grid:resource[@name='mem']/@max)) * ($hostcellspace div 2))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="slots_gauge_min">
      <xsl:choose>
        <xsl:when test="not(number(grid:job-slots))">-</xsl:when>
        <xsl:when test="not(number(grid:usage/@running-jobs))">0</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="ceiling((number(grid:usage/@running-jobs) div number(grid:job-slots)) * ($cellspace_minimal - 8))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="slots_gauge">
      <xsl:choose>
        <xsl:when test="not(number(grid:job-slots))">-</xsl:when>
        <xsl:when test="not(number(grid:usage/@running-jobs))">0</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="ceiling((number(grid:usage/@running-jobs) div number(grid:job-slots)) * ($hostcellspace div 2))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="host_status">
      <xsl:choose>
        <xsl:when test="@licensed='false'">
          <status>unlicensed</status>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="grid:status/@ef" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="action-url">
      <xsl:value-of select="$url"/>
      <xsl:text>?_uri=//com.enginframe.grid</xsl:text>
      <xsl:text>/host.info&amp;host=</xsl:text>
      <xsl:value-of select="encode:forUriComponent(@name)"/>
    </xsl:variable>

    <script type="text/javascript">
function showLayer( whichLayer )
{
  var elem, vis;
  if( document.getElementById ) // this is the way the standards work
    elem = document.getElementById( whichLayer );
  else if( document.all ) // this is the way old msie versions work
      elem = document.all[whichLayer];
  else if( document.layers ) // this is the way nn4 works
    elem = document.layers[whichLayer];
  vis = elem.style;
  vis.display = 'block';
}

function hideLayer( whichLayer )
{
  var elem, vis;
  if( document.getElementById ) // this is the way the standards work
    elem = document.getElementById( whichLayer );
  else if( document.all ) // this is the way old msie versions work
      elem = document.all[whichLayer];
  else if( document.layers ) // this is the way nn4 works
    elem = document.layers[whichLayer];
  vis = elem.style;
  vis.display = 'none';
}
    </script>

    <div class="hy-gridhosts-box-min hy-gridhosts-status-{$host_status}">
      <a class="highlight" href="{$action-url}" onmouseover="showLayer('ef_host_box_{encode:forJavaScriptAttribute(@name)}')" onmouseout="hideLayer('ef_host_box_{encode:forJavaScriptAttribute(@name)}')">

        <div class="hy-gridhosts-box-min-head">
          <h2><xsl:value-of select="substring(@name, 1, $min_host_name_max_length)" /></h2>
        </div>
        <div class="hy-gridhosts-box-min-body">
          <xsl:call-template name="hy_gridhosts_percentage">
            <xsl:with-param name="value">
              <xsl:value-of select="$slots_gauge_min" />
            </xsl:with-param>
            <xsl:with-param name="max">
              <xsl:value-of select="$cellspace_minimal - 8" />
            </xsl:with-param>
            <xsl:with-param name="class_name">hy-gridhosts-slots-bar-min</xsl:with-param>
          </xsl:call-template>
          <xsl:choose>
            <xsl:when test="grid:resource[@name='mem']">
              <xsl:call-template name="hy_gridhosts_percentage">
                <xsl:with-param name="value">
                  <xsl:value-of select="$mem_gauge_min" />
                </xsl:with-param>
                <xsl:with-param name="max">
                  <xsl:value-of select="$cellspace_minimal - 8" />
                </xsl:with-param>
                <xsl:with-param name="class_name">hy-gridhosts-mem-bar-min</xsl:with-param>
              </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
              <xsl:call-template name="hy_gridhosts_percentage">
                <xsl:with-param name="value">0</xsl:with-param>
                <xsl:with-param name="max">
                  <xsl:value-of select="$cellspace_minimal - 8" />
                </xsl:with-param>
                <xsl:with-param name="class_name">hy-gridhosts-mem-bar-min</xsl:with-param>
              </xsl:call-template>
            </xsl:otherwise>
          </xsl:choose>
        </div>
      </a>
      <div id="ef_host_box_{@name}" style="display: none" class="hy-gridhosts-box-tooltip">
        <div class="hy-gridhosts-box hy-gridhosts-status-{$host_status}">
          <a href="{$action-url}">
            <div class="hy-gridhosts-box-head" >
              <h2>
                <xsl:apply-templates select="." mode="archicon"/>
                <xsl:choose>
                  <xsl:when test="contains(@name, $hostnameSeparator)">
                    <xsl:value-of select="substring-before(@name, $hostnameSeparator)"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="@name"/>
                  </xsl:otherwise>
                </xsl:choose>
              </h2>
            </div>

            <div class="hy-gridhosts-cluster-host-image" >
              <img src="/{$_root_context}/hydrogen/images/host_alpha.png" />
            </div>

            <div class="hy-gridhosts-box-body">
              <div class="hy-gridhosts-data-name">Status</div>  <div class="hy-gridhosts-status-value"><xsl:value-of select="$host_status" /></div>
              <div class="hy-gridhosts-data-name">Jobs</div>
              <xsl:call-template name="hy_gridhosts_percentage">
                <xsl:with-param name="value">
                  <xsl:value-of select="$slots_gauge" />
                </xsl:with-param>
                <xsl:with-param name="max">
                  <xsl:value-of select="$hostcellspace div 2" />
                </xsl:with-param>
                <xsl:with-param name="overlay">
                  <xsl:choose>
                    <xsl:when test="not(number(grid:job-slots))">
                      <xsl:value-of select="grid:usage/@running-jobs"/>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select="grid:usage/@running-jobs"/>/<xsl:value-of select="grid:job-slots"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:with-param>
                <xsl:with-param name="class_name">hy-gridhosts-slots-bar</xsl:with-param>
              </xsl:call-template>
              <xsl:choose>
                <xsl:when test="grid:resource[@name='ut']">
                  <div class="hy-gridhosts-data-name">CPU</div>
                  <xsl:call-template name="hy_gridhosts_percentage">
                    <xsl:with-param name="value">
                      <xsl:value-of select="$cpu_gauge" />
                    </xsl:with-param>
                    <xsl:with-param name="max">
                      <xsl:value-of select="$hostcellspace div 2" />
                    </xsl:with-param>
                    <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
                    <xsl:with-param name="overlay">
                      <xsl:value-of select="$cpu_gauge"/><xsl:if test="not($cpu_gauge='--')">%</xsl:if>
                    </xsl:with-param>
                  </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                  <div class="hy-gridhosts-data-name">Load</div>
                  <div class="hy-gridhosts-cpu-value">
                    <xsl:choose>
                      <xsl:when test="grid:resource[@name='r1m']">
                        <xsl:value-of select="grid:resource[@name='r1m']" /><xsl:text> (r1m)</xsl:text>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:text>--</xsl:text>
                      </xsl:otherwise>
                    </xsl:choose>
                  </div>
                </xsl:otherwise>
              </xsl:choose>
              <div class="hy-gridhosts-data-name">Memory</div>
              <xsl:call-template name="hy_gridhosts_percentage">
                <xsl:with-param name="value">
                  <xsl:value-of select="$mem_gauge" />
                </xsl:with-param>
                <xsl:with-param name="max">
                  <xsl:value-of select="$hostcellspace div 2" />
                </xsl:with-param>
                <xsl:with-param name="class_name">hy-gridhosts-mem-bar</xsl:with-param>
                <xsl:with-param name="overlay">
                  <xsl:choose>
                    <xsl:when test="grid:resource[@name='mem']">
                      <xsl:call-template name="hy_gridhosts_normalize_mem">
                        <xsl:with-param name="bytes_value">
                          <xsl:value-of select="grid:resource[@name='mem']/@max - grid:resource[@name='mem']"/>
                        </xsl:with-param>
                      </xsl:call-template>/<xsl:call-template name="hy_gridhosts_normalize_mem">
                        <xsl:with-param name="bytes_value">
                          <xsl:value-of select="grid:resource[@name='mem']/@max"/>
                        </xsl:with-param>
                      </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>--</xsl:otherwise>
                  </xsl:choose>
                </xsl:with-param>
              </xsl:call-template>
            </div>
          </a>
        </div>
      </div>
    </div>
  </xsl:template>

  <xsl:template match="grid:host-list[(count(grid:host) > $nhost_for_singlebar_view)]" priority="+1">
    <div class="hy-gridhosts-singlebar-cluster-wrapper">
      <xsl:apply-templates select="grid:host" mode="singlebar"/>
    </div>
  </xsl:template>

  <!-- Similar to minimal view but only with job slots bar -->
  <xsl:template match="grid:host" mode="singlebar" priority="+1" >

    <xsl:variable name="mem_gauge_min">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='mem']) = 0"><xsl:value-of select="$cellspace_minimal - 8"/></xsl:when>
        <xsl:when test="not(number(grid:resource[@name='mem']))">--</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="ceiling((number((grid:resource[@name='mem']/@max) - (grid:resource[@name='mem'])) div number(grid:resource[@name='mem']/@max)) * ($cellspace_minimal - 8))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="cpu_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='ut']) = 0">0</xsl:when>
        <xsl:when test="not(number(grid:resource[@name='ut']))">--</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(ceiling((grid:resource[@name='ut'] * ($hostcellspace div 2)) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="mem_gauge">
      <xsl:choose>
        <xsl:when test="number(grid:resource[@name='mem']) = 0"><xsl:value-of select="$hostcellspace div 2"/></xsl:when>
        <xsl:when test="not(number(grid:resource[@name='mem']))">--</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="ceiling((number((grid:resource[@name='mem']/@max) - (grid:resource[@name='mem'])) div number(grid:resource[@name='mem']/@max)) * ($hostcellspace div 2))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="slots_gauge_min">
      <xsl:choose>
        <xsl:when test="not(number(grid:job-slots))">-</xsl:when>
        <xsl:when test="not(number(grid:usage/@running-jobs))">0</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="ceiling((number(grid:usage/@running-jobs) div number(grid:job-slots)) * ($cellspace_minimal - 8))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="slots_gauge">
      <xsl:choose>
        <xsl:when test="not(number(grid:job-slots))">-</xsl:when>
        <xsl:when test="not(number(grid:usage/@running-jobs))">0</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="ceiling((number(grid:usage/@running-jobs) div number(grid:job-slots)) * ($hostcellspace div 2))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="host_status">
      <xsl:choose>
        <xsl:when test="@licensed='false'">
          <status>unlicensed</status>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="grid:status/@ef" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="action-url">
      <xsl:value-of select="$url"/>
      <xsl:text>?_uri=//com.enginframe.grid</xsl:text>
      <xsl:text>/host.info&amp;host=</xsl:text>
      <xsl:value-of select="@name"/>
    </xsl:variable>

    <script type="text/javascript">
function showLayer( whichLayer )
{
  var elem, vis;
  if( document.getElementById ) // this is the way the standards work
    elem = document.getElementById( whichLayer );
  else if( document.all ) // this is the way old msie versions work
      elem = document.all[whichLayer];
  else if( document.layers ) // this is the way nn4 works
    elem = document.layers[whichLayer];
  vis = elem.style;
  vis.display = 'block';
}

function hideLayer( whichLayer )
{
  var elem, vis;
  if( document.getElementById ) // this is the way the standards work
    elem = document.getElementById( whichLayer );
  else if( document.all ) // this is the way old msie versions work
      elem = document.all[whichLayer];
  else if( document.layers ) // this is the way nn4 works
    elem = document.layers[whichLayer];
  vis = elem.style;
  vis.display = 'none';
}
    </script>

    <div class="hy-gridhosts-box-min hy-gridhosts-status-{$host_status}">
      <a class="highlight" href="{$action-url}" onmouseover="showLayer('ef_host_box_{encode:forJavaScriptAttribute(@name)}')" onmouseout="hideLayer('ef_host_box_{encode:forJavaScriptAttribute(@name)}')">

        <div class="hy-gridhosts-box-singlebar-body">
        <xsl:call-template name="hy_gridhosts_percentage">
          <xsl:with-param name="value">
            <xsl:value-of select="$slots_gauge_min" />
          </xsl:with-param>
          <xsl:with-param name="max">
            <xsl:value-of select="$cellspace_minimal - 8" />
          </xsl:with-param>
          <xsl:with-param name="class_name">hy-gridhosts-slots-bar-min</xsl:with-param>
        </xsl:call-template>
        </div>
      </a>
      <div id="ef_host_box_{@name}" style="display: none" class="hy-gridhosts-box-tooltip">
        <div class="hy-gridhosts-box hy-gridhosts-status-{$host_status}">
          <a href="{$action-url}">
            <div class="hy-gridhosts-box-head" >
              <h2>
                <xsl:apply-templates select="." mode="archicon"/>
                <xsl:choose>
                  <xsl:when test="contains(@name, $hostnameSeparator)">
                    <xsl:value-of select="substring-before(@name, $hostnameSeparator)"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="@name"/>
                  </xsl:otherwise>
                </xsl:choose>
              </h2>
            </div>

            <div class="hy-gridhosts-cluster-host-image" >
              <img src="/{$_root_context}/hydrogen/images/host_alpha.png" />
            </div>

            <div class="hy-gridhosts-box-body">
              <div class="hy-gridhosts-data-name">Status</div>
              <div class="hy-gridhosts-status-value"><xsl:value-of select="$host_status" /></div>
              <div class="hy-gridhosts-data-name">Jobs</div>
              <xsl:call-template name="hy_gridhosts_percentage">
                <xsl:with-param name="value">
                  <xsl:value-of select="$slots_gauge" />
                </xsl:with-param>
                <xsl:with-param name="max">
                  <xsl:value-of select="$hostcellspace div 2" />
                </xsl:with-param>
                <xsl:with-param name="overlay">
                  <xsl:choose>
                    <xsl:when test="not(number(grid:job-slots))">
                      <xsl:value-of select="grid:usage/@running-jobs"/>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select="grid:usage/@running-jobs"/>/<xsl:value-of select="grid:job-slots"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:with-param>
                <xsl:with-param name="class_name">hy-gridhosts-slots-bar</xsl:with-param>
              </xsl:call-template>
              <xsl:choose>
                <xsl:when test="grid:resource[@name='ut']">
                  <div class="hy-gridhosts-data-name">CPU</div>
                  <xsl:call-template name="hy_gridhosts_percentage">
                    <xsl:with-param name="value">
                      <xsl:value-of select="$cpu_gauge" />
                    </xsl:with-param>
                    <xsl:with-param name="max">
                      <xsl:value-of select="$hostcellspace div 2" />
                    </xsl:with-param>
                    <xsl:with-param name="class_name">hy-gridhosts-cpu-bar</xsl:with-param>
                    <xsl:with-param name="overlay">
                      <xsl:value-of select="$cpu_gauge"/><xsl:if test="not($cpu_gauge='--')">%</xsl:if>
                    </xsl:with-param>
                  </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                  <div class="hy-gridhosts-data-name">Load</div>
                  <div class="hy-gridhosts-cpu-value">
                    <xsl:choose>
                      <xsl:when test="grid:resource[@name='r1m']">
                        <xsl:value-of select="grid:resource[@name='r1m']" /><xsl:text> (r1m)</xsl:text>
                      </xsl:when>
                      <xsl:otherwise>
                         <xsl:text>--</xsl:text>
                      </xsl:otherwise>
                    </xsl:choose>
                  </div>
                </xsl:otherwise>
              </xsl:choose>
              <div class="hy-gridhosts-data-name">Memory</div>
              <xsl:call-template name="hy_gridhosts_percentage">
                <xsl:with-param name="value">
                  <xsl:value-of select="$mem_gauge" />
                </xsl:with-param>
                <xsl:with-param name="max">
                  <xsl:value-of select="$hostcellspace div 2" />
                </xsl:with-param>
                <xsl:with-param name="class_name">hy-gridhosts-mem-bar</xsl:with-param>
                <xsl:with-param name="overlay">
                  <xsl:choose>
                    <xsl:when test="grid:resource[@name='mem']">
                      <xsl:call-template name="hy_gridhosts_normalize_mem">
                        <xsl:with-param name="bytes_value">
                          <xsl:value-of select="grid:resource[@name='mem']/@max - grid:resource[@name='mem']"/>
                        </xsl:with-param>
                      </xsl:call-template>/<xsl:call-template name="hy_gridhosts_normalize_mem">
                        <xsl:with-param name="bytes_value">
                          <xsl:value-of select="grid:resource[@name='mem']/@max"/>
                        </xsl:with-param>
                      </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>--</xsl:otherwise>
                  </xsl:choose>
                </xsl:with-param>
              </xsl:call-template>
            </div>
          </a>
        </div>
      </div>
    </div>
  </xsl:template>

  <xsl:template match="grid:host[@arch-family]" mode="archicon" priority="+1">
    <img src="/{$_root_context}/images/arch-family/20x20/{f:uppercase(@arch-family)}.gif" alt=" "/>
  </xsl:template>

  <xsl:template match="grid:host[@arch]" mode="archicon">
    <img src="/{$_root_context}/images/arch-family/20x20/{f:uppercase(@arch)}.gif" alt=" "/>
  </xsl:template>

  <xsl:template match="grid:host" mode="archicon">
    <img src="/{$_root_context}/images/arch-family/20x20/UNKNOWN.gif" alt=" "/>
  </xsl:template>

  <!-- propagate ef:errors -->
  <xsl:template match="/ef:error" priority="-1">
    <xsl:apply-templates select="." mode="error"/>
  </xsl:template>

  <xsl:template match="node()|@*" mode="error" >
    <xsl:copy>
      <xsl:apply-templates select="node()|@*" mode="error"/>
    </xsl:copy>
  </xsl:template>

  <func:function name="f:uppercase">
    <xsl:param name="text" />
    <func:result>
      <xsl:variable name="lowercase" select="'abcdefghijklmnopqrstuvwxyz'" />
      <xsl:variable name="uppercase" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'" />
      <xsl:value-of select="translate($text, $lowercase, $uppercase)"/>
    </func:result>
  </func:function>

</xsl:stylesheet>
