<?xml version="1.0" encoding="UTF-8"?>
<!--
  * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.-->
<xsl:transform version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:grid="http://www.enginframe.com/2000/GRID"
  xmlns:filter="http://www.enginframe.com/2010/EnginFrame/Filter"
  exclude-result-prefixes="grid filter"
  >

  <!-- import generic adapter library -->
  <xsl:import href="hydrogen.adapter.library.xsl" />

  <!-- re-define the pending reason -->
  <xsl:template match="filter:mapper[@id='reasons']" mode="adapter">
    <xsl:param name="row" />
    <xsl:if test="$row/grid:reasons">
      <reasons>
        <xsl:for-each select="$row/grid:reasons/grid:reason">
          <reason><xsl:value-of select="text()" /></reason>
        </xsl:for-each>
      </reasons>
    </xsl:if>
  </xsl:template>

  <!-- re-define the value of execution-host for parallel jobs -->
  <xsl:template match="filter:mapper[@id='execution-host']" mode="adapter">
    <xsl:param name="row" />
    <xsl:variable name="number-of-hosts" select="count($row/grid:execution-host[not(text() = preceding-sibling::grid:execution-host/text())])" />
    <xsl:choose>
      <xsl:when test="$number-of-hosts > 1">
        <execution-host n="{$number-of-hosts}">
          <xsl:for-each select="$row/grid:execution-host[not(text() = preceding-sibling::grid:execution-host/text())]">
            <host><xsl:value-of select="text()" /></host>
          </xsl:for-each>
        </execution-host>
      </xsl:when>
      <xsl:otherwise>
        <execution-host>
          <xsl:value-of select="$row/grid:execution-host" />
        </execution-host>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- FIXME: The following template is never used. It should be removed. -->
  <xsl:template match="filter:mapper[@id='array-execution-host']" mode="adapter">
    <xsl:param name="row" />
    <xsl:variable name="number-of-hosts" select="count($row/grid:array-execution-host)" />
    <xsl:choose>
      <xsl:when test="$number-of-hosts > 1">
        <execution-host n="{$number-of-hosts}">
          <xsl:for-each select="$row/grid:execution-host">
            <host><xsl:value-of select="text()" /></host>
          </xsl:for-each>
        </execution-host>
      </xsl:when>
      <xsl:otherwise>
        <execution-host>
          <xsl:value-of select="$row/grid:execution-host" />
        </execution-host>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

</xsl:transform>
