<?xml version="1.0" encoding="UTF-8"?>
<!--
  * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.-->
<xsl:transform version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
  xmlns:filter="http://www.enginframe.com/2010/EnginFrame/Filter"
  exclude-result-prefixes="ef filter"
  >

  <!-- import generic adapter library -->
  <xsl:import href="hydrogen.adapter.library.xsl" />

  <!-- re-define guests into something we can parse -->
  <xsl:template match="filter:mapper[@id='guests']" mode="adapter">
    <xsl:param name="row" />
    <xsl:if test="$row/ef:guests">
      <guests>
        <xsl:for-each select="$row/ef:guests/ef:guest[not(@access='read')]">
          <user><xsl:value-of select="text()" /></user>
        </xsl:for-each>
        <xsl:for-each select="$row/ef:guests/ef:guest[@access='read']">
          <viewer><xsl:value-of select="text()" /></viewer>
        </xsl:for-each>
      </guests>
    </xsl:if>
  </xsl:template>

</xsl:transform>
