<?xml version="1.0" encoding="UTF-8"?>
<!--
  * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.-->
<xsl:transform version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
  exclude-result-prefixes="ef"
  >

  <xsl:key name="spoolers-by-project" match="ef:spooler" use="ef:metadata[@attribute='EF_SPOOLER_PROJECT']" />

  <xsl:template match="ef:list-spoolers">
    <stats>
      <projects>
        <xsl:for-each select="ef:spooler[count(. | key('spoolers-by-project', ef:metadata[@attribute='EF_SPOOLER_PROJECT'])[1]) = 1]">
          <xsl:sort select="ef:metadata[@attribute='EF_SPOOLER_PROJECT']" />
          <project name="{ef:metadata[@attribute='EF_SPOOLER_PROJECT']}">
            <xsl:value-of select="count(key('spoolers-by-project', ef:metadata[@attribute='EF_SPOOLER_PROJECT']))"/>
          </project>
        </xsl:for-each>
      </projects>
    </stats>
  </xsl:template>

</xsl:transform>
