<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
  xmlns:StringEscapeUtils="org.apache.commons.lang3.StringEscapeUtils"
  exclude-result-prefixes="ef StringEscapeUtils">
  <!--
    * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.  -->

  <xsl:output omit-xml-declaration="yes" method="text" media-type="application/json" />

  <xsl:template match="/">
    <xsl:text>[</xsl:text>
    <xsl:apply-templates select="ef:user-list/ef:user|ef:user"/>
    <xsl:text>]</xsl:text>
  </xsl:template>

  <xsl:template match="ef:user">
    <xsl:text>{"id": "</xsl:text>
    <xsl:value-of select="StringEscapeUtils:escapeJson(@id)"/>
    <xsl:text>", "name": "</xsl:text>
    <xsl:choose>
      <xsl:when test="text() != ''">
        <xsl:value-of select="StringEscapeUtils:escapeJson(text())"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="StringEscapeUtils:escapeJson(@id)"/>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:text>"}</xsl:text>
    <xsl:if test="position() != last()">
      <xsl:text>, </xsl:text>
    </xsl:if>
  </xsl:template>

</xsl:stylesheet>
