<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
  xmlns="http://www.w3.org/1999/xhtml"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
  xmlns:efx="xalan://com.enginframe.xslt.xalan.Extensions"
  xmlns:grid="http://www.enginframe.com/2000/GRID"
  xmlns:func="http://exslt.org/functions"
  xmlns:date="http://exslt.org/dates-and-times"
  xmlns:f="http://www.enginframe.com/2011/EnginFrame/functions"
  xmlns:hy="http://www.enginframe.com/2009/UI/Hydrogen"
  xmlns:encode="org.owasp.encoder.Encode"
  extension-element-prefixes="ef efx func date f"
  exclude-result-prefixes="ef efx func date f encode">

<!--
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.
-->

  <!-- Input parameters -->
  <xsl:param name="_root_context">enginframe</xsl:param>

  <xsl:variable name="purevdi" select="/hy:param[@name='pureVdi'] = 'true'"/>
  <xsl:template match="/hy:param" />

  <xsl:template match="/ef:show-spooler/ef:spooler">
    <xsl:variable name="name" select="ef:name/text()" />
    <xsl:variable name="owner" select="ef:owner/text()" />
    <xsl:variable name="creationtime" select="ef:creation-time" />
    <xsl:variable name="star" select="f:getmeta('EF_SPOOLER_STAR')" />
    <xsl:variable name="type" select="f:getmeta('INTERACTIVE_SESSION_TYPE')"/>
    <xsl:variable name="status" select="f:getmeta('INTERACTIVE_SESSION_STATUS')"/>
    <xsl:variable name="screenshot" select="f:getmeta('INTERACTIVE_SESSION_SCREENSHOT_FILE')"/>
    <xsl:variable name="remote" select="f:getmeta('INTERACTIVE_SESSION_REMOTE')"/>
    <xsl:variable name="jobmanager" select="f:getmeta('INTERACTIVE_SESSION_JOBMANAGER')"/>
    <xsl:variable name="delegate" select="f:getmeta('INTERACTIVE_SESSION_DELEGATE')"/>
    <xsl:variable name="isShareable" select="f:getmeta('INTERACTIVE_SESSION_SHAREABLE')" />
    <xsl:variable name="ef_user" select="../../ef:user"/>
    <xsl:variable name="cluster" select="f:getmeta('INTERACTIVE_SESSION_CLUSTER')"/>
    <xsl:variable name="clustername">
      <xsl:choose>
        <xsl:when test="f:lowercase($type) = 'delegate'">
          <xsl:value-of select="$cluster" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:choose>
            <xsl:when test="$cluster!=''">
              <xsl:copy-of select="/grid:list-clusters/grid:cluster[@type=$jobmanager and @id=$cluster]"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:copy-of select="/grid:list-clusters/grid:cluster[@type=$jobmanager][1]"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <div class="hy-session-info-container">

      <!-- If there is a warning, show a notification -->
      <xsl:variable name="warning" select="f:getmeta('INTERACTIVE_SESSION_WARNING')"/>
      <xsl:if test="$warning!=''">
        <div class="hy-session-warning"><xsl:value-of select="$warning"/></div>
      </xsl:if>

      <div class="hy-session-info-title">
        <div class="hy-session-info-screen-wrapper">
          <xsl:choose>
            <xsl:when test="$status = 'Running'">
              <xsl:choose>
                <xsl:when test="$isShareable != 'false' or $owner = $ef_user">
                  <a href="#" title="Connect to session {$name}">
                    <xsl:choose>
                      <xsl:when test="$screenshot != ''">
                        <xsl:variable name="screenurl"
                           select="concat('/', $_root_context, '/download/', $screenshot, '?_spooler=',
                                   string(encode:forUriComponent(@uri)),
                                   '&amp;_efdm=local&amp;_size=-1&amp;_file=', $screenshot,
                                   '&amp;_plugin=hydrogen&amp;_', date:second-in-minute())"/>
                        <img class="hy-session-info-screen" src="{$screenurl}"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <div class="hy-session-info-screen hy-session-info-screen-running"></div>
                      </xsl:otherwise>
                    </xsl:choose>
                  </a>
                </xsl:when>
                <xsl:otherwise>
                  <div>
                    <xsl:choose>
                      <xsl:when test="$screenshot != ''">
                        <xsl:variable name="screenurl"
                           select="concat('/', $_root_context, '/download/', $screenshot, '?_spooler=',
                                   string(encode:forUriComponent(@uri)),
                                   '&amp;_efdm=local&amp;_size=-1&amp;_file=', $screenshot,
                                   '&amp;_plugin=hydrogen&amp;_', date:second-in-minute())"/>
                        <img class="hy-session-info-screen" src="{$screenurl}"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <div class="hy-session-info-screen hy-session-info-screen-running"></div>
                      </xsl:otherwise>
                    </xsl:choose>
                  </div>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
              <div>
                <xsl:attribute name="class">hy-session-info-screen hy-session-info-screen-<xsl:value-of select="f:lowercase($status)"/></xsl:attribute>
                <div class="hy-session-info-spinner"></div>
              </div>
            </xsl:otherwise>
          </xsl:choose>
        </div>
        <div class="hy-session-info-title-name"><xsl:value-of select="$name"/></div>
      </div>
      <xsl:choose>
        <xsl:when test="$star = 'true'"><div class="hy-star hy-star-on hy-star-details-page" ></div></xsl:when>
        <xsl:otherwise><div class="hy-star hy-star-off hy-star-details-page" ></div></xsl:otherwise>
      </xsl:choose>

      <div class="hy-session-info-details">
        <xsl:copy-of select="f:row('Owner', $owner)" />
        <xsl:copy-of select="f:row('Project', f:getmeta('EF_SPOOLER_PROJECT'), '-')" />
        <xsl:copy-of select="f:row('Status', f:statuslabel($status))" />
      </div>

      <div class="hy-session-info-wrapper-box ui-helper-clearfix">

      <div class="hy-session-info-session-box">
        <div class="hy-session-info-session-box-head">
          <h2>Session</h2>
        </div>
        <div class="hy-session-info-session-box-body">
          <xsl:choose>
            <xsl:when test="f:lowercase($type) = 'delegate'">
              <xsl:copy-of select="f:row('Remote Host',       f:getmeta('INTERACTIVE_SESSION_EXECUTION_HOST'), '-')" />
              <xsl:copy-of select="f:row('Cluster',           $clustername, '-')" />
            </xsl:when>
            <xsl:otherwise>
              <xsl:copy-of select="f:row('Remote Host',       f:hosturl('INTERACTIVE_SESSION_EXECUTION_HOST', $jobmanager, $cluster), '-')" />
              <xsl:if test="$clustername!=''">
                <xsl:copy-of select="f:row('Cluster',         f:cluster($clustername, $jobmanager, $cluster))" />
              </xsl:if>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:copy-of select="f:row('Operating System',      f:osname('INTERACTIVE_SESSION_OS'))" />
          <xsl:copy-of select="f:row('Creation Time',         f:iso8601time($creationtime))" />
          <xsl:copy-of select="f:row('Size',                  f:geometry('INTERACTIVE_SESSION_WIDTH', 'INTERACTIVE_SESSION_HEIGHT'))" />
          <xsl:copy-of select="f:row('Color Depth',           f:depth('INTERACTIVE_SESSION_DEPTH', $remote))" />
          <xsl:copy-of select="f:row('Remotization Protocol', f:remote($remote))" />
        </div>
      </div>

      <xsl:if test="$isShareable != 'false'">
        <div class="hy-session-info-share-box">
          <xsl:variable name="users" select="//ef:guest[contains(@groups,'interactive-collaborators')]"/>
          <xsl:variable name="viewers" select="//ef:guest[contains(@groups,'interactive-viewers')]"/>

          <div class="hy-session-info-share-box-head">
            <h2>Sharing</h2>
          </div>
          <div class="hy-session-info-share-box-body">
            <xsl:copy-of select="f:row('Collaborators',         f:userlist($users))" />
            <xsl:copy-of select="f:row('Viewers',               f:userlist($viewers))" />
          </div>
        </div>
      </xsl:if>

      <xsl:choose>
        <xsl:when test="f:lowercase($type) = 'delegate'">
          <efx:acl>
            <ef:apply-acl select="allow-to[vdi:admin], admin-only" priority="allow">
              <div class="hy-session-info-delegate-session-box">
                <div class="hy-session-info-delegate-session-box-head">
                  <h2>Delegate Session</h2>
                </div>
                <div class="hy-session-info-delegate-session-box-body">
                  <xsl:copy-of select="f:row('Delegate Session ID',           f:getmeta('INTERACTIVE_SESSION_DELEGATESESSIONID'))" />
                  <xsl:copy-of select="f:row('Delegate Session Manager',      $delegate)" />
                  <xsl:apply-templates select="ef:metadata" mode="delegate"/>
                </div>
              </div>
            </ef:apply-acl>
          </efx:acl>
        </xsl:when>
        <xsl:otherwise>
          <xsl:if test="not($purevdi)">
            <div class="hy-session-info-job-box">
              <div class="hy-session-info-job-box-head">
                <h2>Job</h2>
              </div>
              <div class="hy-session-info-job-box-body">
                <xsl:copy-of select="f:row('Job ID',           f:joburl('INTERACTIVE_SESSION_JOBID', $jobmanager, $cluster))" />
                <xsl:copy-of select="f:row('Job Manager',      f:getmeta('INTERACTIVE_SESSION_JOBMANAGER'))" />
                <xsl:copy-of select="f:row('Cluster',          $cluster)" />
              </div>
            </div>
          </xsl:if>
        </xsl:otherwise>
      </xsl:choose>

      </div> <!-- clearfix -->

    </div>
  </xsl:template>

  <!-- discard the cluster list now that we have the name -->
  <xsl:template match="grid:list-clusters"/>

  <!-- discard the ef:user now that we have the user name -->
  <xsl:template match="ef:user"/>

  <!-- Show INTERACTIVE_SESSION_DELEGATE_PUBLIC_* metadata as delegate-session attributes.
       The Delegate specific metadata will be elaborated by stripping prefix and making name user friendly.
       i.e. "INTERACTIVE_SESSION_DELEGATE_PUBLIC_MACHINE_STATE" will become "machine state". -->
  <xsl:template match="ef:metadata" mode="delegate">
    <xsl:if test="contains(@attribute,'INTERACTIVE_SESSION_DELEGATE_PUBLIC_')">
      <xsl:variable name="metadataName" select="string(@attribute)" />
      <xsl:variable name="metadataValue" select="text()" />

      <xsl:variable name="label">
        <xsl:value-of select="f:lowercase(translate(substring-after($metadataName, 'INTERACTIVE_SESSION_DELEGATE_PUBLIC_'), '_', ' '))" />
      </xsl:variable>

      <xsl:copy-of select="f:row($label, $metadataValue, '-')" />
    </xsl:if>
  </xsl:template>

  <func:function name="f:getmeta">
    <xsl:param name="key" />
    <func:result>
      <xsl:value-of select="string(ef:metadata[@attribute=$key])" />
    </func:result>
  </func:function>

  <func:function name="f:lowercase">
    <xsl:param name="text" />
    <func:result>
      <xsl:variable name="lowercase" select="'abcdefghijklmnopqrstuvwxyz'" />
      <xsl:variable name="uppercase" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'" />
      <xsl:value-of select="translate($text, $uppercase, $lowercase)"/>
    </func:result>
  </func:function>

  <func:function name="f:statuslabel">
    <xsl:param name="status" />
    <func:result>
      <span>
        <xsl:attribute name="class">hy-session-status hy-session-status-<xsl:value-of select="f:lowercase($status)"/></xsl:attribute>
        <xsl:value-of select="$status"/>
      </span>
    </func:result>
  </func:function>

  <func:function name="f:row">
    <xsl:param name="label" />
    <xsl:param name="value" />
    <xsl:param name="defvalue" />
    <xsl:variable name="realvalue">
      <xsl:choose>
        <xsl:when test="$value and $value!=''">
          <xsl:value-of select="$value" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$defvalue" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <func:result>
      <xsl:if test="$realvalue and $realvalue!=''">
        <div class="hy-session-info-box-name"><xsl:copy-of select="$label" /></div>
        <!-- $realvalue must be already html-encoded. It can contains also node elements. -->
        <div class="hy-session-info-box-value"><xsl:copy-of select="$realvalue" /></div>
      </xsl:if>
    </func:result>
  </func:function>

  <func:function name="f:joburl">
    <xsl:param name="jobkey" />
    <xsl:param name="grid" />
    <xsl:param name="cluster" />
    <xsl:param name="jobid" select="f:getmeta($jobkey)" />
    <func:result>
      <xsl:choose>
        <xsl:when test="$jobid and $jobid!='' and $jobid!='-'">
          <xsl:variable name="params" select="concat('jobid=', string(encode:forUriComponent($jobid)),
                                                     '&amp;grid=', string(encode:forUriComponent($grid)),
                                                     '&amp;cluster=', string(encode:forUriComponent($cluster)))"/>
          <a href="?_uri=//com.enginframe.grid/job.info&amp;{$params}">
            <xsl:value-of select="$jobid"/>
          </a>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$jobid" />
        </xsl:otherwise>
      </xsl:choose>
    </func:result>
  </func:function>

  <func:function name="f:iso8601time">
    <xsl:param name="time" />
    <func:result>
      <span class="hy-iso8601-time">
        <xsl:value-of select="$time"/>
      </span>
    </func:result>
  </func:function>

  <func:function name="f:hosturl">
    <xsl:param name="hostkey" />
    <xsl:param name="grid" />
    <xsl:param name="cluster" />
    <xsl:param name="host" select="f:getmeta($hostkey)" />
    <func:result>
      <xsl:choose>
        <xsl:when test="$host and $host!='' and $host!='-'">
          <xsl:variable name="params" select="concat('host=', string(encode:forUriComponent($host)),
                                                     '&amp;grid=', string(encode:forUriComponent($grid)),
                                                     '&amp;cluster=', string(encode:forUriComponent($cluster)))"/>
          <a href="?_uri=//com.enginframe.grid/host.info&amp;{$params}">
            <xsl:value-of select="$host"/>
          </a>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>-</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </func:result>
  </func:function>

  <func:function name="f:cluster">
    <xsl:param name="name" />
    <xsl:param name="grid" />
    <xsl:param name="cluster" />
    <func:result>
      <xsl:variable name="params" select="concat('grid=', string(encode:forUriComponent($grid)),
                                                 '&amp;cluster=', string(encode:forUriComponent($cluster)))"/>
      <a href="?_uri=//com.enginframe.grid/list.hosts&amp;{$params}">
        <xsl:value-of select="$name"/>
      </a>
    </func:result>
  </func:function>

  <func:function name="f:osname">
    <xsl:param name="oskey" />
    <xsl:param name="os" select="f:getmeta($oskey)" />
    <func:result>
      <xsl:choose>
        <xsl:when test="$os='linux'">
          Linux
        </xsl:when>
        <xsl:when test="$os='windows'">
          Microsoft Windows
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$os" />
        </xsl:otherwise>
      </xsl:choose>
    </func:result>
  </func:function>

  <func:function name="f:geometry">
    <xsl:param name="wkey" />
    <xsl:param name="hkey" />
    <xsl:param name="default" select="'-'" />
    <xsl:param name="width" select="f:getmeta($wkey)" />
    <xsl:param name="height" select="f:getmeta($hkey)" />
    <func:result>
      <xsl:choose>
        <xsl:when test="$width and $width!='' and $width!='-' and $height and $height!='' and $height!='-'">
          <xsl:value-of select="concat($width, 'x', $height)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$default" />
        </xsl:otherwise>
      </xsl:choose>
    </func:result>
  </func:function>

  <func:function name="f:depth">
    <xsl:param name="key" />
    <xsl:param name="remote" />
    <xsl:param name="default">
      <xsl:choose>
        <xsl:when test="$remote='dcv2'">
          <xsl:text>24M colors</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>-</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:param>
    <xsl:param name="depth" select="f:getmeta($key)" />
    <func:result>
      <xsl:choose>
        <xsl:when test="$depth='8'">
          256 colors
        </xsl:when>
        <xsl:when test="$depth='15'">
          32K colors
        </xsl:when>
        <xsl:when test="$depth='16'">
          64K colors
        </xsl:when>
        <xsl:when test="$depth='24'">
          16M colors
        </xsl:when>
        <xsl:when test="$depth='32'">
          24M colors
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$default" />
        </xsl:otherwise>
      </xsl:choose>
    </func:result>
  </func:function>

  <func:function name="f:remote">
    <xsl:param name="remote" />
    <func:result>
      <xsl:choose>
        <xsl:when test="$remote='dcv2'">
          NICE Desktop Cloud Visualization (DCV)
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$remote" />
        </xsl:otherwise>
      </xsl:choose>
    </func:result>
  </func:function>

  <func:function name="f:userlist">
    <xsl:param name="users" />
    <xsl:param name="default" select="'-'" />
    <func:result>
      <xsl:choose>
        <xsl:when test="count($users) > 0">
          <xsl:for-each select="$users">
            <xsl:value-of select="text()"/>
            <xsl:if test="position() != last()">, </xsl:if>
          </xsl:for-each>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$default" />
        </xsl:otherwise>
      </xsl:choose>
    </func:result>
  </func:function>

</xsl:stylesheet>
