<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
  xmlns="http://www.w3.org/1999/xhtml"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
  exclude-result-prefixes="ef">
<!--
  * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.-->
<xsl:output omit-xml-declaration="yes" method="text" media-type="application/json" />

  <xsl:template match="/">
    {
      <xsl:call-template name="supportViewOnlyMetadata"/>
    }
  </xsl:template>

  <xsl:template name="supportViewOnlyMetadata">
    <xsl:choose>
      <!-- 2017.1+ sessions have the INTERACTIVE_SESSION_SUPPORT_VIEW_ONLY metadata always valued,
            instead the old 2017.0- sessions use the INTERACTIVE_SESSION_VNC_ENCVIEWONLYPASSWD metadata. -->
      <xsl:when test="//ef:metadata[@attribute='INTERACTIVE_SESSION_SUPPORT_VIEW_ONLY']/text() = 'true' or
            (//ef:metadata[@attribute='INTERACTIVE_SESSION_SUPPORT_VIEW_ONLY']/text() = '' and //ef:metadata[@attribute='INTERACTIVE_SESSION_VNC_ENCVIEWONLYPASSWD']/text() != '')">
        <xsl:text>"supportViewOnly": "true"</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>"supportViewOnly": "false"</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

</xsl:stylesheet>
