<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:func="http://exslt.org/functions"
  xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
  xmlns:grid="http://www.enginframe.com/2000/GRID"
  xmlns:f="http://www.enginframe.com/2011/EnginFrame/functions"
  xmlns:encode="org.owasp.encoder.Encode"
  exclude-result-prefixes="ef grid func f encode">

<!--
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.
-->

  <!-- Input parameters -->
  <xsl:param name="_root_context">enginframe</xsl:param>

  <xsl:template match="grid:template" priority="1">
    <div class="hy-gridtemplates-panel-container">
      <div class="hy-gridtemplates-panel-head">

        <div id="hy-gridtemplates-template-name" style="display:none"><xsl:value-of select="@name"/></div>

        <div class="hy-gridtemplates-panel-templatedata">
          <div class="hy-gridtemplates-data-name">Id:</div>
          <div class="hy-gridtemplates-data-value"><xsl:value-of select="@id"/></div>
        </div>

        <div class="hy-gridtemplates-panel-templatedata">
          <xsl:for-each select="//grid:option[@name != 'accountId' and @name != 'bucketName']">
              <div class="hy-gridtemplates-data-name"><xsl:value-of select="@label"/>:</div>
              <div class="hy-gridtemplates-data-value"><xsl:value-of select="text()"/></div>
          </xsl:for-each>
        </div>
      </div>
    </div>
  </xsl:template>

  <!-- propagate ef:errors -->
  <xsl:template match="/ef:error" priority="-1">
    <xsl:apply-templates select="." mode="error"/>
  </xsl:template>

  <xsl:template match="node()|@*" mode="error" >
    <xsl:copy>
      <xsl:apply-templates select="node()|@*" mode="error"/>
    </xsl:copy>
  </xsl:template>

</xsl:stylesheet>
