<?xml version="1.0"?>

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
  xmlns:efx="xalan://com.enginframe.xslt.xalan.Extensions"
  xmlns:hy="http://www.enginframe.com/2009/UI/Hydrogen"
  xmlns:ia="http://www.enginframe.com/2012/Interactive"
  xmlns:encode="org.owasp.encoder.Encode"
  extension-element-prefixes="efx"
  exclude-result-prefixes="ef efx hy ia encode">

  <!--
    * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.  -->

  <xsl:template match="ef:ui-widget[@ui='hydrogen' and @type='interactive-list-sessions']" mode="widget.head">
    <script type="text/javascript" src="/{$_root_context}/hydrogen/js/widgets/hydrogen.{@type}.js?{$_ef_cache_timestamp}"></script>
  </xsl:template>

  <xsl:template match="ef:ui-widget[@ui='hydrogen' and @type='interactive-list-sessions']" mode="widget">
    <div id="{@id}" class="hy-content ui-helper-clearfix">
      <div class="hy-left-column-wrapper">
        <div class="hy-left-column-content">
          <div class="hy-innertube-left">
            <div id="{concat(@id,'-message')}"/>
            <div id="{concat(@id,'-connectionbar')}"/>
            <div id="{concat(@id,'-toolbar')}"/>
            <div id="{concat(@id,'-list-view')}"/>
            <div id="{concat(@id,'-compact-view')}"/>
          </div>
        </div>
      </div>

      <div class="hy-right-column">
        <div class="hy-innertube-right">
          <div id="{concat(@id,'-filters')}" />
        </div>
      </div>
    </div>

    <script type="text/javascript"><xsl:comment>
        interactiveListSessions.init('<xsl:value-of select="@id"/>');
    //</xsl:comment></script>

  </xsl:template>

  <!-- Custom renering of the submission error that looks like hymessage -->
  <xsl:template match="ia:error">
    <div class="interactive-submit-error ui-widget hy-message">
      <div class="ui-state-error ui-corner-all">
        <table width="100%">
          <tr>   
            <td><span class="ui-icon ui-icon-alert"></span></td>
            <td width="99%">
              <span>
                <xsl:apply-templates mode="submit-error"/>
              </span>
            </td>
          </tr>
        </table>
      </div>
    </div>
  </xsl:template>

  <xsl:template match="ia:message" mode="submit-error">
    <div class="hy-error-primary-message"><xsl:value-of select="text()"/></div>
  </xsl:template>

  <xsl:template match="ia:secondary-message" mode="submit-error">
    <div class="hy-error-secondary-message"><xsl:value-of select="text()"/></div>
  </xsl:template>

  <xsl:template match="ia:command" mode="submit-error">
<efx:acl>
  <ef:apply-acl select="admin-only">
    <div class="hy-error-command"><xsl:value-of select="text()"/></div>
  </ef:apply-acl>
</efx:acl>
  </xsl:template>

  <!-- ignore the rest for now -->
  <xsl:template match="text()|@*" mode="submit-error" priority="-1"/>

</xsl:stylesheet>
