#!/bin/bash

################################################################################
################################################################################
# Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
# Copyright 1999-2023 by Nice, srl., All rights reserved.
#
# This software includes confidential and proprietary information
# of NI SP Software GmbH ("Confidential Information").
# You shall not disclose such Confidential Information
# and shall use it only in accordance with the terms of
# the license agreement you entered into with NI SP Software.
################################################################################
################################################################################

declare -- _proxy_host=$1
declare -- _proxy_port=$2
declare -- _proxy_type=$3

if [ -z "${_proxy_host}" ]; then
    echo "[error] Invalid proxy host '${_proxy_host}'." >&2
    exit 1
fi

# Verify if the host is pingable by EnginFrame instance.
ping -W 2 -c 1 "${_proxy_host}" 2>/dev/null
if [ $? -ne 0 ]; then
    echo "[error] Proxy host '${_proxy_host}' unreachable." >&2
    exit 1
else
    echo "[info] Proxy host '${_proxy_host}' is available." >&2
fi

# ex:ts=4:sw=4:et:ft=sh:


