BEGIN {
    FS="[ \t]+";
    server_host = tolower(server_host);
}

# skip comments
/^[ \t]*#/ {
    next;
}
# skip empty lines
/^[ \t]*$/ {
    next;
}

function server_matches(server, server_pattern) {
    # In case we want to switch from glob to regex, here is the place
    regex = glob2ere(tolower(server_pattern))
    where = match(server, regex)
    if (where != 0) {
        return 1
    }
    else {
        return 0
    }
}

{
    priority=$1
    server_host_pattern=$2
    target_host=$3
    target_port=$4
    target_web_url_path=$5

    if (server_matches(server_host, server_host_pattern)) {
        print priority " " target_host ":" target_port ":" target_web_url_path
    }
}
