/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */


jQuery(document).ready(function () {
    function setFullView() {
        var options = { path: '/', expires: 7 };
        jQuery("#i9-container").addClass("i9-navigation-hidden");
        jQuery("#i9-navigation-open-button").show();
        jQuery("#i9-navigation-close-button").hide();
        jQuery.cookie('i9-navigation-panel', 'closed', options);
    }

    function removeFullView() {
        var options = { path: '/', expires: 7 };
        jQuery("#i9-container").removeClass("i9-navigation-hidden");
        jQuery("#i9-navigation-open-button").hide();
        jQuery("#i9-navigation-close-button").show();
        jQuery.cookie('i9-navigation-panel', 'open', options);
    }

    if (jQuery.cookie('i9-navigation-panel') == 'closed') {
        jQuery("#i9-navigation-wrapper").hide();
        setFullView();
    }
    else {
        jQuery("#i9-navigation-open-button").hide();
    }

    jQuery("#i9-navigation-close-button>a").click(function () {
        jQuery("#i9-navigation-wrapper").fadeOut(setFullView);
        return false;
    });

    jQuery("#i9-navigation-open-button>a").click(function () {
        removeFullView();
        jQuery("#i9-navigation-wrapper").fadeIn();
        return false;
    });
});


// ex:ts=4:et:
