////////////////////////////////////////////////////////////////////////////////
// Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
// Copyright 1999-2023 by Nice, srl., All rights reserved.
//
// This software includes confidential and proprietary information
// of NI SP Software GmbH ("Confidential Information").
// You shall not disclose such Confidential Information
// and shall use it only in accordance with the terms of
// the license agreement you entered into with NI SP Software.
////////////////////////////////////////////////////////////////////////////////
/*global window, jQuery, document*/

var appearanceEditor = {

    sdf: "/" + jQuery.enginframe.rootContext + "/themes/next-round/lib/xml/com.enginframe.themes.xml",

    init: function (plugin) {
        jQuery(document).ready(function () {
            appearanceEditor.getCurrentSettings(plugin);
            appearanceEditor.initThemeSelector(plugin);
            appearanceEditor.initColorPicker(plugin);
            appearanceEditor.initSaveSettingsButtons(plugin);
            appearanceEditor.initUploadLogoButton(plugin);
            appearanceEditor.initResetLogoButton(plugin);
            appearanceEditor.initCSSEditor(plugin);
            //appearanceEditor.initJsEditor(plugin);
            appearanceEditor.initMOTDEditor(plugin);
            window.scrollTo(0, 0);
            jQuery("input[type='button']").button().click(function (e) {
                e.preventDefault();
            });
        });
    },

    initSaveSettingsButtons: function (plugin) {
        jQuery('.save-custom-js').click(function () {
            var themeVersion = (new Date()).getTime(); // use timestamp as theme version
            var data = {
                plugin: plugin,
                themeVersion: themeVersion,
                customJs: jQuery('#custom-js').texteditor('getContent')
            };
            appearanceEditor.saveSettings(themeVersion, data);
        });
        jQuery('.save-custom-css').click(function () {
            var themeVersion = (new Date()).getTime(); // use timestamp as theme version
            var data = {
                plugin: plugin,
                themeVersion: themeVersion,
                customCss: jQuery('#custom-css').texteditor('getContent')
            };
            appearanceEditor.saveSettings(themeVersion, data);
        });
        jQuery('.save-custom-motd').click(function () {
            var themeVersion = (new Date()).getTime(); // use timestamp as theme version
            var data = {
                plugin: plugin,
                themeVersion: themeVersion,
                customMotdEnabled: true,
                customMotd: CKEDITOR.instances['custom-motd'].getData()
            };
            appearanceEditor.saveSettings(themeVersion, data);
        });
    },

    initJsEditor: function (plugin) {
        if (document.getElementById("custom-js")) {
            jQuery.hydrogen.invokeService({
                sdf: appearanceEditor.sdf,
                uri: "//com.enginframe.themes/get.js",
                data: {
                    plugin: plugin
                },
                dataType: "text",
                success: function (content) {
                    jQuery('#custom-js').texteditor({mode : 'javascript', height: "200px", width: "100%"});
                    jQuery('#custom-js').texteditor('setContent', content);
                },
                error: function () {
                    var messageArea = jQuery("#ef-message-wrapper").hymessage();
                    messageArea.hymessage('alert', "An error occurred retrieving Javascript content, please check EF Portal logs");
                }
            });
        }
    },

    initCSSEditor: function (plugin) {
        if (document.getElementById("custom-css")) {
            jQuery.hydrogen.invokeService({
                sdf: appearanceEditor.sdf,
                uri: "//com.enginframe.themes/get.css",
                data: {
                    plugin: plugin
                },
                dataType: "text",
                success: function (content) {
                    jQuery('#custom-css').texteditor({mode : 'css', height: "200px", width: "100%"});
                    jQuery('#custom-css').texteditor('setContent', content);
                },
                error: function () {
                    var messageArea = jQuery("#ef-message-wrapper").hymessage();
                    messageArea.hymessage('alert', "An error occurred retrieving CSS content, please check EF Portal logs");
                }
            });
        }
    },

    initMOTDSection: function (isMotdEnabled) {
        if (isMotdEnabled == "true") {
            jQuery('#custom-motd-section').removeClass('setting_disabled');
            jQuery('#custom-motd-enabler').prop('checked', true);
        } else {
            jQuery('#custom-motd-section').addClass('setting_disabled');
            jQuery('#custom-motd-enabler').prop('checked', false);
        }
    },

    initMOTDEditor: function (plugin) {
        // initialize editor
        CKEDITOR.replace('custom-motd');

        jQuery('#custom-motd-enabler').on('change', function() {
            if (this.checked) {
                jQuery('#custom-motd-section').removeClass('setting_disabled');
            } else {
                jQuery('#custom-motd-section').addClass('setting_disabled');
            }
            var themeVersion = (new Date()).getTime(); // use timestamp as theme version
            var data = {
                plugin: plugin,
                themeVersion: themeVersion,
                customMotdEnabled: this.checked
            };
            appearanceEditor.saveSettings(themeVersion, data);
        });

        // load MOTD content
        jQuery.hydrogen.invokeService({
            sdf: "/" + jQuery.enginframe.rootContext + "/" + plugin + "/" + plugin + ".xml",
            uri: "//com.enginframe.themes/get.motd",
            data: {
                plugin: plugin
            },
            dataType: "text",
            success: function (output) {
                CKEDITOR.instances['custom-motd'].setData(output);
            },
            error: function () {
                var messageArea = jQuery("#ef-message-wrapper").hymessage();
                messageArea.hymessage('alert', "An error occurred retrieving MOTD content, please check EF Portal logs");
            }
        });
    },

    initUploadLogoButton: function (plugin) {
        jQuery('#custom-logo-button').button();

        jQuery('#custom-logo-form').attr('action', appearanceEditor.sdf + "?_uri=//com.enginframe.themes/upload.logo");
        jQuery('#custom-logo-form').ajaxForm({
            success: function () {
                location.reload();
            },
            error: function () {
                jQuery("#ef-message-wrapper").hymessage().hymessage('alert', 'An unknown error occurred while performing the upload.');
            }
        });

        jQuery('#custom-logo').change(function () {
            // update data and submit the form
            jQuery('#custom-logo-plugin').val(plugin);
            jQuery('#custom-logo-version').val((new Date()).getTime());
            jQuery('#custom-logo-form').submit();
        });
    },

    initResetLogoButton: function (plugin) {
        jQuery('#reset-logo-button').button().click(function () {
            var logoVersion = (new Date()).getTime();
            jQuery.hydrogen.invokeService({
                sdf: appearanceEditor.sdf,
                uri: "//com.enginframe.themes/reset.logo",
                data: {
                    plugin: plugin,
                    logoVersion: logoVersion
                },
                dataType: "xml",
                success: function (xml) {
                    location.reload();
                }
            });
        });
    },

    initThemeSelector: function (plugin) {
        jQuery.hydrogen.invokeService({
            sdf: appearanceEditor.sdf,
            uri: "//com.enginframe.themes/get.themes",
            data: {
                plugin: plugin
            },
            dataType: "xml",
            success: function (xml) {
                jQuery(xml).find('theme').each(function (index, elem) {
                    var mainColor, newDiv;
                    mainColor = jQuery(elem).find('main-color').text();
                    newDiv = '<div class="theme-color-selector theme-color-box" id="' + mainColor + '" style="background-color: #' + mainColor + ';" />';
                    jQuery(newDiv).appendTo('#theme-default-selector');
                });

                jQuery('.theme-color-selector').click(function () {

                    var themeSelected = jQuery(this).css('backgroundColor');
                    jQuery('.theme-color-selector').css('border', 'none');
                    jQuery(this).css('border', '1px solid #666666');
                    appearanceEditor.updateBannerColor(plugin, themeSelected, true);
                });
            }
        });
    },

    initColorPicker: function (plugin, value) {
        jQuery('#theme-colorpicker').ColorPicker({
            color: '#9900CC',
            onShow: function (colpkr) {
                jQuery(colpkr).fadeIn(500);
                return false;
            },
            onHide: function (colpkr) {
                appearanceEditor.updateBannerColor(plugin, jQuery('#theme-colorpicker div').css('backgroundColor'), true);
                jQuery(colpkr).fadeOut(500);
                return false;
            },
            onChange: function (hsb, hex, rgb) {
                appearanceEditor.updateColorPickerColor(hex);
                appearanceEditor.updateBannerColor(plugin, hex, false);
            },
            onSubmit: function(hsb, hex, rgb, el) {
                jQuery(el).val(hex);
                appearanceEditor.updateBannerColor(plugin, hex, true);
            }
        });
        jQuery('.colorpicker_current_color').click(function () {
            appearanceEditor.updateColorPickerColor(jQuery(this).css('backgroundColor'));
            appearanceEditor.updateBannerColor(plugin, jQuery(this).css('backgroundColor'), true);
        });
        jQuery('.colorpicker_new_color').click(function () {
            appearanceEditor.updateColorPickerColor(jQuery(this).css('backgroundColor'));
            appearanceEditor.updateBannerColor(plugin, jQuery(this).css('backgroundColor'), true);
        });
    },

    updateColorPickerColor: function (color) {
        jQuery('#theme-colorpicker div').css('backgroundColor', '#' + appearanceEditor.colorToHex(color));
    },

    getCurrentSettings: function (plugin) {
        jQuery.hydrogen.invokeService({
            sdf: appearanceEditor.sdf,
            uri: "//com.enginframe.themes/get.theme.settings",
            data: {
                plugin: plugin
            },
            dataType: "xml",
            success: function (xml) {
                appearanceEditor.initMOTDSection(jQuery(xml).find('custom-motd').attr('enabled'));
            }
        });
    },

    updateCurrentThemeVersion: function (themeVersion) {
        jQuery("link.theme-versioned").each(function () {
            jQuery(this).attr('href', jQuery(this).attr('href').split("?")[0] + '?' + themeVersion);
        });
        jQuery("script.theme-versioned").each(function () {
            jQuery(this).attr('src', jQuery(this).attr('src').split("?")[0] + '?' + themeVersion);
        });
    },

    updateBannerColor: function (plugin, color, saveConfiguration) {
        var hexColor, themeVersion, data;

        hexColor = appearanceEditor.colorToHex(color);
        jQuery('#nj-banner').css('backgroundColor', '#' + hexColor);
        if (saveConfiguration) {
            themeVersion = (new Date()).getTime(); // use timestamp as theme version
            data = {
                plugin: plugin,
                themeVersion: themeVersion,
                mainColor: hexColor
            };
            appearanceEditor.saveSettings(themeVersion, data);
        }
    },

    saveSettings: function (themeVersion, data) {
        var messageArea = jQuery("#ef-message-wrapper").hymessage();
        jQuery.hydrogen.invokeService({
            sdf: appearanceEditor.sdf,
            uri: "//com.enginframe.themes/save.appearance",
            data: data,
            success: function (data) {
                appearanceEditor.updateCurrentThemeVersion(themeVersion);
                // Scroll to top
                window.scrollTo({ top: 0, behavior: 'smooth' });
                messageArea.hymessage('info', 'Settings saved successfully');
            },
            messagebox: messageArea
        });
    },

    colorToHex: function (color) {
        // convert from rgb format
        color = (color.indexOf('rgb') >= 0)? appearanceEditor.rgbToHex(color) : color;
        // remove '#' character, if exists
        return (color.indexOf('#') >= 0)? color.split('#')[1] : color;
    },

    rgbToHex: function (rgb) {
        rgb = rgb.match(/^rgb\((\d+),\s*(\d+),\s*(\d+)\)$/);
        return ("0" + parseInt(rgb[1], 10).toString(16)).slice(-2) +
               ("0" + parseInt(rgb[2], 10).toString(16)).slice(-2) +
               ("0" + parseInt(rgb[3], 10).toString(16)).slice(-2);
    }
};
// ex:ts=4:et:
