/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */
/*global window, jQuery, document*/

var niceJump = {

    renderLayout: function () {
        niceJump.setHeight();
        niceJump.setWidth();
    },

    setHeight: function () {
        var documentHeight, containerHeight, bannerHeight, contentHeaderHeight, footerHeight;
        var navigationWrapperHeight, contentWrapperHeight, contentDivHeight, wrappersHeight;

        jQuery('#nj-navigation-wrapper').height('auto');
        jQuery('#nj-content-wrapper').height('auto');
        jQuery('#nj-content-div').height('auto');
        jQuery('.hy-right-column').height('auto');
        niceJump.resetFileBrowserHeight();

        documentHeight = jQuery(document.body).prop('scrollHeight');
        containerHeight = jQuery('#nj-container').height();
        bannerHeight = jQuery('#nj-banner').outerHeight(true);
        footerHeight = jQuery('#nj-footer').outerHeight(true);

        navigationWrapperHeight = jQuery('#nj-navigation-wrapper').outerHeight(true);

        contentWrapperHeight = jQuery('#nj-content-wrapper').outerHeight(true);
        contentHeaderHeight = jQuery('#nj-content-header').outerHeight(true);
        contentDivHeight = jQuery('#nj-content-div').outerHeight(true);
        contentLeftColHeight = jQuery('.hy-left-column-wrapper').outerHeight(true);

        wrappersHeight = Math.max(documentHeight - bannerHeight - footerHeight, containerHeight - bannerHeight - footerHeight, navigationWrapperHeight, contentWrapperHeight, contentDivHeight + contentHeaderHeight, contentLeftColHeight + contentHeaderHeight);
	// wrappersHeight -= 5;
        jQuery('#nj-navigation-wrapper').outerHeight(wrappersHeight, true);
        jQuery('#nj-content-wrapper').outerHeight(wrappersHeight, true);
        jQuery('.hy-right-column').outerHeight(wrappersHeight - contentHeaderHeight, true);
        niceJump.extendFileBrowser();
    },

    navigationCookie: 'nj-navigation-panel',

    setWidth: function () {
        if (jQuery.cookie(niceJump.navigationCookie) === 'closed') {
            niceJump.setFullView();
        }
        else {
            niceJump.removeFullView();
        }
    },

    setFullView: function () {
        var browser = jQuery.hydrogen.getBrowser();

        // IE8 does not support getBoundingClientRect().width and in IE9 does not work with float values
        if (browser.name === 'MSIE' && browser.version <= 9) {
            jQuery("#nj-navigation-wrapper").width("2.2%");
            jQuery("#nj-content-wrapper").width("97.8%");
        }
        else {
            jQuery("#nj-navigation-wrapper").width(30);
            jQuery("#nj-content-wrapper").width(document.body.getBoundingClientRect().width - jQuery("#nj-navigation-wrapper").width());
        }
        
        jQuery("#nj-navigation-open-button").show();
        jQuery("#nj-navigation-close-button").hide();
        jQuery("#nj-navigation-title").hide();
        jQuery("#nj-navigation-div").children().hide();
    },

    removeFullView: function () {
        jQuery("#nj-content-wrapper").width("85%");
        jQuery("#nj-navigation-wrapper").width("15%");
        jQuery("#nj-navigation-open-button").hide();
        jQuery("#nj-navigation-close-button").show();
        jQuery("#nj-navigation-title").show();
        jQuery("#nj-navigation-div").children().show();
    },

    reloadCharts: function () {
        jQuery("[id$=-charts].hy-charts").each(function () {
            jQuery(this).hycharts("reload");
        });
        jQuery("[id$=-queues].hy-queues").each(function () {
            jQuery(this).hyqueues("resetSize");
        });
        jQuery("[id$=-projects].hy-projects").each(function () {
            jQuery(this).hyprojects("resetSize");
        });
    },

    resetFileBrowserHeight: function () {
        jQuery('.hy-file-browser .ui-jqgrid-bdiv').height('380px');
    },

    extendFileBrowser: function () {
        // skip File Browser on Spooler View service
        if (jQuery('.hy-file-browser').length && !jQuery('#ef-spooler-data').length) {
            if (!jQuery('.ef-service-form').length) {
                // Files Browse page case
                jQuery('.hy-file-browser .ui-jqgrid-bdiv').outerHeight(
                        jQuery('#nj-content-wrapper').height() -
                        jQuery('#nj-content-header').outerHeight(true) -
                        jQuery('#fm-browse-toolbar').outerHeight(true) - 
                        /* (jQuery('#fm-browse-message').is(":visible")? jQuery('#fm-browse-message').outerHeight(true) : 0) - */ 
                        jQuery('.hy-file-browser-location-bar').outerHeight(true) -
                        jQuery('.hy-file-browser .ui-jqgrid-hdiv').outerHeight(true) - 2,
                    true);
            } else if (jQuery('.ef-service-form').length) {
                // RFB case
                jQuery('.hy-rfb-dialog').each(function () {
                    var rfb = jQuery(this);
                    if (rfb.is(":visible")) {
                        rfb.find('.hy-file-browser .ui-jqgrid-bdiv').outerHeight(
                                rfb.find('.hy-rfb').height() -
                                rfb.find('.hy-rfb .hy-toolbar').outerHeight(true) -
                                rfb.find('.hy-file-browser-location-bar').outerHeight(true) -
                                rfb.find('.hy-file-browser .ui-jqgrid-hdiv').outerHeight(true) -
                                rfb.find('.hy-file-browser .ui-jqgrid-pager').outerHeight(true),
                            true);
                        // remove resizable
                        jQuery('.hy-rfb-dialog.ui-resizable').resizable('destroy');
                    }
                });
            }
        }
    },

    improveEFError: function () {
        if (jQuery("h3.large-app-error").length && !jQuery(".ef-error-wrapper").length) {
            jQuery("*[class$='-app-error']").wrapAll("<div class='ef-error-wrapper' />");
            jQuery("h3.large-app-error").prepend("<span class='ui-icon ui-icon-alert' />");
            if (jQuery("div.hy-left-column-wrapper").length) {
              jQuery("div.ef-error-wrapper").detach().prependTo("div.hy-left-column-wrapper");
            }
            else if (jQuery("div#login-container > .ef-error-wrapper").length) {
                jQuery(".ef-error-wrapper").css("padding-right", "0.8em");
                jQuery(".ef-error-wrapper > h3.large-app-error").css("cssText", "margin: auto !important; text-align: center ! important;");
            }
        }

        if (jQuery("#nj-content-div div.warning_message").length && !jQuery(".ef-error-wrapper").length) {
            jQuery("#nj-content-div div.warning_message").parent().children().wrapAll("<div class='ef-error-wrapper' />");
            jQuery("div.warning_message").prepend("<span class='ui-icon ui-icon-alert' />");
        }
    },

    mvToolbar: function () {
        // do not move on ef-interactive-<remote>-settings, service-form or service editor services.
        if (!jQuery('div[id^=ef-interactive-][id$=-settings]').length && !jQuery('.ef-service-form').length && !jQuery('#ef-srv-ide-service-editor').length) {

            // Note: hy-connectionbar and his hy-message are hidden or displayed together,
            // so we have to detach the whole div before moving hy-messages.
            var connectionBar = jQuery('.hy-connectionbar').detach();

            // mv hy-messages inside content
            if (jQuery('.hy-innertube-left').length) {
                jQuery('.hy-innertube-left').first().prepend(jQuery('#nj-container .hy-message').detach());
                jQuery('.hy-innertube-left').first().prepend(connectionBar);
            }
            else {
                jQuery('#nj-content-div').first().prepend(jQuery('#nj-container .hy-message').detach());
                jQuery('#nj-content-div').first().prepend(connectionBar);
            }

            // mv hy-toolbar as first element of the content
            if (jQuery('.hy-innertube-left').length) {
                jQuery('.hy-innertube-left').first().prepend(jQuery("#nj-container .hy-toolbar").first().detach());
            }
            else {
                jQuery('#nj-content-div').prepend(jQuery("#nj-container .hy-toolbar").first().detach());
            }
        }
    },

    selectService: function (navigationService) {
        jQuery('.ef-navigation-item a').each(function () {
            var selectedService = decodeURIComponent(jQuery(this).attr('href')).replace(/^.*[=\/]/g, "");
            if (navigationService === selectedService) {
                jQuery('.ef-navigation-item a').parent().removeClass('ui-state-highlight');
                jQuery(this).parent().addClass('ui-state-highlight');
                return false;
            }
        });
    },

    getURLParameter: function (name) {
        var uriParams, i, paramName;

        uriParams = decodeURIComponent(window.location.search).substring(1).split('&');
        for (i = 0; i < uriParams.length; i++) {
            paramName = uriParams[i].split('=');
            if (paramName[0] === name) {
                return paramName[1];
            }
        }
    },

    detectNavigationService: function () {
        var navigationService;
        // select navigation element
        navigationService = niceJump.getURLParameter('navigation');
        if (navigationService) {
            niceJump.selectService(navigationService);
        }
        else {
            var uri = niceJump.getURLParameter('_uri');
            if (uri) {
                if (uri.indexOf("job.info") >= 0) {
                    jQuery(".hy-gridjobs-panel-title").hide();
                    niceJump.selectService("list.jobs");
                    niceJump.selectService("list.all.jobs");
                    var jobId = jQuery("div.hy-gridjobs-panel-title-job-id").text().split("Job ")[1];
                    var jobName = jQuery("div.hy-gridjobs-panel-title-job-name").text();
                    if (jobId) {
                        var title = jobId;
                        if (jobName) {
                            title = jobId + " - " + jobName;
                        }
                        // jQuery("#nj-content-title").html("Jobs: " + efEncodeHtml(title));
                        jQuery("#nj-content-title").html("Jobs: " + efEncodeHtml(decodeURI(title)));
			var $anchor = $('.hy-gridjobs-data-value a');  // decode and replace spooler name
                        // Check if the element exists
                        if ($anchor.length) {
                            // Decode the URI-encoded text
                            var r=$anchor[0];
                            var decodedText = decodeURIComponent(r.text);
                            r.text = decodedText;
                        }
                    }
                }
                if (uri.indexOf("template.info") >= 0) {
                    niceJump.selectService("template.info");
                    let templateName = jQuery("#hy-gridtemplates-template-name").text();
                    if (templateName) {
                        jQuery("#nj-content-title").html("AWS Cluster Configurations: " + efEncodeHtml(templateName));
                    }
                }
                else if (uri.indexOf("cluster.info") >= 0) {
                    niceJump.selectService("cluster.info");
                    let clusterName = jQuery("#hy-gridclusters-cluster-name").text();
                    if (clusterName) {
                        jQuery("#nj-content-title").html("Clusters: " + efEncodeHtml(clusterName));
                    }
                }
                else if (uri.indexOf("list.all.jobs") >= 0) {
                    niceJump.selectService("list.all.jobs");
                }
                else if (uri.indexOf("host.info") >= 0) {
                    jQuery(".hy-gridhosts-panel-head").hide();
                    niceJump.selectService("list.hosts");
                    var hostName = jQuery("div.hy-gridhosts-panel-title-hostname").text().split("Host ")[1];
                    if (hostName) {
                        hostnameSeparator = "_";
                        hostName = hostName.split(hostnameSeparator)[0]; // if we have a <hostname>_<server id> composite, we get only the host name
                        jQuery("#nj-content-title").html("Hosts: " + efEncodeHtml(hostName));
                    }
                }
                else if (uri.indexOf("list.hosts") >= 0) {
                    niceJump.selectService("list.hosts");
                }
                else if (uri.indexOf("session.info") >= 0) {
                    jQuery(".hy-session-info-title").hide();
                    jQuery(".hy-session-info-screen-wrapper").detach().insertAfter(".hy-session-info-details");
                    niceJump.selectService("list.sessions");
                    niceJump.selectService("list.all.sessions");
                    var sessionName = jQuery("div.hy-session-info-title-name").text();
                    if (sessionName) {
                        jQuery("#nj-content-title").html("Sessions: " + efEncodeHtml(sessionName));
                    }
		      $('.hy-interactive-session-name').each(function() {
                         // Get the current element's text
                         var encodedText = $(this).text();
                         // Decode the text
                         var decodedText = decodeURIComponent(encodedText);
                         // Update the element's text with the decoded version
                         $(this).text(decodedText);
                         // If you also want to update the 'title' attribute
                         var encodedTitle = $(this).attr('title');
                         if (encodedTitle) {
                             var decodedTitle = decodeURIComponent(encodedTitle);
                             $(this).attr('title', decodedTitle);
                         }
                     });

                }
                else if (uri.indexOf("list.sessions") >= 0) {
                    niceJump.selectService("list.sessions");
		    $('.hy-interactive-session-name').each(function() {
                        // Get the current element's text
                        var encodedText = $(this).text();
                        // Decode the text
                        var decodedText = decodeURIComponent(encodedText);
                        // Update the element's text with the decoded version
                        $(this).text(decodedText);
                        // If you also want to update the 'title' attribute
                        var encodedTitle = $(this).attr('title');
                        if (encodedTitle) {
                            var decodedTitle = decodeURIComponent(encodedTitle);
                            $(this).attr('title', decodedTitle);
                        }
                    });
                }
                else if (uri.indexOf("list.all.sessions") >= 0) {
                    niceJump.selectService("list.all.sessions");
                }
                else if (uri.indexOf("connect.session") >= 0) {
                    niceJump.selectService("list.sessions");
                    niceJump.selectService("list.all.sessions");
		      $('.hy-interactive-session-name').each(function() {
                         // Get the current element's text
                         var encodedText = $(this).text();
                         // Decode the text
                         var decodedText = decodeURIComponent(encodedText);
                         // Update the element's text with the decoded version
                         $(this).text(decodedText);
                         // If you also want to update the 'title' attribute
                         var encodedTitle = $(this).attr('title');
                         if (encodedTitle) {
                             var decodedTitle = decodeURIComponent(encodedTitle);
                             $(this).attr('title', decodedTitle);
                         }
                     });

                }
                else if (uri.indexOf("show.spooler") >= 0) {
                    niceJump.selectService("list.spoolers");
                    var spoolerName = jQuery("span.hy-spooler-name").text();
                    if (spoolerName) {
                        jQuery("#nj-content-title").html("Spooler: " + efEncodeHtml(decodeURIComponent(spoolerName)));
                    }
                }
                else if (niceJump.getURLParameter('_actionid') && jQuery("#nj-content-div .large-app-error").length) {
                    if (uri.indexOf("batch") >= 0) {
                        jQuery("#nj-content-title").html("Batch Services: Error");
                    }
                    else if (uri.indexOf("interactive") >= 0) {
                        jQuery("#nj-content-title").html("Interactive Services: Error");
                    }
                }
            }
        }
        var testRun = niceJump.getURLParameter('testRun');
        if (testRun === 'true' && jQuery(".ef-service-title").html() && !jQuery('.ef-service-title-testrun').length) {
            serviceTitle = "Services: Test '" + jQuery(".ef-service-title").html() + "'";
            jQuery(".ef-service-title").addClass('ef-service-title-testrun').html(serviceTitle);
        }
    },

    renderNavigation: function () {
        var serviceNavigation, currentService, serviceUri, navigationUri;

        // bind navigation button click
        jQuery("#nj-navigation-close-button>a").click(function () {
            jQuery.cookie(niceJump.navigationCookie, 'closed', { path: '/', expires: 7 });
            niceJump.setFullView();
            niceJump.reloadCharts();
        });
        jQuery("#nj-navigation-open-button>a").click(function () {
            jQuery.cookie(niceJump.navigationCookie, 'open', { path: '/', expires: 7 });
            niceJump.removeFullView();
            niceJump.reloadCharts();
        });

        // Use root folder name as navigation title
        jQuery(".nj-navigation-title").text(jQuery(".ef-navigation-folder-root-name").html());
        jQuery(".ef-navigation-folder-root-name").hide();

        // Add functionality to open/close navigation folders
        jQuery(".ef-navigation-folder:has(>ul:hidden) > .ef-navigation-folder-name:not(.folder-open, .folder-close)").addClass("folder-close").prepend("<i class='fa fa-caret-right'></i>");
        jQuery(".ef-navigation-folder:not(:has(>ul:hidden)) > .ef-navigation-folder-name:not(.folder-open, .folder-close)").addClass("folder-open").prepend("<i class='fa fa-caret-down'></i>");
        jQuery(".ef-navigation-folder .ef-navigation-folder-name").click(function () {
            if (jQuery(this).hasClass("folder-open")) {
                jQuery(this).removeClass("folder-open").addClass("folder-close");
                jQuery(this).find("i").removeClass("fa-caret-down").addClass("fa-caret-right");
            }
            else {
                jQuery(this).removeClass("folder-close").addClass("folder-open");
                jQuery(this).find("i").removeClass("fa-caret-right").addClass("fa-caret-down");
            }
        });


        // Hide empty folders

	$(".ef-navigation-folder-name").each((index, element) => {
	    if ($(element).next("ul").html().trim() === "") {
		$(element).parent().hide();
	    }
	});
	
        // Hide empty folders
        // jQuery(".ef-navigation-folder-name").each(function () {
        //     if (jQuery.trim(jQuery(this).next("ul").html()) === "") {
        //         jQuery(this).parent().hide();
        //     }
        // });

        // Highlight navigation
        if (jQuery('.ui-state-highlight').length === 0) {
            serviceUri = decodeURIComponent(window.location.search).match(/(?:_uri=\/\/.*?\/|_service=)(.*?)(?=(?:&|$))/);
            currentService = (serviceUri && serviceUri.length > 1) ? serviceUri[1] : "";
            jQuery('.ef-navigation-item').removeClass('ui-state-highlight');
            jQuery('.ef-navigation-item a').each(function () {
                navigationUri = decodeURIComponent(jQuery(this).attr('href')).match(/(?:_uri=\/\/.*?\/|_service=)(.*?)(?=(?:&|$))/);
                serviceNavigation = (navigationUri && navigationUri.length > 1) ? navigationUri[1] : "";
                if (currentService === serviceNavigation) {
                    jQuery(this).parent().addClass('ui-state-highlight');
                    return false;
                }
            });
        }

        niceJump.detectNavigationService();
    },

    renderContent: function () {
        // render layout after user click
        jQuery("fieldset.ef_option_group_collapsible > legend," +
               ".hy-collapsible-box," +
               ".hy-spoolerbar-table," +
               ".ui-tabs li," +
               ".ui-icon.ui-icon-close," +
               "input[type='checkbox']," +
               "li.ef-navigation-folder")
	    .off('click.niceJump')
	    .on('click.niceJump', function() {
            setTimeout(niceJump.renderLayout, 500);
        });
        // jQuery("fieldset.ef_option_group_collapsible > legend," +
        //        ".hy-collapsible-box," +
        //        ".hy-spoolerbar-table," +
        //        ".ui-tabs li," +
        //        ".ui-icon.ui-icon-close," +
        //        "input[type='checkbox']," +
        //        "li.ef-navigation-folder")
	//     .unbind('click.niceJump')
	//     .bind('click.niceJump', function() {
        //     setTimeout(niceJump.renderLayout, 500);
        // });

	jQuery('select')
	    .off('change.niceJump')
	    .on('change.niceJump', function() {
		niceJump.renderLayout();
	    });

	// jQuery('select').unbind('change.niceJump').bind('change.niceJump', function() {
        //     niceJump.renderLayout();
        // });

        // avoid layout problems with 100% width, see layout.css
        jQuery('.hy-vtip').hover(function() {
            jQuery('.ui-tooltip').addClass('ui-tooltip-blocked');
        });

        // render layout at message fadeout

	jQuery('.hy-message')
	    .off('hymsgInfoFadeoutEvent.niceJump')
	    .on('hymsgInfoFadeoutEvent.niceJump', function() {
		niceJump.renderLayout();
	    });
	
	jQuery('.hy-message')
	    .off('hymsgAlertFadeoutEvent.niceJump')
	    .on('hymsgAlertFadeoutEvent.niceJump', function() {
		niceJump.renderLayout();
	    });
	
        // jQuery('.hy-message').unbind('hymsgInfoFadeoutEvent.niceJump').bind('hymsgInfoFadeoutEvent.niceJump', function() {
        //     niceJump.renderLayout();
        // });
        // jQuery('.hy-message').unbind('hymsgAlertFadeoutEvent.niceJump').bind('hymsgAlertFadeoutEvent.niceJump', function() {
        //     niceJump.renderLayout();
        // });

        // move first toolbar at the top of the page
        niceJump.mvToolbar();

        // improve EF error presentation
        niceJump.improveEFError();

        // Open NI SP Support link in a new tab
        const supportItem = jQuery('.ef-navigation-support a');
        const supportHref = supportItem.attr('href');
        if (supportHref) {
            supportItem.removeAttr('href').on('click', function(e) {
                e.preventDefault();
                window.open(supportHref, '_blank');
            });
        }

        // Show input content as title
        jQuery(".ef_option_value input").on('input change focus', function() {
            this.title = this.value;
        }).each(function() {
            this.title = this.value;
        });
    },

    renderTitle: function () {
        // Use first .ef-service-title div content as content header
        jQuery("#nj-content-title").text(jQuery(".ef-service-title").first().text());
        jQuery(".ef-service-title").hide();
    },

    renderLogin: function () {
        // Improve login button position
        jQuery('#ef_loginform table tr td input[type="submit"]').parent().attr('colspan', 1).parent().prepend('<td />');
    }
};

jQuery(document).ready(function () {
    if (!jQuery("#nj-content-div .hy-right-column").length) {
        jQuery("#nj-content-div").addClass('nj-content-div-single-column');
    }
    niceJump.renderNavigation();
    niceJump.renderContent();
    niceJump.renderLogin();
});

/* jQuery(window).load(function () {  NSW */ 
jQuery(window).on('load', function () {
    niceJump.renderTitle();
    // jQuery(".ef-service-title").change(niceJump.renderTitle);
    jQuery(".ef-service-title").on("input", niceJump.renderTitle);
    niceJump.renderLayout();
});

window.addEventListener('resize', function () {
    niceJump.renderLayout();
    setTimeout(function () {
        // Avoid white horizontal spaces with navigation collapsed
        niceJump.renderLayout();
        niceJump.reloadCharts();
    }, 50);
});


// jQuery(window).resize(function () {
//     niceJump.renderLayout();
//     setTimeout(function () {
//         // avoid white horizontal spaces with navigation collapsed
//         niceJump.renderLayout();
//         niceJump.reloadCharts();
//     }, 50);
// });

jQuery(document).ajaxComplete(function () {
    niceJump.detectNavigationService();
    niceJump.renderContent();
    niceJump.renderLayout();
    // if the service shows a message, we have to re-render the page
    setTimeout(niceJump.renderLayout, 500);
});
// ex:ts=4:et:
