<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
                exclude-result-prefixes="ef">

<!--
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.-->

  <xsl:output
    encoding="utf-8"
    method="html"
    media-type="text/html"
    doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
    doctype-system="http://www.w3.org/TR/html4/loose.dtd"
    omit-xml-declaration="yes"
  />

  <!-- System stylesheets inclusions -->
  <xsl:include href="$(EF_ROOT)/lib/xsl/com.enginframe.system.xsl" />

  <!-- Theme templates inclusion -->
  <xsl:include href="$(EF_ROOT)/plugins/themes/lib/xsl/ice-nine/layout.templates.xsl" />

  <!-- Custom parameters -->

  <!-- Enable tree rendering for navigation menu -->
  <xsl:variable name="ef.navigation">treeview</xsl:variable>

  <xsl:template match="/ef:agent" mode="layout.head" priority="-1" />

  <!-- root template match -->
  <xsl:template match="/">
    <html>
      <head>
        <xsl:call-template name="i9_head_rendering"/>
      </head>
      <body>
        <div id="i9-container">
          <xsl:call-template name="i9_banner_rendering"/>
          <xsl:call-template name="i9_contents_rendering"/>
          <xsl:call-template name="i9_footer_rendering"/>
        </div>
      </body>
    </html>
  </xsl:template>

</xsl:stylesheet>
