<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
                xmlns:efx="xalan://com.enginframe.xslt.xalan.Extensions"
                extension-element-prefixes="efx"
                exclude-result-prefixes="ef efx">

<!--
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.
 -->

  <xsl:output
    encoding="utf-8"
    method="html"
    media-type="text/html"
    doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
    doctype-system="http://www.w3.org/TR/html4/loose.dtd"
    omit-xml-declaration="yes"
  />

  <!-- System stylesheets inclusions -->
  <xsl:include href="$(EF_ROOT)/lib/xsl/com.enginframe.system.xsl" />

  <!-- Theme templates inclusion -->
  <xsl:include href="$(EF_ROOT)/plugins/themes/lib/xsl/next-round/layout.templates.xsl" />

  <!-- Custom parameters -->

  <!-- Use treeview rendering for navigation menu as default -->
  <xsl:variable name="ef.navigation">treeview</xsl:variable>

  <xsl:template match="/ef:agent" mode="layout.head" priority="-1" />

  <!-- root template match -->
  <xsl:template match="/" priority="-1">
    <html>
      <efx:acl>
        <ef:choose-acl>
          <ef:when-acl select="logged-users">
            <head>
              <xsl:call-template name="nj_head_rendering"/>
            </head>
            <body>
              <div id="nj-container">
                <xsl:call-template name="nj_banner_rendering"/>
                <div id="nj-wrapper">
                  <xsl:call-template name="nj_navigation_rendering"/>
                  <xsl:call-template name="nj_content_rendering"/>
                </div>
                <xsl:call-template name="nj_footer_rendering"/>
              </div>
            </body>
          </ef:when-acl>
          <ef:otherwise>
            <!-- If not logged in, show the login form -->
            <head>
              <xsl:call-template name="nj_head_rendering"/>
            </head>
            <body>
              <div id="nj-container">
                <div id="login-container">
                  <div id="nj-banner">
                    <xsl:call-template name="ef.logo" />
                  </div>
                  <h2 id="nj-login-title"><xsl:value-of select='$nj.ef.version'/></h2>
                  <!-- let system xsl render the login form -->
                  <xsl:call-template name="content_rendering"/>
                  <xsl:call-template name="nj_footer_login_rendering"/>
                </div>
              </div>
            </body>
          </ef:otherwise>
        </ef:choose-acl>
      </efx:acl>
    </html>
  </xsl:template>

</xsl:stylesheet>
