<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
                exclude-result-prefixes="ef">

  <xsl:output method="xml" indent="yes" encoding="utf-8"/>
  <xsl:strip-space elements="ef:discovery"/>

  <xsl:param name="keep_hidden_services">false</xsl:param>

  <xsl:template match="ef:discovery">
    <!-- Soft copy <ef:discovery> -->
    <xsl:copy>
      <!-- Recursive apply-templates in "discovery" mode -->
      <xsl:apply-templates mode="discovery"/>
    </xsl:copy>
  </xsl:template>

  <!-- Exclude the following tags in the output -  in "discovery" mode -->
  <xsl:template match="ef:include|ef:location|ef:location-list" mode="discovery"/>

  <!-- Remove hidden ef:service if not(keep_hidden_services) -->
  <xsl:template match="ef:service[@hidden and $keep_hidden_services='true']" mode="discovery">
    <xsl:copy><xsl:apply-templates select="@*|node()" mode="discovery" /></xsl:copy>
  </xsl:template>

  <!-- Strip XML comments in "discovery" mode -->
  <xsl:template match="comment()" mode="discovery" />

  <xsl:template match="ef:folder|ef:spooler" mode="discovery">
    <xsl:apply-templates mode="discovery"/>
  </xsl:template>

  <!-- Strip folder names since info on folders are not reported -->
  <xsl:template match="ef:folder/ef:name" mode="discovery" />

  <xsl:template match="ef:action" mode="discovery">
    <!-- keeping something from ef:action tag -->
    <xsl:copy>
      <xsl:choose>
       <xsl:when test="normalize-space(@id)">
         <xsl:attribute name="id"><xsl:value-of select="@id"/></xsl:attribute>
       </xsl:when>
       <xsl:otherwise>
         <xsl:attribute name="id">submit</xsl:attribute>
       </xsl:otherwise>
      </xsl:choose>
      <xsl:attribute name="label"><xsl:value-of select="@label"/></xsl:attribute>
      <xsl:if test="@result"><xsl:attribute name="result"><xsl:value-of select="@result"/></xsl:attribute></xsl:if>
      <xsl:if test="@output-mode"><xsl:attribute name="output-mode"><xsl:value-of select="@output-mode"/></xsl:attribute></xsl:if>
      <xsl:copy-of select="./ef:result"/>
    </xsl:copy>
  </xsl:template>

  <!-- Copy the rest of the tags in "discovery" mode -->
  <xsl:template match="@*|node()" mode="discovery" priority="-1">
    <xsl:copy><xsl:apply-templates select="@*|node()" mode="discovery" /></xsl:copy>
  </xsl:template>
</xsl:stylesheet>
