BEGIN {
    FS="\""
    mismatching_items=0
}

/^[ \t]*$/ {
    next
}

/^#### REFERENCE ####/ {
    mode="reference"
}

/^#### CURRENT STATUS ####/ {
    mode="current"
}

{
    mismatch=0
    i=0

    i=i+2; filename  =$i
    i=i+2; type      =$i
    i=i+2; ownership =$i
    i=i+2; permission=$i
    i=i+2; size      =$i
    i=i+2; checksum  =$i

    if ( mode == "reference" ) {
        reference_type[filename]=type
        reference_ownership[filename]=ownership
        reference_permission[filename]=permission
        reference_size[filename]=size
        reference_checksum[filename]=checksum
    }
    else if ( mode == "current" ) {
        if (!(filename in reference_ownership)) {
            print filename ": new entry"
            mismatch=1
        }
        else {
            reference_found[filename]=1
            if (reference_type[filename] != type) {
                print filename ": type mismatch. Expected " reference_type[filename] " is " type
                mismatch=1
            }
            if (reference_ownership[filename] != ownership) {
                print filename ": ownership mismatch. Expected " reference_ownership[filename] " is " ownership
                mismatch=1
            }
            if (reference_permission[filename] != permission) {
                print filename ": permission mismatch. Expected " reference_permission[filename] " is " permission
                mismatch=1
            }
            if (reference_size[filename] != size) {
                print filename ": size mismatch. Expected " reference_size[filename] " is " size
                mismatch=1
            }
            if (reference_checksum[filename] != checksum) {
                print filename ": checksum mismatch. Expected " reference_checksum[filename] " is " checksum
                mismatch=1
            }
        }
        if (mismatch==1) {
          mismatching_items++;
        }
    }
}

END {
    for (filename in reference_ownership) {
        if (!(filename in reference_found)) {
            print filename ": deleted"
        }
    }
    if (mismatching_items == 0) {
      exit(0)
    }
    else {
      exit(1)
    }
}
