#! /bin/bash

################################################################################
# Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
#
# This software includes confidential and proprietary information
# of NI SP Software GmbH ("Confidential Information").
# You shall not disclose such Confidential Information
# and shall use it only in accordance with the terms of
# the license agreement you entered into with NI SP Software.
################################################################################

# We replace aarch64 with arm64
# and x86_64 with x64 because of
# how NodeJS packages its binaries
machine=$(uname -m)
machine=${machine/aarch64/arm64}
machine=${machine/x86_64/x64}

# This is how NodeJS packages its binaries
node_version="node-v22.16.0-linux-$machine"

# Unpack Node.js only if necessary
if [ ! -f "$EF_SHELL_NODE/$node_version/bin/node" ]; then
    if ! cd "$EF_SHELL_NODE" ; then
        exit 1
    fi
    tar xfz "node-$(uname -m).tar.gz"
fi

if ! cd "$EF_SHELL_HOME" ; then
    exit 1
fi

# Unpack our node modules only if necessary
if [ ! -d node_modules ]; then
    tar xfz "node_modules-$(uname -m).tar.gz"
fi

export NODE_ENV="production"

"$EF_SHELL_NODE/$node_version/bin/node" app.js &

echo $! > "$EF_SHELLPID"
