#!/bin/bash

# demo=1

# service
# set DBPW in configuration
if [ "$DBPW" == "" ] ; then
    # /opt/nisp/enginframe/conf/derby
    echo "Please set DBPW value in the configuration from $EF_CONF_ROOT/derby/derby.properties (derby.user.dbadmin)" 
    exit
else
    :
    # bash $EF_CONF_ROOT/tomcat/webapps/ROOT/jobhist/script.sh 
fi

# set -x 
spooler="`echo $EF_SPOOLER_URI | sed 's|spooler://||'`"

if [ "$demo" != "1" ] ; then

    source "${EF_CONF_ROOT}/enginframe.conf"
    export PATH=$PATH:$JAVA_HOME/bin
    
    # EF_DATA_ROOT=/opt/nisp/enginframe/data
    conffile=".jobdb.conf.$$"
    echo '{"ConnectionString":"jdbc:derby://localhost:1527/'${EF_DATA_ROOT}'/derby/EnginFrameDB;user=dbadmin;password='$DBPW'"}' > $conffile 
    
    res=`java -jar $EF_CONF_ROOT/tomcat/webapps/ROOT/jobhist/backend/LongTermUtils.jar -configfile $conffile -tabletrigger setup`
    # echo $res
    jsonfile="jobs.json.$$"
    if [ "`echo $res | grep 'Table actions'`" != "" ] ; then
	java -jar $EF_CONF_ROOT/tomcat/webapps/ROOT/jobhist/backend/LongTermUtils.jar -configfile $conffile -sync stdout > $jsonfile
	rm -f $conffile
    else
	rm -f $conffile
	echo Table trigger did not work ... exiting
	exit
    fi
fi
# exit

cat <<'EOF' > index.html
<!DOCTYPE html>
<html>
 <head>
   <meta charset="UTF-8">
    <script src="/jobhist/javascript/dist/jquery-3.7.0.js"></script>
    <script src="/jobhist/javascript/dist/jquery.dataTables.min.js"></script>
    <link rel="stylesheet" href="/jobhist/javascript/dist/dataTables.bootstrap5.min.css" />
    <script src="/jobhist/javascript/dist/dataTables.bootstrap5.min.js"></script>
    <link rel="stylesheet" href="/jobhist/javascript/dist/bootstrap.min.css" />

    <script type="text/javascript" src="/jobhist/javascript/dist/moment.min.js"></script>
    <script type="text/javascript" src="/jobhist/javascript/dist/daterangepicker.min.js"></script>
    <link rel="stylesheet" type="text/css" href="/jobhist/javascript/dist/daterangepicker.css" />
    <link rel="stylesheet" type="text/css" href="/jobhist/style.css" />
    <script src="/jobhist/javascript/dist/chart.js"></script>
    <script src="/jobhist/javascript/dist/filesize.min.js"></script>
    <script src="/jobhist/javascript/dist/chartjs-adapter-moment.js"></script>
    <script src="/jobhist/javascript/datehelpers.js"></script>
    <!--<script src="datasetgenerator.js" type="module"></script> UNCOMMENT THIS FOR faker.js DATASET GENERATION--> 

    <script type="text/javascript" defer>
        let table1;
        let table2;
        let dateMin = null;
        let dateMax = null;

        // Custom range filtering function
        DataTable.ext.search.push(function (settings, data, dataIndex) {
            if (dateMin != null) {
                if (data[7] < dateMin) {
                    return false;
                }
            }

            if (dateMax != null) {
                if (data[7] > dateMax) {
                    return false;
                }
            }
            return true;
        });
EOF

if [ "1"  == "1" ] ; then   # we do not see the demo #demo of the URL here "$demo"
    cat <<EOF >> index.html
    var dataSetDemo = `cat $EF_CONF_ROOT/tomcat/webapps/ROOT/jobhist/backend/demodata.json` ;
EOF
fi
# cp $jsonfile /tmp/XXX.$$
cat <<EOF >> index.html
var dataSet = `cat "$jsonfile"` ;
EOF
rm -f $jsonfile

# exit 

cat <<'EOF' >> index.html

jQuery(document).ready(function () {
    //console.log(window.dataSet);
    // 	var newUrl = window.parent.location.href.split('#')[0] + '#demo';
    
    if (window.parent.location.hash === "#demo") {
	// If the hash is "#demo", set dataSet to dataSetDemo
	// console.log("setting demo data");
	dataSet = dataSetDemo;
	$(window.parent.document).find("#johih1").text("Job History (Demo Mode)");
    }
    // dataSet = data;
    
    if(dataSet.length == 0){
        $("#errormessage").text("The data was loaded correctly, but was empty. You can try using the demo data button below.");
    }
    
    var dateTimeFormat = new Intl.DateTimeFormat("en-US", {
        dateStyle: "short",
        timeStyle: "short",
    });
    
    //window["dataSet"] = dataSet;
    
    const dataSetFiltered = dataSet.filter(
	(e) => e["execution-time"] > 0 &&
	    e["total-cpu-usage"] !== "INVALID" // &&    e["status"] == "DONE"     // exclude "status":"EXIT"
    );
    
    // Applies a filter to a specific column of a table (presumably a DataTables instance).
    // If the filter is "N/A", it searches for empty values using a regular expression;
    // otherwise, it uses the provided filter value.
    const filterBy = (column, filter) => {
        table1
            .column(column)
            .search(filter == "N/A" ? "^$" : filter, true, false)
            .draw();
        if ($("#aggregate").val() != "") {
            updateAggregate();
        }
    };
    
    // Binds a change event handler to a DOM element (likely a dropdown or input field) that triggers the filterBy function when a new option is selected or the value is changed. It adds a "selected" class to the DOM element as well.
    const registerFilter = (column, dom) => {
        dom.on("change", function () {
            dom.addClass(".selected");
            filterBy(column, dom.val());
        });
    };
    // Accepts an array of filter objects and registers each one using the registerFilter function. Each filter object should contain column and dom properties.
    const registerFilters = (...filters) => {
        filters.forEach((f) => {
            registerFilter(f.column, f.dom);
        });
    };
    // Fills a dropdown (<select>) element with unique options extracted from a specific column of a DataTables instance. It provides an "N/A" option for empty or undefined values.
    const populateSelect = (column, dom) => {
        let unique = table1.column(column).data().unique();
        unique.each((e) => {
            dom.append(
                jQuery(document.createElement("option")).prop({
                    value: e ? e : "N/A",
                    text: e ? e : "N/A",
                })
            );
        });
    };
    // Initializes search filters by populating dropdowns with unique column values and registering the filter functionality for each filter object provided.
    const initSearchFilters = (...filters) => {
        filters.forEach((f) => {
            populateSelect(f.column, f.dom);
            registerFilter(f.column, f.dom);
        });
    };
    
    // Destroys a DataTable instance on an element with the ID #jobHistory and recreates the table element. This might be used to reset the table state completely.
    const resetTable = () => {
        $("#jobHistory").DataTable().destroy(true);
        $("#table").append('<table class="table table-striped table-bordered" id="jobHistory" style="width:100%"></table>');
    };
    // Initializes a DataTable on a given DOM element with specified column definitions and data.
    const initTable = (dom, columns, data) => {
        return dom.DataTable({
            columns: columns,
            data: data,
	    order: [7, "desc"],
	    orderFixed: { post: [7, "desc"] }
        });
    };
    // Initializes a DataTable on a given DOM element with specified column definitions and data.
    const initAggregateTable = (dom, columns, data) => {
        return dom.DataTable({
            columns: columns,
            data: data,
	    order: [0, "desc"],
	    orderFixed: { post: [0, "desc"] }
        });
    };
    
    // Aggregates resources from a data array, calculating total CPU usage (summing up times),
    // total memory usage, and total swap usage. CPU times are aggregated by converting
    // them to seconds, summing them, and then converting them back to a time string.
    // console.log('Filtering records: ');
    const aggregateResources = (data) => {
        let totalCpuUsage = data
	// Filter out records with "total-cpu-usage": "INVALID"
	// .filter((e) => e["total-cpu-usage"] !== "INVALID")
	    .filter((e) => {
		if (e["total-cpu-usage"] === "INVALID") {
		    console.log('Filtered record: ' + JSON.stringify(e));
		    return false; // Exclude the record
		} else {
		    // console.log('Used: ' + JSON.stringify(e));
		    return true; // Include the record
		}
	    })
            .map((e) => e["total-cpu-usage"])
            .reduce(function (a, b) {
                var test = b.match(/^\w+:\w+$/g);
                var test2 = b.match(/^\w+:\w+:\w+$/g);
		
                if ((b.match(/:/g) || []).length < 2) {
                    b = "00:" + b;
                }
		console.log("time ... " + a);
                return formatTime(timeStrToSec(a) + timeStrToSec(b));
            }, "00:00:00");
	
        let totalMemoryUsage = data
            .map((e) => e["memory-usage"])
            .reduce(function (a, b) {
                return a + b;
            }, 0);
	
        let totalSwapUsage = data
            .map((e) => e["swap-usage"])
            .reduce(function (a, b) {
                return a + b;
            }, 0);
	
        return { totalCpuUsage, totalMemoryUsage, totalSwapUsage };
    };
    
    $('input[name="datefilter"]').daterangepicker(
        {
            autoUpdateInput: false,
            locale: {
                cancelLabel: "Clear",
            },
	    linkedCalendars: false,
	    showDropdowns: true
        },
        function (start, end, label) {
            dateMin = start.unix();
            dateMax = end.unix();
            table1.draw();
            updateAggregate();
        }
    );

    $('input[name="datefilter"]').on("apply.daterangepicker", function (ev, picker) {
        $(this).val(picker.startDate.format("MM/DD/YYYY") + " - " + picker.endDate.format("MM/DD/YYYY"));
    });

    $('input[name="datefilter"]').on("cancel.daterangepicker", function (ev, picker) {
        $(this).val("");
        dateMin = null;
        dateMax = null;
        table1.draw();
	updateAggregate();
    });

    // Tabs
    jQuery("#tabs li a:not(:first)").addClass("inactive");
    jQuery(".container").hide();
    jQuery(".container:eq(0)").show();
    jQuery(".container:eq(1)").show();

    jQuery("#tabs li a").click(function () {
        var t = jQuery(this).attr("id");
        if (jQuery(this).hasClass("inactive")) {
            jQuery("#tabs li a").addClass("inactive");
            jQuery(this).removeClass("inactive");

            jQuery(".container").hide();
            jQuery(".container:eq(0)").show();
            jQuery("#" + t + "C").fadeIn("fast");
        }
    });

    const initialColumns = [
        { name: "name", data: "name", title: "Name" },
        { name: "queue", data: "queue", title: "Queue" },
        { name: "account", data: "account", title: "Account" },
        { name: "manager", data: "manager", title: "Manager" },
        { name: "owner", data: "owner", title: "Owner" },
        { name: "memory-usage", data: "memory-usage", title: "Memory usage", render: (data, type, row, meta) => (type == "display" ? filesize(data) : data), type: "num" },
        { name: "swap-usage", data: "swap-usage", title: "Swap usage", render: (data, type, row, meta) => (type == "display" ? filesize(data) : data), type: "num" },
        { name: "execution-time", data: "execution-time", title: "Execution time", render: (data, type, row, meta) => (type == "display" ? timeConverter(data) : data) }, //dateTimeFormat.format(new Date(data)) },
        { name: "execution-host", data: "execution-host", title: "Execution host"},
        { name: "total-cpu-usage", data: "total-cpu-usage", title: "Total CPU usage (hours; minutes; seconds)", render: (data, type, row, meta) => (type == "display" ? formatTime(timeStrToSec(data)) : timeStrToSec(data)) },
        { name: "status", data: "status", title: "Status" },
    ];

    const aggregateColumns = [
        { name: "timeframe", data: "timeframe", title: "Timeframe", render: (data, type, row, meta) => (type == "display" ? data[0] : data[1]) },
        { name: "jobsCount", data: "jobsCount", title: "Nr. of jobs" },
        { name: "cpuTime", data: "cpuTime", title: "CPU time (hours; minutes; seconds)", render: (data, type, row, meta) => (type == "display" ? data[0] : data[1]) },
        { name: "memoryUsage", data: "memoryUsage", title: "Memory usage", render: (data, type, row, meta) => (type == "display" ? filesize(data) : data), type: "num" },
        { name: "swapUsage", data: "swapUsage", title: "Swap usage", render: (data, type, row, meta) => (type == "display" ? filesize(data) : data), type: "num" },
    ];

    table1 = initTable(jQuery("#jobHistory"), initialColumns, dataSetFiltered);
    //table1.order.fixed({ post: [7, "desc"] });
    //table1.draw();

    const queues = {
        column: 1,
        dom: jQuery("#queues"),
    };

    const accounts = {
        column: 2,
        dom: jQuery("#accounts"),
    };

    const managers = {
        column: 3,
        dom: jQuery("#managers"),
    };

    const owners = {
        column: 4,
        dom: jQuery("#owners"),
    };

    const executionHost = {
        column: 8,
        dom: jQuery("#hosts"),
    };

    const statuses = {
        column: 10,
        dom: jQuery("#statuses"),
    };

    const updateAggregate = () => {
        const value = $("#aggregate").val();
        const filteredData = table1.rows({ search: "applied" }).data().toArray();

        let dwa = filteredData.map((e) => {
            let date = new Date(e["execution-time"] * 1000);
            return {
                year: date.getFullYear(),
                month: date.getMonth(),
                day: date.getDate(),
            };
        });
        //
                    const calculateYearly = (data) => {
                        let result = [];
                        // Creates an array of unique years from the dwa array (which is not defined within the provided snippet, so it should be defined elsewhere in the code). It uses the .map() method to extract the year from each element and the .filter() method to remove duplicates by checking if the index of the current item is the same as the index where the item is first found in the array.
                        let years = dwa
                            .map((e) => e.year)
                            .filter(function (itm, i, a) {
                                return i == a.indexOf(itm);
                            });
                        // Iterates over each unique year found in the dwa array. For each year (e):
                        years.forEach((e) => {
                            // Filters the data array to find elements where the "execution-time" property corresponds to the current year e. The "execution-time" is assumed to be a UNIX timestamp, which is why it"s multiplied by 1000 when creating a Date object (since JavaScript Date objects are constructed with milliseconds).
                            let jobs = data.filter((f) => {
                                let date = new Date(f["execution-time"] * 1000);
                                return date.getFullYear() == e;
                            });
                            // Calls the aggregateResources function, passing in the filtered jobs array. This function should return an object containing the aggregated values for CPU usage, memory usage, and swap usage. These values are then destructured into the respective constants.
                            const { totalCpuUsage, totalMemoryUsage, totalSwapUsage } = aggregateResources(jobs);

                            const date = new Date(e, 1, 1);
                            // Adds an object to the result array that summarizes the data for the year e. This object includes the year itself (timeframe), the count of jobs for that year (jobsCount), and the aggregated resource usage statistics (cpuTime, memoryUsage, swapUsage).
                            result.push({
                                timeframe: [e, e],
                                jobsCount: jobs.length,
                                cpuTime: [totalCpuUsage, timeStrToSec(totalCpuUsage)],
                                memoryUsage: totalMemoryUsage,
                                swapUsage: totalSwapUsage,
                            });
                        });
                        // After the forEach loop has processed all years, the function returns the result array containing the summarized data for each year.
                        return result;
                    };

                    const calculateMonthly = (data) => {
                        let result = [];

                        let years = dwa
                            .map((e) => e.year)
                            .filter(function (itm, i, a) {
                                return i == a.indexOf(itm);
                            });

                        years.forEach((y) => {
                            let months = dwa
                                .map((d) => d.month)
                                .filter(function (itm, i, a) {
                                    return i == a.indexOf(itm);
                                });

                            months.forEach((f) => {
                                let jobs = data.filter((de) => {
                                    let date = new Date(de["execution-time"] * 1000);
                                    return date.getMonth() == f;
                                });

                                const { totalCpuUsage, totalMemoryUsage, totalSwapUsage } = aggregateResources(jobs);

                                const date = new Date(y, f, 1);

                                result.push({
                                    timeframe: [monthNames[f] + " " + y, date],
                                    jobsCount: jobs.length,
                                    cpuTime: [totalCpuUsage, timeStrToSec(totalCpuUsage)],
                                    memoryUsage: totalMemoryUsage,
                                    swapUsage: totalSwapUsage,
                                });
                            });
                        });

                        return result;
                    };

                    const calculateDaily = (data) => {
                        let result = [];

                        let yrs = dwa
                            .map((e) => e.year)
                            .filter(function (itm, i, a) {
                                return i == a.indexOf(itm);
                            });

                        yrs.forEach((e) => {
                            let months = dwa
                                .filter((f) => f.year == e)
                                .map((d) => d.month)
                                .filter(function (itm, i, a) {
                                    return i == a.indexOf(itm);
                                });

                            months.forEach((f) => {
                                let days = dwa
                                    .filter((g) => g.year == e && g.month == f)
                                    .map((d) => d.day)
                                    .filter(function (itm, i, a) {
                                        return i == a.indexOf(itm);
                                    });

                                days.forEach((g) => {
                                    let jobs = data.filter((de) => {
                                        let date = new Date(de["execution-time"] * 1000);
                                        return date.getDate() == g && date.getMonth() == f && date.getFullYear() == e;
                                    });

                                    const { totalCpuUsage, totalMemoryUsage, totalSwapUsage } = aggregateResources(jobs);

                                    const date = new Date(e, f, g);

                                    result.push({
                                        timeframe: [g + " " + monthNames[f] + " " + e, date], //getOrdinalIndicator(g) + " " + monthNames[f] + " " + e, date],
                                        jobsCount: jobs.length,
                                        cpuTime: [totalCpuUsage, timeStrToSec(totalCpuUsage)],
                                        memoryUsage: totalMemoryUsage,
                                        swapUsage: totalSwapUsage,
                                    });
                                });
                            });
                        });

                        return result;
                    };

                    $("#noaggregatemessage").hide();

                    switch (value) {
                        case "":
                            $("#noaggregatemessage").show();
                            resetTable();
                            table1 = initTable(jQuery("#jobHistory"), initialColumns, dataSetFiltered);
                            table1.order.fixed({ post: [7, "desc"] });
                            table1.draw();
                            registerFilters(queues, accounts, managers, owners, executionHost, statuses);
                            $("#filters").each(function () {
                                $(this).find(":input").val($("#target option:first").val());
                            });
                            updateChart(jQuery("#jobHistory"), initialColumns, null);
                            break;

                        case "daily":
                            resetTable();
                            let daily = calculateDaily(filteredData);
                            table2 = initAggregateTable(jQuery("#jobHistory"), aggregateColumns, daily);
                            updateChart(jQuery("#jobHistory"), aggregateColumns, daily, "daily");
                            table2.on("draw", function () {
                                updateChart(jQuery("#jobHistory"), aggregateColumns, daily, "daily");
                            });

                            break;

                        case "monthly":
                            resetTable();
                            let monthly = calculateMonthly(filteredData);
                            table2 = initAggregateTable(jQuery("#jobHistory"), aggregateColumns, monthly);
                            updateChart(jQuery("#jobHistory"), aggregateColumns, monthly, "monthly");
                            table2.on("draw", function () {
                                updateChart(jQuery("#jobHistory"), aggregateColumns, monthly, "monthly");
                            });
                            break;

                        case "yearly":
                            resetTable();
                            let yearly = calculateYearly(filteredData);
                            table2 = initAggregateTable(jQuery("#jobHistory"), aggregateColumns, yearly);
                            updateChart(jQuery("#jobHistory"), aggregateColumns, yearly, "yearly");
                            table2.on("draw", function () {
                                updateChart(jQuery("#jobHistory"), aggregateColumns, yearly, "yearly");
                            });
                            break;
                    }
                };

                initSearchFilters(queues, accounts, managers, owners, executionHost, statuses);

                jQuery("#aggregate").on("change", updateAggregate);
            // getjson }).fail(()=>{$("#errormessage").text("There was an error loading the statistics. If you want, you can experiment with the demo data button below to the right.")});
        });

        var currcharts = null;

        const createChart = (target, title, labels, data, options, typeofdata) => {
            var ticksettings = {};

            var tooltipsettings = {};


            let typeoflabel = "category";
            switch(typeofdata){
                case "daily":
                case "monthly":
                    typeoflabel = "time";
                    break;
                default:
                    break;
            }

            let timelabelconfig = undefined;
            switch(typeofdata){
                case "daily":
                    timelabelconfig = {
                        unit: "day",
                        displayFormats: {
                            day: "MMM D YY",
                        },
                        tooltipFormat: "MMM D YY",
                    };
                    break;
                case "monthly":
                    timelabelconfig = {
                        unit: "month",
                        displayFormats: {
                            day: "MMM YY",
                        },
                        tooltipFormat: "MMM YY",
                    };
                    break;
            }


            if (options.type == "cputime") {
                ticksettings = {
                    callback: function (value, index, ticks) {
                        return formatTime(value);
                    },
                };
                tooltipsettings = {
                    callbacks: {
                        label: (context) => {
                            if (context.dataset.label == "CPU time (hours; minutes; seconds)") {
                                context.formattedValue = formatTime(context.raw);
                            }
                        },
                    },
                };
            }

            if (options.type == "memory") {
                ticksettings = {
                    callback: function (value, index, ticks) {
                        return filesize(value);
                    },
                };
                tooltipsettings = {
                    callbacks: {
                        label: (context) => {
                            context.formattedValue = filesize(context.raw);
                        },
                    },
                };
            }

            const ctx = target.get(0);
            currcharts.push(
                new Chart(ctx, {
                    type: "bar",
                    data: {
                        labels: labels,
                        datasets: [
                            {
                                label: title,
                                data: data,
                                borderWidth: 1,
                            },
                        ],
                    },
                    options: {
                        responsive: true,
                        animation: false,
                        plugins: {
                            title: {
                                display: false,
                                text: "Chart.js Line Chart - Multi Axis",
                            },
                            tooltip: tooltipsettings,
                        },
                        scales: {
                            y: {
                                type: "linear",
                                display: true,
                                position: "left",
                                title: {
                                    display: false,
                                    text: title,
                                },
                                ticks: ticksettings,
                            },
                            x: {
                                ticks: {
                                    maxRotation: 90,
                                    minRotation: 90,
                                    font: {
                                        size: 10,
                                    },
                                },
                                type: typeoflabel,
                                time: timelabelconfig
                            },
                        },
                    },
                })
            );
        };

        const updateChart = (table, columns, data, typeofdata) => {

            const chartq = $("#chartbox");

            // Clean up old data!
            if (currcharts != null) {
                currcharts.forEach((chart) => {
                    chart.destroy();
                });
                chartq.empty();
                $("#jobchart").empty();
                $("#memorychart").empty();
            }

            // If we stopped seeing aggregates, hide the chart area
            if (data == null) {
                chartq.hide();
                return;
            } else {
                chartq.show();
            }

            currcharts = []; // We need to keep an array of chart.js objects, to be able to destroy them

            const charts_to_show = [
                { data: "jobsCount", title: "Nr. of jobs", options: { type: "integer" } },
                { data: "cpuTime", title: "CPU time (hours; minutes; seconds)", options: { type: "cputime" } },
                { data: "memoryUsage", title: "Memory usage", options: { type: "memory" } },
                { data: "swapUsage", title: "Swap usage", options: { type: "memory" } },
            ];

            let timedescription = typeofdata == "daily" || typeofdata == "monthly" ? {
                type: "time",
                time: {
                    unit: typeofdata == "daily" ? "day" : "month",
                    displayFormats: {
                        day: typeofdata == "daily" ? "MMM D YY" : "MMM YY",
                    },
                    tooltipFormat: typeofdata == "daily" ? "MMM D YY" : "MMM YY",
                }
            } : {type: "category"};


            var labels = [];
            table2
                .column(0, { order: "current" })
                .data()
                .each((cell) => typeofdata != "yearly" ? labels.push(moment(cell[1])) : labels.push(cell[1]));

            charts_to_show.forEach((category) => {
                var chartcontainer = $("<div>");
                chartcontainer.css("width", 100 / charts_to_show.length + "%");
                chartq.append(chartcontainer);

                var newcanvas = $("<canvas>");
                chartcontainer.append(newcanvas);
                var data_to_display = [];
                table2
                    .column(category.data + ":name", { order: "current" })
                    .data()
                    .each((cell) => (Array.isArray(cell) ? data_to_display.push(cell[1].toString()) : data_to_display.push(cell.toString())));

                createChart(newcanvas, category.title, labels, data_to_display, category.options, typeofdata);
            });



	    // LARGE CPU NR JOBS CHART  //////////////////////////////////////////////////
            var newcanvas2 = $("<canvas>");
            $("#jobchart").css({"width": "90%", "height": "360px"}).append(newcanvas2);
            const ctx = newcanvas2.get(0);

            jobData = [];
            table2
                .column(1, { order: "current" })
                .data()
                .each((cell) => jobData.push(cell.toString()));
            cpuTime = [];
            table2
                .column(2, { order: "current" })
                .data()
                .each((cell) => cpuTime.push(cell[1].toString()));

            var memoryData = [];
            var swapData = [];
            table2
                .column(3, { order: "current" })
                .data()
                .each((cell) => memoryData.push(cell.toString()));
            table2
                .column(4, { order: "current" })
                .data()
                .each((cell) => swapData.push(cell.toString()));

            currcharts.push(
                new Chart(ctx, {
                    type: "bar",
                    data: {
                        labels: labels,
                        datasets: [
                            {
                                label: "Number of jobs",
                                data: jobData,
                                yAxisID: "y",
                            },
                            {
                                label: "CPU time (hours; minutes; seconds)",
                                data: cpuTime,
                                yAxisID: "y1",
                            },
                        ],
                    },
                    options: {
                        responsive: true,
                        // animation: true,
			animation: {
                            duration: 450, // Animation duration in milliseconds
                            easing: 'easeOutQuart'
                        },
			maintainAspectRatio: false,
                        interaction: {
                            mode: "index",
                            intersect: false,
                        },
                        stacked: false,
                        plugins: {
                            title: {
                                display: false,
                                text: "Chart.js Line Chart - Multi Axis",
                            },
                            tooltip: {
                                callbacks: {
                                    label: (context) => {
                                        if (context.dataset.label == "CPU time (hours; minutes; seconds)") {
                                            context.formattedValue = formatTime(context.raw);
                                        }
                                    },
                                },
                            },
                        },
                        scales: {
                            y: {
                                type: "linear",
                                display: true,
                                position: "left",
                                title: {
                                    display: true,
                                    text: "Number of jobs",
                                },
                                ticks: {
                                    stepSize: 1,
                                },
                            },
                            y1: {
                                type: "linear",
                                display: true,
                                position: "right",
                                title: {
                                    display: true,
                                    text: "CPU time (hours; minutes; seconds)",
                                },

                                // grid line settings
                                grid: {
                                    drawOnChartArea: false, // only want the grid lines for one axis to show up
                                },
                                ticks: {
                                    callback: function (value, index, ticks) {
                                        return formatTime(value);
                                    },
                                },
                            },
                            x: timedescription
                        },
                    },
                })
            );

	    // LARGE MEM CHART 
            var newcanvas3 = $("<canvas>");
            $("#memorychart").css({"width": "90%", "height": "360px"}).append(newcanvas3);
            const mctx = newcanvas3.get(0);

            currcharts.push(
                new Chart(mctx, {
                    type: "bar",
                    data: {
                        labels: labels,
                        datasets: [
                            {
                                label: "Memory usage",
                                data: memoryData,
                                yAxisID: "y",
                            },
                            {
                                label: "Swap usage",
                                data: swapData,
                                yAxisID: "y1",
                            },
                        ],
                    },
                    options: {
                        responsive: true,
                        // animation: true,
			animation: {
                            duration: 450, // Animation duration in milliseconds
                            easing: 'easeOutQuart'
                        },
			maintainAspectRatio: false,
                        interaction: {
                            mode: "index",
                            intersect: false,
                        },
                        stacked: false,
                        plugins: {
                            title: {
                                display: false,
                                text: "Chart.js Line Chart - Multi Axis",
                            },
                            tooltip: {
                                callbacks: {
                                    label: (context) => {
                                        context.formattedValue = filesize(context.raw);
                                    },
                                },
                            },
                        },
                        scales: {
                            y: {
                                type: "linear",
                                display: true,
                                position: "left",
                                title: {
                                    display: true,
                                    text: "Memory usage",
                                },
                                ticks: {
                                    callback: function (value, index, ticks) {
                                        return filesize(value);
                                    },
                                },
                            },
                            y1: {
                                type: "linear",
                                display: true,
                                position: "right",
                                title: {
                                    display: true,
                                    text: "Swap usage",
                                },
                                grid: {
                                    drawOnChartArea: false, // only want the grid lines for one axis to show up
                                },
                                ticks: {
                                    callback: function (value, index, ticks) {
                                        return filesize(value);
                                    },
                                },
                            },
                            x: timedescription
                        },
                    },
                })
            );
        };
// updated
function demomode () {
    // window.location.href += '#demo'; location.reload();
    console.log("demo mode");
    if (window.self !== window.top) {
	// This code is running inside an iframe
	
	// Append '#demo' to the parent URL
	var newUrl = window.parent.location.href.split('#')[0] + '#demo';
	
	// Update the parent URL
	window.parent.location.href = newUrl;
	
	// Reload the parent window
	window.parent.location.reload();
    }
}
    </script>
</head>
    <body>
        <div class="container">
            <form id="filters">
                <div class="form-group">
                    <div class="row">
                        <div class="col">
                            <label for="owners" class="form-label">Owner:</label>
                            <select id="owners" class="form-select form-select-sm">
                                <option value="">All</option>
                            </select>
                        </div>

                        <div class="col">
                            <label for="queues" class="form-label">Queues:</label>
                            <select id="queues" class="form-select form-select-sm">
                                <option value="">All</option>
                            </select>
                        </div>

                        <div class="col">
                            <label for="accounts" class="form-label">Accounts:</label>
                            <select id="accounts" class="form-select form-select-sm">
                                <option value="">All</option>
                            </select>
                        </div>

                        <div class="col">
                            <label for="hosts" class="form-label">Execution hosts:</label>
                            <select id="hosts" class="form-select form-select-sm">
                                <option value="">All</option>
                            </select>
                        </div>

                        <div class="col">
                            <label class="form-label">Job Managers:</label>
                            <select id="managers" class="form-select form-select-sm">
                                <option value="">All</option>
                            </select>
                        </div>

                        <div class="col">
                            <label for="statuses" class="form-label">Status:</label>
                            <select id="statuses" class="form-select form-select-sm">
                                <option value="">All</option>
                            </select>
                        </div>
                    </div>
                </div>
            </form>
            <form>
                <div class="form-group">
                    <div class="row">
                        <div class="col">
                            <label for="aggregate" class="form-label">Aggregate report view:</label>
                            <select id="aggregate" class="form-select form-select-sm">
                                <option value="">No aggregation</option>
                                <option value="daily">Daily</option>
                                <option value="monthly">Monthly</option>
                                <option value="yearly">Yearly</option>
                            </select>
                        </div>

                        <div class="col">
                            <label for="rdatefilter" class="form-label">Date range</label>
                            <input type="text" name="datefilter" value="" class="form-select form-select-sm" />
                        </div>
                    </div>
                </div>
            </form>
            <ul id="tabs">
                <li><a id="tab1">Table</a></li>
                <li><a id="tab2">Graph</a></li>
            </ul>
            <div id="errormessage"></div>
        </div>
        <div class="container" id="tab1C">
            <style type="text/css">
                #chartbox div {
                    float: left;
                }
            </style>
            <div id="chartbox"></div>
            <div id="table" class="table">
                <table class="table table-striped table-bordered" id="jobHistory" style="width: 100%"></table>
            </div>
            <a class="btn btn-primary" style="float: right;" onclick="demomode()">Run with demo data</a>
        </div>

        <div class="container" id="tab2C" style="display: none;">
            <div id="noaggregatemessage">For graphs to be shown, you need to change the mode to "Aggregate report view".</div>
            <div id="jobchart"></div>
            <div id="memorychart"></div>
        </div>
        
    </body>
</html>
EOF

# env > /tmp/ENV.$$

vroot=$(${EF_ROOT}/plugins/fm/bin/fm.vroot.create "$spooler" "fm" $EF_SPOOLER_URI)
# vroot="`$EF_ROOT/plugins/fm/bin/fm.vroot.hash $EF_SPOOLER_URI`"
# vroot=`ls $spooler/.vroot/ | sed -e 's~.*.vroot/~~'`

dnldpath="/${EF_ROOT_CONTEXT}/download/index.html?_file=/${vroot}/index.html&amp;_spooler=${spooler}&amp;_plugin=fm"

# rename spooler 
export URI=$EF_SPOOLER_URI
${EF_ROOT}/plugins/ef/bin/ef.rename.spooler $EF_SPOOLER_URI "Tmp Job History Spooler"
# ef_reset_spooler --uri "$URI" --name "$2"

# remove spooler after about a minute 
export EF_RM_SPOOLER=$spooler
# ${EF_ROOT}/plugins/ef/bin/ef.remove.spooler $EF_RM_SPOOLER
( sleep 45 ; ${EF_ROOT}/plugins/ef/bin/ef.remove.spooler $EF_RM_SPOOLER ) & 

# echo $vroot >> /tmp/ENV.$$
# echo $dnldpath >> /tmp/ENV.$$

# ls -al $spooler >> /tmp/ENV.$$
# pwd >> /tmp/ENV.$$

# <iframe style="width: 100%; height: 800px; border: 0;" src="/ef/download/index.html?_file=%2F2c0c3c809c2bdf9b1a6ffe2af28ecf849eccb78a%2F%2Findex.html&amp;_spooler=spooler%3A%2F%2F%2Fopt%2Fnisp%2Fenginframe%2Fspoolers%2Fefadmin%2Ftmp3075300234112105650.ef&amp;_size=47188&amp;_plugin=fm">

# <div style="width: 100%; height: 800px; border: 0;"  >

cat <<EOF
<h1 id="johih1" style="padding: 9px;" >Job History</h1>
<script>
var spooler="$spooler";
var dnldpath="$dnldpath";
var encspooler = encodeURIComponent(spooler);
var encdnldpath = encodeURIComponent(dnldpath);
// console.log("spooler is '$spooler' ");
// console.log("dnldpath is '$dnldpath' " + encdnldpath);
// load full content and insert into div 
URL=dnldpath;      
// console.log(URL);

$.ajax({
    url: URL,
    type: 'GET',
    dataType: 'text',
    success: function(data) {
        // console.log('File content:', data);
	var iframe = document.getElementById('ef_jobhi');
	iframe.srcdoc = data;
    }});
</script>
<iframe id="ef_jobhi" style="width: 100%; height: 800px; border: 0;" />
EOF
# <![CDATA[
# ]]>



