#!/bin/bash

# This file is used by the installer only to read the EF configuration into Ant properties
# We specify here the prefix because Ant 1.7.1 does not support loadproperties prefix attribute

echo_properties() {
  local _prefix="$1"
  echo "${_prefix}EF_ROOT=${EF_ROOT}"
  echo "${_prefix}EF_DYNAMIC_ROOT=${EF_DYNAMIC_ROOT}"
  echo "${_prefix}EF_LICENSE_PATH=${EF_LICENSE_PATH}"
  echo "${_prefix}EF_TEMP_ROOT=${EF_TEMP_ROOT}"
  echo "${_prefix}EF_DATA_ROOT=${EF_DATA_ROOT}"
  echo "${_prefix}EF_LOGS_ROOT=${EF_LOGS_ROOT}"
  echo "${_prefix}EF_SPOOLERDIR=${EF_SPOOLERDIR}"
  echo "${_prefix}EF_REPOSITORYDIR=${EF_REPOSITORYDIR}"
  echo "${_prefix}EF_SESSION_SPOOLERDIR=${EF_SESSION_SPOOLERDIR}"
  echo "${_prefix}TOMCAT_USER=${TOMCAT_USER}"
  echo "${_prefix}JAVA_HOME=${JAVA_HOME}"
  echo "${_prefix}DERBY_CONFIGURED=${DERBY_CONFIGURED}"
  echo "${_prefix}DERBY_ADDR=${DERBY_ADDR}"
  echo "${_prefix}DERBY_PORT=${DERBY_PORT}"
}

# Source the old EF env lib
. "${EF_VERSION_ROOT}/bin/functions.sh"

# Load the EF environment
load_env > /dev/null || exit 1

# Emit the variables as properties in the stdout
echo_properties "tmp.ef.old.enginframe.conf."
