
#
################################################################################
# Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
# Copyright 1999-2023 by Nice, srl., All rights reserved.
#
# This software includes confidential and proprietary information
# of NI SP Software GmbH ("Confidential Information").
# You shall not disclose such Confidential Information
# and shall use it only in accordance with the terms of
# the license agreement you entered into with NI SP Software.
################################################################################
#################################################################################


/\r$/                   { gsub("\r$","") } # change Windows newlines to Unix
/^---/                  { skip = 0; reason = 0; mem_found = 0; next; } # start new job
/^ SCHEDULING /         { printf " "; skip = 1; reason = 0; next; }
/^ MEMORY USAGE:/       { printf " "; skip = 1; next; }
/^ [A-Z]* REASON/       { printf ">, Reasons <"; reason = 1; next; }
/^Job /                 { printf "\n\n%s", $0; next; }
/^[A-Za-z]/             { if (!reason) { sub(": ", ">, "); printf ", Event <"; }; }
/^                  /   { sub("^                     ", ""); } # remove initial spaces from the line and continue with next matching
/,$/                    { sub(",$", ", "); }
/Job$/                  { sub("Job$", "Job "); }
/Submitted from host/   { sub("[>] with hold[, ]", "\n"); }
/^The CPU time/         { printf ">, CPU <"; }

# take only first MEM matching (the cumulative one) and skip hosts specific values (if there)
/^MEM:/                 { if (!mem_found) { gsub(";", ""); printf ">, Memory <"$2" "$3">, Swap <"$5" "$6; mem_found = 1; } next; }

# take only PGID(s) and PIDs after the MEM row and skip hosts specific values (if there)
/^PGID[s]?:/            { if (!skip) { gsub(";", ""); sub("PGID[s]?: ", ""); printf ">, PGID <"$0; } next; }

# skip rows following the first empty row after the first MEM matching
# FIXME: we should relate MEM, PGIDs, PIDs to the right execution host in parallel jobs
/^$/                    { if (mem_found && !skip) { skip = 1; printf ">, " } next; }
                        { if (skip) next; printf "%s",$0; }  # print line without newline or skip it

END                     { print; }


# vi: ts=4 sw=4 et syntax=sh :
