
#
################################################################################
# Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
# Copyright 1999-2023 by Nice, srl., All rights reserved.
#
# This software includes confidential and proprietary information
# of NI SP Software GmbH ("Confidential Information").
# You shall not disclose such Confidential Information
# and shall use it only in accordance with the terms of
# the license agreement you entered into with NI SP Software.
################################################################################
#################################################################################


# Variables:
# - GRIDML_COMPRESSION
# - CLUSTER_ID
# - statusmap


BEGIN {
    printf("<grid:job-list type=\"lsf\" mode=\"array\" cluster=\"%s\" %s>" \
        , escapeXmlAttribute(CLUSTER_ID) \
        , EF_XMLNS_grid \
        )
    first = 1
    name_found = 0
    FS = "\t"

    # Read status mapping file
    while (getline < statusmap > 0) {
        split($0, fields, ":")
        s = split(fields[2], label, " ")
        for (i=1; i<=s; i++) {
            states[label[i]] = fields[1]
        }
    }
    close(statusmap)
}


END {
    if (!first) {
        print "  </grid:job>"
    }
    print "</grid:job-list>"
}


function truncate(_s) {
    if ((GRID_TAG_SIZE_LIMIT != "") && (length(_s) > GRID_TAG_SIZE_LIMIT)) {
        _s = substr(_s, 1, GRID_TAG_SIZE_LIMIT - 5)
        sub(/ [^ ]*$/, "", _s);
        return _s "[...]"
    } else {
        return _s
    }
}


/^Year/ {
    year = $2
    month_day = $3
}


/^Job *Group/ {
    if (!index(GRIDML_COMPRESSION, "group"))
        print "    <grid:group>" escapeXmlContent($2) "</grid:group>"
    next
}


/^Job Name/ {
    print "    <grid:name>" escapeXmlContent($2) "</grid:name>"
    name_found = 1
    next
}


/^Job Description/ {
    next
}


/^Job *Priority/ {
    if (!index(GRIDML_COMPRESSION, "priority"))
        print "    <grid:priority>" $2 "</grid:priority>"
    next
}

/^Job will start no sooner than indicated time/ { next }

# TBD manage multicluster jobs
/^Job[\t]* *.* forwarded to cluster .* as Job / { next }
/^Job[\t]* *.* of cluster .* accepted as Job / { next }

/^Job warning action/ { next }
/^Job action warning time/ { next }

/^Job[ \t]+[0-9]+/ {
    if (!first)
        print "  </grid:job>"
    first = 0
    if (split($2, val, "[^0-9]") > 1)
        printf ("\n  <grid:job type=\"lsf\" id=\"%s\" index=\"%s\" is-array=\"true\">", val[1], val[2])
    else
        printf ("\n  <grid:job type=\"lsf\" id=\"%s\" is-array=\"true\">",$2)
    name_found = 0
}


/^Event/ {
    gsub(" +", " ", $2)
    split($2, event, "[ :]")
    job_month_day = sprintf("%s%02s", event[2], event[3])

    # Translate months to numbers
    sub("Jan", "01", job_month_day)
    sub("Feb", "02", job_month_day)
    sub("Mar", "03", job_month_day)
    sub("Apr", "04", job_month_day)
    sub("May", "05", job_month_day)
    sub("Jun", "06", job_month_day)
    sub("Jul", "07", job_month_day)
    sub("Aug", "08", job_month_day)
    sub("Sep", "09", job_month_day)
    sub("Oct", "10", job_month_day)
    sub("Nov", "11", job_month_day)
    sub("Dec", "12", job_month_day)

    if (job_month_day > month_day)
        tmp_year = year-1
    else
        tmp_year = year

    timestamp = sprintf("month=\"%s\" day=\"%s\" hour=\"%s\" minute=\"%s\" second=\"%s\" year=\"%s\"" \
        , event[2] \
        , event[3] \
        , event[4] \
        , event[5] \
        , event[6] \
        , tmp_year \
        )
}


/^User Priority/ {
    next
}


/^User Group/ {
    next
}


/^User/ {
    if (split($2, val, "\\") > 1) {
        user = tolower(val[2])
    } else {
        user = $2
    }

    print "    <grid:owner>" escapeXmlContent(user) "</grid:owner>"
}


/^Project/ {
    print "    <grid:account>" escapeXmlContent($2) "</grid:account>"
}


/^Queue/ {
    print "    <grid:queue>" escapeXmlContent($2) "</grid:queue>"
}


/^[ \t]*Command/ {
    command = truncate($2)
    print "    <grid:command>" escapeXmlContent(command) "</grid:command>"
    if (name_found == 0) {
        # If it's a script text (streamed into the stdin)
        if (command ~ /^# *!/) {
            jobname = "[script]"
        } else {
            jobname = command
        }
        print "    <grid:name>" escapeXmlContent(jobname) "</grid:name>"
    }
    name_found = 0
}


/^[ \t]*Requested Resources/ {
    if (!index(GRIDML_COMPRESSION, "requirements"))
        print "    <grid:requirements>" escapeXmlContent($2) "</grid:requirements>"
}


/^[ \t]*Processors Requested/ {
    nppos = 1
    wcount = split($0, parallel, " ")
    for ( wi in parallel ) {
        if (parallel[wi] == "Processors") {
            nppos = (wi-1)
        }
    }

    sub("Processors", "", parallel[nppos])
    i = split(parallel[nppos], procs, "-")
    if (!index(GRIDML_COMPRESSION, "parallel"))
        print "    <grid:parallel min=\"" procs[1] "\" max=\"" procs[i] "\"/>"
}


/^Submitted from host/ {
    if (!index(GRIDML_COMPRESSION, "submission-time"))
        print "    <grid:submission-time " timestamp "/>"
    if (!index(GRIDML_COMPRESSION, "submission-host"))
        print "    <grid:submission-host>" escapeXmlContent($2) "</grid:submission-host>"
}


/^Share group charged/ {
    next
}


/^CWD/ {
    print "    <grid:submission-directory>" escapeXmlContent($2) "</grid:submission-directory>"
}


/^[\[]*[0-9]*[\]]*[ ]*[Ss]tarted on/ {
    if (array_found == 0) {
        if (!index(GRIDML_COMPRESSION, "execution-time"))
            print "    <grid:execution-time " timestamp "/>"
        gsub("><", "\n    ", $0)
        if (!index(GRIDML_COMPRESSION, "execution-host")) {
            # cleanup execution_hosts array if there
            split("", execution_hosts)
            for (i = 2; i <= NF; i++) {
                if (index($i, "*")) {
                    # parallel submission: host value is <cores>*<hostname> (e.g. 24*host1)
                    split($i, host, "*")
                    execution_hosts[host[2]] += host[1]
                }
                else {
                    execution_hosts[$i]++
                }
            }
            for (j in execution_hosts) {
                print "    <grid:execution-host cores=\"" execution_hosts[j] "\">" escapeXmlContent(j) "</grid:execution-host>"
            }
        }
    }
}


/^[ \t]*Allocated [0-9]* Slot\(s\) on Host\(s\)/ {
    if (array_found == 0) {
        if (!index(GRIDML_COMPRESSION, "execution-time"))
            print "    <grid:execution-time " timestamp "/>"
        gsub("><", "\n    ", $0)
        if (!index(GRIDML_COMPRESSION, "execution-host")) {
            # cleanup execution_hosts array if there
            split("", execution_hosts)
            for (i = 2; i <= NF; i++) {
                if (index($i, "*")) {
                    # parallel submission: host value is <cores>*<hostname> (e.g. 24*host1)
                    split($i, host, "*")
                    execution_hosts[host[2]] += host[1]
                }
                else {
                    execution_hosts[$i]++
                }
            }
            for (j in execution_hosts) {
                print "    <grid:execution-host cores=\"" execution_hosts[j] "\">" escapeXmlContent(j) "</grid:execution-host>"
            }
        }
    }
}


/^[ \t]*COUNTERS: / {
    c = split($0, counters, " ")
    print "    <grid:array-status>"
    c = (c-1)/2
    for (i=2; i<=c+1; i++) {
        status_grid = counters[i]
        status_ef = states[status_grid]
        status_value = counters[i+c]
        print "      <grid:counter grid=\"" status_grid "\" ef=\"" status_ef "\">" status_value "</grid:counter>"
    }
    print "    </grid:array-status>"
}


#
# vi: ts=4 sw=4 et syntax=awk :
#

