#!/bin/bash
#######################################
# Get GPU information
#
# Returns array:
# 0 = average UT
# 1 = average MUT
# >3 = UT GPU X
#
########################################
# . /apps/lsf_10.1/conf/profile.lsf

cmd="bhosts -gpu -l ${1}"
readarray -t val_array < <(bhosts -gpu -l ${1} 2>/dev/null | grep -A 5 'DYNAMIC ATTRIBUTES')
i=2
count=0
ut_sum=0
return_array=[]

for row in "${val_array[@]}"
do
        if [[ "$row" =~ ^[0-9] ]]; then
                row_array=($row)
                ut="${row_array[6]}"
                ut_num=${ut/"%"/""}
                ut_sum=$(( ut_sum + ut_num ))
                return_array[${i}]=$ut_num

                mut="${row_array[7]}"
                mut_num=${mut/"%"/""}
                mut_sum=$(( mut_sum + mut_num ))                                                                   
                return_array[${i}+1]=$mut_num

                i=$(( i + 2 ))
                count=$(( count + 1 ))
        fi                                                                                                         
done
if [[ ${#return_array[*]} -gt 2 ]]; then
        if [[ ut_sum -eq 0 ]] || [[ count -eq 0 ]]; then
                return_array[0]=0
        else
                return_array[0]=$(( $ut_sum / count ))
        fi

        if [[ mut_sum -eq 0 ]] || [[ count -eq 0 ]]; then
                return_array[1]=0
        else
                return_array[1]=$(( $mut_sum / count ))
        fi
fi

printf -v joined '%s,' "${return_array[@]}"
echo "${joined%,}"
# echo "${joined%,}" > "/tmp/gpu"

