#!/bin/sh

################################################################################
################################################################################
# Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
# Copyright 1999-2023 by Nice, srl., All rights reserved.
#
# This software includes confidential and proprietary information
# of NI SP Software GmbH ("Confidential Information").
# You shall not disclose such Confidential Information
# and shall use it only in accordance with the terms of
# the license agreement you entered into with NI SP Software.
################################################################################
################################################################################

# LSF plugin related actions to be executed at login time


. "${EF_ROOT}/plugins/ef/lib/utils"
ef_source_conf lsf "ef.lsf.conf"

# Check if we want to load LSF profile at login once for session
if [ "${LSF_LOAD_PROFILE}" = "login" ]; then

  if [ -z "${LSF_PROFILE}" ] ; then
    ef_error "LSF_PROFILE is not correctly defined inside ${EF_ROOT}/plugins/lsf/conf/ef.lsf.conf" \
             "Configuration Error" \
             "\${EF_ROOT}/plugins/lsf/bin/common"
  elif [ ! -r  "${LSF_PROFILE}" ] ; then    
    ef_error "Cannot source LSF profile ${LSF_PROFILE}" \
             "Configuration Error" \
             "\${EF_ROOT}/plugins/lsf/bin/common"
  else
    # Source LSF Profile
    . "${LSF_PROFILE}"

    # Save LSF environemnt in session data
    cat << EOF
    <ef:session xmlns:ef="http://www.enginframe.com/2000/EnginFrame" persistent="false">
      <ef:option id="LSF_SERVERDIR">${LSF_SERVERDIR}</ef:option>
      <ef:option id="LSF_LIBDIR">${LSF_LIBDIR}</ef:option>
      <ef:option id="LD_LIBRARY_PATH">${LD_LIBRARY_PATH}</ef:option>
      <ef:option id="LSF_BINDIR">${LSF_BINDIR}</ef:option>
      <ef:option id="BINARY_TYPE_HPC">${BINARY_TYPE_HPC}</ef:option>
      <ef:option id="XLSF_UIDDIR">${XLSF_UIDDIR}</ef:option>
      <ef:option id="LSF_ENVDIR">${LSF_ENVDIR}</ef:option>
      <ef:option id="PATH">${PATH}</ef:option>
      <ef:option id="EF_GRID_LSF_PROFILE_LOADED">login</ef:option>
    </ef:session>
EOF
  fi

fi


