
#
################################################################################
# Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
# Copyright 1999-2023 by Nice, srl., All rights reserved.
#
# This software includes confidential and proprietary information
# of NI SP Software GmbH ("Confidential Information").
# You shall not disclose such Confidential Information
# and shall use it only in accordance with the terms of
# the license agreement you entered into with NI SP Software.
################################################################################
#################################################################################


BEGIN {
    ok = 0
    unavail = 0
    closed = 0
    busy = 0
    unlicensed = 0
    unknown = 0
}


NR == 1 {
    next
}


{
    if ($2 == "ok") {
        ok++
    } else if ($2 == "unavail" || $2 == "unreach") {
        unavail++
    } else if ($2 == "closed_Full" || $2 == "closed_Excl" || $2 == "closed_Busy") {
        busy++
    } else if (index($2, "closed") == 1) {
        closed++
    } else if ($2 == "unlicensed") {
        unlicensed++
    } else {
        unknown++
    }
}


END {
    pie_values = ""
    pie_colors = ""
    pie_labels = ""

    if (ok > 0) {
        pie_values = pie_values "," ok
        pie_colors = pie_colors "," chart_ok_color
        pie_labels = pie_labels "," chart_ok_label " (" ok ")"
    }

    if (closed > 0) {
        pie_values = pie_values "," closed
        pie_colors = pie_colors "," chart_closed_color
        pie_labels = pie_labels "," chart_closed_label " (" closed ")"
    }

    if (busy > 0) {
        pie_values = pie_values "," busy
        pie_colors = pie_colors "," chart_busy_color
        pie_labels = pie_labels "," chart_busy_label " (" busy ")"
    }

    if (unavail > 0) {
        pie_values = pie_values "," unavail
        pie_colors = pie_colors "," chart_unavailable_color
        pie_labels = pie_labels "," chart_unavailable_label " (" unavail ")"
    }

    if (unlicensed > 0) {
        pie_values = pie_values "," unlicensed
        pie_colors = pie_colors "," chart_unlicensed_color
        pie_labels = pie_labels "," chart_unlicensed_label " (" unlicensed ")"
    }

    if (unknown > 0) {
        pie_values = pie_values "," unknown
        pie_colors = pie_colors "," chart_unknown_color
        pie_labels = pie_labels "," chart_unknown_label " (" unknown ")"
    }

    if (pie_values != "") {

        sub(/^ *,/, "", pie_values)
        sub(/^ *,/, "", pie_colors)
        sub(/^ *,/, "", pie_labels)

        print "<ch:chart " EF_XMLNS_ch ">"
        print "  <ch:data>"
        print "    <ch:series>" pie_values "</ch:series>"
        print "    <ch:labels>" pie_labels "</ch:labels>"
        print "  </ch:data>"
        print "  <ch:view type=\"pie\" width=\"" chart_width "\" height=\"" chart_height "\">"
        print "    <ch:option name=\"colors\">" pie_colors "</ch:option>"
        print "    <ch:option name=\"is3D\">false</ch:option>"
        print "    <ch:option name=\"legend\">bottom</ch:option>"
        print "    <ch:option name=\"legendOrientation\">vertical</ch:option>"
        print "  </ch:view>"
        print "</ch:chart>"
    }
}


#
# vi: ts=4 sw=4 et syntax=awk :
#

