BEGIN {
    tot = 0
    unavail = 0
    used = 0
    rsv = 0
}


NR == 1 {
    next
}


{
    tot = tot + $4
    if ($2 == "ok" || $2 == "closed_Full") {
        used = used + $5 + $6 + $7
        rsv = rsv + $8
    }
    else {
        unavail = unavail + $4
    }
}


END {
    avail = tot - unavail - used - rsv

    avail_color="99CC00"
    used_color="3399CC"
    rsv_color="CCCCCC"
    unavail_color="FF3333"

    printf("<ch:chart xmlns:ch=\"http://www.enginframe.com/2010/chart\">\n")
    printf("  <ch:data>\n")
    printf("    <ch:series>%d,%d,%d,%d</ch:series>\n",avail,used,reserved,unavail)
    printf("    <ch:labels>Free (%d),Busy (%d),Reserved (%d),Unavailable (%d)</ch:labels>\n",avail,used,reserved,unavail)
    printf("  </ch:data>\n")
    printf("  <ch:view type=\"pie\" width=\"%d\" height=\"%d\">\n", cw, ch)
    printf("    <ch:option name=\"is3D\">false</ch:option>\n")
    printf("    <ch:option name=\"legend\">bottom</ch:option>\n")
    printf("    <ch:option name=\"legendOrientation\">vertical</ch:option>\n")
    printf("    <ch:option name=\"colors\">%s,%s,%s,%s</ch:option>\n",avail_color,used_color,rsv_color,unavail_color)
    printf("  </ch:view>\n")
    printf("</ch:chart>\n")
}


#
# vi: ts=4 sw=4 et syntax=awk :
#

