/* 
################################################################################
# Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
# Copyright 1999-2023 by Nice, srl., All rights reserved.
#
# This software includes confidential and proprietary information
# of NI SP Software GmbH ("Confidential Information").
# You shall not disclose such Confidential Information
# and shall use it only in accordance with the terms of
# the license agreement you entered into with NI SP Software.
################################################################################
################################################################################
*/ 
/*global jQuery */
var hyPbs = {

    loadPbsOutput: function (textarea, uri, job) {
        jQuery.enginframe.invokeService({
            sdf: '/' + jQuery.enginframe.rootContext + '/pbs/grid.pbs.job.actions.xml',
            uri: uri,
            data: {
                jobid: job.jobid,
                grid: job.grid,
                cluster: job.cluster
            },
            success: function (output) {
                textarea.val(output);
            },
            dataType: 'text'
        });
    },

    qpeekDialog: function (job) {
        var dialog, textarea;
        dialog = jQuery('<div class="hy-action-dialog"/>').appendTo(jQuery('body'));
        textarea = jQuery('<textarea rows="25" readonly="readonly" style="width: 99%; height: 99%;"/>').appendTo(dialog);
        dialog.dialog({
            title: "Output of Job: " + efEncodeHtml(job.jobid),
            buttons: {
                "Close": function () {
                    jQuery(this).dialog("close");
                }
            },
            width: jQuery(80).toPx(),
            bgiframe: true,
            modal: true
        });
        hyPbs.loadPbsOutput(textarea, '//grid.pbs.job.actions/job.output', job);
    },

    tracejobDialog: function (job) {
        var dialog, textarea;
        dialog = jQuery('<div class="hy-action-dialog"/>').appendTo(jQuery('body'));
        textarea = jQuery('<textarea rows="25" readonly="readonly" style="width: 99%; height: 99%;"/>').appendTo(dialog);
        dialog.dialog({
            title: "History of Job: " + efEncodeHtml(job.jobid),
            buttons: {
                "Close": function () {
                    jQuery(this).dialog("close");
                }
            },
            width: jQuery(80).toPx(),
            bgiframe: true,
            modal: true
        });
        hyPbs.loadPbsOutput(textarea, '//grid.pbs.job.actions/job.history', job);
    }
};
