#!/bin/bash

################################################################################
################################################################################
# Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
# Copyright 1999-2023 by Nice, srl., All rights reserved.
#
# This software includes confidential and proprietary information
# of NI SP Software GmbH ("Confidential Information").
# You shall not disclose such Confidential Information
# and shall use it only in accordance with the terms of
# the license agreement you entered into with NI SP Software.
################################################################################
################################################################################
################################################################################
################################################################################
# $EF_ROOT/plugins/pbs/bin/functions.lib.sh - common functions for PBS Plugin
################################################################################

# parse the output of PBS qstat -f jobid
ef_qstat_f2xml () {
    # sed qstat -f output to join lines starting with tabs, then produce XML via awk
    [ -n "${host}" ] && _host=""
    sed -e :a -e '$!N;s/\n\t//;ta' -e 'P;D' | sed 's/    /\n/g' | "${EF_AWK}" \
        -v "hostfilter=${_host}" \
        -v "statusmap=${EF_ROOT}/plugins/pbs/conf/grid.job.status.mapping" \
        -v "PBS_CLUSTER_ID=${PBS_CLUSTER_ID}" \
        -v "GRID_TAG_SIZE_LIMIT=${GRID_TAG_SIZE_LIMIT}" \
        -v "jobid=${jobid}" \
        -f "${EF_ROOT}/plugins/ef/lib/awk/utils.awk" \
        -f "${EF_ROOT}/plugins/pbs/lib/qstat_f2xml.awk"
}

# parse the output of PBS qstat -f job array
ef_qstat_array_f2xml () {
    # sed qstat -f output to join lines starting with tabs, then produce XML via awk
    [ -n "${host}" ] && _host=""
    sed -e :a -e '$!N;s/\n\t//;ta' -e 'P;D' | sed 's/    /\n/g' | "${EF_AWK}" \
        -v "statusmap=${EF_ROOT}/plugins/pbs/conf/grid.job.status.mapping" \
        -v "PBS_CLUSTER_ID=${PBS_CLUSTER_ID}" \
        -v "GRID_TAG_SIZE_LIMIT=${GRID_TAG_SIZE_LIMIT}" \
        -v "jobid=${jobid}" \
        -f "${EF_ROOT}/plugins/ef/lib/awk/utils.awk" \
        -f "${EF_ROOT}/plugins/pbs/lib/qstat_array_f2xml.awk"
}

# parse the output of pbsnodes
ef_pbsnodes2xml () {
    "${EF_AWK}" \
    -v "PBS_CLUSTER_ID=${PBS_CLUSTER_ID}" \
    -f "${EF_ROOT}/plugins/ef/lib/awk/utils.awk" \
    -f "${EF_ROOT}/plugins/pbs/lib/pbsnodes2xml.awk"
}


jobname_sanitize() {
    local -- _jobname="${1:-$(</dev/stdin)}"

    # From "man qsub" of pbs_version = PBSPro_11.1.1.112253
    #    -N name Sets job's name to name.  Sets job's Job_Name attribute to name.  Format: string, up to 15 characters in length.
    #     It must consist of an alphabetic or numeric character followed by printable, non-white-space characters.
    #     Default:  if  a script is used to submit the job, the job's name is the name of the script.
    #     If no script is used, the job's name is "STDIN".
    printf "%s" "${_jobname}" | tr '/:@\\*?[:space:]' _ | awk '{print substr($1, i, 15)}' | sed 's/^[^a-zA-Z0-9]/_/'
}

# ex:ts=4:sw=4:et:ft=sh:
