################################################################################
# Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
# Copyright 1999-2023 by Nice, srl., All rights reserved.
#
# This software includes confidential and proprietary information
# of NI SP Software GmbH ("Confidential Information").
# You shall not disclose such Confidential Information
# and shall use it only in accordance with the terms of
# the license agreement you entered into with NI SP Software.
################################################################################
################################################################################
BEGIN {
    tot = 0;
    used = 0;
}

/^[ ]* jobs =/ {
    str = $0; gsub("^.* = ", "", str); 
    jobs = split(str, arr, " ");
    used = used + jobs;
}

/^[ ]* resources_available.ncpus =/ {
    maxcpu=$3;
    if (maxcpu >= jobs)
        tot = tot + maxcpu;
    else
        tot = tot + jobs;
}

END {
    avail = tot - used;

    avail_color="99CC00";
    used_color="3399CC";

    printf("<ch:chart xmlns:ch=\"http://www.enginframe.com/2010/chart\">\n");
    printf("  <ch:data>\n");
    printf("    <ch:series>%d,%d</ch:series>\n",avail,used);
    printf("    <ch:labels>Free (%d),Busy (%d)</ch:labels>\n",avail,used);
    printf("  </ch:data>\n");
    printf("  <ch:view type=\"pie\" width=\"%d\" height=\"%d\">\n", cw, ch);
    printf("    <ch:option name=\"is3D\">false</ch:option>\n");
    printf("    <ch:option name=\"legend\">bottom</ch:option>\n");
    printf("    <ch:option name=\"legendOrientation\">vertical</ch:option>\n");
    printf("    <ch:option name=\"colors\">%s,%s</ch:option>\n",avail_color,used_color);
    printf("  </ch:view>\n");
    printf("</ch:chart>\n");
}
