////////////////////////////////////////////////////////////////////////////////
// Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
// Copyright 1999-2023 by Nice, srl., All rights reserved.
//
// This software includes confidential and proprietary information
// of NI SP Software GmbH ("Confidential Information").
// You shall not disclose such Confidential Information
// and shall use it only in accordance with the terms of
// the license agreement you entered into with NI SP Software.
////////////////////////////////////////////////////////////////////////////////
/*global jQuery, document */
/*global CKEDITOR */
/*global clearTimeout: false, setTimeout: false, window: false */
(function ($) {
    'use strict';
    $.widget('ui.efserviceeditor', {
        options: {
            debug: false,
            changed: false,
            actionLabel: 'Submit',
            content: null,
            removeEfOptions: ''
        },
        _init: function () {
            var i, sId, self, inWheel, j, efOptToRemove;
            self = this;
            this._actionLabel = this.options.actionLabel;
            this._propsColWidth = 300;
            this._content = {};
            this.ckeditorCounter = 0;
            this.element.on('change');
            inWheel = false;

            this._properties = {
                html_id : {type: 'hidden', title: "The unique identifier of the html element, it doesn't change also if option id changes."},
                id : {type: 'string', title: "The unique identifier of the option.&#10;" +
                    "On service execution, it becomes the name of the environment variable, whose content is the current value of the option.&#10;" +
                    "It must comply with OS environment variable naming conventions. It cannot start with EF_."},
                extra : {type: 'string', title: "A short text displayed near the control (normally on the right side of the control).&#10;" +
                    "It can be used, for example, to specify measurement units."},
                altformat : {type: 'string', title: "The format of the date shown to the user.&#10;" +
                    "This allows to specify a date format to be shown to the user for selection purposes," +
                    " while a different format (the one specified with the dateformat attribute)" +
                    " is actually sent to the server behind the scenes.&#10;" +
                    "See the dateformat attribute for a full list of the possible formats."},
                accept : {type: 'string', title: "The accept attribute specifies the types of files user can upload.&#10;" +
                    "The accepted values are:&#10;" +
                    " - file_extension - A file extension starting with the '.' character, e.g: .gif, .jpg, .png, .doc&#10;" +
                    " - audio/* - All sound files are accepted&#10;" +
                    " - video/* - All video files are accepted&#10;" +
                    " - image/* - All image files are accepted&#10;" +
                    " - media_type - A valid media type, with no parameters.&#10;" +
                    "Works only on HTML 5 browsers supporting the accept attribute."},
                applet : {type: 'checkbox', title: "If selected, the file browser control is an Applet.&#10;" +
                    "Works only on browsers supporting the Java Applets."},
                'class' : {type: 'string', title: "This property assigns a class name or set of class names to the control associated with the option.&#10;" +
                    "Multiple class names must be separated by white space characters."},
                cluster : {type: 'string', title: "Select the Cluster to use to get the item list."},
                collapsed : {type: 'checkbox', title: "Specifies whether the group is initially collapsed.&#10;" +
                    "The class ef_option_group_collapsed is assigned to the fieldset associated with the option group."},
                collapsible : {type: 'checkbox', title: "Specifies whether the group is collapsible.&#10;" +
                    "The class ef_option_group_collapsible is assigned to the fieldset associated with the option group."},
                base : {type: 'string', title: "Specifies the directory from which users start browsing.&#10;" +
                    "It can contain environment variables like ${HOME}.&#10;" +
                    "If not specified, the value is set to the last visited path of any RFB option within the service, or to ${HOME}.&#10;" +
                    "By setting 'rfb-main-location' in the Class field for this option, the selected path in this RFB will be used as base path for all the RFBs in the service."},
                dateformat : {type: 'string', title: "The format of the string representing the selected date.&#10;" +
                    "It can be combinations of the following:&#10;" +
                    "d - day of month &#10;" +
                    "dd - day of month (two digit)&#10;" +
                    "o - day of year &#10;" +
                    "oo - day of year (three digit)&#10;" +
                    "D - day name short&#10;" +
                    "DD - day name long&#10;" +
                    "m - month of year &#10;" +
                    "mm - month of year (two digit)&#10;" +
                    "M - month name short&#10;" +
                    "MM - month name long&#10;" +
                    "y - year (two digit)&#10;" +
                    "yy - year (four digit)&#10;" +
                    "@ - Unix timestamp (ms since 01/01/1970)&#10;" +
                    "! - Windows ticks (100ns since 01/01/0001)&#10;" +
                    "'' - single quote&#10;" +
                    "'...' or anything else - literal text"},
                disabled : {type: 'checkbox', title: "Specifies if the control associated with the option should be disabled when the page is loaded."},
                'embedded-service' : {type: 'select', event: '_listServices'},
                filename : {type: 'string', title: "Specifies the name of the file where the contents of the multi-line text input control will be stored.&#10;" +
                    "It must be a valid filename (not a path).&#10;" +
                    "If the filename is not valid, the default filename is used and an error message is logged into the log files."},
                'grid-manager' : {type: 'string', title: "Select the Grid Manager to use to get the item list."},
                filter : {type: 'string', title: "A filter expression to select the files to be shown. As an example:&#10;" +
                    "type = 'folder' or name *= '*.zip'&#10;" +
                    "This filter selects all directories and files that end with the zip extension."},
                height : {type: 'numeric', title: "Specifies the width of the input field in number of characters or pixels."},
                'icon-trigger' : {type: 'checkbox', title: "If selected, a calendar icon is displayed on the right of the text input" +
                    " and the datepicker control is displayed only when the user clicks on such icon."},
                inline : {type: 'checkbox', title: "If selected, the control is embedded in the page instead of in an overlay or dialog."},
                label : {type: 'string', title: "The label associated with the displayed option."},
                max : {type: 'numeric', label: 'Max Chars', title: "Specifies the maximum number of characters allowed in the input field."},
                multi: {type: 'checkbox', title: "Specifies that multiple options can be selected."},
                multiple: {type: 'checkbox', title: "If present the file supports multiple file upload.&#10;" +
                    "Works only on HTML 5 browsers supporting the multiple attribute."},
                name: {type: 'string', title: 'Name'},
                'output-mode' : {type: 'select', value: ['normal', 'rest']},
                readonly : {type: 'checkbox', title: "Specifies that the control associated with the option should be read-only."},
                'result-type' : {type: 'select', value: ['text/xml', 'text/plain']},
                selected : {type: 'checkbox', title: "Specifies if the checkbox is initially checked."},
                'show-status' : {type: 'checkbox', title: "Show host status near the host name."},
                required : {type: 'checkbox', title: "Specifies if the control associated with the option must be filled out before submitting the form.&#10;" +
                    "Works only on HTML 5 browsers supporting the required attribute."},
                size : {type: 'numeric', title: "The number of visible options in the drop-down list."},
                target : {type: 'select', title: "Specifies the type of objects that can be selected.", value: ['file', 'directory', 'both']},
                title : {type: 'string'},
                value : {type: 'string', label: 'Default value'},
                vroot : {type: 'string', title: "Specifies the uri of the EnginFrame 'VRoot' to be shown in the dialog.&#10;" +
                    "When specified, navigation will be restricted to the specified vroot and the option value will be a path relative to the vroot itself.&#10;" +
                    "When omitted, the default value is file:///, which means that this RFB will be able to browse the whole file system.", value: "file:///"},
                width : {type: 'numeric', title: "Specifies the width of the input field in number of characters or pixels."},
                plugin : {type: 'string', event: '_addPluginOption'},
                priority : {type: 'select', label: 'Access', value: ['allowed to', 'denied to'], title: "Specifies the access to give to specified User Groups."},
                remote : {type: 'hidden', event: '_addRemoteOption'},
                'user-groups' : {type: 'string', label: 'User Groups', event: '_listUserGroups'}
            };

            this._listsDemoValues = {
                'dynamic-list' : '<option>value1</option><option>value2</option><option>value3</option><option>valueN</option>',
                'list-of-clusters' : '<option>cluster1</option><option>cluster2</option><option>cluster3</option>',
                'list-of-hosts' : '<option>host1</option><option>host2</option><option>host3</option><option>hostN</option>',
                'list-of-queues' : '<option>queue1 (Active, 0 jobs, 0 running)</option><option>queue2 (Active, 0 jobs, 0 running)</option><option>queue3 (Active, 0 jobs, 0 running)</option><option>queueN (Active, 0 jobs, 0 running)</option>',
                'list-of-resolutions' : '<option>resolution1</option><option>resolution2</option><option>resolution3</option>',
                'list-of-desktop-managers' : '<option>desktop-manager1</option><option>desktop-manager2</option><option>desktop-manager3</option>'
            };

            this._servicesGroups = ['Basic', 'Lists', 'File', 'All'];
            this._defaultServiceGroup = 0;
            this._allServiceGroup = '3';

            this._services = {
                info : {label: 'Info', p: 'html_id id class', group: 0},
                group : {label: 'Group', p: 'html_id id label class collapsible collapsed disabled', group: 0},
                acl: {label: 'Access Modifier', p: 'html_id id priority user-groups', group: 0},
                text : {label: 'Text', p: 'html_id id label class extra value width max disabled readonly required', group: 0},
                textarea : {label: 'Textarea', p: 'html_id id label class extra value width height disabled readonly required', group: 0},
                'boolean' : {label: 'Boolean', p: 'html_id id label class value selected disabled required', group: 0},
                'static-list': {label: 'Static List', p: 'html_id id label class extra multi size disabled required inner_options', group: 1},
                'dynamic-list': {label: 'Dynamic List', p: 'html_id id label class extra multi size disabled required embedded-service params', group: 1},
                radio : {label: 'Radio', p: 'html_id id label class disabled inner_options', group: 1},
                file : {label: 'File', p: 'html_id id class extra accept multiple label width disabled required', group: 2},
                sfu: {label: 'Single File Upload', p: 'html_id id label extra accept width filters', group: 2},
                mfu: {label: 'Multiple File Upload', p: 'html_id id label extra accept width height filters', group: 2},
                rfb: {label: 'Remote File Browsing', p: 'html_id id label class extra target multi base vroot filter width height required', group: 2},
                textfile: {label: 'Textfile', p: 'html_id id label class extra value filename width height disabled readonly required', group: 2},
                date: {label: 'Date', p: 'html_id id label class extra dateformat altformat inline icon-trigger disabled required width', group: 0},
                password : {label: 'Password', p: 'html_id id label class extra value width max disabled readonly required', group: 0},
                'list-of-clusters': {label: 'List of Clusters', p: 'html_id id label class extra size disabled plugin', group: 1},
                'list-of-hosts': {label: 'List of Hosts', p: 'html_id id label class extra size disabled show-status grid-manager cluster', group: 1},
                'list-of-queues': {label: 'List of Queues', p: 'html_id id label class extra size disabled grid-manager cluster', group: 1},
                'list-of-resolutions': {label: 'List of Display Resolutions', p: 'html_id id label extra size disabled remote', group: 1},
                'list-of-desktop-managers': {label: 'List of Desktop Managers', p: 'html_id id label class extra size disabled plugin', group: 1},
                filters : {label: '', p: 'label filter', inner: true, title: "File filters are used to restrict the files that are shown in the file select dialog. " +
                    "By default, all the user files and directories are shown in the file chooser dialog, with the exception of 'hidden' files. " +
                    "Setting one or more file filters for the mfu option, it is possible to restrict the list of files shown to the user.&#10;" +
                    "File Filter is defined by:&#10;" +
                    " - Label: The description of the filter. For example: 'JPG and GIF Images'&#10;" +
                    " - Filter: A list of globs, separated by a space. For example '*.jpg *.gif'"},
                inner_options : {label: 'Options', p: 'selected label value disabled', inner: true},
                params : {label: 'Parameters', p: 'name value', inner: true},
                actionLabel: {p: 'id label result-type output-mode edit-action', inner: true},
                serviceName: {p: 'title', inner: true}
            };

            efOptToRemove = this.options.removeEfOptions.split(",");
            for (j = 0; j < efOptToRemove.length; j++) {
                delete this._services[efOptToRemove[j]];
            }

            this._handsonColsSize = {
                'inner_options': [15, 65, 67, 66, 65],
                'params': [15, 131, 131],
                filters: [15, 65, 99, 98]
            };

            // layout
            this.element.addClass('ef-srv-edt');
            this.container = $('<div class="ef-srv-edt-cnt"></div>');
            this.container.html(
                // center
                '<div class="ef-srv-edt-col ef-srv-edt-col-center">' +
                    '<div class="ui-tabs ui-widget ui-widget-content ef-srv-edt-col-widget ui-corner-all">' +
                        '<div class="ef-srv-edt-toolbars"></div>' +
                        '<h2 class="ef-service-title" style="display: none;"></h2>' +
                        '<div class="ui-tabs ui-widget ef-srv-edt-col-cnt"></div>' +
                    '</div>' +
                '</div>' +
                '<div class="ef-srv-edt-col-right-wrapper">' +
                    '<div class="ef-srv-edt-col-right">' +
                        // service list
                        '<div class="ef-srv-edt-col ef-srv-edt-col-services">' +
                            '<div class="ui-tabs ui-widget ui-widget-content ef-srv-edt-col-widget ui-corner-all">' +
                                '<div class="ef-srv-edt-col-cnt"></div>' +
                            '</div>' +
                        '</div>' +
                        // properties
                        '<div class="ef-srv-edt-col ef-srv-edt-col-properties">' +
                            '<div class="ui-tabs ui-widget ui-widget-content ef-srv-edt-col-widget ui-corner-all">' +
                                '<div class="ui-widget-header ef-srv-edt-col-header ui-corner-all">' +
                                    '<div class="ef-srv-edt-col-header-title">Properties</div>' +
                                '</div>' +
                                '<div class="ef-srv-edt-col-cnt"></div>' +
                            '</div>' +
                        '</div>' +
                    '</div>' +
                '</div>'
            );
            this.container.appendTo(this.element);
            this.serviceCol = $('div.ef-srv-edt-col-services .ef-srv-edt-col-cnt', this.element);
            this.previewCol = $('div.ef-srv-edt-col-center .ef-srv-edt-col-cnt', this.element);
            this.propertiesCol = $('div.ef-srv-edt-col-properties .ef-srv-edt-col-cnt', this.element);

            // service groups
            this.serviceGroup = $('<div class="ef-srv-edt-services-groups"></div>');
            for (i = 0; i < this._servicesGroups.length; i += 1) {
                this.serviceGroup.append(
                    '<input type="radio" id="ef-srv-edt-services-group-' + i + '" name="ef-srv-edt-services-group" ' + (i === self._defaultServiceGroup ? ' checked' : '') + ' value="' + i + '">' +
                    '<label class="ef-srv-edt-services-group-' + i + '" for="ef-srv-edt-services-group-' + i + '">' + this._servicesGroups[i] + '</label>');
            }
            this.serviceGroup.controlgroup({
                items: {
                    "button": "input[type=button], input[type=submit], input[type=reset], input[type='radio'], button, a",
                    "controlgroupLabel": ".ui-controlgroup-label, input[type='text']",
                    "checkboxradio": "input[type='checkbox']",
                    "selectmenu": "select",
                    "spinner": ".ui-spinner-input"
                }
            });
            this.serviceGroup.change(function () {
                var mode = $(this).children(':checked').val();
                self.serviceList.css('top', 0);
                if (mode !== self._allServiceGroup) {
                    $('.ef-srv-edt-service', self.serviceList).hide();
                    $('.ef-srv-edt-service-group' + mode, self.serviceList).show();
                } else {
                    $('.ef-srv-edt-service', self.serviceList).show();
                }
            });

            // available service list
            this.serviceListCnt = $('<div class="ef-srv-edt-list-cnt"></div>');
            this.serviceList = $('<div class="ef-srv-edt-list" title="&quot;Drag & Drop&quot; or &quot;Click&quot; to add"></div>');
            for (sId in this._services) {
                if (this._services.hasOwnProperty(sId) && !this._services[sId].inner) {
                    this.serviceList.append(
                        '<div class="ef-srv-edt-service ef-srv-edt-service-' + sId + ' ef-srv-edt-service-group' + this._services[sId].group + '" data-value="' + sId + '">' +
                        '<span class="ui-icon"></span>' +
                        '<span class="ui-label">' + (this._services[sId].label || sId) + '</span>' +
                        '</div>');
                }
            }
            // show default group
            $('.ef-srv-edt-service', self.serviceList).hide();
            $('.ef-srv-edt-service-group' + self._defaultServiceGroup, self.serviceList).show();

            // ie7 nowrap
            this.serviceList.children('div.ef-srv-edt-service').draggable({
                distance: 10,
                revertDuration: 200,
                revert: 'invalid',
                connectToSortable: '.ef-srv-edt-sortable',
                helper: 'clone',
                appendTo: this.element
            });
            this.serviceList.children('div.ef-srv-edt-service').click(function () {
                self.addOption($(this), true);
            });
            this.serviceList.children('div.ef-srv-edt-service').mouseover(function () {
                $(this).addClass('ui-state-hover');
            });
            this.serviceList.children('div.ef-srv-edt-service').mouseout(function () {
                $(this).removeClass('ui-state-hover');
            });

            this.serviceList.disableSelection();

            this.serviceList.appendTo(this.serviceListCnt);

            this.serviceListCnt.appendTo(this.serviceCol);
            this.serviceCol.append('<div class="ef-srv-edt-option-clear"></div>');

            this.serviceGroup.insertBefore(this.serviceListCnt);

            // Disable automatic inline editor creation
            CKEDITOR.disableAutoInline = true;

            // div preview
            this.service = $('<div class="ef-srv-edt-preview ef-srv-edt-sortable"></div>');
            this.serviceTitle = $('<div id="ef-srv-title" class="ef-srv-title" contenteditable="true" />');
            this.serviceTitle.appendTo(this.service);
            this.service.appendTo(this.previewCol);

            this.service.sortable({
                axix: 'y',
                placeholder: 'ui-state-highlight',
                connectWith: '.ef-srv-edt-sortable',
                revert: true,
                revertDuration: 200,
                items: '.ef-srv-edt-option:not(.ef-srv-edt-option-inner_options)',
                handle: '.ui-sort-handle',
                update: function (e, ui) {
                    self.addOption(ui.item, null, true);
                    self._optionChange();
                }
            });

            this.serviceAction = $('<div class="ef-srv-edt-option ef-srv-edt-option-action ui-corner-all" title="Click to edit"' +
                                       ' opt-id="submit"' +
                                       ' opt-result-type="text/xml"' +
                                       ' opt-output-mode="normal"' +
                                       ' opt-label="' + this._actionLabel + '"' +
                                       ' data-type="actionLabel">' +
                                       '<input type="button" value="' + this._actionLabel + '" />' +
                                  '</div>');
            this.serviceAction.click(function () {
                // fire an action to open the edit action dialog
                self._editAction(this);
            });
            this.serviceAction.mouseover(function () {
                $(this).addClass('ef-srv-edt-option-over');
            });
            this.serviceAction.mouseout(function () {
                $(this).removeClass('ef-srv-edt-option-over');
            });
            this.previewCol.append(this.serviceAction);

            // properties
            this.propertiesForm = $('<form class="ef-srv-edt-form" method="post" action="" onsubmit="return false;"></form>');
            this.propertiesForm.appendTo(this.propertiesCol);

            // custom actions (triggered by the efserviceeditor.js)
            this.element.bind('updateOptions', function (event, optionName, value) {
                // Update optionName property items with the given value
                var serviceJson = self._exportJSON(true);
                self._updating = true;
                if (self.updateOptions(serviceJson, optionName, value)) {
                    self._importJSON(serviceJson, true);
                }
                else {
                    self._checkIfReady();
                }
            });

            this.setLayout();
        },
        _log: function () {
            if (this.options.debug) {
                console.log.apply(console, arguments);
            }
        },
        setLayout: function () {
            // fire a window resize to re-render layout
            $(window).trigger('resize');
        },
        addOption: function (opt, byclick, bysort, sets) {
            var self, type, item, selected, renderedOpt;
            var infoObj, labelObj, extraObj;

            self = this;
            if (!opt.attr('data-rendered')) {
                type = opt.attr('data-value');
                item = $(this.renderOption(type, opt, sets));
                if (byclick) {
                    selected = $('.ef-srv-edt-option-in-update', self.service)[0];
                    if (selected) {
                        if ($(selected).attr('data-type') === 'group' || $(selected).attr('data-type') === 'acl') {
                            $(selected).children('.ui-sortable').append(item);
                            $(selected).children('.ui-sortable').removeClass('ef-srv-edt-sortable-void');
                        } else {
                            $(selected).after(item);
                        }
                    } else {
                        $(this.service).append(item);
                    }
                } else {
                    item.replaceAll(opt);
                }

                if (type === 'info') {
                    infoObj = $('.ef-srv-edt-option-info.ck-editable.ck-to-load');
                    if (infoObj.length) {
                        CKEDITOR.inline(infoObj.attr('id'), {
                            on: {
                                instanceReady: function (ev) {
                                    var blockTags = ['div', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6',
                                                     'p', 'pre', 'li', 'blockquote', 'ul', 'ol',
                                                     'table', 'thead', 'tbody', 'tfoot', 'td', 'th'];
                                    for (var i = 0; i < blockTags.length; i++) {
                                        this.dataProcessor.writer.setRules(blockTags[i], {
                                            indent: false,
                                            breakBeforeOpen: false,
                                            breakAfterOpen: false,
                                            breakBeforeClose: false,
                                            breakAfterClose: false
                                        });
                                    }
                                    if (sets) {
                                        this.setData(sets.value);
                                    }
                                    this.setReadOnly(false);
                                    self._ckeditorReady();
                                },
                                change: function (event) {
                                    self._optionChange();
                                }
                            }
                        });
                        infoObj.removeClass('ck-to-load');
                    }
                } else {
                    // label
                    labelObj = $('.ef-srv-edt-option-label.ck-editable-inline.ck-to-load');
                    if (labelObj.length) {
                        CKEDITOR.inline(labelObj.attr('id'), {
                            keystrokes: [
                                [ CKEDITOR.SHIFT + 13, 'blur']
                            ],
                            removePlugins: 'toolbar',
                            enterMode: CKEDITOR.ENTER_BR,
                            on: {
                                instanceReady: function (event) {
                                    if (sets) {
                                        this.setData(efEncodeHtml(sets.label));
                                    }
                                    this.setReadOnly(false);
                                    self._ckeditorReady();
                                },
                                change: function (event) {
                                    var value, range;
                                    // use text() in place of getData() to avoid html entities
                                    value = $(this.container.$).text();
                                    if ($(this.element.$).hasClass('ef-srv-edt-option-inner_options-label')) {
                                        $('.ef-srv-edt-prop-table').handsontable('setDataAtCell', labelObj.parent().parent().index(), 2, value);
                                        // move cursor at the end of the text
                                        range = this.createRange();
                                        range.moveToElementEditEnd(range.root);
                                        this.getSelection().selectRanges([range]);
                                    } else {
                                        $('.ui-input-text[name=label]', self.propertiesCol).eq(0).val(value);
                                        $('.ui-input-text[name=label]', self.propertiesCol).eq(0).keyup();
                                    }
                                    self._optionChange();
                                },
                                key: function (event) {
                                    if (event.data.keyCode === 13) {
                                        event.cancel();
                                    }
                                },
                                focus: function (event) {
                                    if ($(this.element.$).hasClass('ef-srv-edt-option-inner_options-label')) {
                                        $('.ef-srv-edt-prop-table').handsontable('deselectCell');
                                    }
                                }
                            }
                        });
                        labelObj.removeClass('ck-to-load');
                    }
                    // extra
                    extraObj = $('.ef-srv-edt-option-extra.ck-editable-inline.ck-to-load');
                    if (extraObj.length) {
                        CKEDITOR.inline(extraObj.attr('id'), {
                            keystrokes: [
                                [ CKEDITOR.SHIFT + 13, 'blur']
                            ],
                            removePlugins: 'toolbar',
                            enterMode: CKEDITOR.ENTER_BR,
                            on: {
                                instanceReady: function (event) {
                                    if (sets) {
                                        this.setData(efEncodeHtml(sets.extra));
                                    }
                                    this.setReadOnly(false);
                                    self._ckeditorReady();
                                },
                                change: function (event) {
                                    // use text() in place of getData() to avoid html entities
                                    $('.ui-input-text[name=extra]', self.propertiesCol).eq(0).val($(this.container.$).text());
                                    $('.ui-input-text[name=extra]', self.propertiesCol).eq(0).keyup();
                                },
                                key: function (event) {
                                    if (event.data.keyCode === 13) {
                                        event.cancel();
                                    }
                                }
                            }
                        });
                        extraObj.removeClass('ck-to-load');
                    }

                    // value or selected
                    if (type !== 'static-list' && type !== 'inner_options') {
                        renderedOpt = $(item).children('.ef-srv-edt-option-item').children('.ef-srv-rendered-opt');
                        if (type === 'boolean') {
                            renderedOpt.change(function () {
                                // NSW $('.ui-input-checkbox[name=selected]', self.propertiesCol).attr('checked', $(this).is(':checked'));
				$('.ui-input-checkbox[name=selected]', self.propertiesCol).prop('checked', $(this).is(':checked'));
                                $('.ui-input-checkbox[name=selected]', self.propertiesCol).change();
                            });
                        } else {
                            renderedOpt.keyup(function () {
                                $('.ui-input-text[name=value]', self.propertiesCol).val($(this).val());
                                $('.ui-input-text[name=value]', self.propertiesCol).keyup();
                            });
                        }
                    }

                    // radio inner items
                    if (type === 'inner_options') {
                        renderedOpt = $(item).children('.ef-srv-edt-option-item').children('.ef-srv-rendered-opt');
                        renderedOpt.change(function () {
                            $('.ef-srv-edt-prop-table').handsontable('setDataAtCell', renderedOpt.parent().parent().index(), 1, true);
                        });
                    }

                    // insert a void option for radio, static and dynamic lists
                    if (!sets && (type === 'radio' || type === 'static-list' || type === 'dynamic-list')) {
                        item.attr('data-init', true);
                    }
                }
                if (byclick || bysort) {
                    item.click();
                }

                if (type !== 'info') {
                    $('input[name=id]', self.propertiesCol).focus();
                    $('input[name=id]', self.propertiesCol).select();
                }

                this.setLayout();
                if (!sets) {
                    this._optionChange();
                }
                return item;
            }
        },
        renderOption: function (type, returnItem, sets) {
            var self, srv, props, hostName, opt, i, handleB, copyB, trashB, codeItem = '';
            self = this;
            srv = this._services[type];
            // skip types not included in _services
            if (srv) {
                props = srv.p ? srv.p.split(' ') : null;
                hostName = $(returnItem).get(0).nodeName.toLowerCase();
                opt = $('<' + hostName + ' class="ef-srv-edt-option ef-srv-edt-option-' + type + '" data-type="' + type + '" data-host="' + hostName + '" data-rendered="true"></' + hostName + '>');

                // setting properties
                if (props) {
                    if (!sets) {
                        sets = {};
                    }
                    for (i = 0; i < props.length; i += 1) {
                        switch (props[i]) {
                        case 'label':
                            if (!sets[props[i]]) {
                                if (!srv.inner) {
                                    sets[props[i]] = srv.label;
                                } else {
                                    sets[props[i]] = '';
                                }
                            } else if (hostName === 'option') {
                                opt.html(efEncodeHtml(sets.label));
                            }
                            break;
                        case 'id':
                            if (!sets[props[i]]) {
                                sets[props[i]] = this.uniqueId(type);
                            }
                            break;
                        case 'html_id':
                            if (!sets[props[i]]) {
                                sets[props[i]] = this.htmlId(type);
                            }
                            break;
                        default:
                            if (!sets[props[i]]) {
                                sets[props[i]] = '';
                            }
                            break;
                        }
                        opt.attr('opt-' + props[i], sets[props[i]]);
                    }
                }

                if (!srv.inner) {
                    opt.addClass('ui-corner-all');
                    opt.click(function (e) {
                        if (!$(this).hasClass('ui-sortable-helper')) {
                            self.editOption(type, this);
                        }
                        e.stopImmediatePropagation();
                    });
                    opt.mouseover(function (e) {
                        $(this).addClass('ef-srv-edt-option-over');
                        $(this).children('span.ui-icon-system').css('display', 'block');
                        e.stopImmediatePropagation();
                    });
                    opt.mouseout(function (e) {
                        $(this).removeClass('ef-srv-edt-option-over');
                        $(this).children('span.ui-icon-system').css('display', 'none');
                        e.stopImmediatePropagation();
                    });

                    // sort handle
                    handleB = $('<span class="ui-icon ui-icon-system ui-icon-arrow-4 ui-sort-handle" style="display:none;" title="Drag to sort"></span>');
                    handleB.appendTo(opt);

                    // copy
                    copyB = $('<span class="ui-icon ui-icon-system ui-icon-copy" style="display:none;" title="Duplicate option"></span>');
                    copyB.click(function () {
                        var option, item;
                        option = $(this).parent();
                        item = option.clone(true);
                        item.removeClass('ef-srv-edt-option-in-update ef-srv-edt-option-over');
                        item.attr('opt-html_id', self.htmlId(option.attr('data-type')));
                        item.attr('opt-id', self.uniqueId(option.attr('data-type')));
                        if (item.attr('data-type') === 'group' || item.attr('data-type') === 'acl') {
                            item.find('.ef-srv-edt-option').each(function (index, opt) {
                                $(opt).attr('opt-html_id', self.htmlId($(opt).attr('data-type')));
                                $(opt).attr('opt-id', self.uniqueId($(opt).attr('data-type'), index));
                            });
                        }
                        $(option).after(item);

                        // If option contains ckeditors we have to re-initalize them
                        item.find('.ckeditor').each(function () {
                            var editorId, editor, editorContent, newEditorId, newEditor;

                            // save original editor info
                            editor = $(this);
                            editorId = editor.attr('id');
                            editorContent = CKEDITOR.instances[editorId].getData();

                            // destroy original editor (from 'option' object)
                            CKEDITOR.instances[editorId].destroy();

                            // change one editorId and re-initialize editors
                            newEditorId = editorId.substring(0, editorId.lastIndexOf("-") + 1) + Date.now()  + '-' + Math.floor(Math.random() * 100000);
                            editor.attr('id', newEditorId);
                            self._resetCkeditor(editorId, editorContent);
                            self._resetCkeditor(newEditorId, editorContent);
                        });
                        self._optionChange();
                    });
                    copyB.appendTo(opt);

                    // delete
                    trashB = $('<span class="ui-sort-delete ui-icon ui-icon-system ui-icon-close" style="display:none;" title="Delete option"></span>');
                    trashB.click(function () {
                        if ($(this).parent().hasClass('ef-srv-edt-option-in-update')) {
                            if ($(this).parent().next().length) {
                                $(this).parent().next().click();
                            } else if ($(this).parent().prev().length) {
                                $(this).parent().prev().click();
                            }
                        }
                        $(this).parent().remove();
                        self._optionChange();
                    });
                    trashB.appendTo(opt);

                    if ($.inArray('label', props) !== -1 && type !== 'boolean') {
                        opt.append('<div id="' + self.htmlId('label') + '" class="ef-srv-edt-option-label ckeditor ck-editable-inline ck-to-load" contenteditable="true">' + efEncodeHtml(sets.label) + '</div>');
                        self.ckeditorCounter++;
                    }
                    opt.append('<div class="ef-srv-edt-option-item"></div>');
                }

                switch (type) {
                case 'group':
                    opt.children('.ef-srv-edt-option-label').addClass('ui-widget-header ui-state-default');
                    opt.children('.ef-srv-edt-option-item').addClass('ef-srv-edt-sortable ef-srv-edt-sortable-void');
                    opt.children('.ef-srv-edt-option-item').sortable({
                        axix: 'y',
                        connectWith: '.ef-srv-edt-sortable',
                        placeholder: 'ui-state-highlight',
                        revert: true,
                        revertDuration: 200,
                        items: '.ef-srv-edt-option:not(.ef-srv-edt-option-inner_options)',
                        handle: '.ui-sort-handle',
                        update: function (e, ui) {
                            self.addOption(ui.item);
                            if ($(this).children().length) {
                                $(this).removeClass('ef-srv-edt-sortable-void');
                            } else {
                                $(this).addClass('ef-srv-edt-sortable-void');
                            }
                            self._optionChange();
                        }
                    });
                    opt.children('.ef-srv-edt-option-label').before(
                        '<span class="ui-icon ui-icon-triangle-1-e' + (sets.collapsed ? ' ui-icon-triangle-1-s' : '') +
                            ' ui-icon-collapsed-render"' + (sets.collapsible ? '' : ' style="display:none;"') + '></span>'
                    );
                    if (sets.collapsible) {
                        opt.addClass('ef-srv-edt-group-collapsible');
                    }
                    break;
                case 'acl':
                    opt.children('.ef-srv-edt-option-item').addClass('ef-srv-edt-sortable ef-srv-edt-sortable-void');
                    opt.children('.ef-srv-edt-option-item').sortable({
                        axix: 'y',
                        connectWith: '.ef-srv-edt-sortable',
                        placeholder: 'ui-state-highlight',
                        revert: true,
                        revertDuration: 200,
                        items: '.ef-srv-edt-option:not(.ef-srv-edt-option-inner_options)',
                        handle: '.ui-sort-handle',
                        update: function (e, ui) {
                            self.addOption(ui.item);
                            if ($(this).children().length) {
                                $(this).removeClass('ef-srv-edt-sortable-void');
                            } else {
                                $(this).addClass('ef-srv-edt-sortable-void');
                            }
                            self._optionChange();
                        }
                    });
                    opt.addClass(sets.priority.indexOf('allow') !== -1 ? 'ef-srv-edt-option-acl-allow' : 'ef-srv-edt-option-acl-deny');
                    break;
                case 'info':
                    opt.children('.ef-srv-edt-option-item').append('<div id="' + self.htmlId('info') + '" class="ef-srv-edt-option-info ckeditor ck-editable ck-to-load" contenteditable="true">' + (sets.value || '&nbsp;') + '</div>');
                    self.ckeditorCounter++;
                    break;
                case 'dynamic-list':
                case 'list-of-clusters':
                case 'list-of-hosts':
                case 'list-of-queues':
                case 'list-of-resolutions':
                case 'list-of-desktop-managers':
                    opt.children('.ef-srv-edt-option-item').addClass('ef-srv-rendered-opt-options');
                    codeItem = '<select class="ef-srv-rendered-opt"' +
                        (sets.disabled ? ' disabled' : '') +
                        (sets.size ? ' size="' + sets.size + '"' : '') +
                        (sets.multi ? ' multiple="true"' : '') +
                        '>';
                    if (this._listsDemoValues[type]) {
                        codeItem += this._listsDemoValues[type];
                    }
                    codeItem += '</select>';
                    break;
                case 'static-list':
                    opt.children('.ef-srv-edt-option-item').addClass('ef-srv-rendered-opt-options');
                    codeItem = '<select class="ef-srv-rendered-opt"' +
                        (sets.disabled ? ' disabled' : '') +
                        (sets.size ? ' size="' + sets.size + '"' : '') +
                        (sets.multi ? ' multiple="true"' : '') +
                        '></select>';
                    break;
                case 'radio':
                    opt.children('.ef-srv-edt-option-item').addClass('ef-srv-rendered-opt-options');
                    break;
                case 'inner_options':
                    if (hostName !== 'option') {
                        opt.append('<div class="ef-srv-edt-option-item"></div>');
                        codeItem = '<input type="radio" class="ef-srv-rendered-opt" value="' + sets.value + '"' +
                            (sets.name ? ' name="' + sets.name + '"' : '') +
                            (sets.selected ? ' checked' : '') +
                            (sets.disabled || sets.disabledRendered ? ' disabled' : '') +
                            ' />';
                        codeItem += '<div id="' + self.htmlId('label') + '" class="ef-srv-edt-option-label ef-srv-edt-option-inner_options-label ckeditor ck-editable-inline ck-to-load" contenteditable="true">' + efEncodeHtml(sets.label) + '</div>';
                        self.ckeditorCounter++;
                    } else {
                        if (sets.selected) {
                            // NSW opt.attr('selected', true);
                            opt.prop('selected', true);
                        }
                        if (sets.disabled) {
                            // NSW opt.attr('disabled', true);
                            opt.prop('disabled', true);
                        }
                    }
                    break;
                case 'sfu':
                case 'mfu':
                    opt.children('.ef-srv-edt-option-item').addClass('ef-srv-rendered-opt-options');
                    codeItem += '<span class="ui-file-upload ui-file-upload-' + type + '"></span>';
                    break;
                case 'file':
                    codeItem = '<input type="file" class="ef-srv-rendered-opt" value="' + sets.value + '" onclick="return false;"' +
                        ' size="' + (sets.width ? sets.width : '15') + '"' +
                        (sets.max ? ' maxlength="' + sets.max + '"' : '') +
                        (sets.multiple ? ' multiple' : '') +
                        (sets.disabled ? ' disabled' : '') +
                        ' readonly="readonly" />';
                    break;
                case 'rfb':
                    codeItem = '<input type="text" class="ef-srv-rendered-opt ef-srv-rendered-opt-disabled"' + (sets.multi ? ' style="display:none;"' : '') +
                        ' size="' + (sets.width ? sets.width : '15') + '"' +
                        ' readonly="readonly" />';
                    codeItem += '<textarea class="ef-srv-rendered-opt ef-srv-rendered-opt-disabled" style="resize:none;' + (!sets.multi ? 'display:none;' : '') + '"' +
                        (sets.width ? ' cols="' + sets.width + '"' : '') +
                        (sets.height ? ' rows="' + sets.height + '"' : '') +
                        ' readonly="readonly"></textarea>';
                    codeItem += '<span class="ef-srv-rendered-opt-rfb-buts" style="position:absolute;margin-left:5px;width:80px;">';
                    codeItem += '<input type="button" value="Select..." />';
                    codeItem += '<input type="button" value="Clear" class="ef-srv-rendered-opt-clear"' + (!sets.multi ? ' style="display:none;"' : '') + '" />';
                    codeItem += '</span>';
                    break;
                case 'text':
                    codeItem = '<input type="text" class="ef-srv-rendered-opt" value="' + sets.value + '" ' +
                        ' size="' + (sets.width ? sets.width : '15') + '"' +
                        (sets.max ? ' maxlength="' + sets.max + '"' : '') +
                        (sets.disabled ? ' disabled' : '') +
                        (sets.readonly ? ' readonly' : '') +
                        '/>';
                    break;
                case 'password':
                    codeItem = '<input type="password" class="ef-srv-rendered-opt" value="' + sets.value + '" ' +
                        ' size="' + (sets.width ? sets.width : '15') + '"' +
                        (sets.max ? ' maxlength="' + sets.max + '"' : '') +
                        (sets.disabled ? ' disabled' : '') +
                        (sets.readonly ? ' readonly' : '') +
                        '/>';
                    break;
                case 'textarea':
                case 'textfile':
                    codeItem = '<textarea class="ef-srv-rendered-opt" style="resize:none;"' +
                        (sets.width ? ' cols="' + sets.width + '"' : '') +
                        (sets.height ? ' rows="' + sets.height + '"' : '') +
                        (sets.disabled ? ' disabled' : '') +
                        (sets.readonly ? ' readonly' : '') +
                        '>' + sets.value + '</textarea>';
                    break;
                case 'boolean':
                    codeItem = '<input type="checkbox" class="ef-srv-rendered-opt" value="' + sets.value + '" ' + (sets.selected ? ' checked' : '') + (sets.disabled ? ' disabled' : '') + '/>';
                    codeItem += '<div id="' + self.htmlId('label') + '" class="ef-srv-edt-option-label ckeditor ck-editable-inline ck-to-load" contenteditable="true">' + efEncodeHtml(sets.label) + '</div>';
                    self.ckeditorCounter++;
                    break;
                case 'date':
                    codeItem = '<span class="ef-srv-rendered-datapick"' + (sets.inline ? ' style="display:none;"' : '') + '>';
                    codeItem += '<input type="text" class="ef-srv-rendered-opt" />';
                    codeItem += '<img class="ui-datepicker-trigger" src="../third-party/fugue-icons/icons/calendar-blue.png"' + (!sets['icon-trigger'] ? ' style="display:none;"' : '') + '>';
                    codeItem += '</span>';
                    codeItem += '<span class="ef-srv-rendered-datainline"' + (!sets.inline ? ' style="display:none;"' : '') + '>';
                    break;
                }

                if (codeItem) {
                    if (!srv.inner && type !== 'radio' && type !== 'boolean') {
                        codeItem += '<div id="' + self.htmlId('extra') + '" class="ef-srv-edt-option-extra ckeditor ck-editable-inline ck-to-load" contenteditable="true">' + (efEncodeHtml(sets.extra) || '') + '</div>';
                        self.ckeditorCounter++;
                    }
                    opt.children('.ef-srv-edt-option-item').html(codeItem);
                    if (type === 'date') {
                        opt.find('.ef-srv-rendered-datainline').datepicker({changeMonth: true, changeYear: true});
                    }
                }
                if (hostName !== 'option') {
                    opt.append('<hr class="ef-srv-edt-option-clear" />');
                }
                return opt;
            }
        },
        editOption: function (type, opt) {
            var self, propItem, labelStr, inputField, innerTable, innerTitle, innerProps, i, y, props, myProp, myValues, myProps, myHeaders, myColumns, tdDel;
            self = this;
            opt = $(opt);
            if (opt.hasClass('ef-srv-edt-option-in-update')) {
                return;
            }

            $('.ef-srv-edt-col-header-title').html('Properties: ' + (this._services[type].label || ''));
            this.propertiesForm.html('');
            $('.ef-srv-edt-option-in-update', this.previewCol).removeClass('ef-srv-edt-option-in-update');
            opt.addClass('ef-srv-edt-option-in-update');
            props = this._services[type].p ? this._services[type].p.split(' ') : null;
            if (props) {
                for (i = 0; i < props.length; i += 1) {
                    // filters, radio, list
                    if (this._services[props[i]]) {
                        innerTitle = this._services[props[i]].title? '<span class="ef-srv-edt-prop-help"><i class="fa fa-question-circle" title="' + this._services[props[i]].title + '" /></span>' : '';
                        this.propertiesForm.append('<div class="ef-srv-edt-prop-title">' + (this._services[props[i]].label || self._formatLabel(props[i])) + innerTitle + '</div>');
                        innerTable = $('<div class="ef-srv-edt-prop-table ef-srv-edt-prop-table-' + props[i] + '"></div>');
                        innerProps = this._services[props[i]].p ? this._services[props[i]].p.split(' ') : null;
                        myHeaders = ['&nbsp;'];
                        myColumns = [{
                            data : 'funs',
                            readOnly : true,
                            renderer : function (instance, td) {
                                $(td).html('<span style="display:none;" class="ui-icon ui-icon-close" title="Delete"></span>');
                                return td;
                            }
                        }];
                        myProps = [];
                        opt.find('.ef-srv-edt-option-' + props[i]).each(function (index, el) {
                            el = $(el);
                            myProp = {};
                            myValues = {};
                            for (y = 0; y < innerProps.length; y += 1) {
                                $.extend(true, myProp, self._properties[innerProps[y]]);
                                if (index === 0) {
                                    myHeaders.push(self._formatLabel(innerProps[y]));
                                    myColumns.push({data : innerProps[y], type : myProp.type !== 'string' ? myProp.type : null});
                                }
                                myValues[innerProps[y]] = el.attr('opt-' + innerProps[y]);
                                myValues.node = el;
                                myValues.type = myProp.type;
                                if (myProp.type === 'checkbox' && !el.attr('opt-' + innerProps[y])) {
                                    myValues[innerProps[y]] = false;
                                }
                            }
                            myProps.push(myValues);
                        });

                        if (myProps.length) {
                            innerTable.appendTo(this.propertiesForm);

                            innerTable.handsontable({
                                colHeaders: myHeaders,
                                colWidths: self._handsonColsSize[props[i]],
                                stretchH: 'all',
                                currentRowClassName: 'ef-srv-edt-prop-table-selected',
                                columns: myColumns,
                                data: myProps,
                                fillHandle: false,
                                beforeChange: function (changes) {
                                    var y, z, data, docActiveElement = document.activeElement;
                                    data = innerTable.data('handsontable').getData();
                                    for (y = 0; y < changes.length; y += 1) {
                                        if (changes[y][1] === 'selected' && (props[i] === 'filters' || type === 'radio' || !opt.attr('opt-multi')) && (changes[y][3] === true || changes[y][3] === 'true')) {
                                            for (z = 0; z < data.length; z += 1) {
                                                if (data[z][changes[y][1]] === true || data[z][changes[y][1]] === 'true') {
                                                    data[z][changes[y][1]] = false;
                                                    self.saveProperty({name: changes[y][1], value: false, type: myProps[changes[y][0]].type}, myProps[changes[y][0]].node, !$(docActiveElement).hasClass('ck-edit-focus'));
                                                }
                                            }
                                        }
                                    }
                                    innerTable.data('handsontable').loadData(data);
                                },
                                afterChange: function (changes, source) {
                                    var y;
                                    if (source !== 'loadData') {
                                        for (y = 0; y < changes.length; y += 1) {
                                            self.saveProperty({name: changes[y][1], value: changes[y][3], type: myProps[changes[y][0]].type}, myProps[changes[y][0]].node, true);
                                        }
                                    }
                                },
                                afterInit: function () {
                                    innerTable.find('tbody tr').mouseover(function () {
                                        $(this).find('.ui-icon-close').show();
                                    });
                                    innerTable.find('tbody tr').mouseout(function () {
                                        $(this).find('.ui-icon-close').hide();
                                    });
                                },
                                beforeRemoveRow: function (index) {
                                    var data;
                                    data = innerTable.data('handsontable').getData();
                                    data[index].node.remove();
                                },
                                afterRemoveRow: function (index) {
                                    if (!innerTable.data('handsontable').getData().length) {
                                        innerTable.remove();
                                    }
                                    self.setLayout();
                                },
                                afterRender: function () {
                                    innerTable.find('tbody tr .ui-icon-close').click(function () {
                                        innerTable.handsontable('alter', 'remove_row', $(this).parent().parent().index());
                                        self._optionChange();
                                    });
                                }
                            });
                        }

                        propItem = $('<div class="ef-srv-edt-prop ef-srv-edt-prop-buttons"></div>');
                        inputField = $('<button data-value="' + props[i] + '">Add</button>').button({icon: 'ui-icon-circle-plus'});
                        inputField.click(function () {
                            var inner, selected;
                            selected = innerTable.handsontable('getSelected');

                            if ($(this).attr('data-value') === 'inner_options' && type !== 'radio') {
                                inner = $('<option data-value="' + $(this).attr('data-value') + '"></option>');
                                if (selected && selected[0] !== false) {
                                    inner.insertAfter(opt.children('.ef-srv-rendered-opt-options').children('.ef-srv-rendered-opt').children('option')[selected[0]]);
                                } else {
                                    opt.children('.ef-srv-rendered-opt-options').children('.ef-srv-rendered-opt').append(inner);
                                }
                            } else {
                                inner = $('<div data-value="' + $(this).attr('data-value') + '"></div>');
                                if (selected && selected[0] !== false) {
                                    inner.insertAfter(opt.children('.ef-srv-rendered-opt-options').children('.ef-srv-edt-option-' + $(this).attr('data-value'))[selected[0]]);
                                } else {
                                    opt.children('.ef-srv-rendered-opt-options').append(inner);
                                }
                            }
                            self.addOption(inner);

                            // refresh table
                            $(opt).removeClass('ef-srv-edt-option-in-update');
                            $(opt).click();
                        });
                        inputField.appendTo(propItem);
                        propItem.append('<div class="ef-srv-edt-option-clear"></div>');
                        propItem.appendTo(this.propertiesForm);
                    } else {
                        propItem = $('<div class="ef-srv-edt-prop' + (this._properties[props[i]].type === 'button' ? ' ef-srv-edt-prop-button' : '') + '"></div>');
                        if (this._properties[props[i]].type !== 'button') {
                            labelStr = this._formatLabel(this._properties[props[i]].label || props[i]) + (this._properties[props[i]].type !== 'checkbox' ? ':' : '');
                            propItem.append('<label for="' + props[i] + '">' + labelStr + '</label>');
                        }
                        inputField = $(this.renderInput(this._properties[props[i]], props[i], opt.attr('opt-' + props[i]), type));
                        switch (this._properties[props[i]].type) {
                        case 'numeric':
                        case 'string':
                            inputField.on('blur', function (e) {
                                self.saveProperty(this, opt, true);
                            });
                            inputField.keyup(function (e) {
                                var that = this;
                                self.saveProperty(that, opt, $(e.target).is(':focus'));
                                self._optionChange();
                            });
                            inputField.change(function () {
                                self.saveProperty(this, opt, true);
                                self._optionChange();
                            });
                            break;
                        default:
                            inputField.change(function (e) {
                                self.saveProperty(this, opt, $(e.target).is(':focus'));
                            });
                            break;
                        }
                        inputField.appendTo(propItem);
                        propItem.append('<div class="ef-srv-edt-option-clear"></div>');
                        propItem.appendTo(this.propertiesForm);
                        if (this._properties[props[i]].event) {
                            if (props[i] === 'user-groups') {
                                // prepare layout for the event
                                inputField.height('10em');
                            }
                            self[this._properties[props[i]].event]();
                        }
                        if (this._properties[props[i]].type === 'select' && this._properties[props[i]].value) {
                            $("select[name='" + props[i] + "']").change();
                        }
                        if (this._properties[props[i]].type === 'hidden') {
                            propItem.css('display', 'none');
                        }
                        // manage mfu specific properties
                        if (props[i] === 'applet') {
                            inputField.change(function () {
                                if (opt.attr('opt-applet') !== undefined && opt.attr('opt-applet') !== "true") {
                                    self.disableProperties($('input[name="base"], select[name="target"]'), "Only available with 'applet' mode enabled");
                                }
                                else {
                                    self.enableProperties($('input[name="base"], select[name="target"]'));
                                }
                            });
                        }
                        if (props[i] === 'target' || props[i] === 'base') {
                            // don't disable for rfb options
                            if (opt.attr('opt-applet') !== undefined && opt.attr('opt-applet') !== "true") {
                                this.disableProperties($('input[name="base"], select[name="target"]'), "Only available with 'applet' mode enabled");
                            }
                            else {
                                this.enableProperties($('input[name="base"], select[name="target"]'));
                            }
                        }
                        // manage option-group specific properties
                        if (props[i] === 'collapsible') {
                            // disable collapsed property if collapsible is not enabled
                            inputField.change(function () {
                                if (opt.attr('opt-collapsible') !== undefined && opt.attr('opt-collapsible') === "true") {
                                    self.enableProperties($('input[name="collapsed"]'));
                                }
                                else {
                                    self.disableProperties($('input[name="collapsed"]'), "Only available with 'collapsible' mode enabled");
                                }
                            });
                        }
                        if (props[i] === 'collapsed') {
                            if (opt.attr('opt-collapsible') !== undefined && opt.attr('opt-collapsible') === "true") {
                                this.enableProperties($('input[name="collapsed"]'));
                            }
                            else {
                                this.disableProperties($('input[name="collapsed"]'), "Only available with 'collapsible' mode enabled");
                            }
                        }
                    }
                }
                $('.ef-srv-edt-col-properties', this.container).show();
                this.setLayout();
            }
            // insert a void option for radio, static and dynamic lists
            if (opt.attr('data-init')) {
                opt.attr('data-init', null);
                inputField.click();
            }
        },
        updateOptions: function (jsonObj, name, value) {
            var self, options, changed;

            self = this;
            options = jsonObj.options;
            changed = false;
            jQuery.each(options, function (optKey, optValue) {
                if (options[optKey][name] !== undefined) {
                    options[optKey][name] = value;
                    changed = true;
                }
                if (options[optKey].options) {
                    changed = changed || self.updateOptions(options[optKey], name, value);
                }
            });
            return changed;
        },
        disableProperties: function (props, title) {
            props.prop('disabled', true).parent().addClass('ef-srv-ide-component-disabled').prop('title', title ? title : '');
        },
        enableProperties: function (props, title) {
            props.prop('disabled', false).parent().removeClass('ef-srv-ide-component-disabled').prop('title', title ? title : '');
        },
        uniqueId: function (type, index) {
            var cnt = 1;
            while ($('.ef-srv-edt-option[opt-id=' + type.replace(/-/g, '_') + '_' + cnt + ']', this.service).length) {
                cnt += 1;
            }
            if (index) {
                cnt = cnt + index;
            }
            return type.replace(/-/g, '_') + '_' + cnt;
        },
        htmlId: function (type) {
            return 'ef-srv-edt-option-' + type + '-' + Date.now()  + '-' + Math.floor(Math.random() * 100000);
        },
        saveProperty: function (item, opt, syncRender) {
            var self, err, field, value, rege;
            self = this;
            err = '';
            // handsontable save
            if ($.isPlainObject(item)) {
                field = item.name;
                value = item.value === false ? '' : item.value;
            } else {
                field = $(item).attr('name');
                value = (($(item).attr('type') === 'checkbox' || $(item).attr('type') === 'radio') && !$(item).is(':checked')) ? '' : $(item).val();
                $(item).next('.ui-state-error-text').remove();
                $(item).removeClass('ui-state-error');

                if ($(item).hasClass('ui-input-numeric')) {
                    rege = /^[0-9]*$/;
                    if (!rege.test(value)) {
                        err = 'This must be a number';
                    }
                }

                // type radio and lint single select sync value
                if ($(item).attr('type') === 'radio') {
                    $(opt).parent().children('.ef-srv-edt-option').attr('opt-' + field, '');
                    $(opt).parent().children('.ef-srv-edt-option').attr(field, null);
                    if (opt.attr('data-type') === 'inner_options' && opt.attr('data-host') !== 'option') {
                        $(opt).parent().find('.ef-srv-rendered-opt').attr('checked', null);
                    }
                }
            }

            switch (field) {
            case 'id':
                if (value !== opt.attr('opt-' + field)) {
                    rege = /^[_a-zA-Z][_a-zA-Z0-9]*$/;
                    if (!value) {
                        err = 'Not allowed empty';
                    } else if (!rege.test(value)) {
                        err = 'Wrong format';
                    } else if ($('.ef-srv-edt-option[opt-id=' + value + ']', this.service).length) {
                        err = 'Duplicated id';
                    }
                }
                break;
            case 'label':
                if ($(opt).attr('data-type') === 'actionLabel') {
                    if (!value) {
                        err = 'Not allowed empty';
                    } else {
                        $(opt).children().val(value);
                    }
                } else if ($(opt).attr('data-host') === 'option') {
                    $(opt).html(efEncodeHtml(value));
                } else if (syncRender) {
                    $(opt).find(".ef-srv-edt-option-label.cke_editable").first().text(value);
                }
                break;
            case 'extra':
                if (syncRender) {
                    $(opt).find(".ef-srv-edt-option-extra.cke_editable").first().text(value);
                }
                break;
            case 'class':
                rege = /-?[_a-zA-Z]+[_a-zA-Z0-9\-]*$/;
                if (value && !rege.test(value)) {
                    err = 'Wrong format';
                }
                break;
            case 'value':
                if ($(opt).attr('data-host') === 'option') {
                    $(opt).val(value);
                } else if (syncRender || $(opt).attr('data-type') === 'inner_options') {
                    $(opt).find(".ef-srv-rendered-opt").first().val(value);
                }
                break;
            case 'title':
                if (!value) {
                    err = 'Not allowed empty';
                } else if (syncRender) {
                    $(".ef-srv-title.cke_editable").first().text(value);
                    self._updateTitle(value);
                }
                break;
            case 'width':
                if (!err) {
                    if ($(opt).attr('data-type') === 'textarea' || $(opt).attr('data-type') === 'textfile' || ($(opt).attr('data-type') === 'rfb' && $(opt).attr('opt-multi') === 'true')) {
                        $($(opt).find('.ef-srv-rendered-opt')).attr('cols', value);
                    } else {
                        $($(opt).find('.ef-srv-rendered-opt')).attr('size', value);
                    }
                }
                break;
            case 'height':
                if (!err) {
                    if ($(opt).attr('data-type') === 'textarea' || $(opt).attr('data-type') === 'textfile' || $(opt).attr('data-type') === 'rfb') {
                        $($(opt).find('.ef-srv-rendered-opt')).attr('rows', value);
                    } else {
                        $($(opt).find('.ef-srv-rendered-opt')).css('height', value);
                    }
                }
                break;
            case 'max':
                $($(opt).find('.ef-srv-rendered-opt')[0]).attr('maxlength', value);
                break;
            case 'disabled':
                if ($(opt).attr('data-type') === 'group') {
                    $($(opt).find('.ef-srv-rendered-opt')).attr('disabled', value || null);
                    $($(opt).find('.ef-srv-edt-option[opt-disabled]')).attr('opt-disabled', value || '');
                } else if ($(opt).attr('data-host') === 'option') {
                    $(opt).attr('disabled', value || null);
                } else {
                    $($(opt).find('.ef-srv-rendered-opt')).attr('disabled', value || null);
                }
                break;
            case 'readonly':
                if ($(opt).attr('data-type') === 'group') {
                    $($(opt).find('.ef-srv-rendered-opt')).attr('readonly', value || null);
                    $($(opt).find('.ef-srv-edt-option[opt-readonly]')).attr('opt-readonly', value || '');
                } else {
                    $($(opt).find('.ef-srv-rendered-opt')[0]).attr('readonly', value || null);
                }
                break;
            case 'collapsible':
                if (value) {
                    $(opt).addClass('ef-srv-edt-group-collapsible');
                    $(opt).children('.ui-icon-collapsed-render').show();
                } else {
                    $(opt).removeClass('ef-srv-edt-group-collapsible');
                    $(opt).children('.ui-icon-collapsed-render').hide();
                }
                break;
            case 'collapsed':
                if (value) {
                    $(opt).children('.ui-icon-collapsed-render').addClass('ui-icon-triangle-1-s');
                } else {
                    $(opt).children('.ui-icon-collapsed-render').removeClass('ui-icon-triangle-1-s');
                }
                break;
            case 'selected':
                if ($(opt).attr('data-host') === 'option') {
                    if (!$(opt).parent().attr('multiple')) {
                        // if multi = false remove selected attribute from other options
                        $(opt).parent().find('option[selected="selected"]').attr('selected', null).attr('opt-selected', false);
                    }
                    $(opt).attr('selected', value || null);
                } else if ($(opt).attr('data-type') === 'boolean' && syncRender) {
                    $(opt).find('.ef-srv-rendered-opt').attr('checked', value || null);
                } else if ($(opt).attr('data-type') === 'inner_options') {
                    if (value) {
                        $(opt).find('.ef-srv-rendered-opt').attr('checked', value);
                    }
                    else {
                        $(opt).parent().find('.ef-srv-rendered-opt').attr('checked', false).parent().parent().attr('opt-selected', '');
                    }
                }
                break;
            case 'icon-trigger':
                $(opt).find('.ui-datepicker-trigger').css('display', value ? 'inline' : 'none');
                break;
            case 'inline':
                if (value) {
                    $(opt).find('.ef-srv-rendered-datapick').hide();
                    $(opt).find('.ef-srv-rendered-datainline').show();
                } else {
                    $(opt).find('.ef-srv-rendered-datapick').show();
                    $(opt).find('.ef-srv-rendered-datainline').hide();
                }
                break;
            case 'multi':
                if ($(opt).attr('data-type') === 'rfb') {
                    if (value) {
                        $(opt).find('input.ef-srv-rendered-opt').hide();
                        $(opt).find('textarea.ef-srv-rendered-opt').show();
                        $(opt).find('input.ef-srv-rendered-opt-clear').show();
                    } else {
                        $(opt).find('input.ef-srv-rendered-opt').show();
                        $(opt).find('textarea.ef-srv-rendered-opt').hide();
                        $(opt).find('input.ef-srv-rendered-opt-clear').hide();
                    }
                } else {// sync option
                    opt.attr('opt-' + field, value);
                    $(opt).find('.ef-srv-rendered-opt').attr('multiple', value || null);
                    $(opt).removeClass('ef-srv-edt-option-in-update');
                    if (!value) {
                        // if multi = false set selected attribute only to the first element
                        $('.ef-srv-rendered-opt option[selected="selected"]').removeAttr('selected').attr('opt-selected', false);
                        $(".ef-srv-rendered-opt option:first").attr('selected', true).attr('opt-selected', true);
                    }
                    $(opt).click();
                    return;
                }
                break;
            case 'size':
                if (!err) {
                    $($(opt).find('.ef-srv-rendered-opt')).attr('size', value || 1);
                }
                break;
            // lists special type
            case 'embedded-service':
                if (!value) {
                    err = 'Not allowed empty';
                }
                if (value && value !== opt.attr('opt-' + field)) {
                    rege = /^[_\/a-zA-Z][_\/a-zA-Z0-9.]*$/;
                    if (!rege.test(value)) {
                        err = 'Wrong format';
                    }
                }
                break;
            case 'name':
            case 'grid-manager':
            case 'cluster':
                if (value && value !== opt.attr('opt-' + field)) {
                    rege = /^[_a-zA-Z][_a-zA-Z0-9.\-]*$/;
                    if (!rege.test(value)) {
                        err = 'Wrong format';
                    }
                }
                break;
            case 'priority':
                if (value.indexOf('allow') !== -1) {
                    jQuery(opt).addClass('ef-srv-edt-option-acl-allow').removeClass('ef-srv-edt-option-acl-deny');
                }
                else {
                    jQuery(opt).addClass('ef-srv-edt-option-acl-deny').removeClass('ef-srv-edt-option-acl-allow');
                }
                break;
            }

            if (err) {
                $(item).addClass('ui-state-error');
                $(item).after('<b class="ui-state-error-text">' + err + '</b>');
            } else {
                // exportItem function will get the opt-<field> value
                opt.attr('opt-' + field, value);
            }
            self.setLayout();
        },
        renderInput: function (field, name, value, optType) {
            var code, type, help, i, self;
            self = this;
            code = '';
            type = field.type;
            help = (field.title && !(optType === 'info' && name === 'id')) ? ' <span class="ef-srv-edt-prop-help"><i class="fa fa-question-circle" title="' + field.title + '"/></span>' : '';

            switch (type) {
            case 'hidden':
            case 'string':
            case 'numeric':
                if ((optType === 'textarea' || optType === 'textfile') && name === 'value') {
                    code += '<textarea name="' + name + '" class="ui-widget-content ui-input ui-input-text ui-input-' + type + '" style="resize:none;">' + value + '</textarea>' + help;
                } else {
                    if (value) {
                        value = value.replace(/"/g, '&quot;');
                    }
                    else if (field.value) {
                        value = field.value.replace(/"/g, '&quot;');
                    }
                    code += '<input type="text" name="' + name + '"' +
                        ' class="ui-widget-content ui-input ui-input-text ui-input-' + type + '"' +
                        ' value="' + (value || '') + '" />' + help;
                }
                break;
            case 'checkbox':
            case 'radio':
                code += '<input type="' + type + '" name="' + name + '"' +
                    ' class="ui-widget-content ui-input ui-input-checkbox ui-input-' + type + '"' +
                    ((field.value || "true") === value ? ' checked' : '') +
                    ' value="' + (field.value || true) + '" />' + help;
                break;
            case 'select':
                if (field.value) {
                    code += '<select name="' + name + '" class="ui-widget-content ui-input ui-input-select ui-input-' + type + '">' + help;
                    for (i = 0; i < field.value.length; i += 1) {
                        code += '<option value="' + field.value[i] + '"' + (field.value[i] === value ? ' selected' : '') + '>' + field.value[i] + '</option>';
                    }
                    code += '</select>';
                }
                else if (field.event) {
                    code += '<select name="' + name + '" class="ui-widget-content ui-input ui-input-select ui-input-' + type + '">' + help;
                    code += '<option value="' + value + '"' + ' selected' + '></option>';
                    code += '</select>';
                }
                break;
            default:
                code += 'Unknow type "' + type + '"';
                break;
            }
            return code;
        },
        _formatLabel: function (str) {
            return str.replace('-', ' ').replace(/(?:^|\s)\w/g, function (match) {
                return match.toUpperCase();
            });
        },
        _destroy: function () {
            this.element.removeClass('ef-srv-edt');
            this.element.html('');
        },
        _importJSON: function (value, raw) {
            var action, opt, self, titleEd;

            self = this;
            this._content = raw ? value : $.parseJSON(value);
            // actions
            if (this._content.actions[0]) {
                action = this._content.actions[0];
                for (opt in action) {
                    if (action.hasOwnProperty(opt)) {
                        this.serviceAction.attr('opt-' + opt, action[opt]);
                    }
                }
                this.serviceAction.children('input[type=button]').val(action.label);
            }
            // options
            this.service.children('.ef-srv-edt-option').remove();
            if (this._content.options && this._content.options.length) {
                this._importItem(this._content.options, this.service, null);
            }
            // name
            titleEd = CKEDITOR.instances['ef-srv-title'];
            if (!titleEd) {
                self.ckeditorCounter++;
                CKEDITOR.inline('ef-srv-title', {
                    keystrokes: [
                        [ CKEDITOR.SHIFT + 13, 'blur']
                    ],
                    removePlugins: 'toolbar',
                    enterMode: CKEDITOR.ENTER_BR,
                    on: {
                        instanceReady: function (event) {
                            $(this.container.$).click(function () {
                                self.editOption('serviceName', this);
                            });
                            this.setData(efEncodeHtml(self._content.name));
                            this.setReadOnly(false);
                            self._ckeditorReady();
                        },
                        change: function (event) {
                            // use text() in place of getData() to avoid html entities
                            var val = $(this.container.$).text();
                            $('.ui-input-text[name=title]', self.propertiesCol).val(val);
                            $('.ui-input-text[name=title]', self.propertiesCol).keyup();
                            self._updateTitle(val);
                        },
                        key: function (event) {
                            if (event.data.keyCode === 13) {
                                event.cancel();
                            }
                        }
                    }
                });
            }
            else {
                titleEd.setData(efEncodeHtml(this._content.name));
            }
            this.serviceTitle.attr('opt-class', this._content['class']);
            this.serviceTitle.attr('opt-title', this._content.name);
            this._checkIfReady();
        },
        _importItem: function (options, parentNode, parentType) {
            var i, option, item;

            for (i in options) {
                if (options.hasOwnProperty(i)) {
                    option = options[i];
                    if (!option.type) {
                        switch (parentType) {
                        case 'static-list':
                            option.type = 'inner_options';
                            item = $('<option data-value="' + option.type + '"></option>');
                            parentNode.children('.ef-srv-rendered-opt-options').children('.ef-srv-rendered-opt').append(item);
                            break;
                        case 'radio':
                            if (parentNode.attr('opt-disabled')) {
                                option.disabledRendered = true;
                            }
                            option.name = parentNode.attr('opt-id');
                            option.type = 'inner_options';
                            item = $('<div data-value="' + option.type + '" />');
                            parentNode.children('.ef-srv-rendered-opt-options').append(item);
                            break;
                        case 'sfu':
                        case 'mfu':
                            option.type = 'filters';
                            item = $('<div data-value="' + option.type + '" />');
                            parentNode.children('.ef-srv-rendered-opt-options').append(item);
                            break;
                        case 'dynamic-list':
                            option.type = 'params';
                            item = $('<div data-value="' + option.type + '" />');
                            parentNode.children('.ef-srv-rendered-opt-options').append(item);
                            break;
                        }
                    } else {
                        item = $('<div data-value="' + option.type + '" />');
                        parentNode.append(item);
                    }

                    item = this.addOption(item, null, null, option);
                    // children
                    if (option.options) {
                        if (option.type === 'group' || option.type === 'acl') {
                            item.children('.ef-srv-edt-option-item').removeClass('ef-srv-edt-sortable-void');
                            this._importItem(option.options, item.children('.ef-srv-edt-option-item'), option.type);
                        } else {
                            this._importItem(option.options, item, option.type);
                        }
                    }
                    if (option.filters) {
                        this._importItem(option.filters, item, option.type);
                    }
                    if (option.params) {
                        this._importItem(option.params, item, option.type);
                    }
                }
            }
        },
        _exportJSON: function (raw) {
            var self = this;
            this._exportingContent = {
                name: this.serviceTitle.attr('opt-title'),
                'class': this.serviceTitle.attr('opt-class'),
                options: [],
                actions: [self._exportItem($('.ef-srv-edt-option-action', self.previewCol))]
            };
            this.service.children('.ef-srv-edt-option').each(function (index, opt) {
                self._exportingContent.options.push(self._exportItem($(opt)));
            });
            return raw ? this._exportingContent : JSON.stringify(this._exportingContent);
        },
        _exportItem: function (opt) {
            var self, optObj, type, pInfo, srv, props, i, ckEdtStr, value, defaultValue;

            self = this;
            optObj = {};
            type = opt.attr('data-type');
            srv = this._services[type];
            props = srv.p ? srv.p.split(' ') : null;

            for (i = 0; i < props.length; i += 1) {
                pInfo = this._properties[props[i]] ? this._properties[props[i]].type : 'inner';
                switch (pInfo) {
                case 'inner':
                    break;
                case 'checkbox':
                    optObj[props[i]] = (opt.attr('opt-' + props[i]) === 'true');
                    break;
                case 'string':
                    value = (opt.attr('opt-' + props[i]));
                    if (value) {
                        optObj[props[i]] = value;
                    } else {
                        defaultValue = this._properties[props[i]].value;
                        optObj[props[i]] = (defaultValue) ? defaultValue : value;
                    }
                    break;
                default:
                    optObj[props[i]] = opt.attr('opt-' + props[i]);
                    break;
                }
                if (props[i] === 'id' && type !== 'actionLabel') {
                    optObj.type = type;
                }
            }

            switch (type) {
            case 'group':
                optObj.options = [];
                opt.children('.ef-srv-edt-option-item').children('.ef-srv-edt-option').each(function (index, opt2) {
                    optObj.options.push(self._exportItem($(opt2)));
                });
                break;
            case 'acl':
                optObj.options = [];
                opt.children('.ef-srv-edt-option-item').children('.ef-srv-edt-option').each(function (index, opt2) {
                    optObj.options.push(self._exportItem($(opt2)));
                });
                break;
            case 'info':
                if (CKEDITOR.instances[opt.find('.ef-srv-edt-option-info').attr('id')]) {
                    optObj.value = CKEDITOR.instances[opt.find('.ef-srv-edt-option-info').attr('id')].getData().replace(/&nbsp;/g, '&#160;');
                } else {
                    // if ckEdt is not yet initialized, we have to get content by hand
                    ckEdtStr = $(opt.find('.ef-srv-edt-option-info')).html();
                    optObj.value = ckEdtStr.replace(/&/g, "&amp;").replace(/>/g, "&gt;").replace(/</g, "&lt;").replace(/"/g, "&quot;").replace(/<br>/g, '<br/>');
                }
                break;
            case 'static-list':
            case 'radio':
                optObj.options = [];
                opt.find('.ef-srv-edt-option').each(function (index, opt2) {
                    optObj.options.push(self._exportItem($(opt2)));
                });
                break;
            case 'sfu':
            case 'mfu':
                optObj.filters = [];
                opt.find('.ef-srv-edt-option').each(function (index, opt2) {
                    optObj.filters.push(self._exportItem($(opt2)));
                });
                break;
            case 'dynamic-list':
                optObj.params = [];
                opt.find('.ef-srv-edt-option').each(function (index, opt2) {
                    optObj.params.push(self._exportItem($(opt2)));
                });
                break;
            }
            return optObj;
        },
        _optionChange: function () {
            this.setLayout();
            this.element.trigger('change');
        },
        _listServices: function () {
            this.element.trigger('listServices');
        },
        _listUserGroups: function () {
            this.element.trigger('listUserGroups');
        },
        _addPluginOption: function () {
            this.element.trigger('addPluginOption');
        },
        _addRemoteOption: function () {
            this.element.trigger('addRemoteOption');
        },
        _editAction: function () {
            this.element.trigger('editAction', this.serviceAction.attr('opt-id'));
        },
        _updateTitle: function (value) {
            this.serviceTitle.attr('opt-title', value);
            this._optionChange();
            this.element.trigger('updateTitle', value);
        },
        _ckeditorReady: function () {
            // triggered when a ckeditor is ready
            this.ckeditorCounter--;
            this._log("efserviceeditor -> ckeditorReady. ckcounter:", this.ckeditorCounter);
            this._checkIfReady();
        },
        _checkIfReady: function () {
            var title, titleEd;

            if (this.ckeditorCounter === 0) {
                // single option added correctly
                this.element.trigger('editorReady');
                this._log("efserviceeditor -> editorReady");

                if (this._updating || this._importing) {

                    if (this._updating) {
                        // updateOptions finished
                        this._log("efserviceeditor -> updateCompleted");
                        this.element.trigger('updateCompleted');
                        this._updating = false;
                    }
                    if (this._importing) {
                        // setContent finished
                        this._log("efserviceeditor -> importCompleted");
                        this.element.trigger('importCompleted');
                        this._importing = false;
                    }

                    // highlight service title
                    titleEd = CKEDITOR.instances['ef-srv-title'];
                    if (titleEd && titleEd.container) {
                        $(titleEd.container.$).click();
                    }
                }

                // fire a change to re-render layout
                this._optionChange();
            }
        },
        _resetCkeditor: function (editorId, editorContent) {
            var self, editor, editorObj;

            self = this;
            editorObj = $('#' + editorId);
            if (editorObj.hasClass('ef-srv-edt-option-info')) {
                editor = CKEDITOR.inline(editorId, {
                    on: {
                        instanceReady: function (ev) {
                            var blockTags = ['div', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6',
                                             'p', 'pre', 'li', 'blockquote', 'ul', 'ol',
                                             'table', 'thead', 'tbody', 'tfoot', 'td', 'th'];
                            for (var i = 0; i < blockTags.length; i++) {
                                this.dataProcessor.writer.setRules(blockTags[i], {
                                    indent: false,
                                    breakBeforeOpen: false,
                                    breakAfterOpen: false,
                                    breakBeforeClose: false,
                                    breakAfterClose: false
                                });
                            }
                            if (editorContent) {
                                this.setData(editorContent);
                            }
                        },
                        change: function (event) {
                            self._optionChange();
                        }
                    }
                });
            }
            else if (editorObj.hasClass('ef-srv-edt-option-label')) {
                editor = CKEDITOR.inline(editorId, {
                    keystrokes: [
                        [ CKEDITOR.SHIFT + 13, 'blur']
                    ],
                    removePlugins: 'toolbar',
                    enterMode: CKEDITOR.ENTER_BR,
                    on: {
                        instanceReady: function (event) {
                            if (editorContent) {
                                this.setData(editorContent);
                            }
                        },
                        change: function (event) {
                            var value, range;
                            // use text() in place of getData() to avoid html entities
                            value = $(this.container.$).text();
                            if ($(this.element.$).hasClass('ef-srv-edt-option-inner_options-label')) {
                                $('.ef-srv-edt-prop-table').handsontable('setDataAtCell', this.parent().parent().index(), 2, value);
                                // move cursor at the end of the text
                                range = this.createRange();
                                range.moveToElementEditEnd(range.root);
                                this.getSelection().selectRanges([range]);
                            } else {
                                $('.ui-input-text[name=label]', self.propertiesCol).eq(0).val(value);
                                $('.ui-input-text[name=label]', self.propertiesCol).eq(0).keyup();
                            }
                            self._optionChange();
                        },
                        key: function (event) {
                            if (event.data.keyCode === 13) {
                                event.cancel();
                            }
                        }
                    }
                });
            }
            else if (editorObj.hasClass('ef-srv-edt-option-extra')) {
                editor = CKEDITOR.inline(editorId, {
                    keystrokes: [
                        [ CKEDITOR.SHIFT + 13, 'blur']
                    ],
                    removePlugins: 'toolbar',
                    enterMode: CKEDITOR.ENTER_BR,
                    on: {
                        instanceReady: function (event) {
                            if (editorContent) {
                                this.setData(editorContent);
                            }
                        },
                        change: function (event) {
                            // use text() in place of getData() to avoid html entities
                            $('.ui-input-text[name=extra]', self.propertiesCol).eq(0).val($(this.container.$).text());
                            $('.ui-input-text[name=extra]', self.propertiesCol).eq(0).keyup();
                        },
                        key: function (event) {
                            if (event.data.keyCode === 13) {
                                event.cancel();
                            }
                        }
                    }
                });
            }
        },
        filter: function (v) {
            $('#ef-srv-edt-services-group-0', this.serviceGroup).attr('checked', true);
            this.serviceGroup.controlgroup('refresh');
            if (v) {
                $('.ef-srv-edt-service', this.serviceList).hide();
                $('.ef-srv-edt-service[data-value*=' + v.toLowerCase() + ']', this.serviceList).show();
            } else {
                $('.ef-srv-edt-service', this.serviceList).show();
            }
        },
        getContent: function () {
            return this._exportJSON();
        },
        setContent: function (value) {
            this._importing = true;
            return this._importJSON(value);
        },
        listId: function () {
            var list = [this.serviceAction.attr('opt-id')];
            $('.ef-srv-edt-option[opt-id][data-type!=group][data-type!=info]', this.service).each(function (index, el) {
                list.push($(el).attr('opt-id'));
            });
            return list;
        },
        listOptions: function (type) {
            var list = {};
            $('.ef-srv-edt-option[opt-id][data-type=' + type + ']', this.service).each(function (index, el) {
                list[$(el).attr('opt-html_id')] = $(el).attr('opt-id');
            });
            return list;
        },
        getOptionHtmlId: function (optionId) {
            // NSW var opt = $('.ef-srv-edt-option[opt-id=' + optionId + ']');
            try {
                var opt = $('.ef-srv-edt-option[opt-id=' + optionId + ']');
            } catch (err) {
                // console.log("getOptionId: " + err);
                return "";
            }
            return opt.length === 1 ? opt.attr('opt-html_id') : '';
        },
        getOptionId: function (htmlId) {
            // NSW var opt = $('.ef-srv-edt-option[opt-html_id=' + htmlId + ']');
            try {
                var opt = $('.ef-srv-edt-option[opt-html_id=' + htmlId + ']');
            } catch (err) {
                // console.log("getOptionId: " + err);
                return "";
            }
            return opt.length === 1 ? opt.attr('opt-id') : '';
        }
    });

}(jQuery));
